//
// Localization strings for TTDPatch.
//

// Vertaald door: Jan Willem van Dormolen, jw.van.dormolen@hccnet.nl
// 
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Dutch")
COUNTRYARRAY(countries) = { 31, 0, 0x13, 0 };
SETARRAY(countries);
	// 31 is the Netherlands, 0x13 is Dutch in Windows

DOSCODEPAGE(850)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(850)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " wordt gestart.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "grootte")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "De adressen in deze programmaversie zijn bekend.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"LET OP! Je programmaversie is niet bekend bij dit programma.\n We kunnen nu proberen\n"
	"         om toch te starten en de nodige informatie zelf te bepalen,\n"
	"         maar als dat faalt, zal TTD eindigen met een beschermingsfout.\n"
	"\n"
	"         Afhankelijk van hoe je besturingssysteem een beschermingsfout afhandelt,\n"
	"         kan je computer vastlopen; als gevolg daarvan kun je gegevens kwijtraken. Kijk\n"
	"         in paragraaf 4.1 van TTDPATCH.TXT voor meer informatie.\n"
	"\n"
	"Antwoord alleen 'j' als je ZEKER weet wat je doet.\n JE BENT GEWAARSCHUWD!\n"
	"Wil je Transport Tycoon toch starten? ")

// Keys which continue loading after the above warning *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "yj")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Programmastart afgebroken.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Ik zal m'n best doen...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "LET OP!: Versie is niet bekend!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " niet gevonden, ik zoek de originele bestanden:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Kon noch TYCOON.EXE noch %s vinden.\n")

// (Windows) and GameGFX.exe either.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "Kon %s niet vinden.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Kopiren: %s naar %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Kon %s niet uitvoeren\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Kopieerfout - bestand %s bestaat niet.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, ".EXE-opmaak niet herkend.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Kon programmaversie niet achterhalen.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "De programmanaam is %s\nDe exacte versie is %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Versie heeft te veel getallen!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Dit is niet Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Geparste versie is %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Dit is het extended-DOS uitvoerbare bestand.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Dit is het Windows uitvoerbare bestand.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Dit is niet een bekend uitvoerbaar soort bestand.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up.
// %s=DOS of Windows
SETTEXT(LANG_NOTSUPPORTED, "Sorry, deze versie van TTDPatch werkt alleen met de %s-versie.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Ongeldige originele segmentlengte van %lx.")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Codesegment aangepast naar %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Kan niet schrijven naar TTDLOAD.OVL, is het alleen-lezen?\n")

// Installing the code loader
SETTEXT(LANG_INSTALLLOADER, "Installatie: codelader.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Kon codelader niet installeren")
SETTEXT(LANG_DELETEOVL, "%s wordt verwijderd.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s is OK.\n")
 
// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Druk op een toets om af te breken.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Druk op Escape om af te breken, of op een andere toets om door te gaan.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Aangepaste teksten worden geladen.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "Lezen van %s: Ongeldige bestandsopmaak.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"Voor deze versie van TTDPatch moet %s opnieuw worden gemaakt.\n"
	"Download de nieuwste versie van mkpttxt.exe en start deze.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Past TTD aan en start het aangepaste programma %s\n"
	  "\n"
	  "Gebruik: TTDPATCH [-C cfg-file] [opties] [CD-pad] [-W cfg-bestand]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line. // From    |                                to:
// From    |                                to:
TEXTARRAY(halflines,) =
	{ "-a:  Alle opties behalve -x",
 	  "-d:  Volledige datum weergeven",
	  "-f:  Maak treinen aanpasbaar",
	  "-g:  Algemene verbeteringen",
	  "-k:  Kleine vliegvelden blijven",
	  "-l:  Stations met 7 perrons",
	  "-n:  Nieuwe non-stop-afhandeling",
	  "-q:  Ander (uit-)laad-algoritme",
	  "-s:  Valsspelen met bordjes toestaan",
	  "-v:  Bij starten alle opties weergeven",
	  "-w:  Voorseinen gebruiken",
	  "-y:  Stel geen vragen over onbekende", "    versies",
	  "-z:  Mammoettreinen (126 wagons)",

	  "-B:  Langere bruggen bouwen",
	  "-D:  Dynamiet sloopt meer objecten",
	  "-E:  Foutmeldingen naar rechtsboven",
	  "-F:  \"Full load\" betekent n van", "    de mogelijke typen vracht ipv alle",
	  "-G:  Grondstof per station selecteren",
	  "-I:  Zet inflatie af",
	  "-J:  Meer luchthavens per stad",
	  "-L:  Alles lenen/aflossen met 'Ctrl'",
	  "-N:  Meer krantenberichten",
	  "-O:  Kantoorflats accepteren voedsel",
	  "-P:  Locomotieven blijven beschikbaar", "    indien in gebruik",
	  "-R:  Auto's wachten bij laadstations",
	  "-S:  Nieuwe schepen",
	  "-T:  Nieuwe treinmodellen",
	  "-Z:  Weinig geheugen (2,5 MB)",

	  "-2:  Verbeteringen voor Windows 2000 ",

	  "-Xb: Gemeenten omkopen",
	  "-Xd: Depots in orders gebruiken",
	  "-Xe: Eeuwig doorspelen na 2070",
	  "-Xf: Aanvoerservice m.g.v. 'unload'",
	  "-Xg: Geleidelijk laden van voertuigen",
	  "-Xi: Ind. sluit niet bij stabiele eco.",
	  "-Xm: Laad-optie in schijfmenu",
	  "-Xo: Valsspelen met bordjes kost geld",
	  "-Xr: Maak steeds nieuw TTDPATCH.OVL",
	  "-Xs: Snelheden weergeven",
	  "-Xw: Uitgebreide voorseinen gebruiken",
	  "-Xx: Extra gegevens opslaan en laden",

	  "-XA: Verplicht vernieuwen met -Xa",
	  "-XE: Electrische treinen",
	  "-XF: Experimentele opties aan",
	  "-XG: Alle nieuwe plaatjes laden",
	  "-XP: Nieuwe vliegtuigen",
	  "-XR: Nieuwe wegvoertuigen",
	  "-XS: Computerspelers overnemen",

	  "-Ya: Minder invloed veroudering voert.",
	  "-Yb: Meer bouwen op hellingen",
	  "-Yc: Versch. kosten versch. baantypen",
	  "-Ym: Handm. baantype wijzigen mogelijk",
	  "-Ys: Treinseinen aan wegverkeerkant",
	  "-Yt: Meer statistieken in stadsvenster",
	  "-Yw: Sneller wagons verkopen",

	  "-YC: Op kusten bouwen",
	  "-YH: Meer/nieuwe sneltoetsen",
	  "-YP: Vliegtuigsnelheid als aangegeven",
	  "-YS: Semafoorseinen voor 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Vergroot maximumspreiding stations\n"
	  "-i #:    Standaardonderhoudsinterval is het gegeven aantal dagen\n"
	  "-x #:    Vergroot voertuigarray naar 850*#. Lees handleiding!\n"
	  "-mc #:   Nieuwe bergen- of bochtenafhandeling.\n"
	  "-trpb #: Verhoog aantal t)treinen, r)auto's, p)vliegtuigen en/of b)schepen.\n"
	  "-A #:    Artificile intelligentie verbeteren. (Kleine waarden svp)\n"
	  "-M #:    Treinen met meerdere locs, snelheidstoename in procenten.\n"
	  "-Xa #:   Vernieuw automatisch voertuigen # maanden nadat ze verouderd zijn\n"
	  "-Xc #:   Vliegtuigongelukken instellen\n"
	  "-Yr #:   Trein-/voertuigbotsingen als aangegeven (1/2)\n"
	  "-Xt #:   Maximumgrootte tot waar een stad kan groeien\n"
	  "-XC #:   Meer valuta, en valutaweergaveopties instellen\n"
	  "-XD #:   Kies welke rampen mogelijk zijn\n"
	  "-XM #:   Monorail- en maglev-banen combineren\n"
	  "-XT #:   Een op de hoeveel steden groeien sneller en groter\n"
	  "-XX #:   Monorail/maglev-snelheid op bruggen, in procent van max. snelheid\n"
	  "-XY #:   Standaard startjaar voor nieuw willekeurig spel instellen\n"
	  "-X1 #, -X2 #: Max. tijd dat een trein wacht bij een nr.- of tweer.sein in dagen\n"
	  "-Yo #:   Sommige opties van andere schakelopties wijzigen (zie documentatie)\n"
	  "-Yp #:   Meerdere bomen planten, plantmethode instellen\n"
	  "-YB #:   Meer bouwopties, instellen met parameter\n"
	  "-YE #:   Tijd in seconden dat rode foutmeldingen verschijnen instellen\n"
	  "-YG #:   Betere gebruikersinterface, optie kiezen met parameter\n"
	  "-YT #:   Stadsgroeialgorithme instellen\n"
	  "\n"
	  "-C cfg-file:  Gebruik dit configuratiebestand i.p.v. ttdpatch.cfg\n"
	  "-W cfg-file:  Maakt een configuratiebestand met de gegeven configuratie\n"
	  "\n"
	  "Gebruik de juiste hoofd- en kleine letters!\n"
	  "\n"
	  "Voorbeeld: ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n"
	  "(Hint: Als de tekst te snel voorbijrolt, typ dan \"ttdpatch -h|more\"\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Zie TTDPATCH.TXT voor meer informatie.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Waarschuwing: Onbekende aan-/uitwaarde %s, uitgezet.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Onbekende optie '%c%s'. Gebruik -h voor help.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Waarschuwing: Fout in configuratieregel: '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Verhoog aantal voertuigen", " tot %d*850")
SWITCHTEXT(usenewcurves, "Nieuwe bochtensnelheid", " voor %04x")
SWITCHTEXT(usenewmountain, "Nieuwe bergsnelheid", " voor %04x")
SWITCHTEXT(usenewnonstop, "Nieuwe non-stop-afhandeling", "")
SWITCHTEXT(increasetraincount, "Max. aantal treinen", ": %d")
SWITCHTEXT(increaservcount, "Max. aantal auto's", ": %d")
SWITCHTEXT(setnewservinterval, "Stand. onderh.interval", ": %d dagen")
SWITCHTEXT(usesigncheat, "Valsspelen met bordjes", "")
SWITCHTEXT(allowtrainrefit, "Aanpassen treinen mogelijk", "")
SWITCHTEXT(increaseplanecount, "Max. aantal vliegtuigen", ": %d")
SWITCHTEXT(increaseshipcount, "Max. aantal schepen", ": %d")
SWITCHTEXT(keepsmallairports, "Behoudt kleine vliegvelden", "")
SWITCHTEXT(largerstations, "Max. stationsspreiding", " %d vlakken")
SWITCHTEXT(morestationtracks, "Stations uitbreidbaar", "")
SWITCHTEXT(longerbridges, "Langere bruggen mogelijk", "")
SWITCHTEXT(improvedloadtimes, "Verbeterde laadtijdberekening", "")
SWITCHTEXT(mammothtrains, "Mammoettreinen (lengte 127)", "")
SWITCHTEXT(presignals, "Gebruik voorseinen", "")
SWITCHTEXT(officefood, "Kantoorflats accepteren voedsel", "")
SWITCHTEXT(noinflation, "Zet inflatie uit", "")
SWITCHTEXT(maxloanwithctrl, "Max. lenen/aflossen met 'Ctrl'", "")
SWITCHTEXT(persistentengines, "Locomotieven blijven beschikbaar", "")
SWITCHTEXT(fullloadany, "Full load: willekeurige lading", "")
SWITCHTEXT(selectstationgoods, "Goederen indien service", "")
SWITCHTEXT(morethingsremovable, "Meer dingen slopen", "")
SWITCHTEXT(aibooster, "Computerspelers factor", " %d slimmer")
SWITCHTEXT(multihead, "Meerdere locs", ", snelh.toename: %d%%")
SWITCHTEXT(newlineup, "Auto's wachten bij laadstation", "")
SWITCHTEXT(lowmemory, "Weinig geheugen (2,5 MB)", "")
SWITCHTEXT(generalfixes, "Algemene verbeteringen (zie doc.)", "")
SWITCHTEXT(moreairports, "Meer luchthavens per stad", "")
SWITCHTEXT(bribe, "Omkopen toegestaan", "")
SWITCHTEXT(noplanecrashes, "Vliegtuigongelukken aanpassen", ": %d")
SWITCHTEXT(showspeed, "Snelheden weergeven van voertuigen", "")
SWITCHTEXT(autorenew, "Voert. autom. vernieuwen", " op %d mndn")
SWITCHTEXT(cheatscost, "Valsspelen met bordjes kost geld", "")
SWITCHTEXT(extpresignals, "Voorseinen instellen met 'Ctrl'", "")
SWITCHTEXT(diskmenu, "Optie 'load' in schijfmenu", "")
SWITCHTEXT(win2k, "Spelen draait onder Windows 2000/XP", "")
SWITCHTEXT(feederservice, "Aanvoerservice bij optie 'unload'", "")
SWITCHTEXT(gotodepot, "Depots als reisdoel opgeven", "")
SWITCHTEXT(newships, "Nieuwe scheepsmodellen", "")
SWITCHTEXT(subsidiaries, "Computerspelers overnemen en beheren", "")
SWITCHTEXT(gradualloading, "Voertuigen geleidelijk laten laden", "")
SWITCHTEXT(moveerrorpopup, "Foutmeldingen rechtsboven weergeven", "")
SWITCHTEXT(setsignal1waittime, "Wachttijd van treinen bij seinen", ":")
SWITCHTEXT(setsignal2waittime, "", "")                          // dummy entry
SWITCHTEXT(maskdisasters, "Rampencode", ": %d")
SWITCHTEXT(forceautorenew, "Verplicht autom. vernieuwen", "")
SWITCHTEXT(morenews, "Meer krantenberichten", "")
SWITCHTEXT(unifiedmaglev, "Genificeerde maglev", ", modus %d")
SWITCHTEXT(newbridgespeeds, "Max. snelh. op maglev-bruggen", ": %d%%")
SWITCHTEXT(eternalgame, "Eeuwig doorspelen na 2070", "")
SWITCHTEXT(showfulldate, "Volledige datum weergeven", "")
SWITCHTEXT(newtrains, "Nieuwe treinmodellen", "")
SWITCHTEXT(newrvs, "Nieuwe wegvoertuigmodellen", "")
SWITCHTEXT(newplanes, "Nieuwe vliegtuigmodellen", "")
SWITCHTEXT(signalsontrafficside, "Seinen aan 'verkeers'zijde van spoor", "")
SWITCHTEXT(electrifiedrail, "Gelektrificeerd spoor", "")
SWITCHTEXT(newstartyear, "Standaard startjaar", ": %d")
SWITCHTEXT(newerrorpopuptime, "Weergavetijd foutmeldingen", ": %d sec.")
SWITCHTEXT(newtowngrowthfactor, "Stadsgroeifactor wordt", " %d")
SWITCHTEXT(largertowns, "Grotere steden", ", elke 1 van de %d")
SWITCHTEXT(miscmods, "Diverse opties", ": %d")
SWITCHTEXT(loadallgraphics, "Altijd alle nieuwe plaatjes laden", "")
SWITCHTEXT(saveoptdata, "Optionele gegevens opslaan en laden", "")
SWITCHTEXT(morebuildoptions, "Meer bouwopties", ": %d")
SWITCHTEXT(semaphoresignals, "Semafoorseinen voor 1975", "")
SWITCHTEXT(morehotkeys, "Meer/nieuwe sneltoetsen", "")
SWITCHTEXT(plantmanytrees, "Meer bomen tegelijk planten", ", modus %d")
SWITCHTEXT(morecurrencies, "Meer valuta", ", vlaggen: %d")
SWITCHTEXT(manualconvert, "Handmatig spoor converteren", "")
SWITCHTEXT(newtowngrowthrate, "Nieuw stadsgroeialgorithme", ": %d")
SWITCHTEXT(displmoretownstats, "Meer stadsstatistieken weergeven", "")
SWITCHTEXT(enhancegui, "Betere spelinterface", ": %d")
SWITCHTEXT(newagerating, "Minder invloed veroudering voert.", "")
SWITCHTEXT(buildonslopes, "Meer dingen bouwen op hellingen", "")
SWITCHTEXT(buildoncoasts, "Op kusten bouwen mogelijk", "")
SWITCHTEXT(experimentalfeatures, "Nieuwste experim. opties aanzetten", ": %d")
SWITCHTEXT(tracktypecostdiff, "Versch. kosten versch. soorten spoor", "")
SWITCHTEXT(planespeed, "Echte vliegtuigsnelheid gebruiken", "")
SWITCHTEXT(fastwagonsell, "Sneller wagons verkopen", "")
SWITCHTEXT(newrvcrash, "Botsingen wijzigen"," (modus %d)")
SWITCHTEXT(stableindustry, "Industrien sluiten niet","")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Kon config.bestand %s niet vinden. Genegeerd.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Kon niet naar %s schrijven.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Waarschuwing! Configuratieregel is langer dan 32 tekens, afgekapt.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "De gebruikte optie `%s' (-%s) is verouderd. AUB niet gebruiken!\n"
		"Wordt verwijderd in een volgende versie.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDpatch configuratiegegevens, automatisch gemaakt door TTDPatch -W.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Opmaak van de opties is:\n"
	CFG_COMMENT "   optienaam = optiewaarde\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "De \"=\" kan weggelaten worden, evenals de spaties.\n" 
	CFG_COMMENT "Op hoofdlettergebruik wordt niet gelet.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Voor ja/nee [y/n] opties, kan de waarde zijn:\n"
	CFG_COMMENT "   yes, y, on, 1, no, n, off, 0\n"
	CFG_COMMENT "Als de waarde weggelaten wordt, wordt ja aangenomen.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Voor de opties met waarden [v], wordt het bereik gegeven in de\n"
	CFG_COMMENT "beschrijving. Hier vind je ook de standaardwaarde die geldt als de waarde wordt\n"
	CFG_COMMENT "weggelaten. De optie kan afgezet worden door hem een van de 'uit'-waarden te geven.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Commentaarregels beginnen met een niet-alfabetisch teken.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Nieuwe schakelopties ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) verhoogt het maximum aantal schepen. Bereik %ld - %ld, standaard is %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) stelt snelheid in bochten in op normaal (0), sneller (1), snelst (2) of realistisch (3). En cijfer voor trein, monorail, maglev en wegvoertuigen elk. Standaard 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) stelt snelheid op hellingen in op normaal (0), sneller (1), snelst (2) of realistisch (3). En cijfer voor trein, monorail, maglev en wegvoertuigen elk. Standaard 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) maakt grotere stations mogelijk. Bereik %ld - %ld, standaard is %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) maakt het mogelijk locomotieven aan te passen.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) verandert het standaardonderhoudsinterval voor nieuwe locs. Bereik %ld - %ld, standaard is %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) zet alle inflatie uit, zowel voor uitgaven als inkomsten.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) maakt het mogelijk meer sporen of langere stations te gebruiken.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s): de \"Non-stop\"-optie werkt anders.")
SETTEXT(CFG_PLANES, "`%s' (-%s) verhoogt het maximum aantal vliegtuigen. Bereik %ld - %ld, standaard is %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) gebruikt een ander laad-/uitlaadtijdenalgoritme.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) verhoogt het maximum aantal wegvoertuigen. Bereik %ld - %ld, standaard is %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) maakt valsspelen met bordjes mogelijk.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) verhoogt het maximum aantal treinen. Bereik %ld - %ld, standaard is %ld.")
//SETTEXT(CFG_PLAYERS, "`%s' (-%s) stelt de spelers in die benvloed worden door het valsspelen. Een lijst van spelers 0 - 7")
SETTEXT(CFG_VERBOSE, "`%s' (-%s) toont voor het starten van TTD een samenvatting van de ingestelde opties.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) maakt 'voorseinen' mogelijk waarmee stations efficinter gemaakt kunnen worden.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) verhoogt het maximum aantal voertuigen naar waarde*850. Bereik %ld - %ld, standaard is %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) maakt mammoettreinen mogelijk met max. 126 wagons.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) laat een trein vertrekken zodra een van de producten volledig geladen is.")
SETTEXT(CFG_SELECTGOODS, "Met `%s' (-%s) worden pas goederen afgeleverd als er een service voor bestaat.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) maakt het mogelijk met 'Ctrl' alles te lenen of af te lossen.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) zorgt dat kantoorflats voedsel accepteren (tropische en arctische scenario's).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) zorgt dat voertuigen te koop blijven zolang je ze gebruikt.")
SETTEXT(CFG_CDPATH, "`%s' (geen schakeloptie) stelt het pad naar de cd in.")
// Note- CFG_CDPATH heeft geen optie, dus geef geen %s!
SETTEXT(CFG_KEEPSMALLAP, "Met `%s' (-%s) blijven kleine vliegvelden ook later in het spel beschikbaar.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) verhoogt de AI-recursie met deze waarde.")
SETTEXT(CFG_LONGBRIDGES, "Met `%s' (-%s) kun je langere bruggen bouwen (maximaal 127 vlakjes lang).")
SETTEXT(CFG_DYNAMITE, "Met `%s' (-%s) kun je meer objecten opblazen met dynamiet.")
SETTEXT(CFG_RVQUEUEING, "Met `%s' (-%s) wachten wegvoertuigen voor een vol laadstation ipv om te draaien.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) staat TTDPatch toe te draaien in 2,5 MB geheugen, maar je kunt dan de voertuigmatrix tot maximaal 2 verhogen.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) verbetert een aantal kleine programmafouten.")
SETTEXT(CFG_MOREAIRPORTS, "Met `%s' (-%s) kun je meer dan twee luchthavens per stad bouwen.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) voegt de optie `bribe' (omkopen) toe aan stadsmenu's.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) maakt het mogelijk te bepalen wanneer vliegtuigen kunnen neerstorten. Bitgecodeerde waarde, standaard is 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) geeft de huidige snelheid van voertuigen weer in hun voertuigvenster.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) vervangt voertuigen automatisch dit aantal maanden nadat ze `zeer oud' worden. Bereik %ld - +%ld, standaard is %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) maakt dat valsspelen met bordjes geld kost.")
SETTEXT(CFG_EXTPRESIGNALS, "Met `%s' (-%s) kun je verschillende soorten (voor)seinen instellen: normaal, voorsein, uitgangssein of gecombineerd sein. Je stelt deze in met 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) zorgt ervoor dat TTDPatch elke keer dat je het programma start een nieuw bestand TTDLOAD.OVL of TTDLOADW.OVL maakt.")
SETTEXT(CFG_MULTIHEAD, "Met `%s' (-%s) kun je een trein meerdere locs geven. Extra locs koop je met 'Ctrl'. Als parameter geef je de max. extra snelheid die de extra locs opleveren, als percentage van %ld - %ld, standaard is %ld%%.")
SETTEXT(CFG_CHEATSCOST, "'%s' (-%s) maakt dat valsspelen met bordjes geld kost.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) voegt de optie `load' (laden) toe aan het schijfmenu, en 'load game' (spel laden) of 'save game' (spel opslaan, gebruik hiervoor Ctrl) aan de scenario-editor.")
SETTEXT(CFG_WIN2K, "`%s' (-%s) maakt de Windows-versie van TTD compatibel met Windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) wijzigt de optie 'unload'. Een station dat anders de lading zou accepteren laat die lading nu klaar staan voor een andere service die de lading verder kan vervoeren.")
SETTEXT(CFG_GOTODEPOT, "Met `%s' (-%s) kunt u depots toevoegen aan de orders om voertuigen naar garage, remise, hangar of dok te sturen.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) geeft meer en andere schepen.")
SETTEXT(CFG_SUBSIDIARIES, "Met `%s' (-%s) kunt u computerspelers overnemen waarvan u meer dan 75%% in bezit hebt.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) maakt dat voertuigen beetje bij beetje worden geladen, wat realistischer oogt. (stelt ook automatisch de optie `loadtime' in).")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) maakt dat alle rode foutmeldingen rechtsboven op het scherm worden weergegeven.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) wijzigt het aantal dagen dat een trein wacht voor een nrichtingssein voordat hij het opgeeft en omkeert. Bereik 0 - 254; met 255 wacht de trein tot St. Juttemis.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) wijzigt het aantal dagen dat een trein wacht voor een tweerichtingssein voordat hij het opgeeft en omkeert. Bereik 0 - 254; met 255 wacht de trein tot St. Juttemis.")
SETTEXT(CFG_DISASTERS, "Met `%s' (-%s) kun je kiezen welke rampen er kunnen gebeuren. Bitgecodeerde waarde, standaard is 255 (alle rampen).")
SETTEXT(CFG_FORCEAUTORENEW, "Met `%s' (-%s) gaan voertuigen naar het depot wanneer het tijd is om vervangen te worden (zie `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) genereert (kranten-)berichten voor meer gebeurtenissen, zie de documentatie voor nadere informatie.")
SETTEXT(CFG_UNIFIEDMAGLEV, "Met `%s' (-%s) kun je monorail-locs kopen in maglev-remises en vice versa. Modi: 1 - converteer alle maglev-locs naar monorail; 2 - converteer alle monorail-locs naar maglev; 3 - houdt monorail en maglev apart.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) wijzigt de snelheidslimieten op buisbruggen voor monorail en maglev in het opgegeven percentage van de hoogste maximum loc-snelheid in de klasse. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_ETERNALGAME, "Met `%s' (-%s) kun je eeuwig door blijven spelen, de datum wordt niet teruggezet na 2070.")
SETTEXT(CFG_SHOWFULLDATE, "Met `%s' (-%s) wordt altijd de volledige datum in de statusbalk weergegeven (niet alleen tijdens pauzeren).")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) activeert nieuwe treinmodellen.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) activeert nieuwe wegvoertuigmodellen.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) activeert nieuwe vliegtuigmodellen.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) zet treinseinen aan dezelfde kant van het spoor als waar wegvoertuigen op de weg rijden.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) verwijdert n van de magnetische spoorsystemen (Monorail of MagLev) en vervangt die door gelektrificeerde treinsporen.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) stelt het standaardstartjaar voor willekeurige spelen in en biedt meer mogelijkheden voor startjaren in de scenario-maker. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) wijzigt de tijd dat rode foutmeldingen op het scherm blijven staan. Bereik 1 - 255 (in seconden), of 0 voor verschrikkelijk lang. Standaard 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) wijzigt de factor die de maximumgrootte van steden beperkt. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) maakt dat n van elke zoveel steden sneller en groter kunnen groeien (waarbij bovendien `towngrowthlimit' selectief wordt toegepast). Bereik %ld - %ld. Standaard %ld (n op elke vier steden).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) maakt het mogelijk om de werking van bepaalde andere schakelopties te wijzigen, lees de documentatie voor meer info. Bitgecodeerde waarde, standaard 0 (geen wijzigingen).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) dwingt TTDPatch om altijd alle .grf-bestanden in newgrf(w).cfg te laden, ongeacht of ze in een geladen spel (enz.) al waren gebruikt of niet.")
SETTEXT(CFG_SAVEOPTDATA, "Met `%s' (-%s) slaat TTDPatch meer (optionele) gegevens op aan het einde van opgeslagen spellen, en laadt die ook weer in.")
SETTEXT(CFG_MOREBUILDOPTIONS, "Met `%s' (-%s) krijg je meer mogelijkheden bij bouwen. Bitgecodeerde waarde, bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) verandert nieuwe treinseinen die voor 1975 gebouwd worden in semafoorseinen (met bewegende arm).")
SETTEXT(CFG_MOREHOTKEYS, "Nieuwe sneltoetsen krijg je met `%s' (-%s).")
SETTEXT(CFG_MANYTREES, "Met `%s' (-%s) kun je meer dan n boom op n plek planten; met Ctrl kun je een cirkelvormig gebied volplanten.")
SETTEXT(CFG_MORECURRENCIES,"Met `%s' (-%s) worden meer valuta mogelijk, waaronder de Euro. Parameter: 0 - valutasymbool op standaardpositie; 1 - valutasymbool voor bedrag; 2 - valutasymbool achter bedrag. Tel hierbij 4 op om de Euro uit te schakelen.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) maakt het mogelijk handmatig spoortypen te wijzigen door nieuw spoor over oud spoor heen te bouwen.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) maakt de stationsbeoordelingen toleranter voor oudere voertuigen. Voertuigen mogen nu 21 jaar oud zijn in plaats van 3.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) verbetert de gebruikersinterface. Bitgecodeerde waarde, bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "Met `%s' (-%s) kun je de regels definiren voor de berekening van het groeitempo van steden. Modi: 0 - TTD origineel, 1 - TTD uitgebreid, 2 - zelfbepaald. Zie de documentatie voor meer informatie.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (geen opdrachtregelschakeloptie) definieert het minimumgroeitempo van steden, in nieuwe huizen per eeuw. Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (geen opdrachtregelschakeloptie) definieert het maximumgroeitempo van steden, in nieuwe huizen per eeuw. Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (geen opdrachtregelschakeloptie) definieert hoeveel bestaande aktieve stations bijdragen aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - +%ld. Standaard %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (geen opdrachtregelschakeloptie) definieert hoeveel elk aktief station het groeitempo van een stad vergroot (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief aktieve stations zijn in het bijdragen aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief getransporteerde passagiers bijdragen aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief getransporteerde post bijdraagt aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (geen opdrachtregelschakeloptie) definieert het maximum aantal binnenkomende passagiers dat invloed heeft op de groei van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief binnenkomende passagiers bijdragen aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (geen opdrachtregelschakeloptie) definieert het optimale inwonertal per elke 2 zakken binnenkomende post (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief binnenkomende post bijdraagt aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (geen opdrachtregelschakeloptie) definieert het optimale inwonertal per elke 2 kratten inkomende goederen (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief inkomende goederen bijdragen aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (geen opdrachtregelschakeloptie) definieert de minimum hoeveelheid voedsel die vereist is voor steden boven de sneeuwgrens of in de woestijn, in inwoners per 2 ton binnenkomend voedsel (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (geen opdrachtregelschakeloptie) definieert het optimale inwonertal per elke 2 ton binnenkomend voedsel(zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief binnenkomend voedsel bijdraagt aan het groeitempo van een stad (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (geen opdrachtregelschakeloptie) definieert de minimum hoeveelheid water voor steden in woestijngebieden, in inwoners per 2 ton (2.000 liter) binnenkomend water (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (geen opdrachtregelschakeloptie) definieert het optimale inwonertal per elke 2 ton (2.000 liter) binnenkomend water in het sub-tropische klimaat (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief binnenkomend water bijdraagt aan het groeitempo van een stad in het sub-tropische klimaat (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (geen opdrachtregelschakeloptie) definieert het optimale inwonertal per elke 2 zakken binnenkomend snoep in speelgoedland (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief binnenkomend snoep bijdraagt aan het groeitempo van een stad in speelgoedland (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (geen opdrachtregelschakeloptie) definieert het optimale inwonertal per elke 2 binnenkomende frisdranken in speelgoedland (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (geen opdrachtregelschakeloptie) definieert hoe effectief binnenkomende frisdrank bijdraagt aan het groeitempo van een stad in speelgoedland (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (geen opdrachtregelschakeloptie) definieert het basisaantal stadsgebouwen voor de berekening die `tgrtownsizefactor' betreft (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (geen opdrachtregelschakeloptie) definieert hoeveel de grootte van een stad zijn groeitempo benvloedt (zie documentatie voor meer info). Alleen aktief als `towngrowthratemode' is ingesteld op 2. Bereik %ld - %ld. Standaard %ld (bijv. 25%% invloed).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (geen opdrachtregelschakeloptie) definieert het minimum inwonertal waartot steden boven de sneeuwgrens kunnen groeien als er geen voedsel wordt aangevoerd. Aktief als `towngrowthratemode', `towngrowthlimit' of `generalfixes' is ingeschakeld. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (geen opdrachtregelschakeloptie) definieert het minimum inwonertal waartot steden in woestijngebieden kunnen groeien als er geen voedsel en water wordt aangevoerd. Aktief als `towngrowthratemode', `towngrowthlimit' of `generalfixes' is ingeschakeld. Bereik %ld - %ld. Standaard %ld.")
SETTEXT(CFG_MORETOWNSTATS, "Met `%s' (-%s) worden er meer statistieken weergegeven in stadsinformatievensters.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) maakt het mogelijk om sporen, wegen en stations te bouwen op hellingen, door fundamenten te gebruiken zoals die door huizen worden gebruikt.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) maakt het mogelijk om op kusten en rivieroevers te bouwen, zonder eerst de plek op te hoeven blazen.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) geeft verschillende typen spoor verschillende bouwkosten.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (geen opdrachtregelschakeloptie) stelt de wisselkoers in voor de eigen valuta CUS * 1000. Standaard is 1000 (1 CUS = 1 pond). Alleen aktief als `morecurrencies' aan staat.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) schakelt de nieuwste experimentele opties in.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) zorgt ervoor dat vliegtuigen vliegen met de snelheid die aangegeven wordt, en niet een kwart daarvan; bovendien vliegen vliegtuigen op 5/8 van de gewone snelheid als ze panne hebben.")
SETTEXT(CFG_FASTWAGONSELL, "Met `%s' (-%s) kun je sneller wagons verkopen met de Ctrl-toets.")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) wijzigt wat er gebeurt bij trein-/voertuigbotsingen. Met %ld gaat de trein kapot na de botsing. Met %ld worden botsingen onmogelijk. Standaard: type %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) voorkomt dat industrien sluiten als de economie is ingesteld op Stabiel in de moeilijkheidsgraadopties.");


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nDruk op Enter om TTD te starten, op Escape om af te breken of op een andere toets om de instellingen weer te geven.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Ingeschakelde opties:   (%c ingeschakeld, %c uitgeschakeld)\n"
	  )

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "Eenrichtings: ")
SETTEXT(LANG_SWTWOWAY, "Tweerichtings: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d dag(en)")
SETTEXT(LANG_INFINITETIME, "oneindig")

// Shows the load options for ttdload. %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Druk op een toets om \"TTDLOAD %s\" uit te voeren (afbreken met Esc).")

SETTEXT(LANG_SWABORTLOAD, "\nProgrammastart afgebroken door gebruiker.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Interne TTDPatch-fout #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD is niet correct genstalleerd (registerfout %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Niet genoeg geheugen %s, heb %d kB meer nodig\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "om TTD te starten")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Protected mode code te groot!\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Bezig met swappen.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 3rd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "%s%s%s wordt gestart\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Kon %s niet uitvoeren: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Resultaat: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Fout!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Kon aangepast afbeeldingsbestand %s niet vinden, genereer bestand.\n")
SETTEXT(LANG_ERRORCREATING, "Fout bij het maken van %s: %s\n")
