//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("French")
COUNTRYARRAY(countries) = { 2, 32, 33, 0, 0x0c, 0 };
SETARRAY(countries);
	// 2 is Canada (french), 32 is Belgium, 33 is France
	// 0x0c is French in Windows

DOSCODEPAGE(850)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(850)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, ": dmarrage...\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "taille")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Cette version du programme a des adresses connues.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"ATTENTION! La version de votre programme n'est pas connue de ce patch.\n"
	"           On peux quand mme essayer de le lancer et dterminer les\n"
	"           informations ncessaires, mais si c'est un chec, TTD va provoquer\n"
	"           une erreur gnrale de protection (\"GPF\") et s'arrter.\n"
	"\n"
	"           Selon la manire dont votre systme d'exploitation manie une GPF,\n"
	"           ceci peut causer le blocage de votre ordinateur, et vous pouvez\n"
	"           perdre des donnes. Veuillez vous reporter  la section " VERSIONSECTION " de\n"
	"           TTDPATCH.TXT pour davantage d'informations.\n"
	"\n"
	"Rpondez 'o' seulement si vous savez vraiment ce que vous fates.\nVOUS AVEZ T PRVENU!\n"
	"Voulez-vous lancer TTD malgr tout? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "yo")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Chargement du programme abandonn.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Je vais essayer de faire de mon mieux...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "ATTENTION: Version inconnue!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " non trouv, recherche des fichiers originaux:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Ni TYCOON.EXE ni %s ne peuvent tre trouvs.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "%s ne peut tre trouv.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Copie de %s vers %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Impossible d'excuter %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Erreur de copie - %s inexistant.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Format du fichier .EXE non reconnu.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Impossible de dterminer la version du programme.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "Le nom du programme est:\n%s\nLa version exacte est %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "La version a trop de nombres!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Ceci n'est pas Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "La version compile est %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "C'est l'excutable DOS tendu.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "C'est l'excutable Windows.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Ceci n'est pas un format d'excutable connu.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Dsol, cette version de TTDPatch ne fonctionne qu'avec la version %s du jeu.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Longeur originale du segment (%lx) invalide.")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Augmentation de la taille du code  %sMB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Impossible d'crire sur TTDLOAD.OVL (lecture seule?).\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Installation du \"loader\" du code.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Impossible d'installer le \"loader\"")

// Suggestion to delete TTDLOAD.OVL (%s) if it is invalid
SETTEXT(LANG_DELETEOVL, " - essai d'effacement %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s est CORRECT.\n")

// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Appuyez sur une touche pour annuler.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Appuyez sur Echap pour annuler ou une autre touche pour continuer.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Chargement des textes de jeu personaliss.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "Chargement de %s: Foramt de fichier invalidet.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s a besoine d'tre actualis pour cette versino de TTDPatch.\n"
	"Downloadez et xcutez le programme mkpttxt.exe le plus rcent SVP.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Modifie TTD et lance le programme patch %s\n" 
	  "\n" 
	  "Usage: TTDPATCH [-C fichier-cfg] [options] [chemin du CD] [-W fichier-cfg]\n" 
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:  Toutes les options sauf -x",
	  "-d:  Toujours afficher la date entire",
	  "-f:  Change le contenu des locos",
	  "-g:  Corrections gnriques",
	  "-k:  Garder les petits aroports",
	  "-l:  Jusqu' 7 quais par gare",
	  "-n:  Nouvelle gestion du non-stop",
	  "-q:  Algorithme des temps de",
	  "     (d)chargement amlior",
	  "-s:  Active les codes de triche",
	  "-v:  Affiche les options",
	  "-w:  Pr-signaux automatiques",
	  "-y:  Ignore si la version est inconnue",
	  "-z:  Trains mammouths (126 wagons)",

       "-2:  Quelques patchs pour Windows 2000",

	  "-B:  Permettre des ponts plus longs",
	  "-D:  Dynamitage de davantage d'objets",
	  "-E:  Dplacer les messages d'erreurs",
	  "-F:  Chargement complet pour un seul",
	  "     type de cargaison",
	  "-G:  Gare  cargo slectionnable",
	  "-I:  Dsactive l'inflation",
	  "-J:  Plus d'aroports par ville",
	  "-L:  Emprunt/rembours. max. avec Ctrl",
	  "-N:  Ajout d'infos dans les actualits",
	  "-O:  Bureaux acceptant la nourriture",
	  "-P:  Locomotives persistantes",
	  "-R:  File de vhicules routiers",
	  "-S:  Nouveaux navires",
	  "-T:  Nouveaux trains",
	  "-Z:  Version mmoire faible (2.5Mo)",

	  "-Xb: Corruption dans les communes",
	  "-Xd: Ajouter des dpots dans les ",
	  "     ordres des vhicules",
	  "-Xe: Partie infini aprs 2070",
	  "-Xf: Service relais avec dchargement",
	  "-Xg: Chargement graduel des vhicules",
	  "-Xi: Les industries ne ferment pas",
	  "     avec une conomie stable",
	  "-Xm: Chargement de partie dans le ",
	  "     menu Fichier",
	  "-Xo: Panneaux de triche payants",
	  "-Xr: Toujours recrer TTDLOAD.OVL",
	  "-Xs: Vitesse dans la barre d'tat",
	  "-Xw: gestion des pr-signaux tendus",
	  "-Xx: Sauvegarde et chargement des",
	  "     donnes supplmentaire",

	  "-XA: Auto remplacement forc avec -Xa",
	  "-XE: Voies ferres lectriques",
	  "-XF: Active les experimentations",
	  "-XG: Toujours charger les nouveaux",
	  "     graphiques",
	  "-XP: Nouveaux avions",
	  "-XR: Nouveau vhicules routiers",
	  "-XS: Contrler les entreprises",
	  "     concurrentes",

	  "-Ya: Apprciations plus solrantes",
	  "     sur l'ge des vhicules",
	  "-Yb: Construction sur pentes avance",
	  "-Yc: Les diffrents types de rail",
	  "     ont des cot diffrents",
	  "-Ym: Autorise la conversion manuel",
	  "     des voies ferres",
	  "-Ys: Feus des passages  niveau",
	  "     du ct de la route",
	  "-Yt: Donne plus d'informations dans",
	  "     les fentres des villes",
	  "-Yw: Vente de wagon acclre",

	  "-YC: Construction sur les ctes",
	  "-YH: Nouvelles touches de raccourci",
	  "-YP: Vitesse relle des avions",
	  "-YS: Semaphore avant 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Augmente la surface possible d'une station\n"
	  "-i #:    Intervalle de service par dfaut de # jours\n"
	  "         DANGEREUX! Lisez la documentation!\n"
	  "-x #:    tend la table des vhicules  850*#. Lisez la documentation!\n"
	  "-mc #:   Nouvelle gestion, respectivement, des montagnes et des virages\n"
	  "-trpb #: Accrot respectivement le nombre de trains, camions, avions et navires\n"
	  "-A #:    Amliore l'IA par ce nombre. Utilisez de faibles valeurs seulement.\n"
	  "-M #:    Autorise les train multi-locomotives, fixe le gain de vitesse en pourcents.\n"
	  "-Xa #:   Remplacement automatiquement les vhicules # mois aprs la fin de leur dure de vie\n"
	  "-Xc #:   Contrle la frquence des accidents d'avion\n"
	  "-Yr #:   Change le type de collision train/vhicule routier (1/2)\n"
	  "-Xt #:   Fixe la taille maximale des villes \n"
	  "-XC #:   Autorise plus de monnaies et change les options d'affichage des monnaies\n"
	  "-XD #:   Choisi quelles catastrophes peuvent arriver\n"
	  "-XM #:   Combine les systmes de voie monorail et maglev\n"
	  "-XT #:   Fixe la proportion des villes ayant une meilleur croissance, une ville sur :\n"
	  "-XX #:   Nouvelles vitesses des ponts monorail et maglev,\n"
	  "         pourcentage de la vitesse maximale du train\n"
	  "-XY #:   Change l'anne de dpart des parties gnres alatoirement\n"
	  "-X1 #, -X2 #: Temps maximal d'attente des train sur les signaux des voies  sens unique\n"
	  "              (respectivement  double sens)\n"
	  "-Yo #:   Contrle des options d'autres paramtres (voir la documentation)\n"
	  "-Yp #:   Autorise la plantation de nombreux arbres, choisir le mode de plantation\n"
	  "-YB #:   Plus d'options de constructions, contrle d'options avec paramtres\n"
	  "-YE #:   Fixe la dure d'affichage des messages d'erreurs\n"
	  "-YG #:   Amliore l'interface, option avec paramtres\n"
	  "-YT #:   Change l'algorithme de croissance des villes\n"
	  "\n"
	  "-C fichier-cfg:  Lire ce fichier de configuration au lieu de TTDPATCH.CFG\n"
	  "-W fichier-cfg:  Crer un nouveau fichier de configuration\n"
	  "\n"
	  "(Conseil:  Si a dfile trop vite, entrez \"ttdpatch -h|more\")\n"
	  "\n"
	  "L'accumulation est importante!\n"
	  "\n"
	  "Exemple: ttdpatch -fnqz -m 00 -c 13 -trpb 240 -v\n"
	  "\n")
//	  "-u ##..: Numro(s) des joueur(s) affect(s) par les options de triche\n"
//	  "         [ex: -u 01 pour le mode multi-joueur]\n"

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "\nVoir TTDPATCH.TXT (en anglais) pour plus de dtails.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Attention: Statut %s inconnu pour l'option, dsactive.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Option inconnue '%c%s'.  Utilisez -h pour l'aide.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Attention: Commande CFG '%s' inconnue.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "tend total de vhicules", "  %d*850")
SWITCHTEXT(usenewcurves, "Nouv. gestion des virages", " pour %04x")
SWITCHTEXT(usenewmountain, "Nouv. gestion des pentes", " pour %04x")
SWITCHTEXT(usenewnonstop, "Nouvelle gestion du non-stop", "")
SWITCHTEXT(increasetraincount, "Nouveau compteur de trains", ": %d")
SWITCHTEXT(increaservcount, "Nouveau compteur de camions", ": %d")
SWITCHTEXT(setnewservinterval, "Nv. interv. de service", ": %d jours")
SWITCHTEXT(usesigncheat, "Tricher", "")
SWITCHTEXT(allowtrainrefit, "Changer contenu des trains", "")
SWITCHTEXT(increaseplanecount, "Nouveau compteur d'avions", ": %d")
SWITCHTEXT(increaseshipcount, "Nouveau compteur de navires", ": %d")
SWITCHTEXT(keepsmallairports, "Maintien petits aroports", "")
SWITCHTEXT(largerstations, "Accrot l'aire des gares", "  %d")
SWITCHTEXT(morestationtracks, "Stations extensibles", "")
SWITCHTEXT(longerbridges, "Ponts plus longs", "")
SWITCHTEXT(improvedloadtimes, "Temps de (d)chargements amliors", "")
SWITCHTEXT(mammothtrains, "Trains Mammouths (126 wagons)", "")
SWITCHTEXT(presignals, "Pr-signaux automatiques", "")
SWITCHTEXT(officefood, "Bureaux acceptant la nourriture", "")
SWITCHTEXT(noinflation, "Inflation dsactive", "")
SWITCHTEXT(maxloanwithctrl, "Emprunt/rembours. max avec 'Ctrl'", "")
SWITCHTEXT(persistentengines, "Machines persistantes", "")
SWITCHTEXT(fullloadany, "[Charger] pour un type de cargo", "")
SWITCHTEXT(selectstationgoods, "Cargo slectionnable", "")
SWITCHTEXT(morethingsremovable, "Plus d'objets destructibles", "")
SWITCHTEXT(aibooster, "Amliore l'IA", " de %d")
SWITCHTEXT(multihead, "Trains  multi locos", ", vitesse: %d%%")
SWITCHTEXT(newlineup, "File de vhicules routiers", "")
SWITCHTEXT(lowmemory, "Version mmoire faible (2.5Mo)", "")
SWITCHTEXT(generalfixes, "Corrections gnriques", "")
SWITCHTEXT(moreairports, "Plus d'aroports par ville", "")
SWITCHTEXT(bribe, "Affiche l'option de corruption", "")
SWITCHTEXT(noplanecrashes, "Contrle des accidents d'avion", ": %d")
SWITCHTEXT(showspeed, "Vitesse affiche", "")
SWITCHTEXT(autorenew, "Auto-changement d'engins", " a %d mois")
SWITCHTEXT(cheatscost, "Panneaux 'cheats' payants", "")
SWITCHTEXT(extpresignals, "Pre-signaux Choisis avec 'Ctrl'", "")
SWITCHTEXT(diskmenu, "Chargement dans le menu disque", "")
SWITCHTEXT(win2k, "Appliquer patchs Windows 2000/XP", "")
SWITCHTEXT(feederservice, "Service relais avec dchargement", "")
SWITCHTEXT(gotodepot, "Ajouter des dpots dans les ordres", "")
SWITCHTEXT(newships, "Nouveaux navires", "")
SWITCHTEXT(subsidiaries, "Grer les entreprises concurentes", "")
SWITCHTEXT(gradualloading, "chargement graduel des vhicules", "")
SWITCHTEXT(moveerrorpopup, "Dplace les messages d'erreur", "")
SWITCHTEXT(setsignal1waittime, "Nouveaux dlais d'attente des train aux feux", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Masque des catastrophes", ": %d")
SWITCHTEXT(forceautorenew, "Changement automatique des vhicules", "")
SWITCHTEXT(morenews, "Plus d'infos via les actualits", "")
SWITCHTEXT(unifiedmaglev, "Maglev unifis", ", mode %d")
SWITCHTEXT(newbridgespeeds, "Vitesse max de ponts maglev", ": %d%%")
SWITCHTEXT(eternalgame, "Partie infinie apres 2070", "")
SWITCHTEXT(showfulldate, "Affichage complet de la date", "")
SWITCHTEXT(newtrains, "Nouveaux trains", "")
SWITCHTEXT(newrvs, "Nouveaux vhicule routiers", "")
SWITCHTEXT(newplanes, "Nouveaux avions", "")
SWITCHTEXT(signalsontrafficside, "Signaux du ct du 'traffic'", "")
SWITCHTEXT(electrifiedrail, "Voies lectriques", "")
SWITCHTEXT(newstartyear, "Date de dpart", ": %d")
SWITCHTEXT(newerrorpopuptime, "Dure des messages d'erreur", ": %d s.")
SWITCHTEXT(newtowngrowthfactor, "Nouveau facteur de croissance", " de %d")
SWITCHTEXT(largertowns, "Grandes villes", ", 1 sur %d")
SWITCHTEXT(miscmods, "Changements divers", ": %d")
SWITCHTEXT(loadallgraphics, "Toujours charger les nouveaux graphs", "")
SWITCHTEXT(saveoptdata, "Sauve et charge info optionnelles", "")
SWITCHTEXT(morebuildoptions, "Plus d'options de construction", ": %d")
SWITCHTEXT(semaphoresignals, "Semaphores avant 1975", "")
SWITCHTEXT(morehotkeys, "Nouvelle touches de raccourci", "")
SWITCHTEXT(plantmanytrees, "Plantation de beaucoup d'arbres", "")
SWITCHTEXT(morecurrencies, "Autorise plus de monnaies", ", flags: %d")
SWITCHTEXT(manualconvert, "Conversion manuelle des voies", "")
SWITCHTEXT(newtowngrowthrate, "Algo de croissance des villes", ": %d")
SWITCHTEXT(displmoretownstats, "Infos supplmentaires des villes", "")
SWITCHTEXT(enhancegui, "Interface amliore", ": %d")
SWITCHTEXT(newagerating, "Notes plus tolrantes de l'ge", "")
SWITCHTEXT(buildonslopes, "Construction sur les pentes avance", "")
SWITCHTEXT(buildoncoasts, "Construction sur les ctes", "")
SWITCHTEXT(experimentalfeatures, "Active les options experimentales", ": %d")
SWITCHTEXT(tracktypecostdiff, "Cot diffrents des voies ferres", "")
SWITCHTEXT(planespeed, "Vitesse relle des avions", "")
SWITCHTEXT(fastwagonsell, "Vente accelere des wagons", "")
SWITCHTEXT(newrvcrash, "Change collisions train/VR"," (mode %d)")
SWITCHTEXT(stableindustry, "Empeche la fermeture des industries","")
SWITCHTEXT(plantmanytrees, "Planter beaucoup d'arbres", ", mode %d")


// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Fichier CFG introuvable %s: ignor.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Impossible d'ouvrir %s en criture.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Attention!  Ligne CFG de plus de 32 caractres: tronque.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "L'option `%s' (-%s) est obsolte. Veuillez ne pas l'utiliser,\n"
		"elle sera retire dans une prochaine version.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "Fichier de Configuration TTDPatch, cr automatiquement par\n"
	CFG_COMMENT "TDPatch -W [fichier-cfg].\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Format des options:\n"
	CFG_COMMENT "   nom_option = valeur_option\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Le \"=\" et les espaces peuvent tre omis puisqu'ils sont ignors.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Pour les options de type marche/arrt [y/n], la valeur peut tre:\n"
	CFG_COMMENT "   Marche: yes, y, on, 1. Arrt: no, n, off, 0.\n"
	CFG_COMMENT "Si la valeur est omise, la valeur par dfaut est \"yes\" (option active).\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Pour les options  valeur numrique [v], la valeur par\n"
	CFG_COMMENT "dfaut est indique dans la description.  L'option peut tre dsactive\n" 
	CFG_COMMENT "en indiquant une valeur du type' arrt' (cf ci-avant).\n" 
	CFG_COMMENT "\n" 
	CFG_COMMENT "Les commentaires commencent par n'importe quel caractre non-alphabtique.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Nouvelles options ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) augmente la nombre maximum de navires.  Valeur: de %ld  %ld, par dfaut %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) fixe la vitesse dans les virages  normal (0), rapide (1), trs rapide (2) ou realiste (3). Un chiffre pour chacun des voies ferres, monorail, maglev et vhicules routers. Par dfaut 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) fixe la vitesse dans les montagnes  normal (0), rapide (1), trs rapide (2) ou realiste (3). Un chiffre pour chacun des voies ferres, monorail, maglev et vhicules routers. Par dfaut 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) rend possible des stations plus tendues.  Valeur: de %ld  %ld, par dfaut %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) rend possible le changement du contenu des locomotives dans un dpot.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) permet de changer l'intervalle de service initial des nouvelles machines.  Valuer: de %ld  %ld, par dfaut %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) dsactive l'inflation, pour les cots comme les revenus.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) autorise l'agrandissement ou l'allongement de gares, jusqu' 7x7.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) fait se comporter diffremment l'option \"Non-stop\".")
SETTEXT(CFG_PLANES, "`%s' (-%s) augmente le nombre maximum d'avions et d'hlicoptres.  Valeur: de %ld  %ld, par dfaut %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) active un diffrent algorithme de calcul des temps de (d)chargement.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) augment le nombre maximum de vhicules routiers.  Valeur: de %ld  %ld, par dfaut %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) active les codes de triche.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) augmente le nombre maximum de trains.  Valeur: de %ld  %ld, par dfaut %ld.")
//SETTEXT(CFG_PLAYERS, "`%s' (-%s) dfinit les joueurs affects par les options de triche.  Une liste de joueurs de 0  7.")
SETTEXT(CFG_VERBOSE, "`%s' (-%s) affiche le sommaire des options avant le lancement de TTD.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) permet l'usage des 'pr-signaux' automatiquement pour amliorer la gestion des gares.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) augmente le nombre total de vhicules  valeur*850.  Valeur: de %ld  %ld, par dfaut %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) autorise les trains mammouhts avec jusqu' 126 wagons.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) fait que les trains quitte une gare si un *seul* type de cargo est complet.")
SETTEXT(CFG_SELECTGOODS, "Avec `%s' (-%s), les produits arrivent uniquement aprs que le service ait t inaugur.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) active l'emprunt/remboursement maximum en pressant 'Ctrl'.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) permet aux tours de bureaux d'accepter la nourriture (scnarios tropical/arctique).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) prserve les -vieilles- machines tant qu'elles sont utilises.")
SETTEXT(CFG_CDPATH, "`%s' (pas de switch) dfinit le chemin d'accs du CD.")
// Note- CFG_CDPATH has no command line switch, so don't give %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) prserve les petits aroports pour toujours.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) augmente le \"facteur de suite\" de l'IA.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) autorise les longs ponts (-> 127 cases).")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) permet le dynamitage de davantage de choses.")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s) permet un nombre arbitraire de locomotives sur un train. Achetez les locomotices supplmentaires avec 'Ctrl'.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) fait que les vhicules routiers se mettent en file devant une station au lieu de tourner en rond aux alentours.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) permet TTDPatch  s'excuter avec 2.5 Mo de mmoire, mais rduit la valeur max. pour la table tendue de vhicules  2.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) corrige diverses petites chose. Voir la documentation for des infos plus prcises.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) permet la construction du plus de 2 aroport par ville.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) ajoute la possibilit de corrompre dans le menu des communes.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) permet de contrler quand les avions vont s'craser. Valeur boolenne, dfaut 1 (Vraie).")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) affiche la vitesse actuelle pour tous les vhicules dans leur barre d'tat.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) renouvellement des machines qui ont servies ce nombre de mois en plus de leur dure de vie (%ld  %ld) Dfaut %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) rend les panneaux de triche payants.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) autorise le cycle : normal, pre-signaux, sorties et signaux combins avec 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) reconstruit TTDLOAD.OVL ou TTDLOADW.OVL  chaque lancement du jeu.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) ajoute le chargement dans le menu disque et le chargement d'un jeu dans l'diteur de scnario (sauvegarde avec 'Ctrl')")
SETTEXT(CFG_WIN2K, "`%s' (-%s) rend la version Windows de TTD compatible avec Windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) modifie le dchargement forc dans une station acceptant la cargaison et stocke le frt sans rmunration.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) permet d'ajouter les dpots aux ordres des vhicules.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) ajoute de nouveaux navires avec leur propres graphiques.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) permet de diriger les concurents si vous en possedez 75%%.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) change la faon dont son charg les vhicules (mthode plus raliste et graduelle (activer galement `loadtime').")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) dplace les messages d'erreurs en haut  droite de l'cran.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) change le nombre de jours d'attente d'un train devant un signal  sens unique (0..254, ou 255 pour une attente infinie).")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) change le nombre de jours d'attente d'un train devant un signal  double sens (0..254, ou 255 pour une attente infinie).")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) permet de choisir les catastrophes qui peuvent arriver. Code bit  bit, par dfaut 255 (toutes les catastrophes).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) renvoie immdiatement les vhicules au dpots lorsqu'il est temps de les remplacer (voir `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) gnre plus de messages d'informations, voir la documentation pour plus d'informations.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) rend possible la construction de locomotives monorail dans des dpots maglev et inversement.  Modes : 1 - convertie les locomotives maglev en monorail; 2 - convertie les locomotives monorail en maglev; 3 - garde la distinction monorail/maglev.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) change la vitesse maximale des ponts tubulaires (monorail et maglev) au pourcentage de la plus rapide des locomotives de la catgorie (%ld..%ld). Par dfaut %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) permet de jouer une partie illimite dans le temps, la date n'est pas rinitialise apres 2070.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) Montre toujours la date complte dans la barre infrieure, non plus uniquement lors d'une pause.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) active de nouveau trains avec de nouveaux graphiques.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) active de nouveau vhicules routiers avec de nouveaux graphiques.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) active de nouveau avions avec de nouveaux graphiques.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) active les passages  niveau du mme cot que celui o roule les vhicules.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) retire un des modes de rail magntiques (Monorail ou MagLev) et le remplace par un systme de rail lectrique.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) change la date de dbut des parties gnre alatoirement et permet un plus grand choix de date dans l'diteurde scnario (%ld..%ld). Par dfaut %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) modifie la dure d'affichage des messages d'erreurs ( 1..255, en secondes, ou 0 pour une trs longue periode. Par dfaul 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) change le facteur qui limite la croissante maximale d'une ville ( %ld..%ld). Par dfaut %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) permet  une ville sur le nombre donn de crotre plus rapidementr ( appliquer avec `towngrowthlimit') ( %ld..%ld). Par dfaut %ld (une ville sur quatre).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) permet de modifier le fonctionnement d'autres options (voir la documentation pour plus d'informations). Valeur code bit  bit, par dfaut 0 (pas de modifications).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) oblige TTDPatch  toujours charger tous les fichier .grf de newgrf(w).cfg, sans vrifier s'ils taient utiliss ou non dans une partie prcdente.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) permet  TTDPatch de sauvegarder et charger des informations additionnelle (et optionnelles)  la fin des sauvegardes.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) permet plus d'options de constructions. Valeur code bit  bit ( %ld..%ld ).Par dfaut %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) converti les nouveax signaux construits avant 1975 en smaphores.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) active les nouvelles touches de raccourci.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) permet de planter plus qu'un arbre sur une case, ou sur une zone rectangulaire avec Ctrl.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) active de nouvelles monnaies et l'Euro.  Paramtres: 0 - les symboles  leur place par dfaut; 1 - les symboles devant les nombres; 2 - les symboles apres les nombres. Ajoutez 4  la prcdente valeur pour dsactiver l'Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) permet de convertir manuellement les voies en construisant une nouvelle voie sur une voie existante.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) rend les gares plus tolrantes vis  vis de l'age des vhicules. Maintenant les wagons peuvent avoir 21 ans sans baisse  la place de 3 ans.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) Amliore l'interface. Valeur code bit  bit ( %ld..%ld). Par dfault %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) permet de dfinir des regles de calcul sur la croissance des villes.  Modes: 0 - TTD original, 1 - TTD tendu, 2 - personalis.  voir la documentation pour plus d'informations.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (pas de paramtre en ligne de commande) dfinit le taux minimal de croissance des villes, en nouvelles maisons par siecle.  Actif uniquement si `towngrowthratemode' est fix  2 ( %ld..%ld). Par dfaut %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (pas de paramtre en ligne de commande) dfinit le taux maximal de croissance des villes, en nouvelles maisons par siecle.  Actif uniquement si `towngrowthratemode' est fix  2 ( %ld..%ld). Par dfaut %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (pas de paramtre en ligne de commande) definit de combien l'existance de gares actives augmente le taux de croissance des villes (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2. ( %ld..%ld). Par Dfaut %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (pas de paramtre en ligne de commande) dfinit la contribution de chacune des gares actives dans la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2. ( %ld..%ld). Par dfaut %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment une gare active contribue  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  ( %ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment le nombre de passagers transports contribue  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment la quantit de courier transport contribue  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (pas de paramtre en ligne de commande) dfinit le nombre maximum de passagers entrant qui peuvent contribuer  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment le nombre de passagers entrants contribue  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (pas de paramtre en ligne de commande) dfinit la population optimale pour 2 sacs de courrier entrants (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment le courrier entrant contribue  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (pas de paramtre en ligne de commande) dfinit la population optimale pour 2 caisses de marchandise entrantes (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment les marchandises entrantes contribuent  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (pas de paramtre en ligne de commande) dfinit la nourriture minimal ncessaire pour une ville enneige ou en zone desertique, en nombre d'habitants pour 2 tonnes de nourriture entrante (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (pas de paramtre en ligne de commande) dfinit la population optimale pour 2 caisses de nouriture entrantes (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment la nourriture entrante contribue  la croissance d'une ville (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (pas de paramtre en ligne de commande) dfinit la quantit d'eau minimale requise pour une ville en zone dsertique, en nombre d'habitants pour 2 tonnes (2000 litres) d'eau (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (pas de paramtre en ligne de commande) dfinit la population optimale pour 2 tonnes (2000 litres) d'eau entrante du climat tropical (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment l'eau entrante contribue  la croissance d'une ville du climat tropical (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (pas de paramtre en ligne de commande) dfinit la population optimale pour 2 jouets entrants du monde des jouets (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment les jouets entrants contribuent  la croissance d'une ville du monde des jouets(voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (pas de paramtre en ligne de commande) dfinit la population optimale pour 2 boissons gazeuses entrantes du monde des jouets (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (pas de paramtre en ligne de commande) dfinit comment les boissons gazeuses entrants contribuent  la croissance d'une ville du monde des jouets (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (pas de paramtre en ligne de commande) dfinit le nombre de btiments de base pour le calcul impliquant `tgrtownsizefactor' (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (pas de paramtre en ligne de commande) dfinit l'importance de la taille d'une ville dans sa croissante (voir la documentation pour plus d'informations).  Actif uniquement si `towngrowthratemode' est fix  2.  (%ld..%ld).  Par Dfaut %ld (i.e. 25%% influence).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (pas de paramtre en ligne de commande) dfinit la population minimale d'une ville enneige pour qu'elle puisse crotre sans apport de nourriture.  Actif si `towngrowthratemode', `towngrowthlimit' ou `generalfixes' est activ.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (pas de paramtre en ligne de commande) dfinit la population minimale d'une ville en zone dsertique pour qu'elle puisse crotre sans apport ni de nourriture ni d'eau.  Actif si `towngrowthratemode', `towngrowthlimit' ou `generalfixes' est activ.  (%ld..%ld).  Par Dfaut %ld.")
SETTEXT(CFG_MORETOWNSTATS, "With `%s' (-%s) De nouvelles informations sont affiches dans les fentres des villes.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) Rend possible la construction de rails, de route et de gares sur des terrains en pente, sur un fondation comme les maisons.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) Rend possible la construction sur les ctes ou sur les bords de rivires sans avoir  untiliser la dynamite avant.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) Donne des prix diffrents suivant le type de rail.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (pas de paramtre en ligne de commande) Change le taux de la monnaie personnelle, exprim en pour mille.  Par Dfaut 1000 (1 pour une livre).  Actif uniquement si `morecurrencies' est activ.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) active les dernires options exprimentales.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) permet aux avion de voler  leur vitess relle et non  un quart de cette vitesse, rduit galement la vitesse lors des pannes  5/8.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) permet de vendre plus rapidement les wagon avec Ctrl")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) change le mode de collision train/vhicules routiers. %ld rend le train en panne aprs la collision. %ld dsactive compltement les collisions.Par dfaut: type %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) empche les industrie de fermer si l'conomie est rgle  stable dans les options");


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nAppuyez sur Entre pour xcuter TTD, Echap pour annuler, ou tout autre touche pour afficher les rglages.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Options actives:   (%c active, %c dsactive)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "sens unique : ")
SETTEXT(LANG_SWTWOWAY, "double sens : ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d jour(s)")
SETTEXT(LANG_INFINITETIME, "infini")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Pressez une touche pour excuter \"TTDLOAD %s\" (Echap pour abandonner).")

SETTEXT(LANG_SWABORTLOAD, "\nChargement du programme abandonne  la demande de l'utilisateur.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Erreur #%d interne  TTDPatch ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD n'est pas proprement install (erreur %d dans la base de registre)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Mmoire disponible insuffisante\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "pour lancer TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Code du mode protg trop long!\n")

// Show where the code was stored, %p is the location
SETTEXT(LANG_CODESTOREDAT, "Code du mode protg stock  %p.\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Swapping out de TTD.\n")

// Just before running ttdload, show this.  1st %s is ttdload.ovl, 2nd is the options
SETTEXT(LANG_RUNTTDLOAD, "Lancement %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Impossible d'excuter %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Rsultat: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Erreur!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Ne peut trouver le patch graphique %s, fichier vide cr.\n")
SETTEXT(LANG_ERRORCREATING, "Erreur de cration %s: %s\n")

