//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Hungarian")
COUNTRYARRAY(countries) = { 36, 0, 0x0e, 0 };
SETARRAY(countries);
	// english is default language (-1), and 0x09 is English in Windows

DOSCODEPAGE(852)	// The default DOS code page for this language
WINCODEPAGE(1250)	// The default Windows code page for this language
EDITORCODEPAGE(852)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " indts.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "mret")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "A program ezen verzijnak ismertek a cmzsei.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"FIGYELEM! A programverzidat nem tudtam beazonostani. Megprblhatom gy\n"
	"         meghatrozni a szksges informcit, s aztn indtani a TTD-t,\n"
	"         de ha ez sikertelen, a TTD vdelmi hibt fog okozni s kilp.\n"
	"\n"
	"         Attl fggen, hogy a rendszered mennyire viseli az ltalnos Vdelmi\n"
	"         Hibt, a szmtgped kifagyhat s adatokat veszthetsz. Tovbbi\n"
	"         informci a TTDPATCH.TXT fjl " VERSIONSECTION "-as pontjban.\n"
	"\n"
	"Igennel 'i' CSAK akkor vlaszolj, a tudod mit csinlsz. FIGYELMEZTETTELEK!\n"
	"Ettl fggetlenl akarod futtatni a TTD-t? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "iy")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Program betltse megszaktva.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Igyekszem...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "FIGYELEM: Verzi ismeretlen!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " hinyzik, eredeti fjlok keresse:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Nem talltam se a TYCOON.EXE-t se a %s-t.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "%s file nem tallhat.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "%s msolsa %s-be")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "%s nem futtathat\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Msolsi hiba - %s fjl nem ltezik.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Ismeretlen .EXE formtum.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Program verzi nem meghatrozhat.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "A program neve:\n  %s\nA pontos verzi %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "A verziszm tl sok jegy!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Ez nem Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Parsed verzi %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Ez a kiterjesztett md DOS-os EXE.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Ez a Windows-os EXE.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Ez nem egy ismert EXE formtum.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Sajnlom, a TTDPatch ezen verzija csak a %s-os verzival mkdik.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "rvnytelen szegmenshossz: %lx.\n")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Programmret belltsa %s MB-ra.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "%s nem rhat. Lehet, hogy rsvdett?\n")

// Installing the code loader
SETTEXT(LANG_INSTALLLOADER, "Kdtlt teleptse.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Kdtlt nem telepthet")
SETTEXT(LANG_DELETEOVL, " - prbld %s-t trlni.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s OK.\n")

// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Megszakts tetszleges billentyre.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Kilps Escape-el, tovbblps brmely ms billentyuvel.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Egyni szvegek betltse.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "%s olvassa: rvnytelen file formtum.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s-t jra ltre kell hozni a TTDPatch ezen verzijhoz.\n"
	"Krlek tltsd le s futtasd a legjabb mkpttxt.exe programot.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "TTD patch-else s %s patch-elt program indtsa\n"
	  "\n"
	  "Hasznlat: TTDPATCH [-C cfg-fjl] [kapcsolk] [CD tvonal] [-W cfg-fjl]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:  Minden kapcsol, kivve -x",
	  "-d:  Mindig a teljes dtum kijelzse",
	  "-f:  Mozdonyok talakthatak",
	  "-g:  Nhny ltalnos javts",
	  "-k:  Kis repterek megtartsa",
	  "-l:  7x7-es max. vastlloms-mret",
	  "-n:  j non-stop kezels",
	  "-q:  Fejlesztett rakodsi algoritmus",
	  "-s:  Tbls csalsok engedlyezse",
	  "-v:  Kapcsolk sszefoglalsa futskor",
	  "-w:  El-jelzsek automata teleptse",
	  "-y:  'Verzi' krdskr tugrsa",
	  "-z:  Mammut vonatok (126 kocsi)",

	  "-B:  Hosszabb hidak",
	  "-D:  Dinamit tbb dolgot lerombol",
	  "-E:  Piros zenetek thelyezse",
	  "-F:  Teljes rakomny brmely rura",
	  "-G:  llomsi rekomny megvlasztsa",
	  "-I:  Inflci kikapcsolsa",
	  "-J:  Vrosonknt tbb reptr",
	  "-L:  Max. klcsn/trleszts 'Ctrl'-al",
	  "-N:  jsghr tbb esemnyrl",
	  "-O:  Irodahzak elfogadnak telt",
	  "-P:  Mozdonyok megtartsa hasznlatkor",
	  "-R:  Kzti jrmvek felsorakoznak",
	  "-S:  j hajtpusok",
	  "-T:  j vonatmodellek",
	  "-Z:  Alacsony memriahasznlat (3.5MB)",

	  "-2:  Nhny Windows 2000 javts",

	  "-Xb: Lefizethet helyi nkormnyzatok",
	  "-Xd: Depk ticlknt is megadhatak",
	  "-Xe: 2070 utn vgtelen jtkhossz",
	  "-Xf: rutovbbad algoritmus",
	  "-Xg: Egyenletes tem rakods",
	  "-Xi: Stab. gazd-nl megmarad ipar",
	  "-Xm: Tltsi menpont a lemez menben",
	  "-Xo: Tbls csalsok pnzbe kerlnek",
	  "-Xr: TTDLOAD.OVL lland jraptse",
	  "-Xs: Sebessg kijelzse a sttuszsoron",
	  "-Xw: Kibvtett el-jelzs felllts",
	  "-Xx: Extra adatok tltse/mentse",

	  "-XA: Knyszer auto-feljts -Xa-val",
	  "-XE: Villamostott vastvonalak",
	  "-XF: Ksrleti funkcik be",
	  "-XG: j grafikk mindig betltse",
	  "-XP: j replogpmodellek",
	  "-XR: j kzti jmumodellek",
	  "-XS: MI lenyvllalatok irnytsa",

	  "-Ya: Jobb minosts koros jrmuvekkel",
	  "-Yb: Tbb dolog lejton ptse",
	  "-Yc: Klnbzo r vasti vgnyok",
	  "-Ym: Egyni plyakonverzi",
	  "-Ys: Vasti jelzsek a kzti oldalon",
	  "-Yt: Tbb statisztika a vros-ablakban",
	  "-Yw: Gyorsabb vastikocsi-elads",

	  "-YC: Kzvetlen tengerpartra pts",
	  "-YH: Tbb/j gyorsbillentyuk",
	  "-YP: Replok a kirt seb-el mozognak",
	  "-YS: Szemaforok 1975 elott",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Kiterjedtebb llomsok\n"
	  "-i #:    Alap szervzgyakorisg megadsa napokban\n"
	  "-x #:    Jrmszm kibvtse 850*#-ra/re. Inf a tjkoztatban!\n"
	  "-mc #:   j domborzat-, s kanyarkezels, rendre\n"
	  "-trpb #: Vonatok, kzti j.-k, replk s hajk szmnak kibvtse rendre\n"
	  "-A #:    Mestersges Inteligencia feljavtsa ezen KIS rtkkel.\n"
	  "-M #:    Tbbmozdonyos vonatok be, gyorsuls megadsa szzalkban.\n"
	  "-Xa #:   Jrmvek automatikus feljtsa # hnappal a max letkor utn\n"
	  "-Xc #:   Replgp-szerencstlensgek szablyozsa\n"
	  "-Yr #:   Kzti-vonat balesetek jellegnek megadsa (1/2)\n"
	  "-Xt #:   Maximlis vrosmret megadsa\n"
	  "-XC #:   Tbb pnznem, s azok kijelzsi belltsai\n"
	  "-XD #:   Lehetsgesen bekvetkez katasztrfk meghatrozsa\n"
	  "-XM #:   Nyeregvast s maglev vgnyok sszevonsa\n"
	  "-XT #:   A megadott szmbl egy vros gyorsabban s nagyobbra no\n"
	  "-XX #:   j nyeregvast s maglev seb. a hidakon, a maximum seb. %%-ban\n"
	  "-XY #:   j jtkok kezdovnek megadsa\n"
	  "-X1 #, -X2 #: Vonatok vrakozsi ideje (nap) 1- ill. 2-irny piros jelzseknl\n"
	  "-Yo #:   Nhny egyb kapcsol tovbbi finomhangolsa (lsd a dokumentcit)\n"
	  "-Yp #:   Tbb fa egyideju teleptse, s ennek mdja\n"
	  "-YB #:   Tbb ptsi lehetosg, ezek paramterei\n"
	  "-YE #:   Piros hibazenetek megjelentsi idotartama\n"
	  "-YG #:   Bovtett felhasznli interfsz, ennek paramterei\n"
	  "-YT #:   Vrosnvekedsi algoritmus megadsa\n"
	  "\n"
	  "-C cfg-fjl:  Ttdpatch.cfg helyett ezen konfigurcifjl hasznlata\n"
	  "-W cfg-fjl:  Megadott paramterekkel j konfigurcifjl ltrehozsa\n"
	  "\n"
	  "Nagy-, s kisbetk szmtanak!\n"
	  "\n"
	  "Plda:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n"
	  "(Tipp:  Ha tl gyorsan listzdik, hasznld a \"ttdpatch -h|more\"-t)\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Tovbbi informcirt lsd TTDPATCH.TXT-t.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Figyelem: A(z) %s egy ismeretlen be/ki llapot. Kikapcsolva.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "A(z) '%c%s' egy ismeretlen kapcsol. Sg: -h.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Figyelem: rvnytelen a(z) '%s'-dik cfg sor.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Teljes jrmszm bvtse", " %d*850-re")
SWITCHTEXT(usenewcurves, "j kanyarkezels", " %04x-nl/nl")
SWITCHTEXT(usenewmountain, "j domborzatkezels", " %04x-nl/nl")
SWITCHTEXT(usenewnonstop, "j non-stop kezels", "")
SWITCHTEXT(increasetraincount, "Vonatok j szma:", " %d")
SWITCHTEXT(increaservcount, "Kzti jrmvek j szma:", " %d")
SWITCHTEXT(setnewservinterval, "j szervzintervallum:", " %d nap")
SWITCHTEXT(usesigncheat, "Tbls csalsok", "")
SWITCHTEXT(allowtrainrefit, "Mozdonytalakts", "")
SWITCHTEXT(increaseplanecount, "Replgpek j szma:", " %d")
SWITCHTEXT(increaseshipcount, "Hajk j szma:", " %d")
SWITCHTEXT(keepsmallairports, "Kis repterek megtartsa", "")
SWITCHTEXT(largerstations, "Kiterjedtebb llomsok:", " %d mez.")
SWITCHTEXT(morestationtracks, "Kibvthet llomsok", "")
SWITCHTEXT(longerbridges, "Hosszabb hidak", "")
SWITCHTEXT(improvedloadtimes, "Fejlesztett rakodsi algoritmus", "")
SWITCHTEXT(mammothtrains, "Mammut vonatok (127 hossz)", "")
SWITCHTEXT(presignals, "El-jelzsek automata teleptse", "")
SWITCHTEXT(officefood, "Irodahzak elfogadnak telt", "")
SWITCHTEXT(noinflation, "Inflci kikapcsolsa", "")
SWITCHTEXT(maxloanwithctrl, "Max klcsn/trleszts 'Ctrl'-al", "")
SWITCHTEXT(persistentengines, "Mozdonyok megtartsa hasznlatkor", "")
SWITCHTEXT(fullloadany, "Teljes rakomny brmely rura", "")
SWITCHTEXT(selectstationgoods, "llomsi rakomny megvlasztsa", "")
SWITCHTEXT(morethingsremovable, "Tbb lebonthat dolog", "")
SWITCHTEXT(aibooster, "MI-tuning rtk:", " %d")
SWITCHTEXT(multihead, "Tbbmozdonyos vonatok", ", gyors.: %d%%")
SWITCHTEXT(newlineup, "Kzti jrmvek felsorakoznak", "")
SWITCHTEXT(lowmemory, "Cskkentett meriahasznlat (3.5MB)", "")
SWITCHTEXT(generalfixes, "ltalnos javtsok (lsd. dokum.)", "")
SWITCHTEXT(moreairports, "Tbb reptr vrosonknt", "")
SWITCHTEXT(bribe, "Lefizetsi lehetsg", "")
SWITCHTEXT(noplanecrashes, "Replgplezuhans-kezels", ": %d")
SWITCHTEXT(showspeed, "Jrmsebessg kijelzse", "")
SWITCHTEXT(autorenew, "Jrmvek feljtsa", " %d h utn")
SWITCHTEXT(cheatscost, "Tbls csalsok pnzbe kerlnek", "")
SWITCHTEXT(extpresignals, "El-jelzsek teleptse 'Ctrl'-al", "")
SWITCHTEXT(diskmenu, "Tlts opci a lemezmenben", "")
SWITCHTEXT(win2k, "Windows 2000/XP javtsok", "")
SWITCHTEXT(feederservice, "rutovbbad algoritmus", "")
SWITCHTEXT(gotodepot, "Depk megadhatak ticlknt", "")
SWITCHTEXT(newships, "j hajmodellek", "")
SWITCHTEXT(subsidiaries, "MI lenyvllalatok irnytsa", "")
SWITCHTEXT(gradualloading, "Egyenletes tem rakods", "")
SWITCHTEXT(moveerrorpopup, "Piros zenetek thelyezse", "")
SWITCHTEXT(setsignal1waittime, "Vonatok j vrakozsi ideje", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Katasztrfa-maszk", ": %d")
SWITCHTEXT(forceautorenew, "Knyszer auto-feljts", "")
SWITCHTEXT(morenews, "jsghr tbb esemnyrl", "")
SWITCHTEXT(unifiedmaglev, "sszevont maglev", ", md %d")
SWITCHTEXT(newbridgespeeds, "Max. seb. maglev hidakon", ": %d%%")
SWITCHTEXT(eternalgame, "rkjtk 2070 utn", "")
SWITCHTEXT(showfulldate, "Mindig teljes dtum", "")
SWITCHTEXT(newtrains, "j vonatmodellek", "")
SWITCHTEXT(newrvs, "j kzti jrmumodellek", "")
SWITCHTEXT(newplanes, "j replomodellek", "")
SWITCHTEXT(signalsontrafficside, "Vasti jelzsek a kzti oldalon", "")
SWITCHTEXT(electrifiedrail, "Villamostott vasutak", "")
SWITCHTEXT(newstartyear, "Alap kezdov", ": %d")
SWITCHTEXT(newerrorpopuptime, "Hibazenetek ideje", ": %d mp.")
SWITCHTEXT(newtowngrowthfactor, "Vrosnvekedsi faktor", " %d")
SWITCHTEXT(largertowns, "Nagyobb vrosok", ", minden %d-bol 1")
SWITCHTEXT(miscmods, "Egyb mdostsok", ": %d")
SWITCHTEXT(loadallgraphics, "Minden j grafika betltse", "")
SWITCHTEXT(saveoptdata, "Extra adatok mentse/tltse", "")
SWITCHTEXT(morebuildoptions, "Tbb ptsi lehetosg", ": %d")
SWITCHTEXT(semaphoresignals, "Szemaforok 1975 elott", "")
SWITCHTEXT(morehotkeys, "Tbb/j gyorsbillentyuk", "")
SWITCHTEXT(plantmanytrees, "Tbb fa teleptse", ", md %d")
SWITCHTEXT(morecurrencies, "j pnznemek", ", kapcsolk: %d")
SWITCHTEXT(manualconvert, "Egyni plyakonverzi", "")
SWITCHTEXT(newtowngrowthrate, "j nvekedsi algoritmus", ": %d")
SWITCHTEXT(displmoretownstats, "Tbb vrosi statisztika", "")
SWITCHTEXT(enhancegui, "Bovtett jtkinterfsz", ": %d")
SWITCHTEXT(newagerating, "Jobb megtls koros jrmuveknl", "")
SWITCHTEXT(buildonslopes, "Tbb dolog lejtore ptse", "")
SWITCHTEXT(buildoncoasts, "Tengerpartra pts", "")
SWITCHTEXT(experimentalfeatures, "Ksrleti funkcik be", ": %d")
SWITCHTEXT(tracktypecostdiff, "Klnbzo vgny-rak", "")
SWITCHTEXT(planespeed, "Valdi reploseb.", "")
SWITCHTEXT(fastwagonsell, "Gyorsabb kocsielads", "")
SWITCHTEXT(newrvcrash, "Vasti-kzti balesetek"," (md: %d)")
SWITCHTEXT(stableindustry, "Iparvidkek megmaradnak","")


// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "%s nev cfg-fjl nem tallhat. tugorva.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "%s nem rhat.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Figyelem!  A konfigurcis sor hoszabb 32 karakternl, levgva.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "A `%s' (-%s) kapcsol idejtmlt. Krlek ne hasznld,\n"
	"egy jvbeni verziban eltvoltsra kerl.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch Konfigurcis Fjl, 'TTDPatch -W fjlnv' utastssal automatikusan ltrehozva.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "A kapcsolk formtuma:\n"
	CFG_COMMENT "   kapcsolnv = kapcsolrtk\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "A \"=\" a szkzkkel egytt elhagyhat.  Nagy/kisbet nem szmt.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Az igen/nem [i/n] kapcsolknl a lehetsges rtkek:\n"
	CFG_COMMENT "   igen: yes, y, on, 1\n"
	CFG_COMMENT "	nem: no, n, off, 0\n"
	CFG_COMMENT "Ha az rtkads elmarad, az igen/nem kapcsolk alaprtke 'igen'.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Az rtkkel [v] rendelkez kapcsolknl a lersban szerepel az intervallum,\n"
	CFG_COMMENT "valamint az alaprtelmezett rtk az rtkads elhagysa esetn. \n"
	CFG_COMMENT "Ezen kapcsolk a 'nem' rtkek egyikvel kapcsolhatk ki.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Megjegyzsnek szmt minden sor ami nem betvel kezddik.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** j kapcsolk ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) a megadott rtkre nveli a hajk maximlis szmt. Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) megadja a haladsi sebessget a kanyarokban, mely lehet norml (0), gyorsabb (1), leggyorsabb (2) s valsghu (3). Egy-egy szmjegy rendre a vastra, nyeregvastra, maglev-re s kzti jrmuvekre. Alap: 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) megadja a haladsi sebessget a hegyeken, mely lehet norml (0), gyorsabb (1), leggyorsabb (2) s valsghu (3). Egy-egy szmjegy rendre a vastra, nyeregvastra, maglev-re s kzti jrmuvekre. Alap: 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) lehetv teszi az llomsok nagyobb kiterjedst.  Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) talakthatv teszi a raktrrel rendelkez mozdonyokat.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) az j mozdonyok szervzgyakorisgt mdostja.  Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) kikapcsolja az inflcit mind a bevtelekre, mind az rakra.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) bvthetv teszi az llomsokat, 7x7-es maximlis mretig.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) a \"Non-stop\" kapcsol mkdst mdostja.")
SETTEXT(CFG_PLANES, "`%s' (-%s) a megadott rtkre nveli a replgpek maximlis szmt.  Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) msfajta algoritmust hasznl a rakodsi id kiszmtsra.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) a megadott rtkre nveli a kzti jrmvek maximlis szmt.  Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) engedlyezi a tbls csalsokat.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) a megadott rtkre nveli a vonatok maximlis szmt.  Intervallum %ld..%ld.  Alap: %ld.")
//*#define CFG_PLAYERS "`%s' (-%s) megadja mely jtkosokat rintik a tbls csalsok.  Jtkoslista 0..7"
SETTEXT(CFG_VERBOSE, "`%s' (-%s) a TTD indtsa eltt rvid sszefoglalst ad a kapcsolk llsrl.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) az llomsok hatkonyabb mkdse rdekben automatikusan telept el-jelzseket.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) a megadott rtk 850-szeresre nveli a jrmvek megengedett sszltszmt.  Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) engedlyezi a maximum 126 kocsis mammut vonatokat.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) a vonat elhagyja az llomst ha teljes rakomny utasts esetn brmelyik rufajtbl megtelt.")
SETTEXT(CFG_SELECTGOODS, "`%s' (-%s) az ru csak megfelel szlltsi kpessg jelentkezse utn gylik az llomsra.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) a 'Ctrl' billentyvel maximlis mrtkig lehet hitelt felvenni ill. trleszteni.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) irodahzak elfogadjk az telt (trpusi/sarkkri plyk).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) megtart minden a mozdonyt amg az hasznlatban van.")
SETTEXT(CFG_CDPATH, "`%s' (nincs parancssori kapcsolja) megadja a CD elrsi tvonalt.")
// Note- CFG_CDPATH has no command line switch, so don't give the second %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) megtartja vgig a kis reptereket.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) megadott szmmal megnveli a Mestersges Intelligencia jragondolsi rtkt.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) megengedi a max. 127 mezs hidakat.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) tbb dolog dinamitos lebontst engedlyezi.")
SETTEXT(CFG_MULTIHEAD, "`%s' (%ld%s) lehetv teszi tbbmozdonyos vonatok ltrehozst. jabb mozdonyok vsrlsa 'Ctrl'-al. A paramter az j mozdony ltal biztostott max. sebessgnvekedst adja meg szzalkban %ld, alap: %ld%%.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) a kzti jrmvek felsorakoznak az llomsok eltt ahelyett hogy visszafordulnnak.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) hatsra a TTDPatch 2,5 MB memrival is fut, de a jrmszmbvts maximlis rtke ekkor 2.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) megjavt szmos apr hibt, lsd rszletesen a dokumentciban.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) az eredeti kettnl tbb repteret engedlyez vrosonknt.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) a helyi nkormnyzati menben megjelent egy 'lefizets' lehetsget.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) meghatrozza mikor zuhan le egy replgp. Bitkdolt rtk , Alap: 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) feltnteti a jrmvek sebessgt az ablakukban.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) szervizelskor feljtja a mozdonyokat ennyi hnappal a maximlis letkoruk utn.  Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) a tbls csalsok hasznlata pnzbe kerl.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) a 'Ctrl' billentyvel vltogathatunk sima, el-, kilp-, s kombinlt vasti jelszsek kztt.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) a TTDPatch minden egyes indtskor jrapti a TTDLOAD.OVL vagy a TTDLOADW.OVL fjlt.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) megjelent egy 'tlts' lehetsget a lemezmenben, s egy jtk betltse (vagy 'Ctrl'-al jtk elmentse) lehetsget a terepszerkesztben.")
SETTEXT(CFG_WIN2K, "`%s' (-%s) hatsra a Windows-os TTD kompatbilis lesz a Windows 2000/XP-vel.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) knyszertett lerakods esetn mg egy fogadkpes llomson is ottmarad az ru, hogy az tovbbszllthat legyen. Ilyenkor nem jr pnz az rurt!")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) ezltal depkat is megadhatunk a jrmvek ticljaiknt pl. szervzelsi clbl.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) aktivlja az j hajmodelleket s grafikkat.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) 75%%-os tulajdoni rszeseds esetn irnythatjuk a MI vllalatait.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) egy sokkal valsghbb, egyenletes rakodsi algoritmust aktivl (aktivlja a `loadtime' kapcsolt is!).")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) minden piros figyelmeztet ablak a kperny jobb-fels sarkban jelenik meg.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) megadja hogy visszaforduls eltt hny napot vrjon egy vonat egy 1-irny jelszsnl. Intervallum 0..254, vagy 255 hogy rkk vrjon.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) megadja hogy visszaforduls eltt hny napot vrjon egy vonat egy 2-irny jelszsnl. Intervallum 0..254, vagy 255 hogy rkk vrjon.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) meghatrozza hogy mely katasztrfk kvetkezhetnek be.  Bitkdolt rtk, alap: 255 (sszes katasztrfa).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) kiknyszerti a szervizelst ha aktulis mr az automatikus feljts (lsd `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) tbb esemnyrl generl zenetet/jsgcikket, bvebb informci a dokumentciban.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) lehetov teszi a nyeregvasutak vsrlst a maglev depkban, vagy ugyanez fordtva. Mdok: 1 - sszes maglev mozdony talaktsa nyeregvastt; 2 - sszes nyeregvast mozdony talasktsa maglev-v; 3 - nyeregvast s maglev klnvlasztva marad.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) az adott osztlyban elrheto maximlis mozdonysebessg ezen megadott szzalkra korltozza a nyeregvasutak s maglev-ek 'csohdon' val haladsi sebessgt. Intervallum %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) engedlyezi az rkjtkot, a dtum nem vlt vissza 2070 utn.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) mindig a teljes dtum kijelzse. Nemcsak akkor amikor a jtk 'pause'-olva van.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) aktivlja az j vasti modelleket s grafikkat.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) aktivlja az j kzti jrmumodelleket s grafikkat.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) aktivlja az j replogp modelleket s grafikkat.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) a vasti jelzsek a vgny azon oldalra kerlnek, mely megfelel a kzti jrmuvek haladsnak.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) az egyik mgneses vastrendszert (nyeregvast vagy maglev) villamostott vasti vgnyrendszerre cserli.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) egyrszt megadja a vletlenszeruen generlt j jtkok kezdovt, msrszt tgabb dtumintervallumot engedlyez a 'scenario editor'-ban. Intervallum  %ld..%ld.  Alap: %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) megadja mennyi ido elteltvel tunnek el a piros hibazenetek. Intervallum 1..255 (msodpercben), vagy 0 esetn nagyon hossz ido.  Alap: 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) mdostja a vrosok maximlis kiterjedst meghatroz tnyezot. Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) a megadott szmbl egy-egy vros nagyobbra s gyorsabban no (a `towngrowthlimit' kapcsolt szelektven aktivlja).  Intervallum 1..32.  Alap %ld (minden %ldbol %ld).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) lehetov teszi nhny kapcsol mukdsnek tovbbi befolysolst, lsd bovebben a dokumentcit.  Bitkdolt rtk, alap 0 (nincs vltoztats).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) hatsra a TTDPatch mindenkppen betlti a newgrf(w).cfg-ben tallhat sszes grafikt, fggetlenl attl, hogy az adott jtkban hasznlatban voltak-e.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) hatsra a TTDPatch extra adatokat ment/tlt az elmentett llsok vg-re/rol.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) tbb ptsi lehetosget engedlyez. Bitkdolt rtk, intervallum %ld..%ld. Alap %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) az 1975 elott ptett vasti jelzseket szemaforokk vltoztatja.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) engedlyezi az j gyorsbillentyuket.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) egynl tbb fa teleptst engedlyezi egy mezore, vagy Ctrl-al egy ngyszgletu terletre.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) engedlyezi az eurt s tovbbi pnznemeket.  Paramter: 0 - pnznemek jelei az alaprtelmezett helyen; 1 - pnznemek jelei a szmok elott; 2 - pnznemek jelei a szmok utn.  Az elobbi paramterek rtkeihez 4-et hozzadva az eur kikapcsolhat.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) engedlyezi az egyni plyakonverzit, gy egyszeruen a korbbi vgnyokra rpthetoek az jak.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) az egyes llomsok a trsasgok rtkelsnl tolernsabbak lesznek az idosebb kocsik irnt. gy a vasti kocsik mr 21 s nem csak 3 vesek lehetnek.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) bovti a felhasznli interfszt.  Bitkdolt rtk, intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) lehetov teszi a vrosok nvekedsi szablyainak mdostst. Mdok: 0 - TTD eredeti, 1 - TTD kibovtett, 2 - egyni.  Tovbbi inf a dokumentciban.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (nincs parancssori kapcsol) megadja a vrosok nvekedsi temnek minimumt, j hz/vszzad-ban.  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (nincs parancssori kapcsol) megadja a vrosok nvekedsi temnek maximumt, j hz/vszzad-ban.  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (nincs parancssori kapcsol) megadja mennyire nveli egy aktv lloms ltezse egy vros nvekedsi temt (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (nincs parancssori kapcsol) megadja mennyire nveli minden egyes aktv lloms egy vros nvekedsi temt (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrulnak hozz az aktv llomsok egy vros nvekedsi temhez  (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrulnak hozz a szlltott utasok egy vros nvekedsi temhez (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrul hozz a szlltott posta egy vros nvekedsi temhez  (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (nincs parancssori kapcsol) megadja egy vros nvekedsi temt maximlisan befolysol berkezo utasok szmt (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrulnak hozz a berkezo utasok egy vros nvekedsi temhez (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (nincs parancssori kapcsol) magadja az optimlis lakossgot kt-kt zsk berkezo postnknt (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrul hozz a berkezo posta egy vros nvekedsi temhez  (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (nincs parancssori kapcsol) magadja az optimlis lakossgot kt-kt lda berkezo ksztermkenknt (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrulnak hozz a berkezo ksztermkek egy vros nvekedsi temhez (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (nincs parancssori kapcsol) megadja a havas vagy sivatagos terleteken a vrosok minimlis lelmiszerignyt lakossg/2 tonna berkezo lelmiszer-ben (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (nincs parancssori kapcsol) magadja az optimlis lakossgot kt-kt tonna berkezo lelmiszerenknt (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrul hozz a berkezo lelmiszer egy vros nvekedsi temhez (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (nincs parancssori kapcsol) megadja a sivatagos terleteken a vrosok minimlis vzignyt lakossg/2 tonna (2,000 liter) berkezo vz-ben (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (nincs parancssori kapcsol) magadja az optimlis lakossgot kt-kt tonna (2,000 liter) berkezo vzmennyisgenknt a trpusi plykon (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrul hozz a berkezo vz egy vros nvekedsi temhez a trpusi plykon (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (nincs parancssori kapcsol) magadja az optimlis lakossgot kt-kt tonna berkezo cukorknknt (dessg) a toyland plykon (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrul hozz a berkezo cukorka (dessg) egy vros nvekedsi temhez a toyland plykon (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (nincs parancssori kapcsol) magadja az optimlis lakossgot kt-kt berkezo sznsavas italonknt a toyland plykon  (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (nincs parancssori kapcsol) megadja mennyire hatsosan jrul hozz a berkezo sznsavas ital egy vros nvekedsi temhez a toyland plykon (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (nincs parancssori kapcsol) megadja a maximlis figyelembe vett pletszmot a 'tgrtownsizefactor' szmtsakor (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (nincs parancssori kapcsol) megadja mennyire befolysolja a vros mrete annak nvekedsi temt (tovbbi inf a dokumentciban).  Csak akkor aktv, ha a `towngrowthratemode' rtke 2.  Intervallum %ld..%ld.  Alap %ld (gy 25%% befolys).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (nincs parancssori kapcsol) megadja mekkora minimlis lakossgra nohet egy vros a havas plykon lelmiszerellts nlkl. Csak akkor aktv ha a 'towngrowthratemode', a 'towngrowthlimit' vagy a `generalfixes'  be van kapcsolva.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (nincs parancssori kapcsol) megadja mekkora minimlis lakossgra nohet egy vros a sivatagi plykon lelmiszer- s vzellts nlkl. Csak akkor aktv ha a 'towngrowthratemode', a 'towngrowthlimit' vagy a `generalfixes'  be van kapcsolva.  Intervallum %ld..%ld.  Alap %ld.")
SETTEXT(CFG_MORETOWNSTATS, "`%s' (-%s) ltal extra statisztikk jelennek meg a vrosok informcis ablakaiban.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) lehetov teszi llomsok, vgnyok s utak lejtore ptst olyan alapzaton mint amilyet vrosok hzai is hasznlnak.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) lehetov teszi a foly- s tengerpartokra val ptkezst anlkl, hogy elotte a dinamitot kellene hasznlni.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) hatsra a klnbzo vgnytpusok ms-ms rak lesznek.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (nincs parancssori kapcsol) megadja az egyni pnznem tvltsi rfolyamt (CUS * 1000).  Az alap 1000 (1 CUS = 1 angol font).  Csak akkor aktv, ha a 'morecurrencies' is be van kapcsolva.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) engedlyezi a legjabb ksrleti funkcikat.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) hatsra a replogpek valban a kijelzett sebessgen replnek majd (annak negyede helyett), valamint lerobbans esetn lecskkenti a replogpek sebessgt a maximum 5/8-ra.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) lehetov teszi a vasti kocsik gyors eladst a Ctrl-al")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) mdostja a kzti/vasti tkzseket. Mdok: %lda vonat lerobban tkzskor, %ld kikapcsolja az tkzseket. Alap: %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) megakadlyozza az iparvidkek bezrst ha a nehzsgi belltsoknl a stabil gazdasg van kivlasztva.");


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nNyomj Enter-t a futtatshoz, Escape-et a megszaktshoz, vagy brmi ms billentyut a belltsok megtekintshez.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Aktv kapcsolk:   (%c aktv, %c inaktv)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "|*-")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "1-irny: ")
SETTEXT(LANG_SWTWOWAY, "2-irny: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d nap")
SETTEXT(LANG_INFINITETIME, "vgetlen")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Nyomj brmilyen billentyt a \"TTDLOAD %s\" futtatshoz (Escape-re megszakts).")

SETTEXT(LANG_SWABORTLOAD, "\nProgram betltse felhasznli utastsra megszaktva.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Belso TTDPatch hiba #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "A TTD nincs megfeleloen teleptve (%d-s szm regisztrcis adatbzis hiba)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Nincs elg memria %s, %d KB-al tbb kell.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "a TTD indtshoz")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Vdett md kd tl nagy!\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Swap-ols.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 3rd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "%s%s%s indtsa\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "%s nem futtathat: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Eredmny: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Hiba!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "%s grafika nem tallhat, res fjl ltrehozsa.\n")
SETTEXT(LANG_ERRORCREATING, "Hiba %s ltrehozsakor: %s\n")

