//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Italian")
COUNTRYARRAY(countries) = { 39, 0, 0x10, 0 };
SETARRAY(countries);
	// 39 is Italy, 0x10 is Italian in Windows

DOSCODEPAGE(850)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(850)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 in avvio.\n"
// The program name and version are autogenerated, only put the " in avvio\n"
// here
SETTEXT(LANG_STARTING, " in avvio.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "dimensione")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Questa  una versione riconosciuta di TTD.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"La versione del programma non  stata riconosciuta. Si pu provare\n"
	"         a partire ugualmente e a determinare le informazioni necessarie, ma se\n"
	"         questo non riuscisse, TTD terminer in errore.\n"
	"\n"
	"         A seconda di come il tuo PC gestisce i file *GRF, il computer\n"
	"         potrebbe bloccarsi, e potresti perdere dati. Controlla la sezione\n"
	"         " VERSIONSECTION " di TTDPATCH.TXT per maggiori informazioni.\n"
	"\n"
	"Rispondi 's' solo se sei completamente sicuro.\n"
	"Vuoi far partire TTD lo stesso? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yso"
SETTEXT(LANG_YESKEYS, "s")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Caricamento del programma fallito.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Cerco di fare del mio meglio...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "Versione sconosciuta!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " non trovato, cerco i file originali:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "TYCOON.EXE e %s : file non trovati.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "%s : file non trovato.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Sto copiando %s in %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Non riesco a eseguire %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Errore di copia - il file %s non esiste.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Formato .EXE non valido.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Non riesco a determinare la versione del programma.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "Il nome del programma  %s\nLa versione esatta  %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "La versione contiene troppe cifre !!!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Suino, questo non  Transport Tycoon Deluxe !!!\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "La versione  %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Questo  un eseguibile DOS esteso.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Questo  un eseguibile Windows.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Questo non  un formato eseguibile.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Questa versione di TTDpatch funziona solo con la versione %s di TTD.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Lunghezza non valida del segmento originale di %lx.")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Incremento la dimensione del codice a %sMB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Non riesco a scrivere su TTDLOAD.OVL,  un file read-only?\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Sto installando il caricatore del codice.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Non riesco a installare il caricatore del codice")

// Suggestion to delete TTDLOAD.OVL (%s) if it is invalid
SETTEXT(LANG_DELETEOVL, " - prova a cancellare %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s  OK.\n")
 
// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Premere un tasto per uscire.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Premere esc per uscire o un altro tasto per continuare.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Sto caricando i testi personalizzati.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "%s: Formato file non valido.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s deve essere ricreato per questa versione di ttdpatch TTDPatch.\n"
	"Scaricare ed eseguire l'ultima versione di mkpttxt.exe.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Modifico TTD e avvio il programma modificato %s\n" 
	  "\n" 
	  "Sintassi: TTDPATCH [-C cfg-file] [switches] [CD Path] [-W cfg-file]\n" 
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:  Tutti gli switch tranne -x",
   	  "-d:  Mostra sempre la data intera",
	  "-f:  Locomotori riadattabili x ",
          "     carichi diversi",
	  "-g:  Aggiustamenti vari",
	  "-k:  Gli aeroporti piccoli rimangono", // #
	  "-l:  Stazioni fino a 7 binari",
	  "-n:  Nuova gestione del non-stop ",
	  "     per i treni",
	  "-q:  Algoritmo per lo scaricamento ",
	  "     migliorato",
	  "-s:  Abilita i cheat \"a cartello\"",
	  "-v:  Mostra tutti gli switch ",
	  "     prima di iniziare",
	  "-w:  Abilita i pre-segnali",
	  "-y:  Salta il riconoscimento ",
	  "     di versione",
	  "-z:  Treni mammut (fino a 126 vagoni)",
	  "-B:  Ponti pi lunghi",                     // #
	  "-D:  La dinamite distrugge pi oggetti",      // #
	  "-E:  Sposta nell'angolo i popup rossi",
	  "-F:  Il pieno carico di un solo tipo ",
	  "     di merce fa partire il treno",
	  "-G:  Le merci arrivano alle stazioni",
	  "solo quando il servizio  cominciato",
	  "-I:  Disattiva l'inflazione",
	  "-J:  Citt con pi di 2 aeroporti",
	  "-L:  Prestito/rimborso max ",
	  "     con \"Ctrl\"",
	  "-N:  Notizie su pi eventi",
	  "-O:  I grattacieli di uffici ",
	  "     accettano cibo",
	  "-P:  Le locomotive vecchie rimangono ",
	  "     nella lista se utilizzate",
	  "-R:  Bus e camion aspettano in coda",
	  "-S:  Nuovi modelli di nave",
	  "-T:  Nuovi modelli di treno",
	  "-Z:  Versione per memoria piccola ",
	  "     (3.5MB)",
	  "-2:  Patch per Windows 2000",
	  "-Xb: Consiglio comunale corruttibile",
	  "-Xd: Itinerari includono depositi",
	  "-Xe: Partite eterne dopo il 2070",
	  "-Xf: Scar. forz. lascia merci in staz.",
	  "-Xg: Caricamento graduale dei veicoli",
	  "-Xi: Nessuna industria chiude se ",
          "     l'economia  stabile",
	  "-Xm: Menu \"Disco\" pi versatile",
	  "-Xo: I cheat \"a cartello\" costano il",
	  "     corrispettivo di quello che fanno",
	  "-Xr: Ricrea sempre TTDLOAD.OVL",
	  "-Xs: Mostra la velocit ",
	  "     nelle barre di stato dei veicoli",
	  "-Xw: Pre-segnali pi versatili",
	  "-Xx: Salva e carica dati addizionali",
	  "-XA: Auto rinnovamento veicoli con -Xa",
	  "-XE: Ferrovie elettrificate",
	  "-XF: Abilita funzionalit sperimentali",
	  "-XG: Carica tutti i nuovi elem grafici",
	  "-XP: Nuovi modelli di aereo",
	  "-XR: Nuovi modelli di bus e camion",
	  "-XS: Dirigi ditte col 75%%",
	  "-Ya: Il rating tollera veic. + vecchi",
	  "-Yb: Costr. + cose in celle in pendenz",
	  "-Yc: Div. tipi d ferrov. cost. divers.",
	  "-Ym: Abil. convers. man. d. ferrovie",
	  "-Ys: Segnali ferr. sul lato di marcia",
	  "-Yt: Nuove stat. nella finestra citt",
	  "-Yw: Vendita istant. di tutti i vagoni",
	  "-YC: Costruzioni sulle coste",
	  "-YH: Nuove hotkey",
	  "-YP: Gli aerei volano alla vel. indic.",
	  "-YS: Semafori a barra prima del 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n" 
	  "-e #:    Aumenta l'estensione max delle stazioni composte a # quadratini\n" 
	  "-i #:    Modifica la frequenza degli interventi di manutenzione a # giorni\n" 
	  "-x #:    Estende la matrice dei veicoli a 850*#. Leggi la documentazione!\n" 
	  "-mc #:   Nuova gestione delle salite e delle curve\n"
	  "-trpb #: Incrementa il numero di treni, camion, aerei e navi a #.\n" 
	  "-A #:    Migliora l'int.artificiale con un coeff. Usare solo piccoli valori.\n"
	  "-M #:    Abilita treni con pi locomotori e regola incremento %% di velocit.\n"
	  "-Xa #:   Rinnova automaticamente i veicoli # mesi prima del limite\n"
	  "-Xc #:   Regola la frequenza degli incidenti aerei\n"
	  "-Yr #:   Cambia il funzionamento degli incidenti fra treni e bus/camion (1/2)\n"
	  "-Xt #:   Imposta la massima dimensione delle citt\n"
	  "-XC #:   Valute alternative e opzioni per la visualizzazione delle valute\n"
	  "-XD #:   Scegli quali disastri possono succedere\n"
	  "-XM #:   Combina monorotaia e maglev\n"
	  "-XT #:   Stabilisci ogni quante citt una deve crescere pi rapida e grande\n"
	  "-XX #:   Nuovi limiti di velocit per i ponti tubolari, in %% sulla velocit\n"
          "         del locomotore pi rapido nella sua classe (monorotaia/maglev)\n"
	  "-XY #:   Imposta l'anno iniziale per nuove partite generate a caso\n"
	  "-X1 #, -X2 #: Massima durata di attesa a semafori a 1 e 2 direzioni, in giorni\n"
	  "-Yo #:   Impostazioni particolari (vedi la documentazione)\n"
	  "-Yp #:   Pianta pi alberi, modalit per piantare alberi\n"
	  "-YB #:   Nuove opzioni per costruzioni, selezionabili con parametro\n"
	  "-YE #:   Tempo di vita dei popup rossi, in secondi\n"
	  "-YG #:   Opzioni per la nuova interfaccia utente, selezionabili con parametro\n"
	  "-YT #:   Cambia l'algoritmo per la crescita delle citt\n"
	  "\n"
	  "-C cfg-file:  Leggi questo file di configurazione invece di ttdpatch.cfg\n" 
	  "-W cfg-file:  Crea un file di configurazione con la configurazione corrente\n"
	  "\n" 
	  "(Sugg.:  Se tutto scorre troppo rapidamente, scrivi \"ttdpatch -h|more\"\n" 
	  "\n" 
	  "Maiuscole e minuscole hanno significati diversi!\n" 
	  "\n" 
	  "Ex.: ttdpatch -fnqz -m 00 -c 13 -trpb 240 -v\n" 
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Leggi TTDPATCH.TXT per maggiori dettagli.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Occhio: Impostazione on/off %s sconosciuta, settata su off.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Switch '%c%s' sconosciuto.  Usa -h per l'help.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Occhio: Stringa di configurazione '%s' non valida.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Estende il numero veicoli", " a %d*850")
SWITCHTEXT(usenewcurves, "Nuova gest. curve", " : %04x")
SWITCHTEXT(usenewmountain, "Nuova gest. salite", " : %04x")
SWITCHTEXT(usenewnonstop, "Nuova gestione non-stop", "")
SWITCHTEXT(increasetraincount, "Nuovo numero treni", ": %d")
SWITCHTEXT(increaservcount, "Nuovo numero camion", ": %d")
SWITCHTEXT(setnewservinterval, "Intervallo di serv.", ": %d giorni")
SWITCHTEXT(usesigncheat, "Usa cheat a cartello", "")
SWITCHTEXT(allowtrainrefit, "Treni riadattabili", "")
SWITCHTEXT(increaseplanecount, "Nuovo numeri aerei", ": %d")
SWITCHTEXT(increaseshipcount, "Nuovo numeri navi", ": %d")
SWITCHTEXT(keepsmallairports, "Mantiene gli aeroporti piccoli", "")
SWITCHTEXT(largerstations, "Stazioni pi estese", "")
SWITCHTEXT(morestationtracks, "Stazioni con pi binari", "")
SWITCHTEXT(longerbridges, "Ponti pi lunghi", "")
SWITCHTEXT(improvedloadtimes, "Nuovo alg. carico-scarico.", "")
SWITCHTEXT(mammothtrains, "Treni mammut (127 vagoni)", "")
SWITCHTEXT(presignals, "Usa pre-segnali", "")
SWITCHTEXT(officefood, "Grattacieli di uffici acc. cibo", "")
SWITCHTEXT(noinflation, "Disattiva l'inflazione", "")
SWITCHTEXT(maxloanwithctrl, "prestito/rimborso max con w/ctrl", "")
SWITCHTEXT(persistentengines, "Tiene modelli vecchi se in uso", "")
SWITCHTEXT(fullloadany, "Pieno carico di 1 solo tipo di merce", "")
SWITCHTEXT(selectstationgoods, "Arrivo merci a servizio iniziato", "")
SWITCHTEXT(morethingsremovable, "Pi cose rimovibili", "")
SWITCHTEXT(aibooster, "Pi intelligenza artificiale", " di %d")
SWITCHTEXT(multihead, "Treni con pi locom.", "velocit: + %d%%")
SWITCHTEXT(newlineup, "Bus e camion aspettano in coda", "")
SWITCHTEXT(lowmemory, "Versione per memoria piccola (3.5MB)", "")
SWITCHTEXT(generalfixes, "Aggiustamenti vari (vedi docu)", "")
SWITCHTEXT(moreairports, "Pi di 2 aeroporti per citt", "")
SWITCHTEXT(bribe, "Opzione per corrompere il comune", "")
SWITCHTEXT(noplanecrashes, "Regola numero incidenti aerei", ": %d")
SWITCHTEXT(showspeed, "Veloc. nelle barre di stato veicoli", "")
SWITCHTEXT(autorenew, "Rinnova veicoli autom.", " ogni %d mesi")
SWITCHTEXT(cheatscost, "I cheat a cartello costano il giusto", "")
SWITCHTEXT(extpresignals, "Imposta pre-segnali con 'Ctrl'", "")
SWITCHTEXT(diskmenu, "Opzione 'carica' nel Menu 'Disco'", "")
SWITCHTEXT(win2k, "Usa patch per Windows 2000/XP", "")
SWITCHTEXT(feederservice, "Scaric. forz. lascia merci in staz.", "")
SWITCHTEXT(gotodepot, "Include i depositi negli itinerari", "")
SWITCHTEXT(newships, "Consente nuovi modelli di nave", "")
SWITCHTEXT(subsidiaries, "Dirigi ditte se hai il 75%%", "")
SWITCHTEXT(gradualloading, "Caricamento dei veicoli graduale", "")
SWITCHTEXT(moveerrorpopup, "Sposta nell'angolo i popup rossi", "")
SWITCHTEXT(setsignal1waittime, "Nuovo timeout x attesa ai semafori", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Mask per i disastri", ": %d")
SWITCHTEXT(forceautorenew, "Auto rinnov. forzato dei veicoli", "")
SWITCHTEXT(morenews, "Notizie su pi eventi", "")
SWITCHTEXT(unifiedmaglev, "Maglev e monorotaia unificate", ": %d")
SWITCHTEXT(newbridgespeeds, "Vel. max. su ponti tubolari", ": %d%%")
SWITCHTEXT(eternalgame, "Gioca all'infinito dopo il 2070", "")
SWITCHTEXT(showfulldate, "Mostra sempre la data intera", "")
SWITCHTEXT(newtrains, "Nuovi modelli di treno", "")
SWITCHTEXT(newrvs, "Nuovi modelli di bus/camion", "")
SWITCHTEXT(newplanes, "Nuovi modelli di aereo", "")
SWITCHTEXT(signalsontrafficside, "Semafori sul lato di marcia", "")
SWITCHTEXT(electrifiedrail, "Ferrovie elettrificate", "")
SWITCHTEXT(newstartyear, "Anno iniziale di default", ": %d")
SWITCHTEXT(newerrorpopuptime, "Vita dei popup rossi", ": %d sec.")
SWITCHTEXT(newtowngrowthfactor, "Coeff. di crescita delle citt", ": %d")
SWITCHTEXT(largertowns, "Citt pi grandi", ": una ogni %d")
SWITCHTEXT(miscmods, "Opzioni particolari", ": %d")
SWITCHTEXT(loadallgraphics, "Carica tutti i nuovi elem. grafici", "")
SWITCHTEXT(saveoptdata, "Salva e carica dati aggiuntivi", "")
SWITCHTEXT(morebuildoptions, "Nuove opzioni per costruire", ": %d")
SWITCHTEXT(semaphoresignals, "Semafori a barra prima del 1975", "")
SWITCHTEXT(morehotkeys, "Nuove hotkeys", "")
SWITCHTEXT(plantmanytrees, "Pianta pi alberi", ", modalit %d")
SWITCHTEXT(morecurrencies, "Abilita pi valute", ", flags: %d")
SWITCHTEXT(manualconvert, "Conversione manuale dei binari", "")
SWITCHTEXT(newtowngrowthrate, "Nuovo algor. di crescita x citt", ": %d")
SWITCHTEXT(displmoretownstats, "Pi statistiche sulle citt", "")
SWITCHTEXT(enhancegui, "Interfaccia migliorata", ": %d")
SWITCHTEXT(newagerating, "Rating tollera veicoli pi vecchi", "")
SWITCHTEXT(buildonslopes, "Costruisci pi cose in pendenza", "")
SWITCHTEXT(buildoncoasts, "Costruisci su coste e argini", "")
SWITCHTEXT(experimentalfeatures, "Abilita opzioni sperimentali", ": %d")
SWITCHTEXT(tracktypecostdiff, "Diversi binari hanno costi diversi", "")
SWITCHTEXT(planespeed, "Velocit degli aerei come indicato", "")
SWITCHTEXT(fastwagonsell, "Vendi i vagoni tutti insieme", "")
SWITCHTEXT(newrvcrash, "Incidenti fra treni e autoveic.",": %d")
SWITCHTEXT(stableindustry, "Le industrie non chiudono","")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Non riesco a trovare il file cfg %s.  Ignorato.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Non riesco ad aprire %s per la scrittura.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Attenzione!  La linea di configurazione  pi lunga di 32 chr. Troncata.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "Lo switch `%s' (-%s)  obsoleto. Non utilizzarlo, sar rimosso nelle\n"
		"versioni future.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch Configuration File, creato automaticamente da TTDPatch -W filename.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "La sintassi per gli switch :\n"
	CFG_COMMENT "   switchname = switchvalue\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Il \"=\" pu essere omesso, cos come gli spazi.  Le minuscole vengono ignorate.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Per gli switch yes/no [y/n], i valori possibili sono:\n"
	CFG_COMMENT "   yes, y, 1, no, n, off, 0\n"
	CFG_COMMENT "Se un valore  omesso, viene interpretato come un yes.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Per gli switch con un valore [v], il range  dato nella descrizione\n"
	CFG_COMMENT ", e, se omesso,  considerato uguale a valore di default.  Lo switch pu\n"
	CFG_COMMENT "essere disattivato assegnandogli un valore pari a 'off'.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "I commenti sono tutte le linee che iniziano con un carattere non alfabetico.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Nuove opzioni ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) incrementa il massimo numero di navi.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) regola la velocit in curva: normale (0), pi veloce (1), ancora pi veloce (2) o realistica (3). La prima cifra  per le ferrovie normali, la seconda per le monorotaie, la terza per le linee a levitazione magnetica, la quarta per le strade. Default 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) regola la velocit in salita: normale (0), pi veloce (1), ancora pi veloce (2) o realistica (3). La prima cifra  per le ferrovie normali, la seconda per le monorotaie, la terza per le linee a levitazione magnetica, la quarta per le strade. Default 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) stazioni composite pi estese.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) rende possibile riadattare i vagoni a merci diverse.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) cambia l'intervallo di servizio dei treni.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) disattiva l'inflazione.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) permette di avere stazioni pi lunghe o con pi binari, fino a 7x5 o 4x7.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) cambia la gestione dello switch \"Non-stop\" permettendo di usare checkpoint.")
SETTEXT(CFG_PLANES, "`%s' (-%s) incrementa il massimo numero di aerei.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) abilita un calcolo pi 'furbo' dei tempi di carico/scarico.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) incrementa il massimo numero di camion.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) abilita i cheat a cartello.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) incrementa il massimo numero di treni.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_VERBOSE, "`%s' (-%s) mostra gli switch attivi prima di lanciare TTD.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) abilita i 'pre-segnali'.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) incrementa il numero totale di veicoli a val*850.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) permette di avere treni lunghi fino a 126 carrozze.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) cambia l'opzione \"pieno carico\". Il treno partir appena uno qualunque dei suoi tipi di merce  a pieno carico")
SETTEXT(CFG_SELECTGOODS, "With `%s' (-%s) le merci arrivano in stazione solo dopo l'inaugurazione del servizio di trasporto.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) chiedi prestito/ripaga debito al massimo possibile premendo Ctrl.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) i grattacieli di uffici accettano cibo (scenari tropicale/artico).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) si possono acquistare veicoli obsoleti fin quando sono in uso.")
SETTEXT(CFG_CDPATH, "`%s' (no command line switch) stabilisce il percorso del CD.")
// Note- CFG_CDPATH has no command line switch, so don't give %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) mantiene i piccoli aeroporti per sempre.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) migliora l'algoritmo di intelligenza artificiale del computer.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) ponti lunghi fino a 127 caselle.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) permette di distruggere pi cose con la dinamite.")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s) pi locomotrici sullo stesso treno. Quelle dopo la prima si comprano con 'Ctrl'.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) i bus e i camion si accodano anzich tornare indietro se la stazione  occupata.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) permette a TTDPatch di girare con 3.5MB di memoria, ma riduce a 2 il coefficiente per ingrandire la matrice dei veicoli.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) aggiusta svariate piccole cose, vedi la documentazione per maggiori dettagli.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) permette di costruire pi di 2 aeroporti per ogni citt.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) aggiunge l'opzione 'corrompi' al menu del consiglio comunale.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) regola la frequenza degli incidenti aerei. Valore binario, default 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) mostra la velocit istantanea dei veicoli nella barra di stato delle loro finestre.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) rinnova automaticamente i veicoli quando fanno un intervallo di manutenzione a distanza di x mesi da quando diventano molto vecchi.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) fa s che i cheat a cartello costino il corrispettivo di quello che fanno.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) permette di modificare il comportamento dei pre-segnali, ciclando fra segnale normale, pre-segnale, uscita da pre-segnale, segnale composto premendo 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) fa s che TTDPatch rigeneri TTDLOAD.OVL o TTDLOADW.OVL ogni volta che viene lanciato.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) aggiunge l'opzione 'carica file' al menu 'disco', e l'opzione 'carica' (o salva premendo Ctrl) all'editor degli scenari.")
SETTEXT(CFG_WIN2K, "`%s' (-%s) rende TTD per Windows compatibile con Windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) Lo scaricamento forzato lascia le merci in stazione, anche se questa accetta il carico. Il profitto viene conteggiato in proporzione alla tratta effettuata.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) permette di includere i depositi negli itinerari.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) attiva i nuovi modelli di nave con la nuova grafica.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) permette di dirigere ditte di cui possiedi il 75%%.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) i veicoli vengono caricati in modo graduale, pi realistico (e `loadtime' viene attivato).")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) sposta i popup di errore rossi nell'angolo dello schermo.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) cambia il numero di giorni dopo cui un treno fermo a un semaforo a 1 via torna indietro.  Range 0..254, o 255 per aspettare all'infinito.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) cambia il numero di giorni dopo cui un treno fermo a un semaforo a 2 vie torna indietro.  Range 0..254, o 255 per aspettare all'infinito.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) stabilisce quali tipi di disastri possono accadere. Valore in bit, default 255 (tutti i disastri).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) forza la manutenzione dei veicoli quando arriva il momento dell'auto rinnovamento (vedi `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) genera messaggi e notizie su pi eventi, vedi docu.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) Permette di comprare locomotori per monorotaia in depositi di treni a levitazione magnetica o viceversa. Valori: 1 - converte tutti i locomotori maglev in monorotaia; 2 - converte tutti i locomotori per monorotaia in maglev; 3 - mantieni monorotaia e levitazione magnetica separate.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) Sostituisce il limite di velocit sui ponti tubolari con una percentuale della massima velocit del veicolo pi rapido nella sua classe (monorotaia/maglev). Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) Permette di giocare all'infinito, la data non si annulla dopo il 2070.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) Mostra sempre la data intera, non solo quando il gioco  in pausa.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) Abilita i nuovi modelli di treno con la nuova grafica.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) Abilita i nuovi modelli di autoveicoli con la nuova grafica.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) Abilita i nuovi modelli di aereo con la nuova grafica.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) I semafori sono posti sullo stesso lato del senso di marcia.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) Sostituisce monorotaia o maglev con una ferrovia elettrificata.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) Regola la data iniziale per i giochi generati a caso e permette una scelta pi ampia della data iniziale nello scenario editor. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) Stabilisce dopo quanto tempo i popup rossi si chiudono automaticamente. Range 1..255 (in secondi), o 0 per un tempo molto lungo. Default 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) Cambia il fattore che limita l'estensione massima delle citt. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) Fa crescere una citt ogni tot pi rapidamente e pi grande (usando 'towngrowthlimit' selettivamente).  Range %ld..%ld.  Default %ld (una citt su quattro).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) Permette di modificare il comportamento di certe altre opzioni (vedi la documentazione per maggiori informazioni). Valore bitcoded, default 0 (nessun cambiamento).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) Carica sempre tutti i file .grf elencati in newgrf(w).cfg, anche se non erano in uso in un gioco salvato.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) Salva e legge dati addizionali quando salva e apre una partita.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) Abilita nuove opzioni per la costruzione. Valore bitcoded, range %ld..%ld. Default %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) I semafori costruiti prima del 1975 sono a barra.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) Abilita le nuove hotkey.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) Permette di piantare pi alberi sullo stesso quadrato, o simultaneamente su un'area rettangolare se si preme Ctrl.")SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) Abilita pi valute e l'Euro. Valore: 0 - simbolo della valuta al solito posto; 1 - simbolo della valuta prima dell'importo; 2 - simbolo della valuta dopo l'importo. Aggiungere 4 per disabilitare l'Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) Permette di convertire i binari a mano, costruendo un tratto sopra uno gi esistente.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) Rende pi tollerante la valutazione alle stazioni. Ora i vagoni possono avere fino a 21 anni, non pi tre.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) Migliora l'interfaccia utente. Valore bitcoded, range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) Permette di definire regole per l'algoritmo di crescita delle citt. Valori: 0 - TTD originale, 1 - TTD esteso, 2 - custom. Vedi la documentazione per maggiori informazioni.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (non  attivabile dalla riga di comando) Stabilisce il minimo tasso di crescita delle citt, in case nuove per secolo. Funziona solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (non  attivabile dalla riga di comando) Stabilisce il massimo tasso di crescita delle citt, in case nuove per secolo. Funziona solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto l'esistenza di stazioni attive  influisce sul tasso di crescita delle citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto ciascuna stazione attiva influisce sul tasso di crescita delle citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce a che ritmo l'esistenza di stazioni attive influisce sul tasso di crescita delle citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto il numero di passeggeri trasportati  influisce sul tasso di crescita delle citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la quantit di posta trasportata  influisce sul tasso di crescita delle citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (non  attivabile dalla riga di comando) Stabilisce il numero massimo di passeggeri che pu andare a  influire sulla crescita di una citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto il numero di passeggeri in arrivo influisce sulla crescita di una citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2.  Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (non  attivabile dalla riga di comando) Stabilisce il numero ottimale di abitanti per ogni due borse di posta in arrivo (vedi la documentazione). Attivo solo se `towngrowthratemode'  2.  Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la quantit di posta in arrivo influisce sul tasso di crescita delle citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (non  attivabile dalla riga di comando) Stabilisce il numero ottimale di abitanti per ogni due casse di merce in arrivo (vedi la documentazione). Attivo solo se `towngrowthratemode'  2.  Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la quantit di merci in arrivo aumenta il tasso di crescita delle citt (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (non  attivabile dalla riga di comando) Definisce il fabbisogno di cibo nelle citt innevate o desertiche, in abitanti ogni due tonnellate di cibo entrante (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (non  attivabile dalla riga di comando) Definisce la quantit ottimale di cibo entrante nelle citt innevate o desertiche, in abitanti ogni due tonnellate di cibo entrante (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la quantit di cibo in arrivo influisce sul tasso di crescita delle citt innevate o desertiche (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (non  attivabile dalla riga di comando) Definisce il fabbisogno di acqua nelle citt desertiche, in abitanti ogni due tonnellate (2000 litri) di acqua entrante (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (non  attivabile dalla riga di comando) Definisce la quantit ottimale di acqua entrante nelle citt desertiche, in abitanti ogni due tonnellate (2000 litri) di acqua entrante (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la quantit di acqua in arrivo influisce sul tasso di crescita delle citt desertiche (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (non  attivabile dalla riga di comando) Definisce la quantit ottimale di dolci entrante nelle citt giocattolo, in abitanti ogni due borse di dolci entranti (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la quantit di dolci in arrivo influisce sul tasso di crescita delle citt giocattolo (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (non  attivabile dalla riga di comando) Definisce la quantit ottimale di bibite frizzanti entrante nelle citt giocattolo, in abitanti ogni due bibite frizzanti (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la quantit di bibite frizzanti in arrivo influisce sul tasso di crescita delle citt giocattolo (vedi la documentazione). Attivo solo se 'towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (non  attivabile dalla riga di comando) Stabilisce il numero di edifici di una citt che attivano il calcolo con `tgrtownsizefactor' (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (non  attivabile dalla riga di comando) Stabilisce quanto la dimensione di una citt influisce sul suo tasso di crescita (vedi la documentazione). Attivo solo se `towngrowthratemode'  2. Range %ld..%ld. Default %ld (corrispondente a un'influenza del 25%%).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (non  attivabile dalla riga di comando) Stabilisce il numero di abitanti che una citt innevata pu avere, anche senza rifornimento di cibo. Attivo solo se `towngrowthratemode', `towngrowthlimit' o `generalfixes' sono attivi. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (non  attivabile dalla riga di comando) Stabilisce il numero di abitanti che una citt desertica pu avere, anche senza rifornimento di cibo. Attivo solo se `towngrowthratemode', `towngrowthlimit' o `generalfixes' sono attivi. Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_MORETOWNSTATS, "With `%s' (-%s) Mostra pi statistiche nelle finestre delle citt.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) Permette di costruire binari, strade a stazioni su terreni inclinati, su un terrapieno come quello delle case.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) Permette di costruire su coste o argini senza usare prima la dinamite.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) Diversi tipi di binari hanno costi diversi.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (no command line switch) Regola il tasso di cambio per le valute personalizzate.Default 1000 (1 CUS = 1 pound). Funziona solo se `morecurrencies'  abilitato.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) Abilita le ultime opzioni sperimentali.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) Fa volare gli aerei alla velocit indicata anzich a un quarto, e la riduce a 5/8 in caso di avaria.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) Permette di vendere tutti i veicoli di un treno simultaneamente, premendo Ctrl")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) Cambia il comportamento negli incidenti fra treni e autoveicoli. %ld fa guastare il treno dopo l'incidente, %ld disabilita gli incidenti del tutto. Default: %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) Nessuna industria chiude mai se l'economia  stabile nella regolazione della difficolt.");


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nPremi enter per lanciare TTD, escape per uscire o un altro tasto per vedere le impostazioni.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n" 
	  "\n"
       "    Switch abilitati:   (%c abilitato, %c disabilitato)\n" )

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "Senso unico: ")
SETTEXT(LANG_SWTWOWAY, "Doppio senso: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d giorno(i)")
SETTEXT(LANG_INFINITETIME, "infinito")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Premi un tasto per avviare \"TTDLOAD %s\" (escape per uscire).")

SETTEXT(LANG_SWABORTLOAD, "\nCaricamento del programma fallito.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** TTDPatch: errore interno #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD non  installato correttamente (errore %d nel registro)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Memoria insufficiente %s, servono %d KB in pi.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "per avviare TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Codice protetto troppo grande!\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Sto uscendo.\n")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Codice modo protetto troppo grande!\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 3rd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Sto avviando %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Non riesco a eseguire %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Risultato: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Errore!")


// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Patch grafica %s non trovata, viene creato un file vuoto.\n")
SETTEXT(LANG_ERRORCREATING, "Errore generando %s: %s\n")

