//
// Localization strings for TTDPatch.
//
// to Polish language translated Marek Majkowski 		majek04@ids.pl		6.2.2001
//				CFG section translated on 11.2.2001
//				some fixes and some amplify 13.2.2001  19:39
//		more corrections and enhancements by Marcin Grzegorczyk 20.2.2001
// 		V1.8 translation by Marek Majkowski & Marcin Grzegorczyk 10.3.2002
//		V1.9 translation by Jakub (SHADOW-XIII) Grecki & Marcin Grzegorczyk 27.10.2002
//		V2.0 translation by Marcin Grzegorczyk 6.8.2003
//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Polish")
COUNTRYARRAY(countries) = { 48, 0, 0x15, 0 } ;		
SETARRAY(countries);

DOSCODEPAGE(852)	// The default DOS code page for this language
WINCODEPAGE(1250)	// The default Windows code page for this language
EDITORCODEPAGE(852)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.x starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, ": uruchamianie...\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "rozmiar pliku")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Ta wersja programu ma znane adresy.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"UWAGA!   Twoja wersja gry nie jest znana temu programowi. Mona sprbowa\n"
	"         uruchomi j mimo to i ustali potrzebne adresy, ale jeli\n"
	"         to zawiedzie, TTD moe spowodowa bd ochrony (GPF).\n"
	"\n"
	"         Zalenie od tego, jak twj system operacyjny obsuguje GPF, moe\n"
	"         to zawiesi twj komputer, i moesz straci dane. Zajrzyj do rozdziau\n"
	"         " VERSIONSECTION " w pliku TTDPATCH.TXT, aby uzyska obszerniejsze informacje.\n"
	"\n"
	"Wcinij 't' TYLKO jeli naprawd wiesz, co robisz. ZOSTAE OSTRZEONY!\n"
	"Czy mimo wszystko chcesz uruchomi Transport Tycoon Deluxe? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "yt")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "adowanie programu zostao przerwane.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Zobaczymy, co si da zrobi...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "UWAGA: Nieznana wersja!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " - nie znaleziono, szukam oryginalnych plikw:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Nie znaleziono ani TYCOON.EXE, ani %s.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "Nie znaleziono %s.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Kopiowanie %s do %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Nie udao si uruchomi %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Bd kopiowania - plik %s nie istnieje.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Nierozpoznany format pliku .EXE.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Nie udao si okreli wersji programu.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "Nazwa programu:\n  %s\nDokadna wersja: %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Za duo liczb w oznaczeniu wersji!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "To nie jest Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Przeanalizowana wersja: %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "To jest plik wykonywalny systemu DOS.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "To jest plik wykonywalny systemu Windows.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Format tego pliku nie jest znany.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Przykro mi, ta wersja programu TTDPatch dziaa tylko z wersj TTD dla %s.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Nieprawidowa oryginalna dugo segmentu (%lx)\n\t\t\t\t\t")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Ustalam rozmiar programu na %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Nie mog zapisywa do pliku %s.\n"
	"  Czy atrybut tylko do odczytu (read-only) nie jest ustawiony?\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Instalowanie programu adujcego kod ('code loader').\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Nie mog zainstalowa programu 'code loader'")

// Suggestion to delete TTDLOAD.OVL (%s) if it is invalid
SETTEXT(LANG_DELETEOVL, " - sprbuj skasowa %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s: OK.\n")
 
// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Nacinij dowolny klawisz, aby przerwa.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Nacinij Escape, aby przerwa, lub dowolny inny klawisz, aby kontynuowa.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Wczytywanie tekstw do gry.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "Odczyt %s: Nieprawidowy format pliku.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s musi zosta ponownie utworzony dla tej wersji TTDPatch.\n"
	"cignij i uruchom najnowsz wersj programu mkpttxt.exe.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Poprawia TTD i uruchamia poprawiony plik %s\n"
	  "\n"
	  "Uycie: TTDPATCH [-C plik-konf] [przeczniki] [cieka do CD] [-W plik-konf]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-2:  Poprawki do Windows 2000/XP",

	  "-a:  Wcza wszystkie przeczniki",
	  "                      (oprcz -x)",
	  "-d:  Zawsze pokazuje pen dat",
	  "-f:  'Refit' dla lokomotyw",
	  "-g:  Drobne poprawki w programie",
	  "-k:  Mae lotniska zawsze dostpne",
	  "-l:  Do 7 peronw na stacjach",
	  "-n:  Nowa obsuga 'non-stop'",
	  "-q:  Ulepszony czas za-/rozadunku",
	  "-s:  Wcza kody w napisach",
	  "-v:  Pokazuje stan przecznikw",
	  "     przed uruchomieniem gry",
	  "-w:  Automatyczne sygnay wjazdowe",
	  "-y:  Pomija pytanie przy nieznanej",
	  "     wersji TTD",
	  "-z:  Dugie pocigi (do 126 wagonw)",

	  "-B:  Dusze mosty",
	  "-D:  Dynamit usuwa wicej obiektw",
	  "-E:  Okienka bdw u gry ekranu",
	  "-F:  'Full load' dla jednego adunku",
	  "-G:  Na stacjach pojawiaj si tylko",
	  "     towary odbierane",
	  "-I:  Wycza inflacj",
	  "-J:  Wicej lotnisk na miasto",
	  "-L:  Maks. poyczka/spata z 'Ctrl'",
	  "-N:  Wicej komunikatw/wiadomoci",
	  "-O:  Biurowce przyjmuj ywno",
	  "-P:  Stare pojazdy pozostaj",
	  "     w sprzeday, dopki s w uyciu",
	  "-R:  Pojazdy drogowe czekaj w kolejce",
	  "-S:  Nowe typy statkw",
	  "-T:  Nowe typy lokomotyw i wagonw",
	  "-Z:  Mniejsze zuycie pamici (3.5MB)",

	  "-Xb: Umoliwia przekupywanie miast",
	  "-Xd: Zajezdnie na listach przystankw",
	  "-Xe: Czas nie zatrzymuje si w 2070 r.",
	  "-Xf: Transport z podziaem na etapy",
	  "-Xg: Stopniowe adowanie pojazdw",
	  "-Xi: Zakady przemys. nie zamykaj",
	  "     dziaalnoci w stabilnej ekonomii",
	  "-Xm: Opcja 'Load game' w menu dyskowym",
	  "-Xo: Kody w napisach kosztuj",
	  "-Xr: Zawsze utwrz nowy TTDLOAD.OVL",
	  "-Xs: Wywietla prdko w pasku stanu",
	  "-Xw: Rozszerzone sygnay wjazdowe",
	  "-Xx: Zapis i adowanie dodatk. danych",

	  "-XA: Wymusza auto-odnawianie z -Xa",
	  "-XE: Koleje zelektryfikowane",
	  "-XF: Funkcje eksperymentalne",
	  "-XG: Nowa grafika zawsze aktywna",
	  "-XP: Nowe typy samolotw",
	  "-XR: Nowe typy pojazdw drogowych",
	  "-XS: Zarzdzanie firmami komputera",

	  "-Ya: Wiksza tolerancja ocen jakoci",
	  "     transportu wzgl. wieku pojazdw",
	  "-Yb: Wicej moliwoci budowania",
	  "     na pochyym terenie",
	  "-Yc: Rny koszt rnych typw torw",
	  "-Ym: Rczna zmiana typu torw",
	  "-Ys: Sygnay kolejowe po tej samej",
	  "     stronie, co ruch drogowy",
	  "-Yt: Wicej informacji w oknach miast",
	  "-Yw: Uatwia sprzedawanie pocigw",

	  "-YC: Budowanie bezpor. na brzegu wody",
	  "-YH: Nowe skrty klawiszowe",
	  "-YP: Prdko samolotw zgodna",
	  "     ze wskazywan",
	  "-YS: Semafory kolejowe przed 1975 r.",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Zmienia maksymalny rozrzut elementw stacji\n"
	  "-i #:    Ustala standardowy czas midzyobsugowy pojazdw w dniach\n"
	  "-x #:    Zwiksza rozmiar tablicy pojazdw do 850*#. Przeczytaj dokumentacj!\n"
	  "-mc #:   Ustala zwalnianie odpowiednio na wzniesieniach i zakrtach\n"
	  "-trpb #: Ustala maksymaln liczb pocigw/samochodw/samolotw/statkw\n"
	  "-A #:    'Dopala' AI graczy komputerowych. Uywaj tylko maych liczb.\n"
	  "-M #:    Pocigi z wieloma lokomotywami, # okrela wzrost prdkoci w proc.\n"
	  "-Xa #:   Automatycznie odnawia pojazdy # miesicy po okresie amortyzacji\n"
	  "-Xc #:   Zmienia warunki wystpowania katastrof lotniczych\n"
	  "-Yr #:   Modyfikuje efekt kolizji pocigu z pojazdem drogowym; tryb 1 lub 2\n"
	  "-Xt #:   Okrela granic wzrostu miast\n"
	  "-XC #:   Wcza dodatkowe waluty oraz ustawia opcje ich wywietlania\n"
	  "-XD #:   Okrela, ktre katastrofy 'naturalne' mog wystpi\n"
	  "-XM #:   czy systemy 'monorail' i 'maglev'; tryb 1, 2 lub 3\n"
	  "-XT #:   Okrela, e jedno na podan liczb miast wzrasta szybciej\n"
	  "         i do wikszych rozmiarw (okrelonych przez -Xt)\n"
	  "-XX #:   Zwiksza maks. prdko na mostach typu 'monorail' i 'maglev',\n"
	  "         w procentach najwikszej maks. prdkoci pojazdw danego typu\n"
	  "-XY #:   Ustawia rok, w ktrym zaczynaj si losowo generowane gry\n"
	  "-X1 #, -X2 #: Max. czas oczekiwania pocigw na sygn. jedno- i dwukierunkowych\n"
	  "-Yo #:   Modyfikuje dziaanie niektrych przecznikw (patrz dokumentacja)\n"
	  "-Yp #:   Pozwala sadzi wicej drzew rwnoczenie, # okrela tryb dziaania\n"
	  "-YB #:   Wicej opcji konstrukcyjnych; parametr okrela, ktre s aktywne\n"
	  "-YE #:   Ustawia maks. czas wywietlania czerwonych okien bdw w sekundach\n"
	  "-YG #:   Ulepsza interfejs uytkownika; parametr okrela aktywne funkcje\n"
	  "-YT #:   Ustawia algorytm okrelajcy tempo wzrostu miast\n"
	  "\n"
	  "-C plik-konf:  Czyta ten plik konfiguracyjny zamiast TTDPATCH.CFG\n"
	  "-W plik-konf:  Tworzy plik konfiguracyjny z aktualnymi ustawieniami\n"
	  "\n"
	  "Istotne jest rozrnienie maych i wielkich liter w przecznikach!\n"
	  "\n"
	  "Przykad:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FGXmXs -Xa -12 -v\n"
	  "\n"
	  "(Podpowied: Jeli tekst 'przelecia' za szybko, wpisz \"ttdpatch -h|more\".)\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "\nNa polski z problemami przetumaczyli Marek Majkowski (majek04@ids.pl),\n"
	  " Marcin Grzegorczyk (mgrzegor@itma.pwr.wroc.pl)\n"
	  " oraz Jakub Grecki (shadow@onet.pl).\n"
	  "Przeczytaj TTDPATCH.TXT, aby uzyska szczegowe informacje.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Uwaga: Nieznany stan przecznika \"%s\", wyczono.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Nieznany przecznik '%c%s'.  Uyj -h dla uzyskania pomocy.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Uwaga: Nieprawidowe polecenie w pliku konfiguracyjnym:\n  %s\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Wiksza tablica pojazdw", ": %d*850")
SWITCHTEXT(usenewcurves, "Nowa obsuga zakrtw", " dla %04x")
SWITCHTEXT(usenewmountain, "Nowa obsuga wzniesie", " dla %04x")
SWITCHTEXT(usenewnonstop, "Nowa obsuga 'non-stop'", "")
SWITCHTEXT(increasetraincount, "Nowa max. liczba pocigw", ": %d")
SWITCHTEXT(increaservcount, "Nowa max. liczba samochodw", ": %d")
SWITCHTEXT(setnewservinterval, "Nowy czas midzyobsugowy", ": %d dni")
SWITCHTEXT(usesigncheat, "Kody w napisach", "")
SWITCHTEXT(allowtrainrefit, "'Refit' dla pocigw", "")
SWITCHTEXT(increaseplanecount, "Nowa max. liczba samolotw", ": %d")
SWITCHTEXT(increaseshipcount, "Nowa max. liczba statkw", ": %d")
SWITCHTEXT(keepsmallairports, "Mae lotniska zawsze dostpne", "")
SWITCHTEXT(largerstations, "Nowy max. rozrzut stacji", ", do %d pl")
SWITCHTEXT(morestationtracks, "Rozbudowywalne stacje kolejowe", "")
SWITCHTEXT(longerbridges, "Dusze mosty", "")
SWITCHTEXT(improvedloadtimes, "Ulepszony czas za-/rozadunku", "")
SWITCHTEXT(mammothtrains, "Dugie pocigi (max. dugo 127)", "")
SWITCHTEXT(presignals, "Automatyczne sygnay wjazdowe", "")
SWITCHTEXT(officefood, "Biurowce przyjmuj ywno", "")
SWITCHTEXT(noinflation, "Inflacja wyczona", "")
SWITCHTEXT(maxloanwithctrl, "Maks. poyczka/spata z 'Ctrl'", "")
SWITCHTEXT(persistentengines, "Stare pojazdy nie znikaj z listy", "")
SWITCHTEXT(fullloadany, "'Full load' dla jednego towaru", "")
SWITCHTEXT(selectstationgoods, "Na stacjach tylko towary odbierane", "")
SWITCHTEXT(morethingsremovable, "Wicej rzeczy usuwalnych", "")
SWITCHTEXT(aibooster, "Rekursja AI zwikszona", " o %d")
SWITCHTEXT(multihead, "Wielo-lokom. pocigi", ", %d%% przysp.")
SWITCHTEXT(newlineup, "Samochody czekaj w kolejce", "")
SWITCHTEXT(lowmemory, "Oszczdzanie pamici (3.5MB)", "")
SWITCHTEXT(generalfixes, "Oglne poprawki (patrz dokumentacja)", "")
SWITCHTEXT(moreairports, "Wicej lotnisk na miasto", "")
SWITCHTEXT(bribe, "Opcja 'bribe' ('przekup') dla miast", "")
SWITCHTEXT(noplanecrashes, "Kontrola katastrof lotniczych", ": %d")
SWITCHTEXT(showspeed, "Wywietl. prdkoci w pasku stanu", "")
SWITCHTEXT(autorenew, "Auto-odnaw. pojazdw", " (%d mies.)")
SWITCHTEXT(cheatscost, "Kody w napisach kosztuj", "")
SWITCHTEXT(extpresignals, "Ustaw. sygnaw wjazdowych z 'Ctrl'", "")
SWITCHTEXT(diskmenu, "Opcja 'Load game' w menu dyskowym", "")
SWITCHTEXT(feederservice, "Transport etapami poprzez 'Unload'", "")
SWITCHTEXT(win2k, "Poprawki do Windows 2000/XP", "")
SWITCHTEXT(gotodepot, "Stacje obs. na listach przystankw", "")
SWITCHTEXT(newships, "Nowe typy statkw", "")
SWITCHTEXT(subsidiaries, "Zarzdzanie firmami AI", "")
SWITCHTEXT(gradualloading, "Stopniowe adowanie pojazdw", "")
SWITCHTEXT(moveerrorpopup, "Czerwone okna bdw u gry ekranu", "")
SWITCHTEXT(setsignal1waittime, "Czas oczekiwania na sygnaach", ":\n\t")
SWITCHTEXT(setsignal2waittime, "", "")				// zapchajdziura
SWITCHTEXT(maskdisasters, "Maska katastrof", ": %d")
SWITCHTEXT(forceautorenew, "Wymuszanie auto-odnawiania", "")
SWITCHTEXT(morenews, "Wicej zdarze generuje komunikaty", "")
SWITCHTEXT(unifiedmaglev, "Poczone koleje magnet.", ", tryb %d")
SWITCHTEXT(newbridgespeeds, "Ogr. prdk. na mostach maglev", ": %d%%")
SWITCHTEXT(eternalgame, "Czas nie zatrzymuje si w 2070", "")
SWITCHTEXT(showfulldate, "Zawsze pena data na pasku stanu", "")
SWITCHTEXT(newtrains, "Nowe typy pocigw", "")
SWITCHTEXT(newrvs, "Nowe typy pojazdw drogowych", "")
SWITCHTEXT(newplanes, "Nowe typy samolotw", "")
SWITCHTEXT(signalsontrafficside, "Sygnay po stronie ruchu drogowego", "")
SWITCHTEXT(electrifiedrail, "Koleje zelektryfikowane", "")
SWITCHTEXT(newstartyear, "Standardowy rok startu gry", ": %d")
SWITCHTEXT(newerrorpopuptime, "Czas trwania okien bdw", ": %d s.")
SWITCHTEXT(newtowngrowthfactor, "Nowa granica wzrostu miast", ": %d")
SWITCHTEXT(largertowns, "Wiksze miasta", ", 1 na %d")
SWITCHTEXT(miscmods, "Rne modyfikacje", ": %d")
SWITCHTEXT(loadallgraphics, "Nowe .GRF zawsze aktywne", "")
SWITCHTEXT(saveoptdata, "Zapis i adow. dodatkowych danych", "")
SWITCHTEXT(morebuildoptions, "Wicej opcji konstrukcyjnych", ": %d")
SWITCHTEXT(semaphoresignals, "Semafory przed 1975", "")
SWITCHTEXT(morehotkeys, "Nowe skrty klawiszowe", "")
SWITCHTEXT(plantmanytrees, "Usprawn. sadzenie drzew", ", opcje: %d")
SWITCHTEXT(morecurrencies, "Wicej walut", ", opcje: %d")
SWITCHTEXT(manualconvert, "Rczna konwersja torw", "")
SWITCHTEXT(newtowngrowthrate, "Nowy alg. tempa wzrostu miast", ": %d")
SWITCHTEXT(displmoretownstats, "Wicej informacji o miastach", "")
SWITCHTEXT(enhancegui, "Ulepszony interfejs uytkownika", ": %d")
SWITCHTEXT(newagerating, "Alt. obliczanie jakoci transp.", "")
SWITCHTEXT(buildonslopes, "Budowanie na pochyym terenie", "")
SWITCHTEXT(buildoncoasts, "Budowanie bezpor. na brzegu wody", "")
SWITCHTEXT(experimentalfeatures, "Najnowsze funkcje eksperymentalne", ": %d")
SWITCHTEXT(tracktypecostdiff, "Rny koszt rnych typw torw", "")
SWITCHTEXT(planespeed, "Rzeczywista prdko samolotw", "")
SWITCHTEXT(fastwagonsell, "Szybkie sprzedawanie pocigw", "")
SWITCHTEXT(newrvcrash, "Zmodyf. kolizje poc./p.dr.", " (tryb %d)")
SWITCHTEXT(stableindustry, "Wy. zamknicia zak. przemys.", "")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Nie znaleziono pliku konfiguracyjnego %s.  Zignorowano.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Nie mog otworzy %s do zapisu!\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Uwaga! Wiersz w pliku konfiguracyjnym duszy ni 32 znaki zosta obcity.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "Przecznik `%s' (-%s) jest przestarzay.\n"
			     "  Nie uywaj go, w przyszej wersji zostanie usunity.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "Plik konfiguracyjny programu TTDPatch, utworzony automatycznie poleceniem\n"
	CFG_COMMENT "TTDPatch -W [nazwa pliku].\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Format dla przecznikw:\n"
	CFG_COMMENT "   przecznik = warto\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "'=' mona pomin, podobnie jak spacje.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Dla przecznikw typu w./wy. [y/n] wartoci moe by:\n"
	CFG_COMMENT "   wczony: yes, y, on, 1;   wyczony: no, n, off, 0\n"
	CFG_COMMENT "Jeli pominito warto, przecznik jest ustawiany na 'yes'.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Dla przecznikw, dla ktrych wartoci jest liczba [v], zakres podany jest\n"
	CFG_COMMENT "w komentarzu. W przypadku braku wartoci przyjmowana jest warto domylna.\n"
	CFG_COMMENT "Przecznik taki mona wyczy poprzez nadanie mu wartoci 'off'.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Komentarzami s wszystkie wiersze zaczynajce si od znakw nie nalecych do\n"
	CFG_COMMENT "alfabetu.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Nowe przeczniki ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) ustala maksymaln liczb statkw.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) ustawia prdko na zakrtach na normaln (0), zwikszon (1), maksymaln (2) lub realistyczn (3).  Jedna cyfra dla, odpowiednio: kolei, kolei jednoszynowych (monorail) lub zelektryfikowanych, kolei magnetycznych (maglev) i pojazdw drogowych.  Domylnie: 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) ustawia prdko na wzniesieniach na normaln (0), zwikszon (1), maksymaln (2) lub realistyczn (3).  Jedna cyfra dla, odpowiednio: kolei, kolei jednoszynowych (monorail) lub zelektryfikowanych, kolei magnetycznych (maglev) i pojazdw drogowych.  Domylnie: 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) umoliwia tworzenie stacji o wikszym rozrzucie (spread) jej elementw.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) umoliwia 'refit' (zmian typu przewoonego adunku) lokomotyw.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) zmienia standardowy czas midzyobsugowy (service interval) dla nowych pojazdw.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) wycza cakowicie inflacj.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) umoliwia dodawanie peronw oraz budowanie wikszych stacji kolejowych, a do 7x7 pl.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) powoduje, e opcja 'non-stop' w rozkadach jazdy daje inny efekt.")
SETTEXT(CFG_PLANES, "`%s' (-%s) ustala maksymaln liczb samolotw.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) wcza zmienion, bardziej realistyczn kalkulacj czasu zaadunku i rozadunku.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) ustala maksymaln liczb pojazdw drogowych.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) wcza kody specjalne w napisach (opcja \"Place sign\" w TTD).")
SETTEXT(CFG_TRAINS, "`%s' (-%s) ustala maksymaln liczb pocigw.  Zakres: %ld..%ld.  Domylnie: %ld.")
//*#define CFG_PLAYERS "`%s' (-%s) set the players to be affected by the cheats.  A list of players from 0..7"
SETTEXT(CFG_VERBOSE, "`%s' (-%s) proponuje wywietlenie stanu wszystkich przecznikw przed uruchomieniem TTD.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) wcza automatyczne sygnay wjazdowe ('pre-signals'), co umoliwia usprawnienie obsugi stacji.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) zwiksza ogln liczb pojazdw do zadanej wielokrotnoci 850.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) pozwala tworzy dugie pocigi, a do 126 wagonw (plus lokomotywa).")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) zmienia obsug opcji 'Full load' - pocig opuszcza stacj, gdy ktrykolwiek typ wagonw jest peen.")
SETTEXT(CFG_SELECTGOODS, "`%s' (-%s) powoduje, e towary pojawiaj si na stacji dopiero, gdy ich odbir zosta rozpoczty.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) umoliwia zacignicie lub spat (borrow/repay) maksymalnej wartoci kredytu przez przytrzymanie 'Ctrl'.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) wcza przyjmowanie ywnoci (food) przez biurowce  (scenariusze 'sub-tropical', 'sub-arctic').")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) powoduje, e uywane przez graczy pojazdy nie s wycofywane ze sprzeday.")
SETTEXT(CFG_CDPATH, "`%s' (bez przecznika w wierszu polece) ustawia ciek dostpu do CD.")
// Note- CFG_CDPATH has no command line switch, so don't give the second %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) umoliwia budowanie maych lotnisk zawsze, niezalenie od roku.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) zwiksza rekursj sztucznej inteligencji (AI) graczy komputerowych. Naley zwiksza warto stopniowo o 1, aby unikn nadmiernego spowolnienia komputera.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) pozwala na budowanie dugich mostw, a do 127 pl dugoci.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) pozwala usuwa dynamitem wicej obiektw (np. ulice w miastach).")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s) pozwala na dowoln liczb lokomotyw w pocigu.  Dodatkowe lokomotywy kupuje si trzymajc wcinity 'Ctrl'.  Warto okrela maksymalne zwikszenie prdkoci pocigu w procentach.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) powoduje, e pojazdy drogowe, zamiast zawraca, czekaj w kolejce na zwolnienie si stanowiska na stacji.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) ogranicza zapotrzebowanie programu TTDPatch na pami do ok. 3.5 MB, uniemoliwiajc adowanie stanw gry zapisanych przy wikszym ustawieniu 'morevehicles'.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) poprawia kilka drobnych bdw w TTD. Zajrzyj do dokumentacji, aby dowiedzie si, co to dokadnie robi.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) pozwala budowa wicej lotnisk, ni normalne dwa na miasto.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) dodaje opcj 'bribe' (\"przekup\") do menu 'Local Authority' miast.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) pozwala okrela, w jakich sytuacjach mog wystpi katastrofy lotnicze.  Warto zakodowana bitowo, domylnie 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) wywietla aktualn prdko pojazdu w pasku stanu jego okna.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) odnawia pojazdy po upywie zadanej liczby miesicy od zakoczenia okresu amortyzacji.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) powoduje, e uywanie niektrych kodw specjalnych w napisach (patrz 'signcheats') kosztuje.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) pozwala przecza pomidzy sygnaami zwykymi, wjazdowymi, wyjazdowymi i czonymi przy uyciu 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) powoduje, e TTDPatch tworzy plik TTDLOAD.OVL lub TTDLOADW.OVL na nowo przy kadym uruchomieniu.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) dodaje opcj 'Load game' do menu dyskowego (w edytorze scenariuszy take 'Save game' przy wcinitym 'Ctrl').")
SETTEXT(CFG_WIN2K, "`%s' (-%s) umoliwia uruchomienie wersji TTD dla Windows pod Windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) modyfikuje dziaanie opcji 'Unload' w taki sposb, e towar zawsze jest pozostawiany na stacji (co uatwia organizowanie transportu etapami).")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) pozwala dodawa zajezdnie (depots), stocznie i hangary do listy przystankw.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) pozwala przej zarzdzanie firmami graczy komputerowych, jeli posiadasz 75%% udziaw.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) zmienia sposb adowania pojazdw na bardziej realistyczny (aktywuje take przecznik `loadtime').")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) przenosi wszystkie czerwone okienka bdw w lewy grny rg ekranu.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) zmienia maks. czas oczekiwania pocigu na zielone wiato (przy sygn. jednokierunkowych).  Zakres: 0..254 (w dniach), lub 255, aby czeka w nieskoczono.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) zmienia maks. czas oczekiwania pocigu na zielone wiato (przy sygn. dwukierunkowych).  Zakres: 0..254 (w dniach), lub 255, aby czeka w nieskoczono.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) pozwala okreli, jakie katastrofy mog si wydarzy.  Zakodowane bitowo, domylnie 255 (wszystkie moliwe katastrofy).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) wymusza obsug (service) pojazdu, kiedy ten wymaga wymiany (patrz `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) generuje komunikaty/wiadomoci (messages/news reports) przy nowych rodzajach zdarze.  Zajrzyj do dokumentacji, aby dowiedzie si wicej.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) umoliwia kupowanie lokomotyw typu 'monorail' w zajezdniach typu 'maglev' i vice versa.  Parametr: 1 - zmienia wszystkie lokomotywy typu 'maglev' w 'monorail'; 2 - zmienia wszystkie lokomotywy typu 'monorail' w 'maglev'; 3 - pozostawia oddzielne systemy 'monorail' i 'maglev'.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) zwiksza ograniczenie prdkoci na mostach rurowych (tubular) systemw 'monorail' i 'maglev' do wartoci zadanej jako procent maksymalnej prdkoci najszybszej lokomotywy w danej klasie.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) pozwala gra w nieskoczono, tj. rok nie zatrzymuje si na 2070.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) zawze pokazuje pen dat na pasku stanu, nie tylko, gdy gra jest zatrzymana.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) uaktywnia nowe typy lokomotyw i wagonw w plikach z now grafik.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) uaktywnia nowe typy pojazdw drogowych w plikach z now grafik.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) uaktywnia nowe typy statkw w plikach z now grafik.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) uaktywnia nowe typy samolotw i migowcw w plikach z now grafik.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) pokazuje sygnay kolejowe po tej samej stronie toru, po ktrej jed pojazdy po drogach.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) zastpuje jeden z systemw kolei magnetycznej (Monorail lub Maglev, w zalenoci od ustawienia 'unifiedmaglev') systemem kolei zelektryfikowanych.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) ustawia rok, w ktrym rozpoczynaj si losowo generowane gry, i rozszerza zakres roku rozpoczcia gry w edytorze scenariuszy.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) zmienia czas, po ktrym czerwone okienka bdw s automatycznie zamykane.  Zakres: 1..255 (w sekundach), 0 oznacza bardzo dugi czas.  Domylnie: 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) zmienia wspczynnik ograniczajcy maksymalny zasig rozrostu miast.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) powoduje, e jedno na zadan liczb miast wzrasta szybciej ni pozostae (w tym przypadku 'towngrowthlimit' stosuje si tylko do tych miast).  Zakres: %ld..%ld.  Domylnie: %ld (tj. jedno miasto na cztery).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) pozwala modyfikowa dziaanie niektrych innych przecznikw; zajrzyj do dokumentacji, aby dowiedzie si wicej.  Zakodowane bitowo, domylnie 0 (bez modyfikacji).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) powoduje, e TTDPatch zawsze aduje wszystkie pliki .GRF wymienione w newgrf(w).cfg, niezalenie od tego, czy byy wczeniej uywane w zaadowanej grze (itp.), czy nie.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) powoduje, e TTDPatch zapisuje i aduje dodatkowe (opcjonalne) informacje na kocu plikw stanu gry.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) wcza dodatkowe opcje konstrukcyjne.  Zakodowane bitowo, zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) powoduje, e sygnay kolejowe budowane przed rokiem 1975 maj posta semaforw mechanicznych.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) wcza nowe skrty klawiszowe.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) umoliwia sadzenie wielu drzew rwnoczenie.  Zakodowane bitowo: 1 - mona sadzi wicej ni jedno drzewo na kwadrat; 2 - mona obsadzi prostoktny obszar z 'Ctrl'; 4 - przy obsadzaniu prostoktnego obszaru mona sadzi wicej ni jedno drzewo na kwadrat.  Domylnie: 3.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) wcza dodatkowe waluty i Euro.  Parametr: 0 - symbol waluty w standardowym miejscu; 1 - symbol waluty przed liczb; 2 - symbol waluty po liczbie; dodanie 4 wycza Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) umoliwia rczn konwersj typu torw poprzez budowanie nowych torw na ju istniejcych.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) powoduje, e na wspczynniki jakoci transportu (transport ratings) mniejszy wpyw ma wiek pojazdw (najnisza ocena dla wagonw starszych ni 21 lat, zamiast standardowych 3).")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) ulepsza interfejs uytkownika.  Zakodowane bitowo, zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) umoliwia zdefiniowanie regu obliczania tempa wzrostu miast.  Parametr okrela algorytm: 0 - oryginalny TTD, 1 - rozszerzony TTD, 2 - zaawansowany.  Zajrzyj do dokumentacji, aby dowiedzie si wicej.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (bez przecznika w wierszu polece) okrela minimalne tempo wzrostu miast, w nowych domach na stulecie.  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (bez przecznika w wierszu polece) okrela maksymalne tempo wzrostu miast, w nowych domach na stulecie.  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (bez przecznika w wierszu polece) okrela, w jakim stopniu obecno aktywnych stacji w miecie zwiksza jego tempo wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (bez przecznika w wierszu polece) okrela, w jakim stopniu kada aktywna stacja w miecie zwiksza jego tempo wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw aktywnych stacji na tempo wzrostu miasta (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw pasaerw przetransportowanych z miasta na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw poczty przetransportowanej z miasta na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (bez przecznika w wierszu polece) okrela maksymaln liczb pasaerw transportowanych do miasta, jaka moe przyczynia si do jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw pasaerw przetransportowanych do miasta na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (bez przecznika w wierszu polece) okrela optymaln liczb mieszkacw na kade 2 worki przetransportowanej do miasta poczty (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw poczty przetransportowanej do miasta na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (bez przecznika w wierszu polece) okrela optymaln liczb mieszkacw na kade 2 skrzynki przetransportowanych do miasta towarw (goods) (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw towarw (goods) przetransportowanych do miasta na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (bez przecznika w wierszu polece) okrela minimalne zapotrzebowanie na ywno (food) miast w obszarach nienych lub pustynnych, wyraon w liczbie mieszkacw na 2 tony przyjtej ywnoci (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (bez przecznika w wierszu polece) okrela optymaln liczb mieszkacw na kade 2 tony przetransportowanej do miasta ywnoci (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw ywnoci (food) przetransportowanej do miasta na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (bez przecznika w wierszu polece) okrela minimalne zapotrzebowanie na wod miast w obszarach pustynnych, wyraon w liczbie mieszkacw na 2 tony (2000 litrw) przyjtej wody (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (bez przecznika w wierszu polece) okrela optymaln liczb mieszkacw na kade 2 tony (2000 litrw) wody przetransportowanej do miasta w klimacie sub-tropikalnym (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw wody przetransportowanej do miasta w klimacie sub-tropikalnym na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (bez przecznika w wierszu polece) okrela optymaln liczb mieszkacw na kade 2 worki przetransportowanych do miasta w klimacie 'toyland' sodyczy (candy/sweets) (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw sodyczy (candy/sweets) przetransportowanych do miasta w klimacie 'toyland' na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (bez przecznika w wierszu polece) okrela optymaln liczb mieszkacw na kade 2 sztuki przetransportowanych do miasta w klimacie 'toyland' napojw gazowanych (fizzy drinks) (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (bez przecznika w wierszu polece) okrela wzgldny wpyw napojw gazowanych (fizzy drinks) przetransportowanych do miasta w klimacie 'toyland' na tempo jego wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (bez przecznika w wierszu polece) okrela podstawow liczb budynkw w miecie na potrzeby oblicze uwzgldniajcych 'tgrtownsizefactor' (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (bez przecznika w wierszu polece) okrela, w jakim stopniu wielko miasta wpywa na jego tempo wzrostu (zajrzyj do dokumentacji, aby dowiedzie si wicej).  Aktywne tylko gdy przecznik 'towngrowthratemode' jest ustawiony na 2.  Zakres: 0..%ld.  Domylnie: %ld (co odpowiada %ldprocentowemu wpywowi wielkoci miasta na tempo jego wzrostu).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (bez przecznika w wierszu polece) okrela minimaln liczb mieszkacw, ktr miasta w obszarach nienych mog osign nawet bez dostaw ywnoci.  Aktywne, jeli wczony jest jeden z nastpujcych przecznikw: 'towngrowthratemode', 'towngrowthlimit', 'generalfixes'.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (bez przecznika w wierszu polece) okrela minimaln liczb mieszkacw, ktr miasta w obszarach pustynnych mog osign nawet bez dostaw ywnoci i wody.  Aktywne, jeli wczony jest jeden z nastpujcych przecznikw: 'towngrowthratemode', 'towngrowthlimit', 'generalfixes'.  Zakres: %ld..%ld.  Domylnie: %ld.")
SETTEXT(CFG_MORETOWNSTATS, "`%s' (-%s) powoduje wywietlanie dodatkowych danych w oknach informacji o miecie.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) umoliwia budowanie torw, drg i stacji na pochyym terenie, na wyrwnujcym podkadzie (jak pod budynkami miejskimi).")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) umoliwia budowanie na wybrzeach i brzegach rzek bez koniecznoci uycia wpierw narzdzia 'dynamit'.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) powoduje zrnicowanie kosztw budowy rnych typw torw (zwyke, zelektryfikowane, magnetyczne).")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) wcza najnowsze eksperymentalne funkcje programu TTDPatch.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) powoduje, e samoloty lataj ze wskazywan prdkoci (a nie cztery razy wolniej), oraz e w przypadku awarii ich prdko spada do 5/8 maksymalnej.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) umoliwia szybkie sprzedawanie caych pocigw przy pomocy klawisza 'Ctrl'.")
SETTEXT(CFG_NEWRVCRASH, "`%s' (-%s) modyfikuje efekty kolizji pocigu z pojazdem drogowym.  Parametr: %ld - pocig ulega awarii po kolizji; %ld - kolizje nie nastpuj.  Domylnie: %ld.")
SETTEXT(CFG_STABLEINDUSTRY, "`%s' (-%s) powoduje, e przy ustawieniu typu ekonomii (Economy) na stabiln (Steady) w ustawieniach trudnoci (Difficulty settings) zakady przemysowe nigdy nie zamykaj dziaalnoci.")




//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nNacinij Enter, aby uruchomi TTD, Escape, aby anulowa,\n  lub dowolny inny klawisz, aby wywietli ustawienia.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Wczone przeczniki:      (%c wczone,  %c wyczone)\n"  )

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "+-")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "Jednokierunkowe: ")
SETTEXT(LANG_SWTWOWAY, "Dwukierunkowe: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d dni")
SETTEXT(LANG_INFINITETIME, "nieskocz.")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Nacinij dowolny klawisz, aby uruchomi \"TTDLOAD %s\"\n  (Escape - anuluj).")

SETTEXT(LANG_SWABORTLOAD, "\nUruchomienie programu anulowane przez uytkownika.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** TTDPatch: wewntrzny bd #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD nie jest prawidowo zainstalowany (bd rejestru %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Brak pamici %s, potrzeba o %d KB wicej.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "do uruchomienia TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Kod trybu chronionego jest zbyt duy!\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Zwalniam pami trybu rzeczywistego.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 2nd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Startowanie %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Nie udao si uruchomi %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Rezultat: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Bd!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Nie mog znale pliku z dodatkow grafik %s, tworz ten plik.\n")
SETTEXT(LANG_ERRORCREATING, "Bd przy tworzeniu %s: %s\n")
