// 
// Localization strings for TTDPatch.
// 

// -------------------------------------------
// INFO ABOUT THIS LANGUAGE
// -------------------------------------------
SETNAME("Russian")
COUNTRYARRAY(countries) = { 7, 0, 0x19, 0 };
SETARRAY(countries);
	// 7 is Russia, 0x19 is Russian in Windows

DOSCODEPAGE(866)	// The default DOS code page for this language
WINCODEPAGE(1251)	// The default Windows code page for this language
EDITORCODEPAGE(866)	// The code page of all strings in this file.

// -------------------------------------------
// PROGRAM BLURBS
// -------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " 砫 ࠡ.\n")


// -------------------------------------------
// VERSION CHECKING
// -------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "  䠩  ᯮ.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"!   䠩  ணࠬ  .   \n"
	"          ࠢ  ணࠬ,    ⠥    ࠢ塞\n"
	"          ଠ.   砥  訡 ந  室   ணࠬ  \n"
	"          ᮮ⢥騬 ᮮ饭.\n"
	"\n"
	"            ᨬ    ஥   襩  樮  ⥬  \n"
	"                ࠭   \n"
	"          .   ஡ ଠ樨 .  . 4.1 㪮⢠\n"
	"           䠩 TTDPATCH.TXT.\n"
	"\n"
	" 'Y' ⮫쪮  砥, ᫨  㢥७  ᢮  ⢨.  ,\n"
	"                           .\n"
	"       砥? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "y")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "㧪 䠩  ࢠ.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "  ᤥ  ...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "!  ⭠!\n")


// -------------------------------------------
//   CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, "  , ந  宦 䠩:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, " TYCOON.EXE  %s  .\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "  %s.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "  %s  %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "   %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "訡 ஢ - 䠩 %s  .\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, " ଠ .EXE 䠩.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "  䠩   ᯮ.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, " : '%s'\n筠 : %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "   ଠ!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "  'Transport Tycoon Deluxe'.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "ᯮ : %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "ᯮ塞 䠩  -  ७ ० DOS.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "ᯮ塞 䠩  -  Windows.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, " ଠ ᯮ塞 䠩 .\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up.
// %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, " ᮦ,   TTDPatch ࠡ⠥ ⮫쪮  ᨥ  %s.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "ୠ  ਣ쭮 ᥣ 䠩: %lx")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "祭 ࠧ ᥣ  %sMB.\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "᢮ .\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "    %s,  ⨢ ਡ '쪮 ⥭'.\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "⠭ 稪  .\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "  ⠭ 稪  ")

// Suggestion to delete TTDLOAD.OVL (%s) if it is invalid
SETTEXT(LANG_DELETEOVL, " - ஡ 㤠 %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s  浪.\n")
 
// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "    ⬥")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, " Escape, ⮡ ࢠ    , ⮡ த")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "㧪 ஥ ⥪⮢ ᮮ饭.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "⥭ %s:  ଠ 䠩.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
        "%s   ᮧ  ⮩ ᨨ TTDPatch.\n"
        ", ᪠砩 ᫥  ணࠬ mkpttxt.exe   .\n")


// -----------------------------------------------
//  COMMAND LINE HELP (-h)
// -----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, " TTD  ᪠  䠩 %s\n"
	  "\n"
	  "ᯮ짮: TTDPATCH [-C cfg-䠩] [] [  CD] [-W cfg-䠩]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:    ஬ -x",
	  "-d:  ᥣ ⮡ࠦ  ",
	  "-g:   騥 ࠢ",
	  "-k:  ࠭  ய",
	  "-J:   ய⮢  த",
	  "-l:   /   7x7",
	  "-n:     ",
	  "-q:   ६ 㧮 権",
	  "-s:  Cheat-  室 ",
	  "-Xo:  Cheat-",
	  "-v:  ⮡ࠦ ﭨ 祩",
	  "-w:   ᥬ ⠭権",
	  "-Xw: ७ ᥬ ⠭権",
	  "-Xx:   㧪 . ",
	  "-z:  ஬  (126 )",
	  "-f:  ⨢ ॢ ",
	  "-y:  ய ⭮ ᨨ",
        "-E:  ६饭 ᮮ饭  訡",
	  "-F:   㧪   㧠",
	  "-G:  ⠭樨  롨 ⮢",
	  "-B:  夫 ",
	  "-D:   ",
	  "-I:  ⬥ 樨",
	  "-L:  ᨬ /믫  \"Ctrl\"",
        "-N:    襥 ᫮ ᮡ⨩",
	  "-O:    ਭ த",
	  "-P:  ࠭ᯮ ।⢠  祧",
	  "-R:  ⮬ ⠭  ।",
        "-S:    ࠡ",
	  "-T:    ⨢",
	  "-Z:  襭 ꥬ  (2,5 )",
	  "-2:  ⨬  Windows 2000",
	  "-Xb:  \"⪠\" த᪨ ",
        "-Xd:  \"\"  ",
	  "-Xe: ᪮筠  ᫥ 2070",
	  "-Xf:   㧮権",
        "-Xg: 筠 㧪 ࠭ᯮ",
	  "-Xi:  ⠡..  . ",
	  "-Xr: ᥣ ᮧ TTDPATCH.OVL",
	  "-Xs:  ᪮  ப ",
	  "-Xm: 㭪 \"㧨\"  䠩. ",
        "-XA:  ࠭ᯮ  -Xa",
	  "-XE: ஢ /",
	  "-XF: ᯥਬ⠫ ",
	  "-XG: 㦠   䨪",
	  "-XP:   ᠬ⮢",
	  "-XR:   ⮬",
        "-XS: ࠢ ᨤﬨ AI-ப",
	  "-Ya: ௨ ३⨭   ",
	  "-Yb: ந⥫⢮  ⪮",
	  "-Yc:  / ࠧ  ⮨",
	  "-Ym: 筠  ⥩ /",
	  "-Ys:   ஭  ",
	  "-Yt:  ⨪   த",
	  "-Yw:   த ",
	  "-YC: ந⥫⢮  ०",
	  "-YH: / 稥 ",
	  "-YP:    ᪮",
	  "-YS:  ᥬ  1975 ",

	  NULL
      };
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    祭  ࠭  ⠭樨\n"
	  "-i #:    ࢠ 㦨 ࠭ᯮ । ' 㬮砭'\n"
	  "-x #:    ७   ᨢ   ࠭ᯮ  ।     850*#.   \n"
	  "         㬥!\n"
	  "-mc #:    ᯮᮡ      ਢ ᮮ⢥⢥.\n"
	  "-trpb #: 祭 ⢠  ,  ⮬,  ᠬ⮢   ࠡ\n"
	  "         ᮮ⢥⢥.\n"
	  "-A #:    襭 AI   祭. ᯮ ⮫쪮  稭.\n"
	  "-M #:    ⨢ , ᪮ 㢥稢  業.\n"
	  "-Xa #:   ⮬᪮   ࠭ᯮ  ।    #  楢\n"
	  "         ᫥ 祭 ப 㦡\n"
	  "-Xc #:   ࠢ ᮡﬨ \n"
	  "-Yr #:      /⮬   (1/2)\n"
	  "-Xt #:   ⠭ ᨬ쭮 ࠧ ன த\n"
	  "-XC #:    樮   ப  ⮡ࠦ\n"
        "-XD #:   롮 娩 ⢨, ஥  ந\n"
	  "-XM #:    ५ᮢ  ५ᮢ / ⥬\n"
	  "-XT #:   ⠭ ⥭ᨢ  த   ' #-'\n"
	  "-XX #:    ᪮  ५ᮢ  ५ / ⮢\n"
        "          業⭮ ᮮ⭮襭  ᨬ쭮 ᪮ \n"
	  "-XY #:   ⮢  ' 㬮砭'  ந쭮 \n"
        "-X1 #, -X2 #: ᨬ쭮 ⢮ , ஥ 㤥  \n"
        "               ᭮ ᨣ ᢥ, 室  ⪥ \n"
        "              ண  ஭ \n"
	  "-Yo #:   ࠢ 묨 ࠪ⨪ 㣨 祩\n"
        "         (. 㬥)\n"
	  "-Yp #:   ᠤ 襣 ⢠ ॢ쥢, 롮 ⨯ ᠤ\n"
	  "-YB #:    ⥩ ந⥫⢠, ࠢ   ࠬ\n"
	  "-YE #:    ६ ⮡ࠦ  ᮮ饭  訡  ᥪ㭤\n"
	  "-YG #:   ७ 짮⥫᪮ 䥩, 롮 樨 ࠬ஬\n"
	  "-YT #:   ⠭ ⬠  த\n"
	  "\n"
	  "-C cfg-file:  ᯮ짮  䠩 䨣樨  ttdpatch.cfg\n"
	  "-W cfg-file:    䨣樮 䠩  ⥪饩 䨣樥\n"
	  "\n"
	  "᫨   ᯥ  뢮  ଠ, :\n"
	  "\"ttdpatch -h|more\"\n"
	  "\n"
	  ",  묨  ய묨 ᨬ  ࠧ 祭!\n"
	  "\n"
	  "ਬ: ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "\nLocalization (C) 2000-2003 by Yuri Burawtsow.\n"
	  "  ஡ ଠ樨 . 㪮⢮  䠩 TTDPATCH.TXT.\n")


// -----------------------------------------------
// COMMAND LINE AND CONFIG FILE PARSING
// -----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, ": ﭨ /몫 ⭮ - %s, ⠭  몫.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "  '%c%s'.  ᯮ -h  ᪠.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, ": ୠ ப cfg-䠩: '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "⢮ ࠭. ।", "  %d*850")
SWITCHTEXT(usenewcurves, "  ਢ", " - %04x")
SWITCHTEXT(usenewmountain, "  ", " - %04x")
SWITCHTEXT(usenewnonstop, "⠭筮 ", "")
SWITCHTEXT(increasetraincount, "⢮ ", ": %d")
SWITCHTEXT(increaservcount, "⢮ ⮬", ": %d")
SWITCHTEXT(setnewservinterval, "ࢠ ᬮ", ": %d ")
SWITCHTEXT(usesigncheat, "ᯮ짮 cheat-", "")
SWITCHTEXT(allowtrainrefit, "८᭠饭 ⨢", "")
SWITCHTEXT(increaseplanecount, "⢮ ᠬ⮢", ": %d")
SWITCHTEXT(increaseshipcount, "⢮ ࠡ", ": %d")
SWITCHTEXT(keepsmallairports, "࠭  ய", "")
SWITCHTEXT(largerstations, "࠭ ⠭権", "  %d ")
SWITCHTEXT(morestationtracks, "塞 ⠭樨", "")
SWITCHTEXT(longerbridges, "  ", "")
SWITCHTEXT(improvedloadtimes, "६ 㧮 権", "")
SWITCHTEXT(mammothtrains, "஬  ( 127)", "")
SWITCHTEXT(presignals, "७ ᥬ", "")
SWITCHTEXT(officefood, ".  ਭ த", "")
SWITCHTEXT(noinflation, " 樨", "")
SWITCHTEXT(maxloanwithctrl, ". /믫  ctrl", "")
SWITCHTEXT(persistentengines, "࠭. ।⢠  祧", "")
SWITCHTEXT(fullloadany, " 㧪  㧠", "")
SWITCHTEXT(selectstationgoods, "⠭樨 롨 ⮢", "")
SWITCHTEXT(morethingsremovable, "ᮢ襭⢮ ", "")
SWITCHTEXT(aibooster, "襭 AI", "  %d")
SWITCHTEXT(multihead, "⨢ ", "")
SWITCHTEXT(newlineup, "⮬ ⠭  ।", "")
SWITCHTEXT(lowmemory, "襭 ꥬ  (2,5 )", "")
SWITCHTEXT(generalfixes, "騥 ࠢ (. .)", "")
SWITCHTEXT(moreairports, " ய⮢  த", "")
SWITCHTEXT(bribe, "⪨ த᪨ ", "")
SWITCHTEXT(noplanecrashes, "ࠢ 䠬", ": %d")
SWITCHTEXT(showspeed, "  ப ", "")
SWITCHTEXT(autorenew, " ࠭ᯮ", " १ %d ")
SWITCHTEXT(cheatscost, " Cheat-", "")
SWITCHTEXT(extpresignals, "७ ᥬ  'Ctrl'", "")
SWITCHTEXT(diskmenu, "㭪 '㧨'  䠩 ", "")
SWITCHTEXT(win2k, "⨬  Windows 2000", "")
SWITCHTEXT(feederservice, "  㧮権", "")
SWITCHTEXT(gotodepot, "   ࠭ᯮ", "")
SWITCHTEXT(newships, "  ࠡ", "")
SWITCHTEXT(subsidiaries, "ࠢ ᨤﬨ AI-ப", "")
SWITCHTEXT(gradualloading, "筠 㧪 ࠭ᯮ", "")
SWITCHTEXT(moveerrorpopup, " ᮮ饭  訡", "")
SWITCHTEXT(setsignal1waittime, " ६  ", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "᪠ ", ": %d")
SWITCHTEXT(forceautorenew, "ਭ㤨⥫쭮  ࠭ᯮ", "")
SWITCHTEXT(morenews, " ᮮ饭  ᮡ", "")
SWITCHTEXT(unifiedmaglev, "䨪 . ", ", ० %d")
SWITCHTEXT(newbridgespeeds, ". ᪮  . ", ": %d%%")
SWITCHTEXT(eternalgame, "᪮筠  ᫥ 2070", "")
SWITCHTEXT(showfulldate, "ᥣ ⮡ࠦ  ", "")
SWITCHTEXT(newtrains, "  ⨢", "")
SWITCHTEXT(newrvs, "  ⮬", "")
SWITCHTEXT(newplanes, "  ᠬ⮢", "")
SWITCHTEXT(signalsontrafficside, "/ ᢥ  ஭  ", "")
SWITCHTEXT(electrifiedrail, "஢ /", "")
SWITCHTEXT(newstartyear, "⮢  ' 㬮砭'", ": %d")
SWITCHTEXT(newerrorpopuptime, "६ ⮡ࠦ. Error-", ": %d ")
SWITCHTEXT(newtowngrowthfactor, " 䠪  த", "  %d")
SWITCHTEXT(largertowns, "", " %d த ࠧ ॥")
SWITCHTEXT(miscmods, "稥 ࠧ ०", ": %d")
SWITCHTEXT(loadallgraphics, "㦠   䨪", "")
SWITCHTEXT(saveoptdata, "࠭  㦠 . ", "")
SWITCHTEXT(morebuildoptions, " 権 ந⥫⢠", ": %d")
SWITCHTEXT(semaphoresignals, " / ᥬ  1975 ", "")
SWITCHTEXT(morehotkeys, "/ '稥 '", "")
SWITCHTEXT(plantmanytrees, "  ਩", ": %d")
SWITCHTEXT(morecurrencies, " 樮 ", ", 䫠: %d")
SWITCHTEXT(manualconvert, "筮 ८ࠧ ⨯ / ⥩", "")
SWITCHTEXT(newtowngrowthrate, "   த", ": %d")
SWITCHTEXT(displmoretownstats, "뢮  ⨪  த", "")
SWITCHTEXT(enhancegui, "७ ஢ 䥩", ": %d")
SWITCHTEXT(newagerating, "௨ ३⨭   ", "")
SWITCHTEXT(buildonslopes, "ந⥫⢮  뢠/⪮", "")
SWITCHTEXT(buildoncoasts, "ந⥫⢮  ०", "")
SWITCHTEXT(experimentalfeatures, " ᯥਬ⠫ ", ": %d")
SWITCHTEXT(tracktypecostdiff, " /  ࠧ ⮨", "")
SWITCHTEXT(planespeed, "쭠 ᪮ ᠬ⮢", "")
SWITCHTEXT(fastwagonsell, "᪮७ த ", "")
SWITCHTEXT(newrvcrash, "  /⮬"," (० %d)")
SWITCHTEXT(newrvcrash, "⮫  ","  ० %d")
SWITCHTEXT(stableindustry, "।०  ந⢠","")


// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "cfg-䠩 %s  .  ந஢.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, " %s    .\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "! ப 䨣樨  32 ᨬ, १.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, " `%s' (-%s)   ᯮ. ,  ᯮ ,\n"
	     " 㤥     ᫥ ᨩ.\n")

// ---------------------------------------------------
//  CONFIG FILE COMMENTS (for '-W')
// ---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch 䨣殭 䠩, ⮬᪨ ᮧ  TTDPatch -W\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "ଠ :\n"
	CFG_COMMENT "    = ࠬ\n"
	CFG_COMMENT "\n"
	CFG_COMMENT " \"=\"   饭, ⠪  ᪠  ஡  \n"
	CFG_COMMENT "  ᯮ짮  , ⠪  ய.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT " 祩  ﭨ yes/no [y/n] 祭 ⠪   :\n"
	CFG_COMMENT "   yes, y, on, 1 - 祭 ⢨ \n"
	CFG_COMMENT "   no, n, off, 0 - 몫祭 ⢨ \n"
	CFG_COMMENT "᫨ ﭨ   , 騬  㬮砭 ਭ yes.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT " 祩   ᫮ 祭 [v]  祭 ᠭ\n"
	CFG_COMMENT " ਨ   .  㬮砭 祭  . ⢨\n"
	CFG_COMMENT "   ⪫祭  祭 'off'.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT " ப   稭   䠢⭮ ᨬ.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "****   ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
// 
SETTEXT(CFG_SHIPS, "`%s' (-%s) 㢥稢 ᨬ쭮  ⢮ ࠡ.\n//  - %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_CURVES, "`%s' (-%s) ⠭ ᪮   ਢ\n//  ଠ (0), ॥ (1), ᠬ  (2)  ॠ (3).\n//      /, ५ᮢ, ५ᮢ /\n//  ⮬.  㬮砭 0120")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) ⠭ ᪮   \n//  ଠ (0), ॥ (1), ᠬ  (2)  ॠ (3).\n//      /, ५ᮢ, ५ᮢ /\n//  ⮬.  㬮砭 0120")
SETTEXT(CFG_SPREAD, "`%s' (-%s)  ⢮ ⮢,    \n// ⠭.  - %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s)   ८㤮 ⨢  ࠧ\n//  㧮, ࠢ,    ਭ㤨⥫쭮 ॢ ")
SETTEXT(CFG_SERVINT, "`%s' (-%s)  ਮ 审㦨 ࠭ᯮ ।  .\n//  - %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) ⪫砥     , ⠪   室")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s)   ந⥫⢮ / ⠭権 4x7  7x5")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) ⠭ 㣨 ࠢ ⠭筮 ")
SETTEXT(CFG_PLANES, "`%s' (-%s) 㢥稢 ᨬ쭮 ⢮ ᠬ⮢.\n//  - %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_LOADTIME, "`%s' (-%s)    ᫥ ६ 㧮\n// 権")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) 㢥稢 ᨬ쭮 ⢮ ⮬.\n//  - %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s)  ᯮ짮 cheat-  ६ ")
SETTEXT(CFG_TRAINS, "`%s' (-%s) 㢥稢 饥 ⢮ .  - %ld..%ld.\n//  㬮砭 %ld")
// *#define CFG_PLAYERS "`%s' (-%s) set the players to be affected by the cheats.  A list of players from 0..7"
SETTEXT(CFG_VERBOSE, "`%s' (-%s) 뢠 ﭨ  祩 । ᪮ TTD")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s)  ᯮ짮 ᮢ襭⢮ ᥬ \n// 襭 㦨 / ⠭権")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) 㢥稢 ᨬ쭮  ⢮\n// ࠭ᯮ ।    稭 '祭'*850.\n//  - %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s)  㢥稢    126 ")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s)  ࠢ    㧪 \n// ⨯ 㧠")
SETTEXT(CFG_SELECTGOODS, "`%s' (-%s)   ⠭樨  ⮢  ࠢ ,\n//   襭  㧪 ਡ뢠騬 ࠭ᯮ⮬")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s)  / ᨬ쭮  㬬\n// । ᮢ⭮  ⨥ Ctrl")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s)    ਭ த (\n// ᪮  ய᪮ 業ਥ)")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s)   祧 ॢ訬 ࠭ᯮ\n// ।⢠   㯪,    ᯮ")
SETTEXT(CFG_CDPATH, "`%s' (   ப) ⠭   -")
// Note- CFG_CDPATH has no command line switch, so don't give %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s)  ᥣ   ந⥫⢠\n//  ய⮢")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) 㢥稢 AI   ᪠ ⨬쭮  ⥬\n// ७   㪠 祭")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s)   ந⥫⢮ ⮢   127\n// ⮢")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s)   ᭮ 襥 ⢮ ꥪ⮢")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s)  楯  ⠢ ᪮쪮 ⨢,\n//    ⢫ ᮢ⭮  ⨥ 'Ctrl'")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) ⮬ ⠭  ।,  ࠧ稢")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s)   TTDPatch  ꥬ  2.5 ,\n//  ᨬ ꥬ ࠭ᯮ । 㤥 ᭨  2")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) ࠢ ࠧ 訥 , . 㬥,\n//  祬   ")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s)  ந 襥 ⢮ ய⮢ \n//  த")
SETTEXT(CFG_BRIBE, "`%s' (-%s)  㭪 '⪠'    த᪨ ⥩")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s)  ࠢ 䠬.\n// ୮ 祭,  㬮砭 - 1")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) ⮡ࠦ ⥪ ᪮ ࠭ᯮ⭮ ।⢠\n//  ᭮ ப  ")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s)  ࠭ᯮ⭮ ।⢮  \n// ⢮ 楢 ᫥ 祭  ப 㦡.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s)   ਬ Cheat-  ")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s)   㤥ঠ  'Ctrl'\n// 横᪨ 롨 ଠ ᥬ, ।⠭樮,\n// 室  ஢")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) 砥 ணࠬ ᮧ 䠩 TTDLOAD.OVL\n//  TTDLOADW.OVL  ࠧ  ᪥")
SETTEXT(CFG_DISKMENU, "`%s' (-%s)  㭪 '㧨'  䠩 , ⮡ \n// 뫮 㧨 ࠭  ( ࠭ \n//  ⨨ 'Ctrl')\n// אַ    㧨  । 業ਥ")
SETTEXT(CFG_WIN2K, "`%s' (-%s) ࠢ Windows-  TTD  ᮢ⨬\n//  Windows 2000/XP")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s)  ० ਭ㤨⥫쭮 ࠧ㧪\n//  ਭ  ⠭樨, ᯮ㥬  ࠭⭮ ࠭ 㧠")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s)   ''    ࠭ᯮ")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) ⨢   ࠡ   䨪")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s)   ࠢ AI-ﬨ, ᫨ \n//  75%% 権")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s)   㧪 ࠭ᯮ । \n//  ॠ ⥯ (⠪ ⨢ ࠬ஬ `loadtime')")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) ६頥   ᮮ饭  訡  ࠢ\n// 孨 㣮 ࠭")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) ⠭ ⢮ ,  祭 ண\n//  㤥   ᨣ ᢥ  ࠢ /, \n// 祭 ண  ࠧ稢.\n//  - 0..254,  255 -  ᥣ")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) ⠭ ⢮ ,  祭 ண\n//  㤥   ᨣ ᢥ  㭠ࠢ /, \n// 祭 ண  ࠧ稢.\n//  - 0..254,  255 -  ᥣ")
SETTEXT(CFG_DISASTERS, "`%s' (-%s)  롨 ⢨,   ந.\n// 祭 ⮢,  㬮砭 - 255 ( ⢨)")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) ਭ㤨⥫쭮 审㦨, ᫨ 諮 ६\n// (. `autorenew')")
SETTEXT(CFG_MORENEWS, "`%s' (-%s)  ᮮ饭/  襣 ⢠\n// ᮡ⨩. ஡ .  㬥樨")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s)  㯠 ५ᮢ ⨢\n//  ५ᮢ   . : 1 -  \n// ५ᮢ   ᮢ; 2 -   -\n//  ५ᮢ; 3 - -  ५ᮢ ࠭ ࠧ쭮")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s)  । ᪮  - \n// ५ᮢ   ⮬ /   業⭮ ᮮ⭮襭\n// ᮮ⢥⢨  ᨬ쭮 ᪮  ⨢  .\n//  %ld..%ld.  㬮砭 %ld%%")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s)   筮 ᫥ 2070 ")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) ᥣ ⮡ࠦ    ப ,\n// ⥯  ⮫쪮    㧥")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) ⨢   ⨢   䨪")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) ⨢   ⮬   䨪")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) ⨢    㤮  \n// 䨪")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) ⮡ࠦ / ᢥ  ⮩  ஭, \n// ன   ⢫  ⮬")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) 㡨ࠥ    / ⥬ (- \n// ५ᮢ)     ஢ / ⥬")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s)  ⮢  ' 㬮砭'  砫\n// ந쭮  ᪠ 訩 롮 ⮢   ।\n// 業.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s)  ६ ⮬᪮  \n// ᮮ饭  訡    .  1..255 (ᥪ㭤)\n//  0  祭 ⥫쭮 ६.  㬮砭 10")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s)  䠪, ࠭稢騩 ᨬ쭮\n//  ७ த.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) ।,  த 㤥  ॥\n//    ਭ樯 ' n-' (⠪ 롮筮 ਬ\n// `towngrowthlimit').  %ld..%ld.  㬮砭 %ld ( ⢥)")
SETTEXT(CFG_MISCMODS, "`%s' (-%s)  ஢ ࠡ  㣨 祩,\n// . 㬥. ୮ 祭,  㬮砭 0 (no modifications)")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) ।뢠 TTDPatch ਭ㤨⥫쭮 㦠 \n//  .grf-䨪, ᫥  䠩 newgrf(w).cfg ᨬ  ⮣,\n// 뫨  ᯮ짮 ࠭  㦥   ")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s)  TTDPatch ࠭  㦠\n// ⥫ (樮)    䠩 ࠭")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) 砥  ⥩ ந⥫⢠.\n// ୮ 祭,  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s)   / ᢥ, ஥  1975 ,\n//  ᥬ")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) 砥  '稥' ")
SETTEXT(CFG_MANYTREES, "`%s' (-%s)  ᠤ   ॢ  ,\n//  ⠪  אַ㣮쭮   襩 Ctrl")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s)  ᯮ짮  樮 \n//  . ࠬ: 0 - ᨬ    ' 㬮砭',\n// 1 - । ᫮, 2 - ᫥ ᫠. ⮡ ⬥ ,\n// 㦭 ਡ  祭 ࠬ 4")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) ࠧ蠥   ⨯ / ⥩\n//    ०")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) ३⨭ ⠭権  ௨   ࠭ᯮ\n// ।.       21   3")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s)  짮⥫᪨ 䥩.\n// ⮢ 祭,  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s)   ࠢ ᫥ ⥯\n//  த. : 0 - ਣ, 2 - ७,\n// 2 - 짮⥫᪨. . 㬥")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (   ப) ।\n//  ⥬  த,     ⮫⨥. ⨢ \n// 祭 ࠬ `towngrowthratemode', ࠢ 2.  %ld..%ld.\n//  㬮砭 %ld")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (   ப) ।\n//  ⥬  த,     ⮫⨥. ⨢ \n// 祭 ࠬ `towngrowthratemode', ࠢ 2.  %ld..%ld.\n//  㬮砭 %ld")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (   ப) ।\n// ⥬  த  ᨬ  ⢠ ⨢ ⠭権\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (   ப) ।,\n// ᪮쪮  ⨢ ⠭ 㢥稢 ⥬  த\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (   ப) ।\n// 䥪⨢ ᮤ⢨ ⨢ ⠭権 ⥬  த\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (   ப) ।\n// ⥬  த  ᨬ  䥪⨢ ᠦ᪨ ॢ\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (   ப) ।\n// ⥬  த  ᨬ  䥪⨢ ⮢ ॢ\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (   ப) ।\n// ᨬ쭮 ⢮ ਡ뢠  த ᠦ஢,  \n//    த (. 㬥). ⨢  祭\n// ࠬ `towngrowthratemode', ࠢ 2.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (   ப) ।\n// 䥪⨢ ᮤ⢨ ⥬  த ਡ뢠騬  த\n// ᠦࠬ (. 㬥). ⨢  祭 ࠬ\n// `towngrowthratemode', ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (   ப) ।\n// ᨬ쭮 ᥫ    誠   த \n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (   ப) ।\n// 䥪⨢ ᮤ⢨ ⥬  த   த \n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (   ப) ।\n// ⨬쭮 ᥫ    騪   த ⮢஢\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (   ப) । 䥪⨢\n// ᮤ⢨ ⥬  த   த ⮢஢\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (   ப) । 쭮\n// த⢥ ॡ த  ᭥  뭭 ,\n//  ᥫ  2 ⮭  த⮢ (. 㬥). ⨢ \n// 祭 ࠬ `towngrowthratemode', ࠢ 2.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (   ப) । ⨬쭮\n// ᥫ    ⮭   த த⮢\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (   ப) । 䥪⨢\n// ᮤ⢨ ⥬  த   த த⢨\n// (. 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (   ப) । \n// ॡ த  쥢   뭭 ,  ᥫ \n//  ⮭ (2000 ஢)  쥢  (. 㬥).\n// ⨢  祭 ࠬ `towngrowthratemode', ࠢ 2.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (   ப) । ⨬쭮\n// ᥫ    ⮭ (2000 ஢)  쥢  (\n// ய᪮ ) (. 㬥). ⨢  祭\n// ࠬ `towngrowthratemode', ࠢ 2.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (   ப) । 䥪⨢\n// ᮤ⢨ ⥬  த   த 쥢  (\n// ய᪮ ) (. 㬥). ⨢  祭\n// ࠬ `towngrowthratemode', ࠢ 2.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (   ப) । ⨬쭮\n// ᥫ    騪   த  ( 筮\n// ) (. 㬥). ⨢  祭 ࠬ\n// `towngrowthratemode', ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (   ப) । 䥪⨢\n// ᮤ⢨ ⥬  த   த  ( 筮\n// ) (. 㬥). ⨢  祭 ࠬ\n// `towngrowthratemode', ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (   ப) । ⨬쭮\n// ᥫ      த ஢ ⪠ (\n// 筮 ) (. 㬥). ⨢  祭 ࠬ\n// `towngrowthratemode', ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (   ப) ।\n// 䥪⨢ ᮤ⢨ ⥬  த   த\n// ஢ ⪮ ( 筮 ) (. 㬥).\n// ⨢  祭 ࠬ `towngrowthratemode', ࠢ 2.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (   ப) । \n// ⢮   த  ᫥ `tgrtownsizefactor' (.\n// 㬥). ⨢  祭 ࠬ `towngrowthratemode',\n// ࠢ 2.  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (   ப) ।, ᪮쪮\n// ࠧ த   ⥬   (. 㬥). ⨢ \n// 祭 ࠬ `towngrowthratemode', ࠢ 2.  %ld..%ld.\n//  㬮砭 %ld (.. ﭨ 25%%)")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (   ப) । 쭮\n// ᥫ,  ஥ த  ᭥ ਨ   \n//  த⢥ ⠢. ⨢   ६\n// `towngrowthratemode', `towngrowthlimit'  `generalfixes'.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (   ப) ।\n// 쭮 ᥫ,  ஥ த  뭥    \n// ⠢ த⢨  ⥢ . ⨢   ६\n// `towngrowthratemode', `towngrowthlimit'  `generalfixes'.\n//  %ld..%ld.  㬮砭 %ld")
SETTEXT(CFG_MORETOWNSTATS, " 箬 `%s' (-%s)  ଠ樮  த ⮡ࠦ\n// ⥫쭠 ⨪")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s)  ⢫ ந⥫⢮ ண, /\n// ⥩  ⠭権  뢨 ⪠   ९७,\n//  ⮬,   ⠪ ⪠  ")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s)  ⢫ ந⥫⢮  ᪨\n//   ०  ।⥫쭮 ਬ ")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s)   ࠧ ⨯ ண ࠧ\n// ⮨")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (   ப) ⠭   \n//  짮⥫  (CUS)   CUS*1000.\n//  㬮砭 1000 (1 CUS = 1 .).\n// ⨢  饬 ࠬ `morecurrencies'")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s)  ᯮ짮 ᫥\n// ᯥਬ⠫ ")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) ।뢠  ᠬ⠬   ᪮,\n//   ⢥ 襩,  ࠭.\n//   ᠬ  ᪮   5/8  ")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s)  த   ࠧ \n// 㤥ঠ  Ctrl")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s)  室 /   ⮫  \n// ⮬ﬨ. %ld ⠭  ᫥ ⮫  ⮬,\n// %ld 頥  ⮫   ⮬ﬨ.  㬮砭 %ld")
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) 頥 ਠ  뢠, ᫨\n// ࠬ Economy ()   Difficulty settings (ன ᫮)\n// ⠭  Steady (⠡)")

// ----------------------------------------------------
//  SWITCH DISPLAY ('-v')
// ----------------------------------------------------
// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\n Enter  ᪠ TTD, Escape ⮡ ࢠ\n    ⮡ ᬮ ன")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    ⢨ 祩:   (%c 祭, %c 몫祭)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "ࠢ : ")
SETTEXT(LANG_SWTWOWAY, "㭠ࠢ :  ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d ")
SETTEXT(LANG_INFINITETIME, "᪮筮")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "    ᪠ \"TTDLOAD %s\" (Esc - ⬥)")
SETTEXT(LANG_SWABORTLOAD, "\n㧪 ணࠬ ࢠ 짮⥫.\n")


// ---------------------------------------
// STARTUP AND REPORTING
// ---------------------------------------
// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** ७ 訡 TTDPatch %d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD  ⠭ ࠢ쭮 (訡 ॣ樨 %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, " 墠⠥ 㯭  %s, 室  %d KB .\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, " ᪠ TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "  饭 ० ᫨誮 !\n")

// Show where the code was stored, %p is the location
SETTEXT(LANG_CODESTOREDAT, " 饭 ० ࠭  %lX.\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "ᯮ 㠫 .\n")

// Just before running ttdload, show this.  1st %s is ttdload.ovl, 2nd is the options
SETTEXT(LANG_RUNTTDLOAD, " %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, " 믮 %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, ": [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "訡!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "   䠩 䨪 %s, ᮧ 䠩.\n")
SETTEXT(LANG_ERRORCREATING, "訡 ᮧ 䠩 %s: %s\n")

