//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Spanish")
COUNTRYARRAY(countries) = { 34, 51, 52, 54, 56, 58,
			502, 503, 504, 506, 507, 
			591, 593, 595, 598, 809,
			0, 0x0a, 0 };
SETARRAY(countries);
	// 34 = Spain, 51 = Peru, 52 = Mexico, 54 = Argentina, 
	// 56 = Chile, 58 = Venezuela
	// 502 = Guatemala, 503 = El Salvador, 504 = Honduras,
	// 506 = Costa Rica, 507 = Panama
	// 591 = Bolivia, 593 = Ecuador, 595 = Paraguay, 598 = Uruguay
	// 809 = carribean islands
	// and 0x0a is Spanish in Windows

DOSCODEPAGE(850)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(850)	// The code page of all strings in this file.


//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " iniciando.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "tamao") 

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Esta versin del programa tiene direcciones conocidas.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"ADVERTENCIA! La versin de su programa no es conocida por este programa\n"
	"         para iniciar de todas maneras y determinar la informacin necesaria, pero si\n"
	"         eso falla, TTD provocar un fallo de proteccin general y ser terminado.\n"
	"\n"
	"         Dependiendo en lo bien que su sistema operativo maneje un FPG, podra\n"
	"         causar que su computadora deje de responder, y podra perder informacin. Por favor lea\n"
	"         la seccin 4.1 de TTDPATCH.TXT para mayor informacin.\n"
	"\n"
	"Responda 's' slo si realmente sabe lo que hace. HA SIDO ADVERTIDO!!\n"
	"Desea iniciar de todas maneras? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "s")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Inicio de programa abortado.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Intentar hacer lo mejor que pueda...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "ADVERTENCIA: version desconocida!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " no se encontr, buscando archivos originales:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "No se encontr TYCOON.EXE ni %s.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "No se encontr %s.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Copiando %s a %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "No se pudo iniciar %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Error de copiado - el archivo %s no existe.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Formato .EXE no reconocido.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "No se pudo determinar la versin del programa.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "El nombre del programa es %s\nLa versin exacta es %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "La version tiene demasiados nmeros!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Este no es Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "La versin es %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Este es el ejecutable extendido de DOS.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Este es el ejecutable de Windows.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Este no es un ejecutable de formato conocido.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Lo siento, est versin de TTDPatch slo funciona con la versin %s.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Largo de segmento original invalido de %lx.")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Cambiando el tamao del programa a %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "No se puede escribir en %s, es de slo lectura?\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Instalando el cdigo del cargador.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "No se pudo instalar el cdigo del cargador")

// Suggestion to delete TTDLOAD.OVL (%s) if it is invalid
SETTEXT(LANG_DELETEOVL, " - intente borrar %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s es correcto..\n")
 
// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Presione una tecla para abortar.") 

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Presione escape para abortar, o cualquier otra tecla para continuar .")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Cargando textos de juego modificados.\n") 

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "Leyendo %s: Formato de archivo invalido.\n") 

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s debe rehacerse para esta versin de TTDPatch.\n" 
	"Por favor descargue y ejecute la ltima versin del programa mkpttxt.exe.\n") 


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Aplica el parche a TTD e inicia el programa %s\n"
	  "\n"
	  "Usage: TTDPATCH [-C cfg-file] [switches] [CD Path] [-W cfg-file]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:  Todos los modif. excepto -x",
	  "-d:  Mostrar siempre la fecha completa",
	  "-f:  Permite remodelar los trenes",
	  "-g:  Algunas mejoras generales",
	  "-k:  Mantener aeropuertos pequeos",
	  "-l:  Hasta 7 plataformas de estacin",
	  "-n:  Nuevo manejo de orden sin parar",
	  "-q:  Algoritmo mejorado de (des)carga",
	  "-s:  Activa los cdigos en rtulos", 
	  "-v:  Ver los modif. activ. en pantalla",
	  "-w:  Activa las pre-seales",
	  "-y:  No preguntar por versin", 
	  "     desconocida",
	  "-z:  Trenes Mamt (126 vagones)",

	  "-B:  Permite puentes ms largos",
	  "-D:  Dinamita destruye ms objetos",
	  "-E:  Mover mesajes de error",  
	  "-F:  Cargar significa de cualq. tipo",
	  "-G:  Estacin de carga seleccionable",
	  "-I:  Desactivar inflacin", 
	  "-J:  Ms aeropuertos por ciudad",
	  "-L:  Mximo prstamo/pago con 'Ctrl'",
	  "-N:  Noticias de ms eventos", 
	  "-O:  Edif. de ofic. aceptan alimentos",
	  "-P:  Mantener locom. si estn en uso",
	  "-R:  Camiones hacen fila",
	  "-S:  Nuevos modelos de barcos", 
	  "-T:  Nuevos modelos de tren",
	  "-Z:  Versin de poca memoria (3.5MB)",

	  "-2:  Parches de Windows 2000",

	  "-Xb: Opcin de soborno en men de A.L.",
	  "-Xd: Aadir coch. a rdenes de vehic",
	  "-Xe: Juegos eternos despus de 2070",
	  "-Xf: Serv. aliment. descarga forzada", 
	  "-Xg: Carga gradual de vehculos", 
	  "-Xi: No ind. closes with stable eco.",
	  "-Xm: Opcin de cargar juego en men",
	  "-Xo: Los cdigos en rt. valen dinero",
	  "-Xr: Reconstruir siempre TTDLOAD.OVL",
	  "-Xs: Ver vel. del vehculo en ventana",
	  "-Xw: Pre-seales extendidas",
	  "-Xx: Guardar y cargar datos adicion.",

	  "-XA: Auto-renovacin forzada con -Xa", 
	  "-XE: Vas ferreas electrificadas",
	  "-XF: Activar opciones experimentales",
	  "-XG: Cargar todos los nuevos grficos",
	  "-XP: Nuevos modelos de avin",
	  "-XR: Nuevos mod. de veh. de carretera",
	  "-XS: Admin. subvenc. de la IA",

	  "-Ya: Rank. tolera ms la edad de veh.",
	  "-Yb: Contruir ms objetos sobre plat.",
	  "-Yc: Cada tipo de va con dif. valor ",
	  "-Ym: Conversin de va manual",
	  "-Ys: Seal de va en lado de trfico",
	  "-Yt: Ms estad. en ventana de ciudad",
	  "-Yw: Vender vagones ms rapido",

	  "-YC: Constr. directamente en la costa",
	  "-YH: Ms/nuevas teclas de funcin",
	  "-YP: Aviones vuelan a velocidad real",
	  "-YS: Semforos antes de 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Aumentar el cubrimiento posible de estacin\n"
	  "-i #:    Intervalo de servicio por defecto es el nmero dado de das\n"
	  "-x #:    Extender cantidad de vehiculos hasta 850*#. Leer documentacin!\n"
	  "-mc #:   Nuevo manejo de montaa o curva, respectivamente\n"
	  "-trpb #: Aumentar el nmero de trenes, camiones, aviones o barcos, resp.\n"
	  "-A #:    Mejorar IA por este valor. Use slo valores pequeos..\n"
	  "-M #:    Permite trenes con varias locomotoras, aumenta vel. en porcentaje.\n"
	  "-Xa #:   Renueva vehc. automtic. # meses despues de finalizar vida til\n"
	  "-Xc #:   Control de ocurrencia de accidentes areos\n"
	  "-Yr #:   Modificar los choques de veh. de carret/tren. al tipo dado (1/2)\n"
	  "-Xt #:   Establece el tamao mximo al que pueden crecer las ciudades\n"
	  "-XC #:   Ms monedas, establece la visualizacin de opciones de moneda\n"
	  "-XD #:   Escoger que desastres pueden ocurrir\n" 
	  "-XM #:   Combina los sistemas de Monorriel y MagLev\n"
	  "-XT #:   Establce una de cada cuantas ciudades crece ms rpido y grandes\n"
	  "-XX #:   Nueva vel. en puentes de Monorriel y MagLev, porcentaje de la vel. max.\n"
	  "-XY #:   Establece el ao de inicio para juegos aletorios\n"
	  "-X1 #, -X2 #: Tiempo mx. que espera un tren a seal roja en una o\n"
	  "-Yo #:   Controla caracteristicas de otros modificadores (ver docs.)\n"
	  "-Yp #:   Permite plantar ms rboles, escoge el modo de plantacin\n"
	  "-YB #:   Ms opciones de contruccin, copntrola opciones con parmetros\n"
	  "-YE #:   Estab. los segundos que una ventana de error permanece abierta\n"
	  "-YG #:   Mejora la interfaz de usuario, escoja las opciones con parmetros\n"
	  "-YT #:   Establece al algoritmo de crecimiento de las ciudades\n"
	  "              doble va, en das\n"
	  "\n"
	  "-C cfg-file:  Lee este archivo de configuracin en lugar de ttdpatch.cfg\n"
	  "-W cfg-file:  Crea un archivo de configuracin con la conf. actual\n"
	  "\n"
	  "La capitalizacin es importante!\n"
	  "\n"
	  "Ejemplo:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n"
	  "(Consejo: Si todo apareci demasiado rpido, teclee\"ttdpatch -h|more\")\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Vea TTDPATCH.TXT para mayores detalles.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Advertencia: Estado encendido/apagado desconocido %s, desactivado.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Modificador desconocido '%c%s'.  Use -h para ayuda.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Advertencia: Lnea cfg no vlida '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Extender total de vehc", " a %d*850") 
SWITCHTEXT(usenewcurves, "Nuevo manejo curva", " para %04x") 
SWITCHTEXT(usenewmountain, "Nuevo manejo montaa", " para %04x")
SWITCHTEXT(usenewnonstop, "Nuevo manejo sin parar", "")
SWITCHTEXT(increasetraincount, "Nuevo cont. de trenes", ": %d")
SWITCHTEXT(increaservcount, "Nuevo cont. de camiones", ": %d")
SWITCHTEXT(setnewservinterval, "Nueva def. intervalo serv", ": %d das") 
SWITCHTEXT(usesigncheat, "Usar cdigos en rt.", "") 
SWITCHTEXT(allowtrainrefit, "Permite remod. trenes", "")
SWITCHTEXT(increaseplanecount, "Nuevo cont. aviones", ": %d")
SWITCHTEXT(increaseshipcount, "Nuevo cont. barcos", ": %d")
SWITCHTEXT(keepsmallairports, "mantener aerop. pequeos", "")
SWITCHTEXT(largerstations, "aument. cubrim. de est.", " a %d bloq.") 
SWITCHTEXT(morestationtracks, "Estaciones extensibles", "")
SWITCHTEXT(longerbridges, "Puentes ms largos", "")
SWITCHTEXT(improvedloadtimes, "Tiempo de carga mejorado.", "")
SWITCHTEXT(mammothtrains, "Trenes Mamt (largo 127)", "")
SWITCHTEXT(presignals, "Usar pre-seales", "")
SWITCHTEXT(officefood, "Edif. de ofic. acept. alimentos", "")
SWITCHTEXT(noinflation, "Desactivar inflacin", "") 
SWITCHTEXT(maxloanwithctrl, "Mximo prstmo/pago con 'ctrl'", "")
SWITCHTEXT(persistentengines, "Locomot. persist. si en uso", "")
SWITCHTEXT(fullloadany, "Carga compl. en cualq. tipo", "")
SWITCHTEXT(selectstationgoods, "Est. selecc. de mercancas", "")
SWITCHTEXT(morethingsremovable, "Ms objetos removibles", "")
SWITCHTEXT(aibooster, "Mejorar recursiv. de IA", " por %d")
SWITCHTEXT(multihead, "Tenes multi-motor", ", se acelera: %d%%")
SWITCHTEXT(newlineup, "Camiones hacen fila", "")
SWITCHTEXT(lowmemory, "Ver. de baja memoria (3.5MB)", "")
SWITCHTEXT(generalfixes, "Mejoras gen. (ver docs.)", "")
SWITCHTEXT(moreairports, "Ms aeropuertos por ciudad", "")
SWITCHTEXT(bribe, "Opcin de soborno", "")
SWITCHTEXT(noplanecrashes, "Control de accid. areos", ": %d")
SWITCHTEXT(showspeed, "Mostrar vel. en barra de estado", "")
SWITCHTEXT(autorenew, "Autorenovar trenes", " a %d meses")
SWITCHTEXT(cheatscost, "Los trucos valen dinero", "") 
SWITCHTEXT(extpresignals, "Poner pre-seales con 'Ctrl'", "")
SWITCHTEXT(diskmenu, "Mostrar opc. de cargar juego en men", "")
SWITCHTEXT(win2k, "Aplicar parches de Win2000/XP", "")
SWITCHTEXT(feederservice, "Serv. aliment. descarga forzada", "")
SWITCHTEXT(gotodepot, "Aadir coch. a orden de vehc.", "") 
SWITCHTEXT(newships, "Nuevos modelos de barcos", "")
SWITCHTEXT(subsidiaries, "Manejar subvenc. de la IA", "") 
SWITCHTEXT(gradualloading, "Carga gradual de vehc.", "") 
SWITCHTEXT(moveerrorpopup, "Mover mensajes de error", "") 
SWITCHTEXT(setsignal1waittime, "Nuevo tiem. de esp. a seal", ":") 
SWITCHTEXT(setsignal2waittime, "", "") // dummy entry 
SWITCHTEXT(maskdisasters, "Seleccin de desastres", ": %d") 
SWITCHTEXT(forceautorenew, "Forzar autorenov. de trenes", "") 
SWITCHTEXT(morenews, "Noticias de ms eventos", "") 
SWITCHTEXT(unifiedmaglev, "MagLev unificado", ", modo %d")
SWITCHTEXT(newbridgespeeds, "Nva. V.Max. puentes MagLev", ": %d%%")
SWITCHTEXT(eternalgame, "juego eterno desde 2070", "")
SWITCHTEXT(showfulldate, "Fecha completa", "")
SWITCHTEXT(newtrains, "Nuevos trenes", "")
SWITCHTEXT(newrvs, "Nuevos veh. de carretera", "")
SWITCHTEXT(newplanes, "Nuevos aviones", "")
SWITCHTEXT(signalsontrafficside, "Seales en lado de trfico", "")
SWITCHTEXT(electrifiedrail, "Ferrova electr.", "")
SWITCHTEXT(newstartyear, "Ao de inicio", ": %d")
SWITCHTEXT(newerrorpopuptime, "T. max. ventana error", ": %d seg.")
SWITCHTEXT(newtowngrowthfactor, "Nuevo crecimiento", " a %d")
SWITCHTEXT(largertowns, "Ciud. ms grandes", ", 1 de cada %d")
SWITCHTEXT(miscmods, "Modos miscelneos", ": %d")
SWITCHTEXT(loadallgraphics, "Cargar todo grfs nuevo", "")
SWITCHTEXT(saveoptdata, "carga y guarda info adic.", "")
SWITCHTEXT(morebuildoptions, "Ms opciones de constr.", ": %d")
SWITCHTEXT(semaphoresignals, "Semforos antes de 1975", "")
SWITCHTEXT(morehotkeys, "Ms/nuevas teclas de func.", "")
SWITCHTEXT(plantmanytrees, "Plantar ms rboles", ", modo %d")
SWITCHTEXT(morecurrencies, "Ms monedas", ", flags: %d")
SWITCHTEXT(manualconvert, "Conversin de vas manual", "")
SWITCHTEXT(newtowngrowthrate, "Nuevo factor de crecimiento", ": %d")
SWITCHTEXT(displmoretownstats, "Ms estadist. de ciudades", "")
SWITCHTEXT(enhancegui, "Interfaz mejorada", ": %d")
SWITCHTEXT(newagerating, "Ranking tolerante a edad de veh.", "")
SWITCHTEXT(buildonslopes, "Construir sobre laderas", "")
SWITCHTEXT(buildoncoasts, "Construir en costas", "")
SWITCHTEXT(experimentalfeatures, "Activar opciones experim.", ": %d")
SWITCHTEXT(tracktypecostdiff, "Dif. vas dif. costo", "")
SWITCHTEXT(planespeed, "Vel. de aviones real", "")
SWITCHTEXT(fastwagonsell, "Vender vagones rpido", "")
SWITCHTEXT(newrvcrash, "Mod. accid. tren/v. carr."," (modo %d)")
SWITCHTEXT(stableindustry, "Prevenir cierre de industrias","")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "No se encontr archivo cfg %s. Ignorado.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "No se pudo abrir %s para escritura.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Arvertencia!  lnea de conficuracines ms larga de 32 caract, truncada.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "El modificador `%s' (-%s) es obsoleto. Favor no usarlo, ser\n"
		"removido en una versin futura.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "Archivo de configuracin creado por TTDPatch con el modificador \"-W\" y nombrearchivo.\n" 
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "El formato para los modificadores es:\n"
	CFG_COMMENT "   nombre de modificador = valor de modificador\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "The \"=\" se puede omitir, o puede ser espacios. de todas maneras es ignorado.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Para modificadores s/no [y/n], el valor puede ser uno:\n" 
	CFG_COMMENT "   s, y, activado, 1, no, n, desctivado, 0\n" 
	CFG_COMMENT "Si el valor se omite, un modificador s/no da un s por defecto.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Para los modificadores con opcin para un valor [v], el rango se da en la\n"
	CFG_COMMENT "descripcin, si se omite, se usar el valor por defecto. El modificador puede\n" 
	CFG_COMMENT "desactivarse poniendo el valor de desactivado.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Los comentarios comienzan con un caracter alfabetico.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Nuevos modificadores ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) aumeta el nmero mximo de barcos.  Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) establece la velocidad en curva normal (0), ms rpido (1), la ms rpida (2) o realista (3).  Un dgito para cada vehculo tren, monorriel, maglev y vehculos de carretera.  por defecto 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) establece las velocidades en montaas normal (0), ms rpido (1), la ms rpida (2) o realista (3).  Un dgito para cada vehculo tren, monorriel, maglev y vehculos de carretera.  por defecto 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) Hace que las estaciones puedan tener mayor cubrimiento.  Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) Hace posible remodelar locomotoras.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) permite cambiar el intervalo de servicio para nuevas locomotoras.  Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) Desactiva la inflacin de costo y renovacin.") 
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) Permite aadir ms platafomas a una estacin, hasta 4x7 o 7x5.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) Hace que la orden \"sin parar\" se comporte diferente.") 
SETTEXT(CFG_PLANES, "`%s' (-%s) aumenta el nmero mximo de aviones.  Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) Activa un calculo diferente del tiempo de carga/descarga.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) aumenta el nmero mximo de vehculos de carretera. Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) activa los cdigos trampa en rtulos.") 
SETTEXT(CFG_TRAINS, "`%s' (-%s) aumenta el nmero mximo de trenes.  Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_VERBOSE, "`%s' (-%s) muestra una lista de los modificadores antesde iniciar TTD.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) permiete el uso de pre-seales para mejorar el uso de estaciones.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) aumenta el nmero total de vehculos a un valor*850.  Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) permite trenes mat de hasta 126 vagones.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) hace que el tren salga de la estacin si est lleno de algn tipo de carga.")
SETTEXT(CFG_SELECTGOODS, "With `%s' (-%s) las mercancas llegan a una estacin slo si un servicio ha llegado.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) permite pagar/pedir prestado la mxima cantidad posible presionando Ctrl.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) Hace que los edificios de oficina acepten alimentos (en escenarios Tropico y rtico).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) Mantiene las locomotoras disponibles mientras estn en uso.")
SETTEXT(CFG_CDPATH, "`%s' (sin modificador) pone la ruta del CD.")
// Note- CFG_CDPATH no tiene modificador en la lnea de comandos, as que no le de en segundo %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) Mantiene los aeropuertos pequeos para siempre.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) Aumenta la recursividad de la IA por este factor.") 
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) Permite hacer puentes de hasta 127 cuadros de largo.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) permite que ms objetos puedan ser retirados por la dinamita.")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s) permite aadir un nmero arbitrario de locomotoras por tren. Compre motores extra con 'Ctrl'.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) hace que los vehculos de carretera hagan fila en frente a una estacin, no que den la vuelta.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) permite a TTDPatch correr en coptutadores con 3.5MB de memoria, pero reduce el valor max. para el nmero de vehculos extendido a 2.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) arregla varios detalles, vea la documentacin para saber que hace exactamente.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) permite construir ms aeropuertos por ciudad.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) aade una opcin de soborno en el men de autoridades locales.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) le permite controlar cuando est permitido que un avin se estrelle. codificado en un valor de un dgito, por defecto 1.") 
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) muestra la velocidad del vehculo en la barra de estado de su ventana.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) renova los vehculos despues de haber pasado este nmero de meses de que su vida til terminara.  Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) hace que los cdigos trampa en rtulos cuesten dinero.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) permite intercambiar entre, pre-seales, salidas y seales combinadas con 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) hace que TTDPatch reconstruya TTDLOAD.OVL o TTDLOADW.OVL cada vez que inicia.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) aade un comando de cargar juego en el men de disco, un un comando de cargar (o guardar juego con Ctrl) en el editor de escenarios.")
SETTEXT(CFG_WIN2K, "`%s' (-%s) permite que la versin de windows de TTD sea compatible con windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) modifica la descarga forzada e ingresos en una estacin que acepta dejar esa carga en la estacin, sin dinero.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) permite aadir cocheras a las rdenes de los vehculos.") 
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) aumenta la variedad de barcos, con nuevos grficos.") 
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) permite administrar las subvenciones de otras compaias si posee el 75%%.") 
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) hace ms realista la forma en que se cargan los vehculos (activa `loadtime').") 
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) mueve los mensajes de error a una esquina de la pantalla.") 
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) cambia el nmero de das que espera un tren antes de darse vuelta en una va sencilla . Rango 0..254, o 255 para esperar indefinidamente.") 
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) cambia el nmero de das que espera un tren antes de darse vuelta en una va doble. Rango 0..254, o 255 para esperar indefinidamente.") 
SETTEXT(CFG_DISASTERS, "`%s' (-%s) permite escoger que desastres pueden ocurrir. valor codificado, por defecto 255 (todos los desastres).") 
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) forza el servicio a vehculos cuando es hora de la auto-renovacin (vea `autorenew').") 
SETTEXT(CFG_MORENEWS, "`%s' (-%s) genera reportes de noticias para ms eventos, vea la documentacin para mayor informacin.") 
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) permite que compres monorrieles en depsitos de maglev y viceversa.  Modo: 1 - covierte los maglev en monorrieles; 2 - convierte los monorieles en maglev; 3 - mantiene separados los monorrieles y maglev.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) cambia el lmite de velocidad en puentes tubulares de monorriel y maglev a este porcentaje de la velocidad mxima del vehculo.  Rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) permite jugar para siempre, la fecha no regresa al principio despues de 2070.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) mostrar la fecha completa en la barra de estado siempre, no solo cuando el juego esta en pausa.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) activa los nuevos modelos de tren con los nuevos grficos.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) activa los nuevos modelos de vehculos de carretera con los nuevos grficos.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) activa los nuevos modelos de avin con los nuevos grficos.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) muestra las seales de paso a nivel en el mismo lado en el que va el vehculo de carretera.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) remueve uno de los sistemas ferreos magnticos (Monorriel or MagLev) y lo reemplaza con un sistema de ferrocarril electrificado.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) establece un nuevo ao de iniciopara juegos aleatorios y permite ms fechas de inicio en el editor de escenarios.  Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) cambia el tiempo que tarda en cerrarse sola una ventana roja de error.  Rango 1..255 (en segundos), o 0 para un tiempo muy largo.  Por defecto 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) cambia el factor que limita la mayor extensin que puede tener una ciudad.  Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) hace que una de un nmero dado de ciudades crezca ms rpido y ms grande(aplicando tambin `towngrowthlimit' selectivamente).  Rango %ld..%ld.  Por defecto %ld (una de cuatro ciudades).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) modifica la manera en que algunos modificadores trabaja, vea la documentacin para mayor informacin.  valor codificado en bits, Por defecto 0 (sin modificaciones).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) hace que TTDPatch carge siempre todos los archivos .grf en newgrf(w).cfg, sin importar si fueron utilizados en un juego gurdado anterior(etc.) o no.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) hece que TTDPatch guarde y cargue informacin adicional (opcional) al final de los juegos guardados.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) aumenta las opciones de construccin. Valor codificadoen bits, rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) convierte las seales construidas antes de 1975 en seales de semforo.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) activa nuevas teclas de funcin.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) permite plantar ms de un rbol en un cuadro, o sobre un rea rectangular con Ctrl.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) activa ms monedas y el Euro.  Parmetro: 0 - smbolo de moneda en el lugar por defecto; 1 - smbolo de moneda antes del nmero; 2 - smbolo de moneda despues del nmero.  aada 4 al valor anterior para desactivar el Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) permite la conversin manual de vas colocando vas nuevas sobre las vas existentes.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) hace que los rankings de las estaciones sean ms tolerantes a la edad de los vehculos.  Ahora los vagones pueden tener hasta 21 aos en vez de 3.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) mejora la interfaz del usuario.  Valor cofoficado en bits, rango %ld..%ld.  por defecto %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) permite definir reglas para el clculo de la tasa de crecimiento de ciudades.  Modo: 0 - original de TTD, 1 - extendido de TTD, 2 - personalizado.  Vea la documentacin para ms informacin.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (sin modificador de lnea de comandos) define la tasa de crecimiento mnima de ciudades, en nuevas casas por siglo.  Activela unicamente si `towngrowthratemode' tiene el valor 2.  Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (sin modificador de lnea de comandos) define la tasa de crecimiento mxima de ciudades, en nuevas casas por siglo.  Active nicamente si `towngrowthratemode' tiene el valor 2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (sin modificador de lnea de comandos) define cuanto afecta el crecimiento de una ciudad la presencia de estaciones activas(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (sin modificador de lnea de comandos) define cuanto afecta un aestacin activa el crecimiento de una ciudad (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente las estaciones activas contribuyen al crecimiento de una ciudad(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente los pasajeros transportados contribuyen al crecimiento de una ciudad(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente el correo transportado contribuye al crecimiento de una ciudad(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (sin modificador de lnea de comandos) define el nmero mximo de pasajeros que llegan a una ciudad afectan su crecimiento(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente los pasajeros que llegan a una ciudad afectan su crecimiento(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (sin modificador de lnea de comandos) define la poblacin ptima por cada 2 bolsas de correo que llegan a la ciudad (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente el correo que llega contribuye al crecimiento de una ciudad(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (sin modificador de lnea de comandos) define la poblacin ptima por cada 2 cajas de mercancia que llegan a la ciudad (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld.  Por defecto %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente la mercanca que llega contribuye al crecimiento de una ciudad(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (sin modificador de lnea de comandos) define el requerimento mnimno de alimento para ciudades cubiertas por nieve o en reas desrticas, en poblacin por 2 toneladas alimento(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (sin modificador de lnea de comandos) define la poblacin ptima por cada 2 toneladas de alimento que llegan a la ciudad (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente el alimento que llega a una ciudad afecta su crecimiento(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (sin modificador de lnea de comandos) define el requerimento mnimno de agua para ciudades en reas desrticas, en poblacin por 2 toneladas (2,000 litros) de agua(vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (sin modificador de lnea de comandos) define la poblacin ptima por cada 2 toneladas (2,000 litros) de agua que llegan a la ciudad en el clima sub-tropical (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente el agua que llega a una ciudad afecta su crecimiento en el clima sub-tropical (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (sin modificador de lnea de comandos) define la poblacin ptima por cada 2 bolsas de dulces que llegan a la ciudad  (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente los dulces que llegan contribuyen al crecimiento de una ciudad en el mundo de los juguetes (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (sin modificador de lnea de comandos) define la poblacin ptima por cada 2 refrescos que llegan a la ciudad (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (sin modificador de lnea de comandos) define que tan efectivamente los referescos que llegan contribuyen al crecimiento de una ciudad en el mundo de los juguetes (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (sin modificador de lnea de comandos) define el nmero base de edificios para el clculo que involucra `tgrtownsizefactor' (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (sin modificador de lnea de comandos) define que tanto influye el tamao de una ciudad en su crecimiento (vea la documentacin para ms informacin).  Active nicamente si `towngrowthratemode' tiene el valor  2. Rango %ld..%ld. Por defecto %ld (i.e. 25%% de influencia).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (sin modificador de lnea de comandos) define la poblacin mnima a la que pueden crecer las ciudades cubiertas de nieve sin suministro de alimento.  Active si `towngrowthratemode', `towngrowthlimit' o `generalfixes' est activado. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (sin modificador de lnea de comandos) la poblacin mnima a la que pueden crecer las ciudades en reas deserticas sin suministro de agua.  Active si `towngrowthratemode', `towngrowthlimit' o `generalfixes' est activado. Rango %ld..%ld. Por defecto %ld.")
SETTEXT(CFG_MORETOWNSTATS, "With `%s' (-%s) estadsticas adicionales en la ventana de informacin de ciudades.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) posibilita lacontruccin de vas frreas, carreteras y estaciones en laderas, sobre un relleno como las casas.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) hace posible construir en costas o riveras sin utilizar dinamita antes.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) hace que los diferenrtes tipos de vas ferreas tengan costos de construccin distintos.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (sin modificador de lnea de comandos) sets the exchange ratio for custom currency CUS * 1000. Por defecto is 1000 (1 CUS = 1 pound).  Active nicamente si `morecurrencies' is enabled.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) activa las ltimas caractersticas experimentales.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) hace que los aviones vuelen a la velocidad indicada, no a un cuarto como normalmente lo hacen, y reduce la velocidad a 5/8 en caso de una avera.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) permite venter los vagones ms rpido con Ctrl")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) cambia los accidentes entre vehculos de carretera y trenes. %ld hace que el tren sufra una avera despus del accidente. %ld descativa los accidentes del todo. Por defecto: tipo %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) evita cierre de industrias si eligi el valor estable para la economa en laconfiguracin del la dificultad del juego");



//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nPresione Enter para correr TTD, Escape para abortar, o cualquier otra tecla para mostrar la configuracin.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Modificadores activados:   (%c activado, %c desactivado)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "Una va: ") 
SETTEXT(LANG_SWTWOWAY, "Doble va: ") 

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d da(s)") 
SETTEXT(LANG_INFINITETIME, "infinito") 

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Presione cualquier tecla para iniciar \"TTDLOAD %s\" (Escape para abortar).")

SETTEXT(LANG_SWABORTLOAD, "\nInicio de programa abortado por el usuario.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Error interno de TTDPatch #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD no est correctamente instalado(error de registro %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "No hay memoria suficiente disponible %s,se necesitan %d KB ms.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "Para iniciar TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Cdigo de modo protegido demasiado largo!\n")

// Show where the code was stored, %p is the location
SETTEXT(LANG_CODESTOREDAT, "Cdigo de modo protegido almacenado en %lX.\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Estableciendo archivo de intercambio.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 3rd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Iniciando %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "No se pudo ejecutar %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Resultado: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "Correcto")
SETTEXT(LANG_RUNRESULTERROR, "Error!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "No se encontraron los grficos de TTDpatch %s, generando archivo.\n")
SETTEXT(LANG_ERRORCREATING, "Error creando archivo %s: %s\n")



