// Faster selling of trains

uvard sellcost

// Called when selling a train engine
// in:	ax,cx: coordinates
//	edx points to the engine to be sold
//	bit 0 of bl is clear if checking cost only
// safe: ax,cx,di,esi
sellengine:
	// We've owerwritten a je near +0x8c, adjust return address manually
	jne .noadjust
	add dword [esp],0x8c
.noadjust:
	and dword [sellcost],0

	push byte CTRL_DEFAULT
	call ctrlkeystate
	jnz .normalsell

	pusha
	mov esi,edx
	mov eax,[veharrayptr]
.loop:
	movzx esi,word [esi+veh.nextunitidx]
	cmp si,-1
	jz .done

	shl esi,vehicleshift
	add esi, eax
	mov ecx, [esi+veh.value]
	add [sellcost],ecx
	test bl,1
	jz .loop

	call dword [delveharrayentry]
	jmp short .loop
.done:
	popa
	test bl,1
	jz .dontmodifyengine
	or word [edx+veh.nextunitidx],-1
.dontmodifyengine:
.normalsell:
	ret

// Called to decide the cost of selling an engine (should be a negative value)
// in:	ax,cx: coordinates
//	edx points to the engine to be sold
//	bit 0 of bl is clear if checking cost only
// out:	ebx: selling cost
//	esi: engine type for dualhead-checking
//	carry flag set to skip dualhead-checking
// safe: ax, ebx, cx, edx, di, esi
enginesellcost:
	mov ebx,[edx+veh.value]
	neg ebx
	push byte CTRL_DEFAULT
	call ctrlkeystate
	jnz .normalsell
	sub ebx,dword [sellcost]
	stc
	ret

.normalsell:
	movzx esi,word [edx+veh.vehtype]
	clc
	ret

sellwagon:
	jnz .notzero
	add dword [esp],0x7d-4
	jmp short .start
.notzero:
	cmp byte [edx+veh.subclass],4
.start:
	pushf
	and dword [sellcost],0

	push byte CTRL_DEFAULT
	call ctrlkeystate
	jnz .normalsell

	pusha

	mov eax,[veharrayptr]
	mov esi,edx
.loop:
	mov cx,[esi+veh.nextunitidx]
	test bl,1
	jz .nodetach
	mov word [esi+veh.nextunitidx],-1
.nodetach:
	cmp cx,-1
	je .done
	movzx esi,cx
	shl esi,vehicleshift
	add esi,eax

	mov cx,[esi+veh.vehtype]
	bt [isengine],cx
	jc .engine

	mov ecx,[esi+veh.value]
	add dword [sellcost],ecx
	test bl,1
	jz .loop

	call dword [delveharrayentry]
	jmp short .loop

.engine:
	test bl,1
	jz .loop

	mov cx,[esi+veh.idx]
	mov [edx+veh.nextunitidx],cx
	mov edx,esi
	jmp short .loop

.done:
	popa
.normalsell:
	popf
	ret

wagonsellcost:
	mov ebx, [edx+veh.value]
	neg ebx

	push byte CTRL_DEFAULT
	call ctrlkeystate
	jnz .normalsell

	sub ebx,dword [sellcost]

.normalsell:
	mov cx,[esp+4]
	ret 2
