//
// Miscellaneous general fixes
//

//
// Fix the bug that crashes TTD if one tries to play a scenario with running road vehicles
//

// Strip the high-order bit when adding roadtrafficside to BL
getrvmovementbyte1:
	add bl,[roadtrafficside]	// overwritten by the call
	and bl,0x7f
	ret
; endp getrvmovementbyte1 

// same for DL
getrvmovementbyte2:
	add dl,[roadtrafficside]	// overwritten by the call
	and dl,0x7f
	ret
; endp getrvmovementbyte2 


// fix the screenshot hotkeys under Windows
// Windows and DOS: prevent multiple screenshots, allow remapping of Ctrl-G and Ctrl-S
// in:	ebx=address of Ctrl key in keypresstable
// out:	ZF if screenshot will be taken, NZ if not
//	AH=screenshot type (1 or -1) if ZF
// safe:eax ebx ecx edx
checkscreenshotkeys:
	mov ah,0

	// check if the key was remapped (see patches/kbdhand.asm)
	cmp byte [lastkeyremapped],0
	jz .allowed

	bt dword [uiflags],10
	jc .notctrls

.allowed:
	// check key states

#if WINTTDX
%assign KEY_G_OFFSET 54
%assign KEY_S_OFFSET 66
#else
%assign KEY_G_OFFSET -KEY_LCtrl+0x22
%assign KEY_S_OFFSET -KEY_LCtrl+0x1f
#endif

	mov al,[ebx]    		// Ctrl pressed?
	or al,[ebx+KEY_G_OFFSET]	// G pressed?
	jnz short .notctrlg

	mov ah,-1
	mov byte [ebx+KEY_G_OFFSET],0x80	// force G to be released
					// otherwise hundreds of screenshots will be made

.notctrlg:
	mov al,[ebx]
	or al,[ebx+KEY_S_OFFSET]	// Ctrl-S?
	jnz short .notctrls

	mov ah,1
	mov byte [ebx+KEY_S_OFFSET],0x80	// same here

%undef KEY_G_OFFSET
%undef KEY_S_OFFSET

.notctrls:	// set zero flag if ah!=0
	mov al,ah
	and al,1
	dec al
	ret
; endp checkscreenshotkeys 


// If an aircraft is taking off and needs to go to hangar,
// prevent it from landing back unnecessarily
// in:	ESI->vehicle
// out:	EDX=AH=target airport
// safe:AL
gettargethangar:
	mov al,byte [esi+veh.aircraftop]
	cmp al,0xd
	jb short .normal
	cmp al,0x10
	ja short .normal

	// taking off, check its current order
	mov ax,word [esi+veh.currorder]
	and al,0x1f
	dec al
	cmp al,1
	jbe short .done

.normal:
	mov ah,byte [esi+veh.targetairport]

.done:
	movzx edx,ah
	ret
; endp gettargethangar 


	// this is called when the computer decides whether to
	// call the ai building function for a player
	// in:	al=current player
	// out:	zero if player is human
	//	nz and al=fe (or any number other than 0-7, ff)
	//	if player is not human
aibuilding:
	push byte PL_ORG
	call ishumanplayer
	jz short .haveit
	mov al,0xfe
.haveit:
	ret
; endp aibuilding 

	// same as above but for ai station rating bonus
aistationrating:
	push byte PL_ORG | PL_PLAYER
	mov [esp+1],ah
	call ishumanplayer
	jz short .haveit
	mov ah,0xfe
.haveit:
	ret
; endp aistationrating 


	// called after TTD creates the data for human players
makenewhumans1:
	mov byte [gamesemaphore],0	// overwritten

makenewhumans:
	mov eax,[human1]
	mov [landscape3+ttdpatchdata.orgpl1],ax
	ret

	// also done when starting a scenario
	// clear town stats accumulated in the editor
	// while we're at it (but only if generalfixes is enabled)
newscenarioinit:
	testflags generalfixes
	jnc .dontclearstats

	mov esi,townarray
	mov ecx,[townarray2ofst]
	mov bl,numtowns
	xor eax,eax

.clrstatsloop:
	mov [esi+town.maxpassacc],eax		// also clears .maxmailacc
	mov [esi+town.actpassacc],eax		// also clears .actmailacc
	mov [esi+town.foodthismonth],eax	// also clears .waterthismonth
	jecxz .clrnext
	mov [esi+ecx+town2.passthismonth],eax	// also clears .mailthismonth
	mov [esi+ecx+town2.goodsthismonth],eax	// also clears the next field (currently reserved)

.clrnext:
	add esi,byte town_size
	dec bl
	jnz .clrstatsloop

.dontclearstats:
	call $
ovar .origfn,-4
	jmp makenewhumans


	// the following functions are called when TTD finds the name
	// of a player.  If it's a human player, add the suffix "player 0/1"
	// if it's a human player currently managing a subsidiary,
	// add suffix "managed by player x"
	// if it's the original company of a player, add "owned by player"
playertype1:
	push eax
	push ebx

	call findplayername

	mov [textrefstack+6],ax

	pop ebx
	pop eax

	cmp al,0x7f	// definitely clears zero flag

	ret
; endp playertype1 

playertype2:
	push ebx

	mov al,dl
	call findplayername

	pop ebx

	jc short .ishuman
	xor ecx,ecx	// allow buying shares

.ishuman:

	xor dl,dl
	ret
; endp playertype2 

playertype3:
	push eax
	push ebx

	mov al,bl
	call findplayername

	mov [textrefstack+8],ax

	pop ebx
	pop eax
	ret
; endp playertype3 

playertype4:
	push eax
	push ebx

	mov al,bl
	call findplayername

	mov [textrefstack+6],ax

	pop ebx

	mov bl,0xfe
	or bl,bl

	pop eax
	ret
; endp playertype4 

	// finds out which suffix to use, and returns it in ax
	// in:	al=player id
	// out:	ax=suffix text id
	//	carry=is human
	// destroys ebx
findplayername:
	mov ebx,[human1]

	mov ah,0
	cmp al,bl
	je short .human		// is human 1

	inc ah
	cmp al,bh
	je short .human		// is human 2

	mov ah,0
	mov ebx,[landscape3+ttdpatchdata.orgpl1]

	cmp al,bl
	je short .gotit		// is org. human 1

	inc ah
	cmp al,bh
	je short .gotit		// is org. human 2

	// not human in any way
	inc ah
	clc
	jmp short .nothuman

.gotit:
	stc

.nothuman:
	movzx eax,ah
	mov ax,word [nosplit playersuffixtypes+eax*2]
	ret

.human:
		// check if human has another company
	movzx ebx,ah
	cmp al,[landscape3+ttdpatchdata.orgpl1+ebx]

	je short .gotit
	add ah,3
	jmp short .gotit

	align 2
var playersuffixtypes, dw 0x7002,0x7003,6
	dw ourtext(managedby1),ourtext(managedby2)
; endp findplayername 


// Fix the bug in the display of a train engine running cost
// (in the 'New Vehicles' and 'New Locomotive Available' windows)
// in:	EBX=vehicle ID
// out: EAX=running cost multiplier
gettrainrunningcost:
	mov	eax,dword [enginepowerstable]
	movzx	eax,byte [eax+ebx+runningcostfrompower]	// MOVZX instead of the original MOV...
	ret
; endp gettrainrunningcost

// Fix a crash when displaying exclusive offer of new wagon
// in:	esi=runningcostbaseptr
// out:	eax*[esi]>>8 unless esi==0
gettrainrunningcostmultiplier:
	test esi,esi
	jz .norunningcost
	mov esi,[esi]
.norunningcost:
	imul eax,esi
	shr eax,8
	ret


// Prevent TTD house building procedure from going into an infinite loop if year<1930
// out:	AX=date (possibly fake)
// safe:everything else
buildhousegetdate:
	// find the lowest availability start year (normally 10)
	mov esi,[housepopulationtable]
	add esi,0+houseavailyearsfrompop
	xor ecx,ecx
	mov cl,NHOUSETYPES
	xor eax,eax
	mov al,255

.typeloop:
	cmp [esi],al
	jae .next
	mov al,[esi]

.next:
	inc esi
	inc esi
	loop .typeloop

	call yeartodate

	mov eax,[currentdate]	// (overwritten)
	cmp ax,bx
	jae short .done
	mov eax,ebx		// pretend it's already that year
.done:
	ret
; endp buildhousegetdate


// Fix bug which causes crash if TTD runs out of special "vehicles" for
// bubbles (from bubble generators in toyland climate)
// in:	edi=new bubble "vehicle"
initbubble:
	pop eax
	or edi,edi
	jz short .novehicles
	mov word [edi+veh.currentload],ax

.novehicles:
	pop ebx
	ret
; endp initbubble 

// Fix bug with shares owned by a company that's bought out or sold out
// in:	dl=company ID
//	dh=new owner (FF if sold out)
// out:	esi=vehicle array
// safe:eax,(esi)
companysold:
	pusha
	mov eax,dword [playerarrayptr]

	xor ecx,ecx
	mov cl,8	// check 8 players

.checkplayer:
	cmp word [eax+player.name],byte 0
	je short .nextplayer

	push ecx

	mov cl,4

.nextshare:	// any shares owned by the company to be removed?
	cmp byte [eax+player.shareowners+ecx-1],dl
	jne short .notowner

	mov byte [eax+player.shareowners+ecx-1],dh

.notowner:
	loop .nextshare

	pop ecx

.nextplayer:
	add eax,player_size
	loop .checkplayer

	mov bh,dl
	call callclosecompanywindows

	popa

	mov esi,[veharrayptr]
	ret
; endp companysold 

// because closecompanywindows pops cx and ax, we can't call it directly
callclosecompanywindows:
	push ax
	push cx
	jmp dword [closecompanywindows]


// Fix display of amount in litres, the multiplier should be 1000 not 100
amountinlitres:
	movsx eax,word [textrefstack]	// overwritten by runindex call
	imul eax,byte 10
	ret
; endp amountinlitres


// Fix zoom level of giant screenshot not to change
rememberzoomlevel:
	mov esi,[esi+0x16]
	mov al,[esi+0x10]
	mov [curzoomlevel],al
	mov ax,[esi+8]
	ret

makegiantscreenshot:
	mov edx,0x7f707f7 + (1 << 0x1e)		// old value plus bit 1e
	xor eax,eax
	mov cl,0
ovar curzoomlevel, -1
	ret


//
// Fix food/fizzy drinks subsidies
//

// Fix display of food subsidies
// in:	ESI->subsidy (source is an industry)
//	AL=cargo type (i.e. byte [ESI])
// out:	ZF set if the target is a town (i.e. cargo is goods/candy (sweets) or food/fizzy drinks), clear otherwise
// safe:EBP,EBX(saved) (we don't need them anyway)
issubsidytotown1:
	mov [textrefstack+6],ebx	// overwritten by runindex call
	cmp al,5			// this is what the original code checks...
	jz .done
	cmp al,11			// ...and this is what it fails to check
.done:
	ret
; endp issubsidytotown1

// Fix food subsidy award check
// in:	CH=cargo type
// out:	ZF set if the target is a town, clear otherwise
issubsidytotown2:
	cmp ch,2		// overwritten
	jz .done
	cmp ch,5		// ditto
	jz .done
	cmp ch,11
.done:
	ret
; endp issubsidytotown2

// Make food and sweets subsidies possible to medium-sized towns
// in:	EDI->town (randomly selected)
//	EBX->industry which is the cargo source
//	CL=cargo type
// out:	CF set if town's population is too low, clear if it's OK
// safe:EAX,EDX
chksubsidytotown:
	cmp byte [climate],3
	jz .toyland

	cmp cl,11
	jne .goods

.food:
	cmp word [edi+town.population],400	// same as passenger subsidies
	ret

.toyland:
	// in toyland, it's the reverse:
	// almost all town buildings accept sweets (cargo 5), but only few accept fizzy drinks (cargo 11)
	cmp cl,5
	je .food

.goods:
	cmp word [edi+town.population],900	// the original check, overwritten by runindex call
	ret
; endp chksubsidytotown


// Prevent bad things from happening if the target station of a subsidy changes its owner to N/A
// in:	EAX->station
// out: CF set if the station is owned by a company, clear otherwise
//	EAX=owner*player_size if CF=1
// safe:EBX
getsubsidyowner:
	movzx eax,byte [eax+station.owner]
	cmp al,8
	jnb .fin
	imul eax,player_size
	stc
.fin:
	mov word [textrefstack+0x12],0x1A6	// "N/A" (owner)
	ret
; endp getsubsidyowner


// When a station is deleted from the station array, remove references to it in the subsidy array
// in:	ESI->station being deleted
//	AL=station idx
// out: EDI->start of vehicle array
// safe:EBP,DX
deletestationrefs:
	mov edi,subsidyarray
	mov dl,maxsubsidies

.loop:
	cmp byte [edi+subsidy.cargo],-1
	jz .next
	cmp byte [edi+subsidy.age],12
	jb .next
	cmp al,[edi+subsidy.from]
	jz .delete
	cmp al,[edi+subsidy.to]
	jnz .next

.delete:
	mov byte [edi+subsidy.cargo],-1

.next:
	add edi,byte subsidy_size
	dec dl
	jnz .loop

	mov edi,[veharrayptr]		// overwritten by runindex call
	ret
; endp deletestationrefs


// Fix aircraft's notional size when on ground
// (currently used only if buildonslopes is on)
// in:	ESI->vehicle
//	EBX=current aircraft operation code (veh.aircraftop)
dispatchaircraftop:
	call [dword ebx*4-1]
ovar .optable,-4

	movzx ebx,word [esi+veh.nextunitidx]
	shl ebx,vehicleshift
	add ebx,[veharrayptr]

	mov ax,0x202
	cmp byte [esi+veh.xsize],0x10
	jae .shadow

	mov al,byte [esi+veh.direction]
	and eax,byte 3
	mov eax,[aircraftbboxtable+eax*2]
	mov [esi+veh.xsize],ax

.shadow:
	mov [ebx+veh.xsize],ax
	ret
; endp dispatchaircraftop


// Make difficulty settings window show initial loan size properly
// Old code shows the money divided by 1000 and adds a ",000" suffix to it.
// This isn't correct if the thousand separator isn't comma (DM, FF, Pt) and
// if the position of the currency symbol was changed by TTD Translator or
// the morecurrencies patch.
// Change the code to do a real multiply instead of this trick. Changing
// the according string is done in patches.ah.
//
// Called when textrefstack is about to be filled.
//
// In:	eax: number to put in textrefstack
//		epb: number of item in the list
//
// Out:	textrefstack filled correctly
//
// Safe:	eax, cx, dx

showdifficultynums:
	cmp ebp,4
	jnz .default	// adjust initial loan size (number 4) only

	imul eax,1000
.default:
	mov [textrefstack],eax
	jmp near $		// instead of call to save a ret
ovar fndrawstring,-4


// Fix oilfield removal:
// delete the station only if there are no facilities left
// (otherwise stations 'taken over' by a player would screw up)
fixremoveoilstation:
	test byte [esi+station.flags],1
	jz .done

	jmp near $
ovar .delstation,-4

.done:
	ret


// Make train break down for a long time when it collides with a road vehicle
crashrv:
	jnz .continue
	pop edi
	ret

.continue:
	movzx edi,word [edi+veh.engineidx]
	shl edi,7
	add edi,[veharrayptr]

	mov byte [edi+veh.breakdowncountdown],1
	mov byte [edi+veh.breakdowntime],0xff
	and word [edi+veh.speed],0
	call redrawscreen
	inc word [esi+0x68]
	or word [esi+veh.vehstatus],0x80
	ret

// called when marking an industry to be closed next month
// in: esi -> industry
// safe: eax,ebx,ecx,edx
industryclosedown:
	cmp byte [economy],0
	je .noclose
	mov byte [esi+industry.prodmultiplier],0	// overwritten by the
	movzx ebx,byte [esi+industry.type]		// runindex call
	ret

.noclose:
	pop ebx	// remove our return address and
	ret	// return to the caller's caller instead of creating a news message


// Make income stats still work even if the cash reaches the maximum value
// This one is for vehicle running costs
//
// in:	eax=previous cash amount
//	ebx->player struc
//	edx=amount to deducted from cash (plus carry)
//	flags from subtraction
// out:	--
// safe:edx
dodeductvehruncost:
	jno .nooverflow

	mov [ebx+player.cash],eax

.nooverflow:
	sub eax,[ebx+player.cash]
	movzx edx,byte [currentexpensetype]
	add [ebx+player.thisyearexpenses+edx],eax
	jno .nooverfloweither

	sub [ebx+player.thisyearexpenses+edx],eax

.nooverfloweither:
	add edx,[incomequarterstatslist]
	mov edx,[edx]
	test edx,edx
	js .done

	add [ebx+player.thisquarterincome+edx],eax

	jno .done

	sub [ebx+player.thisquarterincome+edx],eax

.done:
	pop edx		// was saved by original procedure
	ret


// Same but for regular expenses
//
// in:	ebx=amount deducted
//	edx->player struc
//	flags from subtraction
// out:	--
// safe:edx
doaddexpenses:
	jno .nooverflow

	add [edx+player.cash],ebx

.nooverflow:
	push eax
	movzx eax,byte [currentexpensetype]
	add [edx+player.thisyearexpenses+eax],ebx
	jno .nooverfloweither

	sub [edx+player.thisyearexpenses+eax],ebx

.nooverfloweither:
	add eax,[incomequarterstatslist]
	mov eax,[eax]
	test eax,eax
	js .done

	add [edx+player.thisquarterincome+eax],ebx
	jno .done

	sub [edx+player.thisquarterincome+eax],ebx

.done:
	pop eax
	ret

// When calculating the company value, limit it to the maximum too
//
// in:	eax=value so far
//	esi->player struc
//	flags from cmp [esi+player.cash],0
// out:	eax=company value (add cash)
// safe:?
companyvalue:
	jle .done
	add eax,[esi+player.cash]
	jno .done
	mov eax,0x7fffffff
.done:
	ret

// Called to make news messages black and white
makenewsblackandwhite:
	cmp byte [currentyear],2000-1920	// the year will be customizable later
	jae .exit
	mov bp,0x4323	// overwritten by the
	call $		// runindex call
ovar .fillrectangle,-4
.exit:
	ret

// sets the background color for the "new vehicle available" news messages
// out: color in bp
// safe: ???
setnewsbackground:
	mov bp,103	// greenish background color
	cmp byte [currentyear],2000-1920	// the year will be customizable later
	jae .exit
	mov bp,10	// default grey background color
.exit:
	ret

// decides whether a wagon can be appended to a consist
// in:	edi -> vehicle to check (at this point, it's surely a train)
//	ebx shr 8: source vehicle type
//	al: source sprite type (used by the old code)
// out:	zf set to allow
// safe: ???
lookforsamewagontype:
	cmp byte [edi+veh.subclass],4	// overwritten by the runindex call
	jnz .exit
	ror ebx,8
	cmp bx,[edi+veh.vehtype]
	pushf	// must preserve zf
	rol ebx,8
	popf
.exit:
	ret

// fill textrefstack for the profit display in the vehicle list window
// in: edi -> vehicle
//	???
// safe: eax,ebx,edi,???
showprofitdata:
	mov eax,[edi+veh.profit]
	mov [textrefstack+2],eax

	mov eax,[edi+veh.previousprofit]
	mov bx,statictext(profit_black)
	cmp word [edi+veh.age],365*2	// don't color if less than 2 years old
	jb .foundid

	inc ebx
	or eax,eax
	js .foundid
	inc ebx
	cmp eax,10000
	jb .foundid
	inc bx
.foundid:
	mov [textrefstack],bx
	mov [textrefstack+6],eax
	ret

// Called to decide if a Zeppelin can crash at a given station tile
// in: al: landscape5 value of the field
// out: cf set to allow crashing
checkzeppelincrasharea:
	test word [miscmodsflags],MISCMODS_NOZEPPELINONLARGEAP
	jnz .onlysmall
	cmp al,0x42	// no heliports
	je .deny

	cmp al,8
	jb .deny
	cmp al,0x43
	ret

.onlysmall:
	cmp al,0x34
	jb .deny
	cmp al,0x42
	ret

.deny:
	clc
	ret


// Make the sprite sorting algorithm more stable

uvard currspritedescpp

// part 1: save pointer to the current entry in table of pointers to sprite descriptors
savecurrspritedescptr:
	mov [tempvar],edi	// overwritten by runindex call
	mov [currspritedescpp],edi
	ret

// part 2: use our pointer instead of tempvar and adjust it
usecurrspritedescptr:
	mov ebx,[currspritedescpp]
	add dword [currspritedescpp],4
	ret


// Fix the cost limit for towns when they're trying to level terrain for their expansion
townraiselowermaxcost:
	mov esi,[raiselowercost]
	shl esi,4
	ret


// choose how many options the track construction type menu will have
// (only used if unimaglev=3 and electrifiedrailway=off)
//
// in:	edx=>player
// out:	ecx=number of options
trackconstmenusize:
	movzx ecx,byte [edx+player.tracktypes]
	cmp ecx,3
	cmc
	sbb ecx,0
	ret

// decide what default to use for track construction type menu selection
//
// in:	cx=number of track types available (1..3)
//	esi=>window struct
// out:	cx=default track type (0..2)
//	set [esi+2a]=cx
// safe:?
settracktypedefault:
	mov [esi+0x2a],cx
	dec ecx
	test byte [miscmodsflags+1],MISCMODS_NODEFAULTOLDTRACKTYPE>>8
	jnz .done
	mov cl,[landscape3+ttdpatchdata.lastrailclass]
	cmp cl,[esi+0x2a]
	jb .done
	mov cl,[esi+0x2a]
	dec ecx
.done:
	ret

// actually open track construction and remember previous choice
//
// in:	edx=track type selection
// out:	[set curtooltracktype]
// safe:eax ebx cx dx ebp
opentrackconstruction:
	cmp dl,1
	jne .done
	add dl,[maglevclassadjust]

.done:
	mov eax,[curtooltracktypeptr]
	mov [eax],dl
	mov [landscape3+ttdpatchdata.lastrailclass],dl
	ret


// Called when a ship can't enter a tile
// normal processing is to reverse the direction
// we additionally check if the reverse direction is still valid on the current tile
// and if not we try other directions to free ships stuck under bridges
// in:	ESI->ship
//	EBX=current direction
// safe:EAX,ECX,EDX,EBP
turnbackship:
	xor bl,4		// overwritten by runindex call

	pusha
	movzx edi,word [esi+veh.XY]
	mov ax,4
	call [getroutemap]
	or al,ah
	and bl,3
	test al,[vehdirectionroutemasks+ebx]
	popa
	jnz .found

	// invalid direction, turn the ship 45 degrees clockwise
	inc ebx
	and ebx,7

.found:
	mov [esi+veh.direction],bl	// overwritten
	ret


// Prevent overflow in the cash limit calculation
// which would disable all LA actions
townactionthreshold:
	jno .finish
	mov edx,0x7fffffff

.finish:
	mov ebp,[fundingbasecost]	// overwritten
	ret


// Called when finding the scale of a company graph window
//
// in:	ebp=>temp structure on stack with graph data
//	cl=companies left on stack (counts from max down to 1)
// out:	eax=[ebp+edx]
//	zero flag set if value not to be considered
// safe:(eax)
findcompanygraphmax:
	movzx eax,byte [ebp+0x614]	// number of companies on graph
	sub al,cl
	bt [ebp+0x610],eax		// bit mask of companies to ignore
	cmc
	sbb eax,eax
	jnz .notignored

	ret

.notignored:
	mov eax,[ebp+edx]
	cmp eax,0x80000000
	ret


// Remember the fact that a construction action was transmittable to the other player
newtransmitaction:
	or byte [actiontransmitflag],1
	jmp near $
ovar .oldfn,-4

uvarb actiontransmitflag

// If the current company is Player 1 and the action was not transmitted,
// don't record the XY in the player array (or else sync would be lost)
// out: ZF set=don't, clear=do record
// safe:ESI
chkrecordactionxy:
	btr dword [actiontransmitflag],0
	jc .record

	// always safe in single player mode
	cmp byte [numplayers],1
	jz .record

	// always do it for the remote player and AIs
	push eax
	mov al,[curplayer]
	cmp al,[human1]
	pop eax
	jnz .record

	// unsafe, return with ZF set
	ret

.record:
	// do the overwritten part
	mov esi,eax
	or si,cx
	ret


// Auxiliary: check if the current AI company can buy any engines from a given range
// in:	BL=first vehtype to check
//	BH=number of vehtypes to check
// out:	CF set=yes, clear=no
// uses:EAX,BX,ECX
canaibuyengines:
	movzx ecx,byte [curplayer]

.engloop:
	movzx eax,bl
	bt [isengine],eax
	jnc .next
	imul eax,0+vehtype_size
	add eax,vehtypearray
	cmp word [eax+vehtype.reliab],0x8a3d
	jb .next
	bt [eax+vehtype.playeravail],ecx
	jc .done

.next:
	inc bl
	dec bh
	jnz .engloop

	clc

.done:
aidonttryroute:
	ret

// Prevent AI from building routes if it can't buy engines for it
// (function call chained in)
// safe:everything except ESI
aitrytrainroute:
	mov bl,TRAINBASE
	mov bh,NTRAINTYPES
	call canaibuyengines
	jnc aidonttryroute
	jmp near $
ovar .origfn,-4

aitryairroute:
	mov bl,AIRCRAFTBASE
	mov bh,NAIRCRAFTTYPES
	call canaibuyengines
	jnc aidonttryroute
	jmp near $
ovar .origfn,-4

// Prevent AI from building a road route
// if there are no vehicles to carry this cargo type
// (function calls chained in)
// in:	ESI->company
//	CL=cargo type
//	EBX->source (industry or town)
//	EDI->destination (industry or town)
// out:	if cannot build then set CL to -1
// safe:EAX,EDX,EBP
aitryroadcargoroute:
	mov al,aicargovehtable.roadbase

aitryroadorshipcargoroute:
	pusha
	movzx eax,al
	add eax,aicargovehicles
	movzx ecx,cl
	mov bl,[eax+ecx*2]
	mov bh,[eax+(aicargovehtable.roadnum-aicargovehtable.roadbase)+ecx]
	or bh,bh
	jz .gotcf

	call canaibuyengines

.gotcf:
	popa
	jc near $
ovar goodairoutefnofst,-4

	mov cl,-1
	ret

// Similar for a ship route
// (uses the same original function)
aitryshipcargoroute:
	mov al,aicargovehtable.shipbase
	jmp aitryroadorshipcargoroute


// Prevent placing buoys at (0,0)
// in:	AX,CX=X,Y
//	BL=constr. flags
//	DX,DI,ESI from gettileinfo
// out:	ZF set if at (0,0)
// safe:EBP
canplacebuoy:
	mov word [operrormsg2],0x304b	// overwritten
	mov ebp,eax
	or bp,cx
	ret
