
// larger stations, 7x7


// This is a weird proc structure; one of the ret's comes before the proc...
// (the reason being that otherwise I'd have to specify "short" or
// no short for all jumps, that's hard to maintain)

	// no carry says "station too close"
trainstationbad:
	clc

trainstationdone:
	popa
	leave
	ret

checkistrainstation:
	// was mov al,gs:[di]; cmp al,0..7
	// now stc if ok; clc if not

	mov al,[landscape5(di)]
	cmp al,8
	jbe short .istrainstation

	// return, and combine this train station with the existing station
	stc
	ret

.istrainstation:
	enter 0,0
	pusha

	// now the stack is like this:
	//
	// ebp+10	org.ax
	// ebp+0e	org.cx
	// ebp+0c	org.dx
	// ebp+0a	mod.dx
	// ebp+08	org.di
	// ebp+04	ret.eip
	// ebp+00	org.ebp
	// (pusha...)
	// ebp-10	org.ebx (1=test only, 0=do it)
	// ebp-1c	org.esi=station being touched

	%define oldeax ebp+0x10
	%define oldebx ebp-0x10
	%define oldecx ebp+0xe
	%define oldedx ebp+0xc
	%define oldesi ebp-0x1c

	push byte PL_RETURNCURRENT
	call ishumanplayer
	jne trainstationbad

	// now cl=current player, ch=0 for first human, 1 for second human

		// touching station owned by the player?
	cmp byte [landscape1+edi],cl
	jne trainstationbad

		// did we check this new station already?
	or al,[oldedx]		// this does really test [oldedx],80h
	js near .isgoodextension

	movzx esi,byte [landscape2+edi]
	imul esi,station_size
	add esi,stationarray

	movzx eax,word [esi+station.railXY]

	mov bl,[landscape5(ax,1)]
	and bl,1			// now bl = old orientation
	cmp bl,[oldebx+1]
	jne trainstationbad		// different orientation won't work

	mov bh,byte [esi+station.platforms]	// length of the platforms
	shr bh,stationlengthshift

	mov bl,byte [esi+station.platforms]	// number of the platforms
	and bl,stationtracksand

		// calculate landscape offset of the new position
	mov eax,[oldecx]
	rol ax,8
	or ax,[oldeax]
	ror ax,4			// now ah=new x, al=new y
	mov ecx,eax

		// depending on the orientation, either the x or y coordinates
		// must be the same, to add more platforms or make them longer

	cmp byte [oldebx+1],0	// orientation?
	je short .isinxdir

	// in y dir
	cmp al,[esi+0xa]
	je short .makelongerx		// y coordinates match -> make longer
	cmp ah,[esi+0xb]
	jne trainstationbad		// x coordinates don't match

	// x coordinates match, add platforms
.correctx:
	mov ah,[esi+0xa]
	jmp short .checkrightpos

.isinxdir:
	cmp ah,[esi+0xb]		// x coordinates match -> make longer
	je short .makelongery
	cmp al,[esi+0xa]
	jne trainstationbad		// y coordinates don't match

	mov al,ah
	mov ah,[esi+0xb]

.checkrightpos:
		// we come here to add more platforms
		//
		// now al=new pos; ah=old pos; old dh=new size, bl=old size
		//
		// check oldpos+oldsize=newpos, or newpos+newsize=oldpos -> more tracks

	cmp bh,[oldedx]		// first check that the new length is the same
	jne trainstationbad

	mov bh,ah		// is oldpos+oldsize = newpos ?
	add bh,bl
	cmp bh,al
	je short .isrightpos

	mov bh,al		// no, but maybe newpos+newsize = oldpos ?
	add bh,[oldedx+1]
	cmp bh,ah
	jne trainstationbad	// no...


		// position matches, qualifies as an extension
.isrightpos:
	add bl,[oldedx+1]
	cmp bl,stationtracksmax		// to many tracks?
	ja trainstationbad

		// all right, extend the station!
	mov bh,[oldedx]

	cmp al,ah
	jna short .keepposition	// don't switch positions unless new one is smaller
.switchpos:
	mov cx,[esi+0xa]
.keepposition:

	// everything is good, we join all train station platforms

	// bx contains the new platform length (bh) and number of platforms (bl)
	// cx contains the new train facility position

	mov word [newstationpos],cx

	shl bh,stationlengthshift
	or bl,bh
	mov byte [newstationtracks],bl

	// set bit 7 in the platform length so that later
	// we'll know we're changing the right station
	or byte [oldedx],0x80

.isgoodextension:
	stc
	jmp trainstationdone


	// we come here if the x or y coordinates don't match, but have
	// same x coord and in y dir, or same y coord and in x dir
	// --> could be trying to make it longer
.makelongerx:

	// swap x and y for convenience
	mov al,ah
	mov ah,[esi+0xb]
	jmp short .makelonger

.makelongery:
	mov ah,[esi+0xa]

.makelonger:
	// here: al=new pos; ah=old pos; old dl=new length, bh=old size
	// check oldpos+oldsize=newpos, or newpos+newsize=oldpos -> more tracks

	cmp bl,[oldedx+1]	// same number of platforms?
	jne trainstationbad

	mov bl,ah		// is oldpos+oldsize = newpos ?
	add bl,bh
	cmp bl,al
	je short .isrightlength

	mov bl,al		// no, but maybe newpos+newsize = oldpos ?
	add bl,[oldedx]
	cmp bl,ah
	jne trainstationbad	// no...

		// position matches, qualifies for making station longer
.isrightlength:
	add bh,[oldedx]
	cmp bh,7		// too long?
	ja trainstationbad

		// all right, extend the station!
	mov bl,[oldedx+1]

	cmp al,ah
	jna .keepposition	// don't switch positions unless new one is smaller
	jmp .switchpos

; endp checkistrainstation 

hastrainstation:
	// was cmp word ptr [esi+0ah],0

	or dl,dl
	js short .extendedstation

	cmp word [esi+0xa],byte 0
	ret
.extendedstation:
	xor edx,0x80000080	// clear sign bit from dl and set it on edx
				// because dl must contain correct value

	cmp al,al		// = set zf
	ret
; endp hastrainstation 

setstationsize:
	// was mov al,dl; shl al,3; or al,dh
	// now add old size; fix position if edx has sign bit set

	or edx,edx
	js short .extendedstation

.normal:
	mov al,dl
	shl al,stationlengthshift
	or al,dh
	ret

.extendedstation:

	mov ax,word [newstationpos]
	mov [esi+0xa],ax

	mov al,byte [newstationtracks]	// new number and length of tracks
	ret
; endp setstationsize 

clearplatformarray:
	or dword [newplatformarray+0x0],byte -1
	or dword [newplatformarray+0x4],byte -1
	or dword [newplatformarray+0x8],byte -1
	or dword [newplatformarray+0xc],byte -1
	ret
; endp clearplatformarray 

readplatformarray:

	%assign curoffset 0
	%rep stationtracksand+1
		cmp di,word [newplatformarray+curoffset]
		jz short .haveit

		%assign curoffset curoffset+2
	%endrep
.haveit:
	ret
; endp readplatformarray 

	// called when a new # of tracks is selected in station dialog
	//
	// in:  cx=#tracks+5
	// out: cx=#tracks shl 8
	// safe:-
tracknumsel:
	sub cl,5
	push byte CTRL_MP
	call ctrlkeystate
	jnz short .notpressed
	add cl,3
.notpressed:
	shl cx,8
	ret
; endp tracknumsel 

	// called when a new platform length is selected in station dialog
	//
	// in:  cx=#tracks+5
	// out: cx=#tracks shl 8
	// safe:-
tracklensel:
	sub cl,9
	push byte CTRL_MP
	call ctrlkeystate
	jnz short .notpressed
	add cl,2
.notpressed:
	push edi
	mov edi,dword [stationsizeofs]
	and word [edi],0xff00
	pop edi
	ret
; endp tracklensel 

// layout of the stations

uvarb largestationlayout,7*7

createplatformsingle:
	mov al,0
	push ecx
	rep stosb
	pop ecx

	lea eax,[ecx-1]
	shr eax,1
	sub eax,ecx
	mov byte [edi+eax],2
	ret

createplatformmulti:
	push ecx
	rep stosb
	pop ecx

	cmp ecx,byte 4
	jbe .done

	mov eax,ecx
	neg eax
	mov byte [edi+eax],0
	mov byte [edi-1],0

.done:
	ret

// Create station layout
// in:	DH=number of platforms
//	DL=platform length
//	EBP->layout buffer
//	ES=DS
// safe:everything (see codefragment newgetstationlayout)
getstationlayout:
	mov edi,ebp

	movzx ecx,dh
	cmp dl,1
	je .single

	mov ebx,ecx
	movzx ecx,dl
	cmp dh,1
	je .single

	shr ebx,1
	jnc .multiloop

	// the odd platform of a multi-platform layout
	call createplatformsingle

.multiloop:
	dec ebx
	js .done

	mov al,4
	call createplatformmulti
	mov al,6
	call createplatformmulti
	jmp .multiloop

.single:
	call createplatformsingle

.done:
	ret
