// functions dealing with some new features of the new trains


	// deal with shorter train vehicles (e.g. tenders)

// called when a train vehicle is leaving depot
// determine whether next vehicle is activated
//
// in:	edi=vehicle
//	dx=cur position on tile
// out:	zero flag clear if activating next vehicle
// safe:eax ecx edx
trainleavedepot:
	mov cx,[dword esi+1]
ovar nexttrainvehthreshold, -4

	mov al,[edi+veh.shortened]
	test al,al
	jnz .gotlength

	movzx eax,byte [edi+veh.vehtype]
	mov al,[trainvehlength+eax]
	or al,0x80
	mov [edi+veh.shortened],al

.gotlength:
	and al,~0x80
	push cx

	// cx is either 0x801, 0x108, 0x80d or 0xd08 depending on direction
	// need to change 1=>-al, 8=>0, d=>al
	sub ch,8
	jz .goty

	mov ch,al
	jns .goty

	neg ch
.goty:
	sub cl,8
	jz .gotx

	mov cl,al
	jns .gotx

	neg cx
.gotx:
	add dx,cx
	pop cx

.isengine:
	cmp dx,cx
	ret

// called when a train vehicle arrives at a depot
//
// in:	edi=vehicle
// out:	set vehstatus, direction
// safe:?
trainentersdepot:
	or word [edi+veh.vehstatus],1
	xor byte [edi+veh.direction],4
	mov byte [edi+veh.shortened],0
	ret

// called train has to be reversed (from button, at signal or otherwise)
//
// in:	dh=total number of vehicles in train
//	dl=0
// out:	-
// safe:eax ecx edx ebp edi
reversetrain:

	param_call advancewagons, byte -1
	push edx

.reversenextset:
	call $
ovar exchtrainvehicles, -4

	inc dl
	dec dh
	cmp dl,dh
	jle .reversenextset

	pop edx
	param_call advancewagons, 1

	ret

// advance a set of wagons for trains that have tenders
proc advancewagons
	arg direction

	local lengthdiff,prevveh

	_enter
	and dword [%$lengthdiff],0
	and dword [%$prevveh],0
	pusha

.nextset:
	push edx
	mov edi,esi

	test dh,dh
	jz .gotlast

.nextwagon:
	movzx edi,word [edi+veh.nextunitidx]
	shl edi,7
	add edi,[veharrayptr]
	dec dh
	jnz .nextwagon

.gotlast:

	// now	esi=first wagon in subset
	//	edi=last wagon in subset (maybe equal to esi)

	mov ecx,[%$lengthdiff]

	mov al,[esi+veh.shortened]
	and eax,0x7f		// for negative moves, use previous length diff
				// and set next one to [esi+veh.shortened]

	cmp dword [%$direction],1
	je .move

	mov al,[edi+veh.shortened]
	and eax,0x7f		// for positive moves, use new length diff
	mov ecx,eax		// from [edi+veh.shortened]


.move:
	// now eax=next length diff
	//     ecx=cur. moves

	mov [%$lengthdiff],eax

	jecxz .dontmove

	mov edx,[recordtraincrash]
	mov byte [edx],0xeb	// never record train crash
	push edx

	mov ax,-1
	xchg ax,[edi+veh.nextunitidx]	// make sure following vehicles don't move too
	push ax

.again:
	pusha
	mov eax,[prevtrainveh]
	mov ebx,[%$prevveh]

	test ebx,ebx	// first vehicle in consist never has to move
	jz .isfirst

	mov [eax],ebx
	mov ah,1
	call dword [movetrainvehicle]

.isfirst:
	popa
	loop .again

	pop word [edi+veh.nextunitidx]

	pop edx
	mov byte [edx],0x73	// record train crashes again

.dontmove:
	// go to next subset

	pop edx
	mov [%$prevveh],esi
	movzx esi,word [esi+veh.nextunitidx]
	shl esi,7
	add esi,[veharrayptr]
	sub dh,2
	jnb .nextset

	popa
	_ret
endproc advancewaggons


// show train sprite in depot or in train info window
//
// in:	cx=x pos
//	dx=y pos
// out:	cx += 14 for depot/other? or += 18 for train window
//	dx += 6
displaytraininfosprite:
	add cx,14
	add dx,6

	cmp byte [esi],14	// train info window
	jne .done

	add cx,4
.done:
	ret

// called when calculating the position of the next vehicle
// in the train depot display
//
// in:	cx=old pos
//	edi=vehicle ptr
// out:	cx adjusted
//	di=nextunitidx
// safe:?
displaytrainindepot:
	push eax
	movzx eax,byte [edi+veh.vehtype]
	mov al,[trainvehlength+eax]
	lea eax,[eax*3-0x1d]
	sub cx,ax
	mov di,[edi+veh.nextunitidx]
	pop eax
	ret

// find out which train vehicle the user clicked on in a depot
//
// in:	al*1d+ah=x coord within window
//	edi=first veh in consist
// out:  al=0
//	edi=0 if beyond consist
// safe: ah
choosetrainvehindepot:
	push ebx
	xchg eax,ebx
	mov al,0x1d
	mul bl
	add al,bh
	adc ah,0

.nextveh:
	movzx ebx,byte [edi+veh.vehtype]
	mov bl,[trainvehlength+ebx]
	lea ebx,[ebx*3-0x1d]
	neg ebx
	sub ax,bx
	jb .foundit

	movzx edi,word [edi+veh.nextunitidx]
	cmp di,-1
	je .notfound
	shl edi,vehicleshift
	add edi,[veharrayptr]
	jmp .nextveh

.notfound:
	xor edi,edi
.foundit:
	mov al,0
	pop ebx
	ret


// calculate coords for the white rectangle around the active train vehicle
//
// in:	cx=start y
//	dx=start x
//	edi=vehicle
// out: ax=start y
//	bx=start x-how much veh is shorter
//	cx=start x
// safe:si edi bp
showactivetrainveh:
	mov ax,cx
	mov cx,dx
	movzx ebx,byte [edi+veh.vehtype]
	mov bl,[trainvehlength+ebx]
	lea ebx,[ebx*3]
	neg ebx
	add bx,ax
	ret

// called after setting up info display for train wagon
//
// in:	ax=loaded weight
// out:	set textrefstack+6 to ax
// safe:all but esi
showwagoninfo:
	mov edi,textrefstack+6
	mov [edi],ax
	cmp word [edi+4],0
	jne .isok
	mov word [edi+2],0x8838
.isok:
	ret
