
// Text handler
// Allows displaying our own text by setting a flag


// in:  eax = text code
//	text code & 07ff is the offset into an array of pointers for TTD
//	text code & f800 is a code indicating what type of text to display
// out:	CF=0, si=ax and eax &= 7ff for TTD strings
//	CF=1 and esi=stringptr for TTDPatch strings (custom or static)
texthandler:
	mov si,ax
#if DEBUG
	mov word [.lastcode],ax
#endif
	and eax,0x7ff
	cmp si,0xf800
	jae short .ourtext
.noitsnotourtext:
	clc
	ret

.ourtext:
	cmp eax,byte ourtext(last) & 0x7ff		// last available entry
	jb short .good

	sub ah,(statictext(first) & 0x7ff) >> 8
	jb .bad

	cmp eax,byte statictext(last) & 0x1ff
	jnb .bad

	mov esi,[stxtptr+eax*4]
	stc
	ret


.bad:
	xor eax,eax

.good:
	mov esi,[customtextptr]
	add esi,[esi+eax*4]
	stc
	ret

	// this is useful to trap on access to a certain string in memory
	// and then use this variable to figure out what the text index was
#if DEBUG
	align 2
var .lastcode, dw 0
#endif

; endp texthandler 


// macro to define static texts (i.e. text strings that are not language
// dependent and don't appear in ttdpttxt.dat)
//
// define static texts in patches/stat_txt.ah
//
%macro stxt 2+.nolist	// params: id,textdefinition...
	%ifnctx stxtdef
		%error "stxt macro used outside of stat_txt.ah"
	%endif
	STXT_%1 equ %$stxtnum
	%assign %$stxtnum %$stxtnum+1
%ifndef PREPROCESSONLY
	%assign %$thistext addr($)
%endif
	%if %$stxtnum>1
		%xdefine %$stxts %$stxts,%$thistext
	%else
		%xdefine %$stxts %$thistext
	%endif
	db %2
%endmacro

%push stxtdef
%assign %$stxtnum 0
STXT_first equ %$stxtnum

#include "stat_txt.ah"

// define two special texts that can be modified by writing
// the text address to specialtext1 and specialtext2
// and using statictext(special1/2)

STXT_special1 equ %$stxtnum
STXT_special2 equ %$stxtnum+1
STXT_last equ %$stxtnum+2

	align 4
var stxtptr, dd %$stxts
var specialtext1, dd 0
var specialtext2, dd 0

%pop
