
// Train refitting

setuptrainwindow:
	//good: eax, ebx, dx

	mov byte [refitenginecnt],0

	// find out if any of the engines can carry cargo
	movzx eax,word [esp+4]
	shl eax,vehicleshift
	add eax,[veharrayptr]

	push eax
	mov bh,0xff	// count all engines, see if *any* can carry cargo
	call getallenginecargo
	pop ebx		// total cargo
	jz short .notindepot

	cmp byte [eax+veh.movementstat],0x80
	jne short .notindepot

		// train with cargo engines is in a depot, use refit button
	mov eax,trainwindowrefit
	jmp short .setwindow

.notindepot:
	mov eax,dword [normaltrainwindowptr]
.setwindow:
	mov dword [esi+0x24],eax
	ret
; endp setuptrainwindow 

// in:	vehicle index on stack
// out:	cargo capacity on stack if nz, zf=no engine/no cargo
getenginecargo:
	push ebx
	xor ebx,ebx
	xchg ebx,[esp+8]

.nextvehicle:
	movzx ebx,word [ebx+veh.vehtype]
	bt dword [isengine],ebx
	jnc short .notacargoengine

	push edx
	mov edx,dword [enginepowerstable]
	add edx,ebx
	movzx ebx,byte [edx+cargosizefrompower]

	// adjust for cargo types (e.g. 250 livestock = 1000 passengers)
	mov dl,byte [edx+cargotypefrompower]
	cmp dl,0
	je short .adjustdone
	shl ebx,1
	cmp dl,2
	je short .adjustdone
	cmp dl,5
	je short .adjustdone
	shl ebx,1

.adjustdone:
	pop edx
	or ebx,ebx
	mov [esp+8],ebx

.notacargoengine:
	pop ebx
	ret
; endp getenginecargo 

// same as above but counts cargo capacity of all engines in the train
// after popping e.g. ebx, returns the number of engines with cargo
// in bl and the total amount in the rest of ebx
//
// in:	bh=new cargo type, if bh!=0ffh, count only engines not already of that type
getallenginecargo:
	push eax	// to save the first engine index
	push edx
	push byte 0	// total cargo

	mov eax,[esp+0x10]

.nextvehicle:
	push eax
	call getenginecargo
	setnz dl

	// now dl=1 if this engine has cargo
	or bh,bh
	js short .count

	cmp bh,byte [eax+veh.cargotype]
	jne short .count

	mov dl,0	// don't count; it's already the right type

.count:
	add [esp+4],dl
	pop edx		// get cargo size from stack
	add [esp+1],edx
	movzx eax,word [eax+veh.nextunitidx]
	cmp ax,-1
	je short .done

	shl eax,vehicleshift
	add eax,[veharrayptr]
	jmp short .nextvehicle

.done:
	pop eax		// total cargo
	or al,al
	mov [esp+12],eax
	pop edx		// restore edx and eax
	pop eax
	ret
; endp getallenginecargo 


checkinhangar:
	mov al,[landscape4(bp)]
	and al,0xf0
	cmp al,0x50
	jnz short .checktraindepot
	mov ah,0
	cmp byte [landscape5(bp)],0x20
	jz short .hangarchecked
	cmp byte [landscape5(bp)],0x41
	jmp short .hangarchecked

.checktraindepot:
	mov ah,1
	cmp al,0x10
	jnz short .hangarchecked
	mov al,[landscape5(bp)]
	cmp al,0xc0
	jl short .isnotindepot
	cmp al,0xc4
	jnl short .isnotindepot

.isindepot:
	xor al,al		// to set ZF
	jmp short .hangarchecked

.isnotindepot:
	or al,1			// to reset ZF

.hangarchecked:		// what really matters is the state of the zero flag
	movzx ebp,ah
	ret
; endp checkinhangar 

trainreverse:
	push eax
	mov al,cl
	shl al,1
	add al,cl
	shl al,2
	movzx eax,al
	add eax,[esi+0x24]
	cmp word [eax+0xa],0x2b4
	pop eax
	jne short .donotrefit

		// refit not reverse
.dorefit:
	add esp,byte 4
	jmp dword [oldrefitplane]

.donotrefit: 	// reverse
	bts word [esi+0x1e],8
	or word [esi+4],byte 5
	ret
; endp trainreverse 

// adjust capacity for cargo type
// in:	on stack: original capacity
//	bh=cargo type
// out:	on stack: adjusted capacity
adjustcapacity:
	xchg eax,dword [esp+4]
	or eax,eax
	pushf		// need to store whether it *was* zero
	cmp bh,0
	je short .adjustdone
	shr eax,1
	cmp bh,5
	je short .adjustdone
	shr eax,1
.adjustdone:
	popf		// might be zero now, if it was less than 2 or 4
	xchg eax,dword [esp+4]
	ret
; endp adjustcapacity 

selectrefittype:
	or bp,bp
	jz short .isplanerefit

	push edx
	call getallenginecargo
	pop eax		// cargo size
	mov byte [refitenginecnt],al
	shr eax,8
	jmp short .done

.isplanerefit:
	cmp bh,byte [edx+veh.cargotype]
	setne byte [refitenginecnt]	// make it cost if the type changes

.done:
	push eax
	call adjustcapacity
	pop eax
	mov bp,word [edx+veh.XY]
	ret
; endp selectrefittype 

// called to store the new capacity
// in:	edx=veh.index
//	ax=new capacity
//	bh=new cargo type
// out:	ax=[edx.nextwaggon]
refitstorecap:
	cmp byte [edx+veh.class],0x10
	jne short .notatrain

	// need to calculate the capacity of this engine only
	push edx
	call getenginecargo
	call adjustcapacity
	pop eax

.notatrain:
	mov word [edx+veh.capacity],ax
	mov ax,word [edx+veh.nextunitidx]
	ret
; endp refitstorecap 

// called after storing the new cargo type and capacity of the first engine
// in:	eax=this vehicle
//	bh=new cargo type
//	edx=first vehicle (engine)
// out:	cx=capacity of this vehicle
refitsecondengine:
	cmp byte [edx+veh.class],0x10	// is it a train?
	je short .train

	cmp bh,0			// planes only get mail if the first
	je short .hasmail		// type is passengers
	xor cx,cx
.hasmail:
	ret

.train:
	push eax

.nextvehicle:
	movzx eax,word [eax+veh.nextunitidx]
	cmp ax,-1
	je short .otherenginesdone

	shl eax,vehicleshift
	add eax,[veharrayptr]

.checknextwaggonrefit:
	push eax
	call getenginecargo
	call adjustcapacity
	pop ecx
	jz short .nextvehicle		// no cargo

	mov word [eax+veh.capacity],cx		// set third and following engines
	mov byte [eax+veh.cargotype],bh
	mov word [eax+veh.currentload],0
	jmp .nextvehicle

.otherenginesdone:
	pop eax		// eax is still on stack; restore it
	push eax
	call getenginecargo
	call adjustcapacity
	pop ecx
	jz short .notanengine	// not an engine but a waggon
	mov byte [eax+veh.cargotype],bh
	ret			// set second engine cargo size upon returning

.notanengine:
	// need to prevent TTD from modifying the cargo type and capacity
	mov eax,edx
	mov cx,word [eax+veh.capacity]
	ret
; endp refitsecondengine 


// calculate cost of refit
// in:	ebx=cost of refitting one engine * 128
// out:	ebx=cost
calcrefitcost:
	imul ebx,byte 1		// the immediate will be stored later
ovar refitenginecnt,-1
	sar ebx,7
	ret
; endp calcrefitcost 
