#!/usr/bin/perl -w

use strict;
use FindBin qw($Bin);
use lib $Bin;
use CRC32;

my $oldcrc = "";
#print STDERR "$ENV{OLDCRC}\n" if exists $ENV{OLDCRC};
$oldcrc = (split " ", $ENV{OLDCRC})[2] || "" if exists $ENV{OLDCRC};
#print STDERR "Old CRC is $oldcrc\n";

my $newcrcdata = "";
my $relnum = 0;
my %relocs;
while (<>) {
	my @F = split;

	# skip lines which don't have a "[" in the byte code
	next unless @F > 2 and $F[2] =~ tr/[//;

	#print "Found $F[2] in $_\n";

	# collect all continuation lines
	while ($F[2] =~ /-$/) {
		$F[2] =~ s/-$/$_=<>;(split)[2]/e;
		#	print "Now $F[2] after adding new line $_\n";
	}

	# find all relocations and record the lower 16 bits of their addresses
	while ($F[2] =~ s/^([0-9a-f]*)\[([0-9a-f]{8})\]/$1$2/i) {
		my $rel = (length $1)/2;
		my $addr = ($rel + hex $F[1]) & 0xffffff;
		my $xaddr = sprintf "%06x", $addr;
		#	print "Relocation: $2 at $xaddr ($1=$rel before it)\n";
		push @{$relocs{substr $xaddr,-6,4}}, "0x" . substr $xaddr, -2;
		$newcrcdata .= $xaddr;
	}
}

my $lastblock = 0x6000;
for (sort {hex $a <=> hex $b} keys %relocs) {
	my $block = hex;
	my $skipblock = $block - $lastblock;

	#printf "In block %4x: $skipblock; @{$relocs{$_}}\n", $block;

	while ($skipblock > 15) {
		$lastblock += 15;
		printf "\tdb 0x0f\t//%4xxx\n", $lastblock;
		$skipblock -= 15;
	}

	$lastblock = $block;

	my @relocs = @{$relocs{$_}};

	while (@relocs) {
		my $num = @relocs;
		$num = 15 if $num > 15;

		my @slice = splice @relocs, 0, $num;

		my $code = sprintf "0x%2x", $skipblock + (@slice << 4);
		local $" = ',';
		print "\tdb $code,\t@slice\t// ${_}xx\n";

		$skipblock = 0;
	}
}

my $newcrc = sprintf "%08x", crc32 $newcrcdata;
print "\n// RELOCCRC $newcrc\n";

#print STDERR "New CRC is $newcrc\n";
#print STDERR "Returning with ", (!$oldcrc || $newcrc ne $oldcrc), "\n";

# return with exit code 1 if the CRCs are different
exit (!$oldcrc || $newcrc ne $oldcrc);
