#!/usr/bin/perl -w
# Generate names and version ID of ourtext() variables
#
# Input: texts.lst   Output: patches/texts.ah
#
use strict;
use FindBin qw($Bin);
use lib $Bin;
use CRC32;

print <<INTRO;
// This file is autogenerated. DO NOT EDIT.
// Edit perl/texts.pl instead.

INTRO

my ($ind,$vardatasize,$maxname,@textnames);
while (<>) {
	my @F = split;
	
	next unless /equ/ && @F==4;
	next if $F[3] eq '$';

	my ($name, $ind) = @F[1,3];

	$maxname = $ind if !$maxname || $ind>$maxname;
	print "#define TXT_$name $ind\n";
	$textnames[$ind] = $name;
}

my $version = sprintf "%x", crc32 "@textnames";

print <<"FOOTER";
#define TXT_VERSIONID HEXVAL($version)

#ifdef WANTINGAMETEXTNAMES
const char *ingametextnames[] = {
FOOTER

print qq(\t"$textnames[$_]",\t// $_\n) for 0..$#textnames;
print "};\n#endif\n";
