@c      vim:    syntax=texinfo

@metanode @chapter,Introduction,What is TTDPatch?  What does it do?


@metanode @section,What does it do?,A brief summary of how TTDPatch is useful.

TTDPatch is a program that modifies the way Transport Tycoon Deluxe (TTD) 
works.  It offers many, many 
improvements in gameplay and offers a different way of experiencing TTD.  Among
the more popular options are:

@table @asis

@item More, Better, Larger
Have you ever been annoyed by the maximum number of vehicles, that you can only have
80 trains, and that there are only 690 vehicles available to all eight
players?  No more!  Now you'll be able to own 240 trains, 240 road vehicles, 240
planes and 240 ships, and altogether up to 40,000 vehicles.
Also you can have larger stations, with up to 7 platforms, each with a
length of up to 7 squares, or even mammoth trains with up to 126 carriages.

@item New Signals
Frustrated that building an efficient station is so hard?  Pre-signals offer
a new way to guide your trains and allow very small, yet efficient stations.
Also, a different way to handle the ``non-stop'' flag makes it easier and
more efficient to give a train way points along its route, in the form of
dummy 1x1 stations.  These improvements allow the creation of large, interconnected
rail networks that are very efficient.

@item New Graphics
If you've always wanted a larger variety of vehicles, TTDPatch is for you.  It
enables new vehicles with new and exciting graphics, and supports making even more
vehicles with a new add-on mechanism.

@item In-game Cheats
Just by placing a sign, you can change the year, your cash, renew all your
carriages for better station ratings and so much more.  Get this, you can even
automatically convert all your tracks to monorail and maglev, so that you
don't have to waste time converting them yourself!

@item Other conveniences,
including refittable train engines, mixed stations with different types of
trains, selectable station goods, more useful ``full load'' option, the
ability to use realistic acceleration on mountains, or turn off the 
effects of curves and mountains entirely, and much, much more.

@end table

None of the above is compulsory, everything can be customized.  You only play with
the options that you like, and leave the rest turned off.  Every one has different
preferences, and this program tries to accomodate that as much as possible.

Just keep on reading, and you'll find out that you really want to try this
program.  And the best: it's totally free!  And that's because I'm just
a TTD nut who can't get enough, and I've been so annoyed with the program at
times that I just decided to fix it myself.  I think I've been successful,
but see for yourself.


@metanode @section,Copyright and Copying,Who made TTDPatch, and under what conditions are you allowed to copy and use it.

This program and the accompanying documentation are Copyright
@copyright{} 1999-2003 by Josef Drexler.  
TTDPatch is distributed under the terms of the GNU general public license (GPL).
For more information please read the @uref{http://www.fsf.org/copyleft/, GNU GPL 
page}.  A copy of the license should have come with the program in the file 
@file{COPYING}, if not please read the @uref{http://www.fsf.org/copyleft/gpl.html, 
license}.

@cindex warranty (lack thereof)
@noindent In particular, the standard warranty disclaimer applies:

BECAUSE THE PROGRAM IS SUPPLIED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM ``AS IS'' WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

@noindent The same things in English:
@itemize @bullet

@item I own it (mostly*).  It's mine.  Muahahaha!  (But I let you use it too.)
@item I can't guarantee that it works, or that it works correctly.
@item If it breaks, it's your fault.  But you do get to keep both pieces.
@item If it breaks something else, it's your fault too.
@item You can give it to your friends, or anyone else you wish, as long as you
credit to whom credit is due.
@item You are free to offer the program on your web page.  All I ask for is
that you give a link back to mine, so that your visitors can be sure that they
have the latest version, and please mention that the program was
made by Josef Drexler.
@item Don't complain to Microprose about any of this.  They can't help you.
@end itemize

@noindent *) Note that other people have contributed code and graphics, and they generally
own their contributions themselves.

@metanode @section,Cheat Disclaimer,When not to use TTDPatch.

This program is a cheat program.  It will enable you to do things that are not
possible in the standard Transport Tycoon Deluxe.

If you think your enjoyment of the game might be reduced by using cheats, you
should not use this program.  Personally, I like TTD much more with some of
the more annoying things removed, and the missing things added.

Any use of the sign cheat will mark your savegame permanently.  If you intend
to participate in a competition, you should not use them (unless they are
permitted), as this can easily be found out.  The rest is more or less
obvious to find out anyway.


@metanode @section,Terminology and Notations,Explaining some of the terms and notations used in this manual.
@c --------------------------
@cindex notations

This section aims to explain some words used in this manual, if they might be ambiguous
or not obvious.  Additionally, some of the notations are explained.

@table @b
@item DOS version
@cindex DOS version
The DOS version refers to the older version of TTD that runs in DOS, or in a DOS window.
Even if it runs under Windows, it is still the DOS version of TTD.
@item Windows version
@cindex Windows version
The Windows version is the more recent version of TTD.  It is a native Windows 
application that uses DirectX to communicate with the graphics and sound hardware.
@item Station
@cindex station
A station is either a station complex or a station facility, depending
on the context.

@item Station complex
@cindex station complex
@cindex complex, station
Several station facilities connected together such that they form a single unit.  A 
station complex can combine several different types of carriers.  The 
name, ratings and goods waiting are always stated for the whole station 
complex, not for each individual facility.

@item Station facility
@cindex station facility
@cindex facility, station
One of the parts that make up a station complex, it
can be a train station, bus or truck terminal, airport, heliport or
ship docks.

@item Vehicle
@cindex vehicle
Any mobile unit that you can buy individually, i.e. train engines and
wagons, road vehicles, aircraft and ships.

@item Carrier
@cindex carrier
A vehicle or consist that is able to transport a certain type of cargo,
e.g. planes can be both passenger and mail carriers.

@item Engine
@cindex engine
The powered vehicle(s) present in every consist.  For trains 
the engine refers to only the train engine(s) without the wagons, 
for all others it refers to the vehicle itself.

@item Consist
@cindex consist
An operational set of vehicles that are given commands 
together.  It refers to the entire train including engine and wagons, or the
bus, truck, aircraft or ship.  See also carrier.
@end table

Some additional clarifications:
A road, air, or water consist is a single vehicle
that functions as both engine and carrier.  A rail consist is multiple vehicles
including an engine and at least one carrier.  Some engines are made of two
vehicles and some engines are also carriers.  

@table @b
@item Option
@cindex option
An option is specified on TTDPatch's command line, to either select what
patches should be applied (see switch) or to otherwise control how
TTDPatch runs.

@item Patch
@cindex patch
A patch is a modification of TTD's behaviour, through TTDPatch.  Can be
activated using a switch.

@item Switch
@cindex switch
A switch is an option that selects what patches TTDPatch should apply.  It
can be specified either as an option on the command line, or as an entry
in the configuration file.
@end table

Definition of notations:
@table @t
@item <angle brackets>
Angle brackets are placeholders, to be replaced by the actual data of your choice.
For example, the ``Year'' sign cheat is defined as @t{@w{Cht: Year <number>}}.  This
means that you should replace @t{@w{<number>}} with the number of the year, e.g.
@t{@w{Cht: Year 2034}}.

@item [square brackets]
Square brackets indicate an optional component.  For example, the ``tracks'' sign
cheat is defined as @t{@w{Cht: <to> [<from>]}}.  This means that @t{@w{<to>}} is mandatory
and must always be specified, but @t{@w{[<from>]}} is optional.  As a result, both
@t{@w{Cht: 1}} and @t{@w{Cht: 1 2}} are valid examples of the track cheat.

@end table

@metanode @section,Contributors,Who works on and helps with TTDPatch
@c --------------------------
@cindex contributions
@cindex acknowledgements
@cindex authors


@subheading Code Contributions

(In order of appearance.)

@table @b
@item Josef Drexler
Josef is the main author of TTDPatch.  He started the project in 1996 and made it
public in May 1999.  He's working on it whenever he has spare time, and wrote 
a large chunk of the code.  If a feature is not credited to someone else, it was
written by Josef.  He also maintains this manual, and the ttdpatch.net website.

@item Marcin Grzegorczyk
Marcin joined Josef in the development of TTDPatch in 2000 and is the other
major contributor to the patch.  He fixed a lot of the bugs in Josef's code, and
developed the following features: 
rvqueueing, Plane crash control, most of the ``generalfixes'', city bridge removal,
signalwaittimes, disaster selection, forceautorenew, morenews, unifiedmaglev,
newbridgespeeds, signalsontrafficside, electrifiedrailway, errorpopuptime,
all new town growth switches, most of the miscmods, saveextradata, 
Enhanced keyboard handler, euro, buildonslopes, buildoncoasts

@item Norman Rasmussen
Norman wrote the Windows 2000/XP compatibility code, and @file{dxmci.dll} to make TTD
use DirectMusic for playing the music.

@item Oskar Eisemuth
Oskar joined the team in March 2003, and has been busily adding new features to the
patch.  He wrote morebuildoptions, morehotkeys, enhancegui 

@item Csaba Varga
Csaba joined in April 2003, and has also contributed a number of new features since
then.  He wrote plantmanytrees, morecurrencies, manualconvert, newagerating,
fastwagonsell, newrvcrash, stableindustry
@end table

@subheading Graphics and other Tools

@table @b
@item Michael Blunck
Michael designed and drew the new graphics distributed with the patch.

@item Jakub ``SHADOW-XIII'' G@'orecki
SHADOW-XIII wrote the TTDPatch Starter, a program to choose your switches and 
write the TTDPatch configuration
file and run either TTD or TTDPatch.  He also wrote the GRF Manager, which simplies
working with the new graphics.

@item Andr@'es Zs@"og@"on
Andr@'es wrote the TTDPatch Configurator, also a program that allows you to choose
the TTDPatch switches and write a configuration file, as well as run TTD and TTDPatch.
In addition, he wrote the GRF Wizard which simplifies working with GRFCodec.
@end table

@subheading Translations

The following people have translated TTDPatch:

@multitable @columnfractions 0.2 0.7
@item Language @tab Translator

@item Czech @tab Mirek Duda
@item Danish @tab Kenneth Vestergaard Schmidt (up to 1.6), Rune Baszkiewicz (from 2.0)
@item Dutch @tab Remon Pel (up to 1.6), Jan Willem van Dormolen (from 1.7)
@item English @tab Josef Drexler
@item Finnish @tab Vesku (up to 1.6)
@item French @tab R@'emi Denis Courmont (up to 1.6), Edo (from 1.8.1)
@item German @tab Josef Drexler
@item Hungarian @tab Gy@"orgy ``Saiyan'' M@"uller
@item Italian @tab Jack VanderCloud (up to 1.6), Lorenzo F. (from 1.8.1)
@item Norwegian @tab Hilanmo Terje (up to 1.6), Tor Inge Johannessen  (from 1.9)
@item Polish @tab Marek Majkowski, SHADOW-XIII and Marcin Grzegorczyk
@item Russian @tab Yuri Burawtsow
@item Spanish @tab John Bernal
@end multitable
