@c	vim: syntax=texinfo

@metanode @chapter,Usage,How to set up and use TTDPatch.
@c --------------------------

@metanode @section,Where to get it,The official homepage of TTDPatch and related sites.
@c --------------------------

The newest version of TTDPatch should always be available from the 
@uref{http://www.ttdpatch.net/, TTDPatch home page}.
@cindex downloading

@noindent If the page doesn't exist, it has probably moved.  
But even if or when it does, you should still be able to find it in the 
@uref{http://W.webring.com/hub?ring=ttweb&id=114&go, Transport Tycoon Webring}.

Because TTDPatch is distributed under the GPL, the source code is available too,
at @uref{http://www.ttdpatch.net/src/}.
@cindex source code
It can be compiled with free compilers, using NASM, OpenWatcom for the DOS version,
GCC and various other tools from the GNU development suite.

@metanode @section,Installation,How to install TTDPatch.
@c ------------------

@cindex installation

@itemize @bullet
@item Download the right version (DOS or Windows), see @ref{FAQ--Version}
@item Unzip it into your TTD directory
@item [Optional] Set up the new graphics, see @ref{New Graphics}
@item Run TTDPatch
@end itemize

To unzip the files you download, you can use @uref{http://www.winzip.com/,Winzip},
the @uref{http://www.info-zip.org/pub/infozip/,Info-Zip} unzip program,
PKZIP or any other program that knows how to handle @file{zip} files.  

Note that TTDPatch does not change any of TTD's files.
You can write-protect the TTD executable to be sure.
Instead, it will copy the old executable (either @file{ttdx.exe},
@file{tycoon.exe} or @file{gamegfx.exe})
to @file{ttdload(W).ovl}, and modify this copy only.
You can switch between TTDPatch and the regular TTD at any time, simply by
choosing which program you run.  @file{ttdpatch(W).exe} is for running with the
patch, and the regular @file{ttdx.exe}, @file{tycoon.exe} or @file{gamegfx.exe}
for when you want the original TTD.

However, savegames that are saved while certain switches are activated may be
incompatible with versions not running this patch.  This also applies to
scenarios created with the scenario editor.  Incompatible savegames may cause 
TTD to crash, so be careful when loading games saved with the patch into TTD.


@metanode @section,Upgrading to a newer version,What you need to do if you're upgrading TTDPatch from an earlier version.
@c -----------------

If you had a copy of TTDPatch before, and are now upgrading to a newer one, there
are a few things that you should pay attention to.

The first one is that TTDPatch may ask you to delete @file{ttdload.ovl}, because
it has become outdated.  This file will then be generated again the next time you
run TTDPatch.  It is generally a good idea to delete this file anyway.

The second thing is that you probably want access to the new options, but they are
not in your configuration file.  To do this, start TTDPatch with the following
command line:
@example
ttdpatch -W ttdpatch.cfg
@end example

Alternatively, put the line
@example
writecfg ttdpatch.cfg
@end example
as the last line of @file{ttdpatch.cfg}.

Both ways will tell TTDPatch to read your current configuration from @file{ttdpatch.cfg},
and write this configuration back, along with the new options.  Then you can edit
the new file, and change the options as you like.

@metanode @section,Running it,How to run TTDPatch.
@c ----------------

To start TTD with the patches enabled, simply run @file{ttdpatch.exe}.  At the
first start, it will copy the old executable to @file{ttdload.ovl}, patch it, and
then run it.  Additionally, it will create a configuration file if none exists
already.  These steps will be omitted after the first start.

You now need to have 9 MB of free memory to run TTD, because of the possibly
larger number of vehicles.  This is true even if you don't use the @option{morevehicles}
switch.  However, with the new @option{lowmemory} option, you can reduce this requirement
to 4 MB, at the expense of not being able to have as many vehicles or new
graphics.

If you are starting TTD from Windows 95, just change the shortcut command line
to run @file{ttdpatch.exe} instead of @file{tycoon.exe} or @file{ttdx.exe},
and append any of the options you would like to have.

For the DOS version, you can pass any parameters to TTD, just add them at
the end of the ttdpatch command line.  This will in most cases be the path to
the CD drive, if your TTD runs only with the CD in the drive.


@noindent Example:

@example
@t{D:\Games\TTD> @kbd{ttdpatch -av E:\}}
@end example

@noindent will run ttdpatch will all switches enabled, and tell TTD to
look for the CD in drive E:.  For an explanation of all switches and options,
please see @ref{Command Line}.  Alternatively, you can set the @t{CDPath} 
directive in the configuration file to point to your CD drive, with the line
@example
@t{CDPath E:\}
@end example
in your @file{ttdpatch.cfg} file.

@metanode @section,Windows Version,Differences between the DOS and Windows versions of TTD and TTDPatch.

@cindex DOS version
@cindex Windows version
Recently, a Windows version of TTD has been released as part of the Tycoon
Collection available from Hasbro.  Since version 1.7, TTDPatch supports this
Windows version too.

There are few differences between the DOS and Windows versions of TTDPatch, and
while this manual was written with the DOS version in mind, everything should work
the same in the Windows version.  The only differences are the file names:

@multitable @columnfractions .20 .25
@item DOS @tab Windows
@item @file{ttdx.exe} (or @file{tycoon.exe}) @tab @file{gamegfx.exe}
@item @file{ttdpatch.exe} @tab @file{ttdpatchW.exe}
@item @file{ttdload.ovl} @tab @file{ttdloadW.ovl}
@item @file{newgrf.cfg} @tab @file{newgrfW.cfg}
@item @file{ttdpatch.kbd} @tab @file{ttdpatchW.kbd}
@end multitable

@noindent The configuration file and options are the same for both versions, but
some switches work only in either the DOS or the Windows version.

In general, the files ending in a ``W'' are files for the Windows version, and
the files without the ``W'' are for the DOS version.

@metanode @section,Language Selection,How to choose TTDPatch's language.

TTDPatch supports a variety of languages.  Currently these languages are
available: Czech, Danish, Dutch, English, Finnish, French, German, 
Hungarian, Italian, Norwegian, Polish, Russian and Spanish.

TTDPatch will first try to automatically
determine your language by asking the operating system.  If you find that
this doesn't work as intended, there is another way, for example if you want
a different language than your operating system reports.

@cindex @t{LANG}, @t{LANGUAGE}
Set either of the environment variables @t{LANG} or @t{LANGUAGE} to
the language you want.  If you select a language that TTDPatch doesn't
support it will complain, but also tell you the list of languages it knows.

For example, you can put the following line in the batch file which runs TTD,
or even in @file{C:\autoexec.bat} if you like:

@example
SET LANG=dutch
@end example

@noindent This would select the dutch language for the output of TTDPatch.


@metanode @section,Configuration File,The file that tells TTDPatch what patches it should apply.
@c ----------------------------
@cindex configuration file
@cindex cfg
@cindex @file{ttdpatch.cfg}

The configuration file tells TTDPatch which of the patches you want to be
enabled, and how.  It is simply a list of the patches, followed by what you
want it to do with this switch.

If no configuration file is specified at the command line, that is, if
there is no @option{-C} option, TTDPatch will read the default @file{ttdpatch.cfg}.
You can specify several configuration files, and they will be read in the
order you give them, but if you want TTDPatch to read @file{ttdpatch.cfg}
@emph{and} your file, you have to specify @emph{both}.

To change the configuration, simply open the file in any text editor, like
Notepad under Windows or Edit under DOS.

The syntax of the configuration file is simple: all lines starting with a
letter define the value of an option, all others are ignored.  The line
defining the option should have one of the following formats:

@example
servint 16000
servint = 16000
@end example

@noindent You can add more spaces, or in the second case take them out.

There are three kinds of switches: on/off switches, switches with a value,
and switches with bit settings.

@table @b
@item On/off switches
@cindex on/off switches
For on/off switches (for example
@option{trainrefit}), you can set them to
any of @code{on, yes, y, 1} to turn them on, or @code{off, no, n, 0} to
turn them off.

@anchor{Switches with values}
@item Switches with values
@cindex Switches with values
@cindex value switches
Switches with values, for example @option{servint}, can be set to a value
within the allowable range, or any of the above on/off values.  If a switch
should have a value but doesn't, the value is set to the default for that
switch; if the given value is out of range, it is set to the nearest allowable value.  You can turn
a switch off by setting it to any of @code{off, no, n}, but not @t{0} (unless
@t{0} is not in the range for this particular switch).  For example,
@code{servint on} sets the new service interval to the default value of 16000 days,
@code{servint 240} sets it to 240 days, and @code{servint off} turns the servint
feature off.

@anchor{Bit Switches}
@item Bit switches
@cindex bit switches
@cindex switches with bit settings
Finally, switches with bit settings allow you to choose various settings of that switch.
An example is the `morebuildoptions' switch.  It has the following options, labelled (a) to (e):
@multitable @columnfractions .05 .06 .09 .7
@item @tab Bit @tab Value @tab Meaning
@item (a) @tab 0 @tab 1 @tab Tunnels may cross
@item (b) @tab 1 @tab 2 @tab Oil rigs and refineries may be built everywhere, not only near edges of map
@item (c) @tab 2 @tab 4 @tab Allow multiple industries of the same type in one city
@item (d) @tab 3 @tab 8 @tab Removal of statues, lighthouses and transmitters
@item (e) @tab 4 @tab 16 @tab Removal of industries
@end multitable

To find out how you specify the value for the `morebuildoptions' switch, you have two choices:
@itemize
@item Use the "#101001" notation.  Each number represents a bit, 1 meaning it is turned
on, 0 meaning it is turned off.  Note that it starts from the @emph{highest} bit.  For
morebuildoptions, it would be "#edcba" for the five options (e) down to (a).  For example, to
turn on (a), (d) and (e), you would use @code{morebuildoptions #11001}.

@item Add all the values you want, and use that for the option.  For example, for having
morebuildoptions bits (a), (d) and (e), you add their values: 1+8+16=25.  Therefore, you would
use @code{morebuildoptions 25}.

@end itemize

@end table

You can also have TTDPatch write a customised configuration file with the
@option{-W} switch.  This useful for example to create a configuration file
in your language, if it is supported.  To convert @file{ttdpatch.cfg},
simply run TTDPatch with

@example
ttdpatch -W ttdpatch.cfg
@end example

Alternatively, put
@example
writecfg ttdpatch.cfg
@end example
in your @file{ttdpatch.cfg}.

@noindent The result of this is that 
the configuration file will be in the selected language (see 
@ref{Language Selection}), 
and you can read and edit it easily.  It will also automatically add
options that were missing or misspelt in the original file.

Since 1.8, the Windows version of TTDPatch converts all comments in
the configuration file to the local Windows code page.  If that code
page does not support all characters used in the selected language,
parts of the text may look wrong.  To override this behavior,
set the environment variable @t{ACP} (``ANSI Code Page'') to the number
of the code page you want.  If you specify a code page that is not
supported by the Windows installation you're using, no conversion will
take place and thus comments will be written in the native DOS code
page of the selected language.

For example, to rewrite @file{ttdpatch.cfg} as @file{new.cfg} in Russian
using the Windows Cyryllic code page, run the following three commands
in order, from the command line:

@cindex @t{ACP}
@cindex code page
@example
SET LANG=russian
SET ACP=1251
ttdpatchw -W new.cfg
@end example

@noindent (A simpler way to do it in Windows is to put these commands in a
batch file and run it.)

The DOS version of TTDPatch does not perform any code page conversions.


@metanode @section,Command Line,How to specify the patches directly on the command line.
@c --------------------------

@cindex command line
@cindex options
@noindent The command line is an alternative way of selecting the patches. 
The format of the command line is

@example
TTDPatch [-C cfg-file] [options] [CD Path] [-W cfg-file]
@end example

The options can start with either a @option{-} (dash)
or @option{/} (slash), followed by the
list of options.  All options can have another @option{-} after them to
turn them off, and if there's an option that takes a parameter, the next option
will be used as that value.

Each option is given by either a single letter, or by a capital ``X'' or ``Y'' 
followed by
a letter, e.g. @t{-abcXaXbYc}.  Note that all switches are case sensitive, and
distinguish between upper case and lower case.
Therefore, @t{-g} and @t{-G} are different switches.

In addition to all the patch switches (see @ref{The Patches}), the following
options control operation of TTDPatch:

@table @code
@item -a
Turn on all patch switches except for ``morevehicles'' and ``experimentalfeatures''
@item -h
Show a brief help summarizing all available options.  Run 
@kbd{ttdpatch -h | more} if it scrolls by too fast.
@item -v
Before running TTD, display a brief summary of what switches are active
@item -C <file>
Select a different configuration file (see @ref{Configuration File})
@item -W <file>
Write current configuration to this file
@end table
@cindex @t{-a}
@cindex @t{-v}
@cindex @t{-h}
@cindex @t{-C}
@cindex @t{-W}
@cindex configuration file

If the @option{-C} option is given, the specified configuration file will be
read instead of the default @file{ttdpatch.cfg}.  You can use several
configuration files by having multiple @option{-C} switches, they will be
read in the order you supply them.

In addition, if you have given a CD Path, if will be passed to TTD and tell it where it
should go looking for the CD.  (This only applies to the DOS version.)

Some switches don't have associated short command line switches, for example the many switches that control 
town growth rate calculation (see @ref{New Town Growth Switches}).  However,
you can use a so-called `long switch', which is two dashes followed by the full
switch name, for example @code{--towngrowthratemin=50} or @code{--trainrefit on}.  This is
not as useful for the DOS version, which has a limit of 127 characters for the command
line, but the Windows version has no such limit (although the command interpreter @file{COMMAND.COM} does, 
so under @w{Windows 95/98/Me} you may have to use an external tool to specify many long switches).

And finally, after you have set all your switches the way you like them, you
can tell TTDPatch to write them to your own configuration file (or
@file{ttdpatch.cfg} for that matter) by using the @option{-W} switch.  With
this, TTDPatch will create a commented file that has all the switches set as
they are when the @option{-W} is encountered on the command line.

If you need a short reminder of all options, run @samp{ttdpatch -h} which will
show a short summary of all command line switches.  If it's too much to fit
on your screen, try @samp{ttdpatch -h|more}.

@noindent A few examples to explain how the command line works:

@example
ttdpatch -an- -i 90 -v
@end example
@noindent will start TTDPatch will all switches enabled (@option{a}) except for the
new non-stop handling (@option{n-}) which is turned off.  The default
service interval is set to 90 days (@option{-i 90}), and before running TTD,
all switches will be displayed to verify they are the way you want (@option{-v}).

@example
ttdpatch -C mycfg.cfg
@end example
@noindent will use the file @file{mycfg.cfg} instead of the default
@file{ttdpatch.cfg} to set the patches.

@example
ttdpatch -C mycfg.cfg -f- -W mycfg.cfg
@end example
@noindent This will read @file{mycfg.cfg}, disable train refitting, and write the new
configuration back to @file{mycfg.cfg} and then run TTD.

@metanode @section,Multiplayer Games,What to look out for when playing multiplayer games with TTDPatch.
@c -------------------------

@cindex multiplayer games
One of the more fun aspects of TTD is playing a multiplayer game against an actual
human opponent, which is a nice change from the brain-damaged computer players.  Now
the question is, how does this work with TTDPatch?

For the most part, TTDPatch works well in network games if you pay attention to
these issues:
@itemize @bullet
@item Both versions of TTDPatch must be identical.
@item Both configurations of TTDPatch must be identical
@item Some options of TTDPatch may be unsafe in multiplayer games
@item Multiplayer mode is very unstable under Windows 2000/XP
@end itemize

In practice, it's easiest to set up TTDPatch on one of the computers, and then copy
both the @file{ttdpatch.exe} and @file{ttdpatch.cfg} files 
(and also @file{newgrf.cfg} and all the new @file{.grf} files, if you use them) to the other computer
without changing them.  If both copies aren't exactly the same, it's very likely that
the multiplayer game will become desynchronised, and basically split into two 
separate games that are not linked anymore (and playing a desynchronised game will very likely
lead to a crash).  There are few switches (listed below) that may work even if they're not set 
identically on each computer, though.

Note that under Windows 2000/XP, the game may become desynchronized much
faster than under other operating systems.  The cause of this is not clear,
and therefore it is difficult to fix.  However, the 
@uref{http://www.ttdpatch.net/tools.html, Tools page on the TTDPatch site}
has a program called @file{sv2flip} which may help in resynchronizing savegames.

Additionally, it is impossible to use most of the patches that require the @kbd{Ctrl} key,
because this key cannot be transmitted via the networking protocol TTD uses,
and therefore two different things would happen on the two computers.  Therefore 
TTDPatch should not even recognize the @kbd{Ctrl} key in multiplayer mode (and if it does, it's a bug). 
The only exception to this is using the @kbd{Ctrl} key for selecting the station size when placing a new
station.

Here is tentative list of which switches do, and which do not work in multiplayer, supplied by Marcin Grzegorczyk.
It is based mostly on a crude analysis of the internal working of TTD's multiplayer mode (and a few tests), 
but since I've never tried it
myself I can't vouch for the correctness.  Peruse at your own risk@dots{}

@table @asis
@item Switches that do not affect the way TTD works, and are therefore 100% safe:
forcerebuildovl,
verbose

@item Switches that @emph{might} work right even if they're set differently on each machine
(they only apply to the local player):
diskmenu,
enhancegui,
errorpopuptime,
keepsmallairport,
morecurrencies,
morehotkeys,
morenews,
moretownstats,
moveerrorpopup,
showfulldate,
showspeed,
signalsontrafficside

@item Switches that @emph{should} work well, as long as they're set identically on both machines:
autorenew,
bribe,
bridgespeedlimits,
buildoncoasts,
buildonslopes,
cheatscost,
curves,
disasters,
electrifiedrailway,
enginespersist,
eternalgame,
extradynamite,
forceautorenew,
fullloadany,
generalfixes,
gradualloading,
largertowns,
largestations,
loadallgraphics,
loadtime,
longbridges,
lowmemory,
mammothtrains,
miscmods,
moreairports,
morevehicles,
mountains,
newagerating,
newplanes,
newrvcrash,
newrvs,
newships,
newtrains,
noinflation,
nonstop,
officefood,
planecrashcontrol,
planes,
planespeed,
presignals,
roadvehs,
rvqueueing,
saveoptionaldata,
selectgoods,
semaphores,
servint,
ships,
signal1waittime,
signal2waittime,
spread,
stableindustry,
startyear,
subsidiaries,
tgr*,
towngrowth*,
townminpopulation*,
trains,
unifiedmaglev,
win2k

@item Switches that may or may not work right, it's difficult to tell since they're complicated:
aiboost,
experimentalfeatures,
extpresignals,
feederservice,
gotodepot,
manualconvert,
morebuildoptions,
multihead,
plantmanytrees,
signcheats,
tracktypecostdiff,
trainrefit

@item Switches that do not work (because of the lack of the @kbd{Ctrl} key) and should have no effect:
debtmax,
fastwagonsell

@end table

Marcin was not able to test the above thoroughly, some switches may still 
cause crashes or loss of synchronization.  Also, some switches offer multiple features, 
of which one may work right while another doesn't.  All feedback
welcome, please submit corrections or additions if you can!

