@c	vim: syntax=texinfo

@metanode @chapter,The Patches,A detailed description and explanation of each patch.
@c ------------------------

@cindex switches
@cindex patches
This chapter contains a detailed description of each patch.  At the beginning of
each section is a line with the configuration file directive for that switch, 
followed by the corresponding command line option.


@metanode @section,Train Refitting,Enable the refitting of trains in depots
@c ---------------------

@switch{trainrefit, -f}
@cindex refitting

Since a few of the train engines come with a passenger or mail compartment,
they were not very useful for other types of cargo because the ``Full Load''
switch could not be used.  This has changed now with the @t{@w{fullloadany}}
switch, but even so, train refitting may still make sense.

By enabling Train Refitting, you can now refit those engines just like planes
to carry whatever cargo you choose.  Only mail and oil are not an option yet,
just like with the planes.  (This might change in the future).

@cindex reverse train
If enabled, it replaces the ``Reverse Train'' button with a ``Refit Train''
button whenever the train window is opened while the train is in a depot, but
only for those engines that really have a cargo capacity.  For all others, there
is no change.  In order to reverse the direction of a train instead of refitting 
it, just open the window while the train is not in a
depot, where the direction cannot be reversed anyway.  The status of this
button does not change until the window is closed and opened again, even
if the train leaves the depot.

Refitting is permanent, and stays even after the option is disabled, until the
engine is sold or refitted again.

@putimage{trnrefit, 6in}

@metanode @section,New Default Service Interval,Set default service interval for new engines to the given number of days.
@c ----------------------------------

@switch{servint, -i}
@cindex service interval

If you think that the train behaviour is annoying when it comes to service,
because they keep going the wrong way looking for a depot,
just set ``Vehicle Breakdowns'' to ``None'' in the difficulty settings in TTD, 
and enable this option.  This will set
the default service interval to 50 years, and no train will ever try to enter
a depot again.  You might also want to have a look at the @t{@w{Cht: ServInt}}
sign cheat (see @ref{Sign Cheats}).

You can give a different number to set all default intervals to 90 days for
example, if you'd rather have them go to the depot more often.

Note that this only works for new engines that are bought while the switch is
enabled.  Use the sign cheat to modify already existing engines.

An alternative solution is to use the @option{gotodepot} switch; see @ref{Go To Depot}.


@metanode @section,New Non-stop Handling,Trains do not stop at stations where ``non-stop'' is selected
@c ---------------------------

@switch{nonstop, -n}

@cindex way points
@cindex checkpoints
@cindex non-stop command
In order to get around the problem of trains not finding their correct routes
in an elaborate network,
it is useful to give them various ``way points'' or ``checkpoints'' along the
route.  These way points are dummy 1x1 or 2x1 stations that are then
put on the train's schedule.
That way you can force a train to take a certain path, when it would normally
take a different, probably longer route.

The disadvantage is that normally these checkpoints have to be as long
as the train to be efficient,
and the train stops at them, which introduces an unnecessary delay.

By using this switch, you can now include these checkpoints in the route, and
set them to non-stop.  That way, the train will travel to them, but never stop
or even just slow down,
and will instead continue at its full speed.  This even works if the checkpoint is
only a single square large.

All stations without ``non-stop'' will behave as if they had the original
``non-stop'' set, i.e.  the train will stop only at stations on its command list
and none it encounters along the way.

This will apply for all trains, so do not use this if you have many routes
which make use of the ``non-stop'' flag, because you will have to remove that
flag from all those trains, or if you want your trains to stop at
intermediate stations as well and don't want to change all the commands.

Note that there are two sign cheats, @t{@w{Cht: AllNonStop}} and
@t{@w{Cht: NoNonStop}} which can be used to modify the schedules of all your
trains if you decide to start (or stop) using this switch.

With this switch, the regular TTD title screen will break, because the monorail
train does not stop at two dummy stations on either side of the road.  As a result,
the road vehicles won't stop in time and there will be collisions.  To fix this,
you can download an improved title screen from the Tools page of the TTDPatch website.

@putimage{nonstop, 4in}

@metanode @section,Sign Cheats,Enable the sign cheats.
@c -----------------

@switch{signcheats, -s}
@switch{cheatscost, -Xo}

@cindex @t{Cht: <cheat>}
Sign cheats are a number of new in-game cheats which are activated by placing a sign
and naming it @t{@w{Cht: <name of the cheat> <parameters>}}.  If 
the cheat was successful, the
sign name will show a tick mark at the end, otherwise it will show an X mark.  Instead of
the colon `:' you may also use a semi-colon `;' to accomodate players of the French DOS
version which cannot generate a colon because of the keyboard mapping.

For a verbose description of the sign cheats, please see @ref{Sign Cheats (detailed)}.

Normally, the sign cheats do not cost anything,
and can be used at any time.  With
the @t{@w{cheatscost}} option however, some of the cheats (at this time, only 
``Tracks'', ``Renew'' and ``PlantTrees'') 
will cost the appropriate amount of money.  In that case, you
can append a question mark to the cheat, in order to see how much it 
will cost before actually using the sign cheat. For example
@t{@w{Cht: Tracks 2 ?}} will tell you how much it would cost to convert
your tracks to Maglev technology.

Once a sign has been placed and activated, i.e. if it has the tick mark or X,
you can immediately remove or rename it again, the cheat will still remain
active.

@cindex keyboard
A note to international players:
The English DOS versions of TTD use a @kbd{QWERTY} keyboard even
if your local keyboard layout is different.  If you have trouble
finding the `@kbd{:}' key, it's to the right of the @kbd{L} key.  Press shift
and the key right to the @kbd{L}, and there you go!

It may also swap some keys, depending on your local layout.  If many cases,
@kbd{y} and @kbd{z} will be
swapped.  So please check if what you've typed is what appears in the sign
name.

@putimage{signcht, 2.5in}

@metanode @section,Increased Number of Vehicles,Allow more vehicles in the game.
@c ----------------------------------

@switch{morevehicles, -x}
@c
@c @switch{reducedsave, -o}
@cindex vehicles

In many games, it is easy to reach the maximum number of vehicles at 850.  And
160 of these are reserved for other animated objects and steam or smoke plumes,
so that the remaining 690 vehicles have to be
shared by all human and computer players.  And planes even count twice,
because they carry both passengers and mail.  (Helicopters count as three 
vehicles, because their rotor is also a vehicle@dots{})   This means that it is easy to
run out of vehicles in games with many opponents.

This switch enables you to increase that maximum number, to more than 40,000
if you like.  If you consider that there are only 65,536 squares in the map,
it's obvious that this is more than enough.  Vehicle memory is allocated in
blocks of 850, and you specify the number of these blocks as a parameter to
morevehicles.  For example, @t{@w{morevehicles 2}} allows you to have 
2 times 690 vehicles, or 1380 vehicles, plus 320 reserved vehicles.
Giving a factor of ``1'' is the same
as not specifying this switch at all, and the maximum factor you can give is
40.

It is usually best to leave this switch set to a value @emph{as small as possible}.
Don't set it to 40 right away!  Only increase the factor when you actually
run out of vehicles.  The reason for this is
that this switch is not easily reversible, as opposed to all the other
switches, and it will also slow down the game significantly if you use factors
larger than 10.

Once a game has been saved with this switch set to a particular
number, it should only be loaded with this switch set to the same (or a higher)
number.  Games saved with an
increased number of vehicles will also get a slightly different filename.
Normally, your savegames are of the form @file{TRT00.SV1}, with morevehicles
set they will instead be @file{TRP00.SV1}.  This will prevent them from being
loaded by plain, unpatched TTD which would crash anyway.

It is always possible to load a smaller number of vehicles, so your old
savegames can still be loaded.  The program will simply fill the array with
unused slots.

However, if you load a game that had the morevehicles swtich set to a larger number
than it is set to now, the patch may have to remove some vehicles in order to
load the game.
In that case, you will get a warning message that tells you how many vehicles
had to be removed.  The game will
be paused immediately, so that you have a chance to check the game for missing 
vehicles before resuming to play.

Note that if any special objects or special vehicles were removed, you must check
your game, whether it had a zeppelin crashed on an airport, or a UFO landed and waiting
for a military plane or helicopter.  In that case, the zeppelin or the military vehicles
may have been removed, which leaves your airport blocked forever, and the UFO will
never get shot down.  Otherwise, the removal of special objects is generally safe,
and means you will lose some steam plumes, diesel smokes or electric sparks, as well
as the steam coming out of some power plants.  In that case, you might want to remove
and replace the power plant in the scenario editor.

All in all, this switch is pretty powerful, but also somewhat tricky to use.
Experiment at your own risk, and keep backup copies of the original games if
they are important to you.

@metanode @section,New Curve and Mountain Handling,Make trains faster on mountains and in curves with realistic acceleration.
@c -------------------------------------

@switch{curves, -c}
@switch{mountains, -m}
@cindex realistic acceleration

TTD does not take into account the differences in the various train
technologies.  For example, the real Maglev trains do not have the same
problems in curves and on hills as the traditional trains do; they can have
a much smaller curve radius or pass the same curve at a much higher speed.
When travelling across hills, 
they can have more power than on flat land, so that their speed
decrease is often negligible.
This is why I created this switch to correct that.  In fact,
this is why I started making TTDPatch, because otherwise you need too many
bridges and tunnels
and other normally unnecessary stuff to create an efficient network.

It also circumvents another bug, namely that there can be no signals inside
tunnels.  This makes larger tunnels rather useless, because it interrupts the
flow of trains that have to wait until a train has completely left a tunnel.
Thus, one has to either level the mountain (if there's no way around) which is
ugly and costly, or lay the tracks on top of the mountain, which considerably
slows down the trains as well.  Until now that is, because now you can set it
so that trains have no disadvantage when going over the mountain.

This switch also allows you to enable realistic acceleration of trains.  Regular
TTD uses a constant acceleration of trains, which is not realistic.  In
reality, acceleration of trains decreases with their speed.  This switch
can make trains use a more realistic model of acceleration.  For more info on
how it works, please see @ref{Realistic Acceleration}.

The @option{mountain} and @option{curve} switches allow to select which
type of trains will use a higher
speed on mountains and in curves, and which ones use realistic acceleration.  
There are two steps of acceleration; the
first one being simply higher speed and the second one doesn't slow down the
train at all.  This can be especially useful if you have many ``clover-leaf''
type crossings, where you have to have a few bridges.

The argument to @option{mountain} and @option{curve} is a four-digit number,
one digit for each of the four land-based vehicle types: railroad, monorail, maglev and
road vehicles. For each, you specify one digit from 0 to 3 with the following meanings: 

@itemize @bullet
@item 0 means ``normal'', i.e. the regular TTD behaviour
@item 1 means ``faster'', the vehicles doesn't slow down as much on mountains and curves
@item 2 means ``full speed'', the vehicles move without slowing down at all
@item 3 means ``realistic'', using a more realistic model for acceleration (see @ref{Realistic Acceleration}).
@end itemize

For example, you might specify @code{mountains 3320}, which means: railroad 
and monorail are realistic (3), maglev is ``full speed'' (2) and road vehicles 
are normal (0).

If the @option{electrifiedrailway} switch is on (see @ref{Electrified Railways}), 
the meaning of the argument slightly changes: the second digit controls 
electrified railroad instead of monorail, and the third digit controls the combined monorail/maglev system.

For curves, setting 3 (``realistic'') is implemented by limiting the speed of
trains in a curve.  It's slower the more curving segments the train is on currently.
For road vehicles, the speed is limited to 75% of the top speed.

Note that if you're using realistic train acceleration, it is possible to make a
train that is too heavy.  If the engine is not powerful enough to overcome the
initial friction, the train will not be able to leave the depot.  What's even worse is
that the engine may be powerful enough for an empty train, but as soon as the train
is full, the increased weight may mean that it'll be unable to leave the station.

In addition, it may happen that a train gets stuck on a mountain, again because the
engine is not powerful to pull the train's weight uphill.  If this happens, you
will either have to remove some waggons, or add more heads to the train using the
multihead feature.  Note that if the engine is too weak to move the train at all,
it will still be able to move exceptionally slowly.  This will allow you to send it
to a depot to rearrange the train even if it really shouldn't be able to move at all.

Finally, note that realistic acceleration assumes trains propelled by wheels.  That
means it's not appropriate for maglev systems, for which you should use either the
``faster'' or ``fastest'' settings.

@metanode @section,More consists,Allow more than 80 trains, planes, road vehicles and ships.
@c ----------------------

@c multiple switches on one line don't work with @switch
@switch{planes, -p}
@switch{roadvehs, -r}
@switch{ships, -b}
@switch{trains, -t}
@cindex vehicles
@cindex number of vehicles
@cindex more vehicles


The total number of trains and road vehicles allowed per company in one
game is arbitrarily limited to 80, ships to 50 and planes to 40.  These limits
are ``soft'' limits, meaning that they are enforced by counting the trains and
making sure you don't have too many.
The ``hard'' limit is 255-15=240, which cannot be exceeded because of the way
consists are numbered.  The soft limit is probably only there for performance
reasons, or maybe a silly design decision.

With this switch, each company can have up to 240 trains, planes, ships
and road vehicles of its own.

Note that the total number of schedule orders is not increased, nor is the total
number of customised consist names.  There can in total only be 5000 orders,
which in the default configuration translates to 20 orders per consist.
However, if you set all limits to 240, you can on average only have about 5
orders per consist, including the ``End of orders'' markers.
An individual consist can have up to 25, but then some have
to have less than 5.  The game will not allow to have more, so that you might
run out of orders instead of trains.

The same limit applies to the consist names, but it is not as important, unless you can't
live without your trains all having their own name.  The maximum total number of custom strings
is 500; this includes manager's name, company name, custom vehicle type names, signs etc.

This switch is reversible, and only applies to new vehicles.  If you turn it
off while you have 150 trains, you will still be able to keep those, but you
won't be able to buy any new ones.

Note that on the command line you can specify the values for all switches
at once using @t{@w{-trpb 240}} for example.

@metanode @section,Larger Station Spread,Allow a station complex to occupy a larger area.
@c ---------------------

@switch{spread, -e}

Use this to get rid of that pesky ``Station too spread out'' message.  Usually
the maximum distance between any part of a station is 11 squares, which can be
too small if you try to combine a large airport with a large train station
(especially an extended one).  A more useful number is 20 for example, and the
upper limit is 255, which is the size of the world, to make it work
just like in the original TT.

This also makes it possible to have several detached station facilities, by
``walking'' them away from the main terminal.  For example, you could build
a train station, and attach a bus station.  Then, you attach a truck loading bay
to the bus station, away from the train station.  When you now remove the
bus station, your station will be in two separate pieces.  The next step
is to place the bus station on the opposite side of the truck loading bay, and
repeat this process for as long as you like.  Then, you can build an airport
that belongs to the same station as the train terminal, but is in fact many
squares away from it.

@metanode @section,Longer Stations/More Platforms,Makes it possible to build train stations with a maximum size of 7x7
@c ------------------------

@switch{largestations, -l}
@cindex more station platforms

When you use this, you don't have to bulldoze stations anymore to add extra
tracks.  Just select the same platform length, move your cursor with 
the new platforms next to
the old station, and place them.  That way you can even get up to 7 platforms.

The length can also be increased, to up to 7 squares length, using the same
process, but choose the same number of platforms and the additional length, to
get platforms up to 7 squares long.

Note that you should also turn on the @ref{Enhanced Graphical User Interface}
feature to be able to directly select longer and more platforms.  
Without the enhanced GUI, you can have a full size station of 7x7 squares by
holding down the @kbd{Ctrl} key when clicking on the number of platforms or
their length.  Note that it @emph{looks} like the wrong button has been
pressed, but that's because larger numbers can't be displayed without the enhanced GUI.
Simply look at the station's
footprint before you place it to make sure that it is the desired size.

Because the added parts will look as if they were placed alone, the station
design is now up to you.  You can have a two-platform station that looks like two
one-platform stations, or alternate roofed and non-roofed sections, if you
like that.  Just alternate between adding 1 and 2 platforms to the station to
get this.

And most importantly, this allows you to have different kinds of trains in one
station.  Just add a platform of a different type to have railroad, monorail
and maglev platforms in a single station.

Note that if either the platform length is different, or the total number of
tracks would be greater than 7, or the position doesn't match then you will see
the old message ``Too close to train station'', not a more appropriate message.

@putimage{multits, 3in}

@metanode @section,New load/unload time calculation,A more realistic calculation of load/unload time.
@c --------------------------------------

@switch{loadtime, -q}

(Note that this switch has been mostly superceded by the gradual loading feature, 
see @ref{Gradual Loading}.)

In the original algorithm used to calculate how much time a trains spends in
getting loaded/unloaded, there are two major bugs.

First, while loading time depends only on the @emph{amount} of cargo, unloading
depends on the @emph{type} of cargo as well.  Passengers will be unloaded
instantly, while valuables will take forever.  This does not make sense, it
must be a bug.

Second, this time is multiplied by the number of cars sticking out of the
station.  If there are four cars sticking out, you'd have to wait five times as
long, which doesn't make any sense either.

In this improved calculation, unloading time is again based on the amount of
cargo and takes the same time as loading it.  The bigger change though, is
that the program assumes that for example a length four station can serve up
to eight cars at the same time.  This would mean that the time it takes to
load/unload two cars is the same as for four or eight cars.  This makes sense,
because why would you want to build a large station if it can't effectively
handle more than one car at the same time?

Also, the problem with cars sticking out is alleviated in two ways.  The
reasonable assumption behind them is the following: the train enters the
station and gets as many cars loaded/unloaded as possible in one go.
The engine will in most cases not be a part of this and can be ignored because it
doesn't carry any cargo.
If not all cars were able to fit in the station, the train will move the next
set of cars in and have those unloaded.  This will continue until the train
is done.

A short summary:

@itemize @bullet

@item Engines don't count if they don't carry any cargo
@item First part of cargo gets loaded, and the time is independent of number of
cars involved
@item If there are 
more cars than station can handle, the second set is loaded, and takes
the same time
@item If there are still some cars left, those get loaded, and so on until
everything is loaded.
@end itemize

To make it even clearer, here is a list for a length three station which
can handle up to six cars at the same time.  The engine is assumed not to be
a cargo-carrying engine:

@multitable @columnfractions .15 .7

@item Train length
@tab Load/unload time (arbitrary units)

@item Eng.+1 car  @tab 1
@item Eng.+5 cars @tab 1
@item Eng.+6 cars @tab 1
@item Eng.+7 cars @tab 2
@item Eng.+11 cars @tab 2
@item Eng.+12 cars @tab 2
@item Eng.+13 cars @tab 3
@item Eng.+18 cars @tab 3
@item Eng.+19 cars @tab 4
@item and so on@dots{}
@end multitable

I find this to be a very reasonable calculation that makes sense and is
realistic.  If you don't, then you can always turn it off.

The unit time depends only on the average amount of cargo in each car.
For example, if all cars are only half full (on average), it will only take
half as much time.

However, the time it takes now for one single car is longer than
previously.  This switch was not meant to speed up loading/unloading but
rather make it more sensible.  ``1'' load time here is approximately the time it
previously took to load six to eight cars.

@metanode @section,Mammoth Trains,Attach up to 126 wagons to a train.
@c --------------------

@switch{mammothtrains, -z}

If you use this switch, there is no real limit to how many cars your trains
can have.  Well, there is a limit, but 127 cars is just so much that it won't
matter.  Really.  Trust me.  Especially since it would take ages to buy such
a train@dots{}

This is meant to be able to fully use length five (or seven) stations
with the above
switch.  Now you can have a double-headed engine @emph{and} ten cars and still load
it without penalty.  If you intend to buy really long trains, you should really
enable the improved load time calculation or the train will be in the station
@emph{forever}.

You will still only see a limited number of cars in the depot.  With @option{enhancegui}
(@ref{Enhanced Graphical User Interface}) you'll see 14 or 18 wagons and
engines, depending on the setting.  Without @option{enhancegui}, you'll see ten wagons
as usual.  This means that if you want to rearrange
your train, you'll have to work in reverse, adding cars at the front of the
trains.

The depot also behaves slightly different, because when a new train only used
to attach at most nine cars to it, now it will take all that are available
(up to 127).  This means that you shouldn't try to upgrade two trains at the
same time, because one of them might get all the cars which could cause a headache.

Another thing is that this can make the layout process of a station very
challenging.  Even though you may not get a penalty (or at least not as much)
for a bit of train sticking out of the station, the cars will still be there
and block tracks and cause signals to remain red.  If you don't leave enough
space at the entrance of a station, there will be a major traffic jam.

And, most importantly, if you have a @emph{really} long train, try not to make it
go atop any mountains.  Although, surprisingly, even a fully loaded 126 car
train, at a total weight of around 7000 tons, made it.  It was only moving
with a few MPH, but it's still amazing (and not very realistic)
that it made it eventually.
However, if you're using realistic train acceleration, it is possible to make a
train that is too heavy and will take ages to move (see @ref{New Curve and Mountain Handling}).

So, I suggest you don't go over about 20 cars or so, except maybe for a bit of
fun.  You can even make a train go through itself without crashing@dots{}

@putimage{mammoth, 5in}

@metanode @section,Pre-signals,An improved signalling technique for very efficient networks and stations
@c ------------------------------

@switch{presignals, -w}
@switch{extpresignals, -Xw}  
@cindex signals

These switches introduce a new type of signal to TTD, the ``pre-signal.''  This
signal is in some sense similar to an advance signal, but it's not quite the same.
For a detailed description of how pre-signals work and in what cases they are
useful, please see @ref{Pre-signals (detailed)}.

Note that you need to load @file{signals.grf} to be able to distinguish pre-signals
from regular signals.  See @ref{New Graphics} for more details.

The idea of pre-signals is quite simple: 
a pre-signal shows a green light if, and only if, one of
the exit signals from the block behind it shows a green light.  This means that
trains will only enter the pre-signal block if there is a green exit.  As a result,
the block will only be entered for short times and trains will leave it immediately,
allowing for a very efficient layout.  This is particularly useful for station 
entrances, but can also be applied in other cases.

@cindex automatic pre-signals
@cindex manual pre-signals
The @t{@w{presignals}} switch activates @emph{automatic} pre-signal configurations.
Using this options, your signals will be converted to pre-signals and pre-signal
exits whenever a train enters a block that qualifies as an automatic pre-signal
block.  For a definition of what this needs to look like, please see
@ref{Pre-signals (detailed)}.  Whenever you modify the block (i.e. add rails,
remove them, etc.), the automatic signals will revert to regular signals.  Note
that in no case will your manual settings (see below) be modified.

With @t{@w{extpresignals}}, you will be able to @emph{manually} modify each signal, and force
it to be either a pre-signal or a plain signal, no matter whether it is in a
valid automatic pre-signal block.  The way to change them is the same as switching
between one-way and two-way signals, but you hold down the @kbd{Ctrl} key while
doing so.  That is, you select the ``buy signal'' option from the railway menu,
press the @kbd{Ctrl} key, and click on the signal you want to change.  Its
appearance should change as a result, and you can verify the setting by using
the query tool.

You can also remove your manual selection by choosing ``buy signal'' and the
bulldozer, and then clicking on the signal while holding @kbd{Ctrl}.  In other
words, you do as if you would remove a signal from the track, but with
the @kbd{Ctrl} key pressed.

You can also specify both options, in which case you will get automatic signals
but can override them using the manual selection.

Please read @ref{Pre-signals (detailed)} for a more detailed description
of how pre-signals work and what types of setups are useful.

@metanode @section,Turn off inflation,All prices remain at the current level, applies to both costs and income.
@c -------------------------

@switch{noinflation, -I}
@cindex inflation

This switch turns off inflation.  However, it only works from the point it
was turned on into the future, and doesn't undo any previous inflation.
Prices stay at their current amount, but they won't increase anymore.  This
affects everything, income, purchases and maintenance/running costs,
and for all players too.

Use this if you frequently have too much money, because without inflation
you'll get much less money.

@ignore
@c not quite true, maximum loan increases with inflation!
Another benefit is that often computer players starting late will have difficulties
starting their businesses because of inflation.  A single engine will often cost
more than they can get credit, and they will never be able to build anything as a
result.  Using this switch, prices stay the same and the competition
will always be able to get started.
@end ignore

Note that you still pay the same amount of interest, so now interest is much
more important than if inflation is turned on.


@metanode @section,Faster Debt Management,Borrow or repay the maximum amount of debt with a single mouse click.
@c -------------------------------------

@switch{debtmax, -L}

When borrowing or repaying a loan, you can hold down the @kbd{Ctrl} key to
borrow/repay the maximum amount possible, as opposed to having to click the
button 1001 times.
This is only limited by the amount of cash you have or the maximum loan
possible.

@metanode @section,Persistent Engines,Keep active engines in the purchase list.
@c -------------------------

@switch{enginespersist, -P}
@cindex persistent engines
@cindex purchase list

There are some problems with engines becoming obsolete.  For example, there are
no more helicopters available after about 2030 so heliports become obsolete too, or you
might want to have a particular engine even though there are newer ones, maybe
because it is relatively cheap but sufficient for a certain purpose.

Or perhaps you want to be able to buy steam engines in 2000, which would cruise along
scenic mountain ranges@dots{} (thanks to Wolfgang Preiss for that idea!)

What this patch does is not to let any engines in use become obsolete.  Any
engine that exists in the game can always be purchased.  
With this and @t{@w{Cht: Year}}, you can basically continue a savegame playing forever.

Also, the reliability remains at the peak, with the reasonable assumption that
if you still have it, you'll also have some engineers who know how to repair
it, right?
An engine doesn't just get less reliable because it has been designed a
hundred years ago.  It might not be up to par in all the specifications, but
why should it suddenly start to deteriorate even if you just bought it?

Only after the last of its kind have been sold will it start to deteriorate,
and eventually disappear, because nobody knows how to build and
properly repair them
anymore.  If you really want to hang on to some engine, make sure you
always have one in stock, maybe in a depot somewhere.  It just needs to
exist, it doesn't have to run at all.

This patch will also re-enable the purchases of engines that you still have
but can't buy anymore.


@metanode @section,Full load for any type of cargo,The ``full load'' will be satisfied for any cargo type.
@c --------------------------------------

@switch{fullloadany, -F}

Basically fixing the same problem as the train refit option does, this makes full
load behave a bit differently.  Instead of waiting for every car to be full,
now if there's any type of cargo that's full will mean that
the train leaves the station.

So, if you have a train that transports passengers, mail and valuables, you
can set it to full load and it will leave when any of those reach their
maximum
capacities.  This also works for planes, so that they leave when either mail
or passenger compartments are full.

However, it is no longer possible to enforce a complete full load for mixed
cargo trains.

@metanode @section,Selectable station cargo,Choose what type of cargo should appear at a station.
@c -------------------------------

@switch{selectgoods, -G}

Sometimes you may want to build two stations at a busy factory, one for
deliveries of steel etc.@: and one to pick up the goods.  The problem is that
normally goods will appear at both of the stations, making this setup
rather useless.

With this patch, no goods will appear until a carrier for that particular
type of cargo has arrived.

Think of the factory manager being very mistrusting.  He won't send any cargo
to your station until he's sure it'll be picked up, because he's afraid that
it might spoil.  This means that you have to prove your capabilities
by showing him your carrier.

So, if you just make sure that no goods trains ever enter your delivery
station, you'll never see any goods there, and you won't get bad ratings for
not picking them up.  This is easier to do
with the new non-stop handling, because
that way no train will stop at the station if it isn't on the schedule.  On
the other hand, the pickup station will only ever see goods, even if
there's a coal mine nearby, which might have its own station.

However, if only a single train tries to pick up goods at the delivery, or
coal at the goods station, they'll continue to appear forever, so be careful.
The only way to reset this is by using the @t{@w{Cht: ResetStation}} cheat.

@metanode @section,Office towers accept food,In the arctic and tropical climates, office towers will accept food.
@c --------------------------------

@switch{officefood, -O}

In the tropic and arctic climates, the office towers by default accept
passengers, mail and goods.  This sometimes prevents a city from growing
further, because it doesn't accept food at all.

With this switch, all the office towers accept an amount of food that is
calculated by (passengers+goods)/4, rounded down.  So an office tower
accepting 4/8 passengers and 1/8 goods would accept 1/8 food too.

Note that this doesn't show up in the query tool, but it is taken into
account when determining what a station will accept.


@metanode @section,Extra Dynamite,Allow the removal of more city roads and bridges.
@c --------------------------------

@switch{extradynamite, -D}
@cindex remove roads, bridges, tunnels, statues
@cindex bulldoze roads, bridges, tunnels, statues
@cindex dynamite
@cindex bridge removal
@cindex tunnel removal
@cindex statue removal

This switch makes your dynamite more powerful.  With it, you can remove more
things from the map:

@itemize
@item All of the city roads, even those that the city normally forbids you to destroy
@item City bridges, if your rating is at least ``excellent''
@item Bridges and tunnels owned by nobody (which happens when
they are built in the scenario editor)
@item Your company statues
@end itemize

The ``forbidden'' roads are the ones that connect to more than one other piece
of road, i.e. the middle piece in a longer street or intersections. You can
also remove city bridges as well as bridges and tunnels owned by nobody else.

You can remove the forbidden roads if your rating is at least ``mediocre'', 
otherwise the city will refuse to let you bring dynamite anywhere near the roads.  

Of course, going against the local authorities' wishes does not exactly endear you to
them.  In fact, your rating will go down by an amount equivalent to the
removal of a few trees if you destroy a road that is not an end piece, and by even more if you destroy a city bridge.  So you
should only do this if you must, and try to remove as few forbidden roads as possible
by carefully planning ahead what you want to tear down.

@metanode @section,Keep Small Airports,It will always be possible to build small airports.
@c --------------------------------

@switch{keepsmallairport, -k}
@cindex small airports

With this option, you can always build small airports, even if you don't
have any planes that can land there anymore.  But at least helicopters can
land safely, and it can hold more helicopters than a heliport, as well as being
able to service them in the hangar.

Computer players do not get this benefit, because they aren't smart enough to use
it properly.  They'd build large planes and try to land them on small airports,
causing an untold number of crashes.  This option only applies to human players.

Note: In versions of TTDPatch earlier than 2.0 this option affected computer players 
as well as human players.  In the games saved with those versions, computer players 
will retain the ability to build small airports after 1960 until the end of a month,
or forever if the year is already 2050 or later.

@metanode @section,Long Bridges,Set the maximum length of a bridge to 127 squares.
@c --------------------------------

@switch{longbridges, -B}
@cindex bridges

With this switch, it is possible to build bridges up to 127 squares long.
At a steep price of course.  This is possible for all bridges that could
previously be built with a maximum length of 20.  These are the wooden
bridges, steel suspension bridges and the tubular steel bridge.
The other bridges aren't
extensible and keep their maximum length.

@metanode @section,AI Boost,Increase the AI recursion depth.
@c --------------------------------

@switch{aiboost, -A}

This switch is deprecated, and does not work as intended.  Do not use it.

@cindex AI
With this switch it is possible to try and make the AI (`artificial intelligence',
i.e. computer players) slightly more
intelligent.  However it is currently of limited use, and large values
(greater 5 or so) can make the game very sluggish, or in fact even stop
it completely.  Don't activate this unless you know that it can lock up the game.

This works by modifying the so-called ``recursion factor'' in the game.  This
determines how far ahead a computer tries to look.  However, the time spent
doing this increases exponentially with that factor, and that's why you
should be very cautious in increasing it.

If a too large value is selected, it may easily happen that the computer
stops responding, because a route evaluation is suddenly taking several hours when
normally it would be done in a few milliseconds.
And since these evaluations happen frequently, even reasonably small increases
are noticeable in small, but frequent pauses.

This switch is more of an experiment than it is useful, since any reasonable
changes doesn't seem to affect the computers' stupidity, they still build
they same brain-damaged routes no matter what you try.  So, feel free to
play with this switch, but don't expect any large effects to happen.

@metanode @section,Multi-headed Engines,Buy additional engines for a train.

@switch{multihead, -M}

This switch makes it possible to add extra engines to a train.  This can be 
especially useful in the early game, or in mountainous terrain.  The extra engines
increase the total power available to accelerate the train, but of course they 
also add weight.  This means that extra engines only make sense if they weigh
much less than the total weight of the train, otherwise they are a waste of money.

Another small benefit of additional engines is that they increase the
maximum speed slightly, because there is some excess power available to accelerate the train to a higher speed.  The first additional engine adds 20%, the next one
10%, and a third extra engines add another 5%.  After that adding more engines will not 
increase the speed any more.  The amount of this increase (in percent) is an option
to the switch, the default is 35% in total.  If you want the game to be more realistic,
you should probably disable the speed increase using @t{@w{multihead 0}}.  Otherwise,
the parameter can be anything between 0 and 100, in which case the additional
engines add 4/7, 2/7 and 1/7 of that amount, respectively.

Now the big question is, how do you buy these additional engines?
Here, the answer is once more the magic @kbd{Ctrl} key.  Simply open a depot with
a train in it, and select the engine to buy.  Now, before you click on the 
``Purchase'' button, hold down the @kbd{Ctrl} key, then click the button.  This
creates a new engine that behaves sort of like a carriage, in that you can place
it anywhere on the train.  If you have the train info window open, you can see
how the train power and speed changes if you add or remove engines.

A slight complication arises for the engines that normally come with two heads, like
the Asiastar for example.  In this case, when you buy an engine, you'll only buy a
single one and not both.  Then, using the @kbd{Ctrl} key, you can buy a second or
even a
third engine.  Note that the maximum speed given in the purchase window is the one
for a dual-engine train.  This means that if you only buy one engine of the Asiastar,
it will actually be slower than what is stated in the window.  Only
adding a second Asiastar engine will raise the maximum speed to the normal value.

The @kbd{Ctrl} key also has another function.  It selects
which way an engine faces.  If you move an engine around in the depot while holding
down @kbd{Ctrl}, it will face one way.  If you move it without holding @kbd{Ctrl}, it
will face the other way.

In multiplayer games, the @kbd{Ctrl} key doesn't work.  Here, you buy additional
heads if there is already an engine in the depot.  This means that the first
engine you buy is a regular one, all other engines are additional heads.  You 
can therefore only have one train in a depot when buying engines, and to buy
a new train, you must not have another train in the depot..

@putimage{multihd, 4in}

@metanode @section,Road Vehicle Queueing,Road vehicles wait at an occupied station.

@switch{rvqueueing, -R}

Have you ever wondering why these stupid truck drivers just turn around when they
arrive at a busy station?  Why don't they just wait till it's their turn?

In order to fix this behaviour, simply enable this switch.  Now trucks (and buses) will
wait at the entrance of the station, and enter the station as soon as a loading bay
is available.  This has two advantages.  First, it means that the trucks don't go and
run around in loops.  Second, it makes a station much more orderly, and actually
reduces the amount of traffic jams that occur at a station's entrance.  This will 
also help you gauge how many trucks you need on a certain route.  If too many trucks
are waiting at a station, that means that you should remove some from this route.

One problem with this is that vehicles may still ``stack up'' if they wait
too long, making several vehicles occupy a single piece of the road.  This
might cause a traffic jam, and will also mess up the order in which they
arrive at the station.  To avoid this, make sure that you don't send too
many vehicles to a loading loading bay or bus station.

This patch was contributed by Marcin Grzegorczyk.

@putimage{rvqueue, 2in}

@metanode @section,Low Memory Version,For computers with less memory.

@switch{lowmemory, -Z}

Using this option, it is now possible to run TTDPatch on computers that have as
little as
4 MB of memory.  Without it, TTDPatch needs at least 9 MB to run.  The only 
disadvantage of this option is that it makes it impossible to load savegames with a larger
vehicle factor than specified.

You have to try how large a vehicle factor you can get, depending on how much
memory you have, and how many new graphics you are loading.  If you run out
of memory, the game will not start.

This option has no effect on the Windows version of TTDPatch.

@metanode @section,General Fixes,Many small improvements.

@switch{generalfixes, -g}

This setting is a combination of many small patches.  They are combined because
there is only a limited supply of command line letters, so that things that are
unlikely to be turned off by anyone are all included in this option.

@noindent Here's what this option fixes in the current version of TTDPatch:

@cindex Oil field acceptance
@cindex Screenshots
@noindent Fixes contributed by Marcin Grzegorczyk:
@itemize @bullet
@item Oilfield acceptance bug.  In TTD, all oilfields should accept
passengers and mail, however some don't, and this is fixed now.  
@item Oilfield stations will be removed when the oil rig closes down, unless
the station has other facilities.
@item Vehicle listing with more than 129 vehicles.  It used to be impossible to
select any vehicles with higher numbers, instead TTD was opening the vehicle
window for the first vehicle. (Note, the same
bug still exists in the depot train list, but who has more than 129 trains 
in a single depot?)
@item Airplane crashes no longer make one of the terminals unusable.
@item The ``Play Scenario'' option used to crash TTD if the loaded scenario
contained running road vehicles.  This is fixed now.  (Such scenarios are
now easy to create by importing saved games into the scenario editor; 
see @ref{Load Entry in the Disk Menu}.)

Note that although you may be able to change the side of road for vehicles
to drive on while they're already running, it is not a good idea since this may
confuse TTD's road vehicle movement code, and some vehicles may get stuck 
at stations.  Make this choice in the main menu, before playing the scenario.
@item Food and fizzy drinks subsidies work now (proviously they did not go
to a town, but to an industry such as a coal mine, which didn't work)
@item Active subsidies to stations that have been temporarily removed (the grey sign 
still exists) are now shown with ``N/A'' as the owner, instead of showing 
``Cannot remove obstacles on land'' or crashing TTD
@item Active subsidies are deleted if their corresponding station is deleted
permanently (the grey sign disappears)
@item If the maintenance time comes when an airplane is taking off, it will head for the hangar 
at the destination airport.  Previously, it would take off and then land back on the same airport.
@item Bridges and tunnels owned by nobody can be removed.  This particular fix is also applied when 
the @option{extradynamite} switch (see @ref{Extra Dynamite}) is turned on.
@item Fixed incorrect internal number of city buildings if building under construction
was removed.  This particular fix is also applied if any of @option{towngrowthlimit}, 
@option{towngrowthratemode}, or @option{largertowns} switches (see @ref{New Town Growth Switches}) is enabled.
@item Towns can now build on coasts or riverbanks, as they do when a new random game is started.  
This particular fix is also applied if any of @option{towngrowthlimit}, 
@option{towngrowthratemode}, or @option{largertowns} switches is enabled. (*)
@item Wooden bridges are always available (otherwise the game might lock up 
when a town would try to build a bridge in years before 1930)
@item Make sure there are always houses that can be built (otherwise the
game might lock up in years before 1930)
@item Custom vehicle type names are now properly removed (and reloaded from @file{vehicle.dat}, 
if that file is present) when a scenario is started
@item Amounts in litres are displayed correctly (1000 litres per tonne, not 100) (*)
@item In the Windows version of TTD too many things (e.g. parts of tunnels and industries) 
could be destroyed when a large UFO was blown up; this is fixed now
@item In the Windows version of TTD the period key ``@kbd{.}'' worked as backspace,
and the backspace key would sometimes trigger a `replay' of the key buffer; this is fixed now.
This particular fix is also applied if the enhanced keyboard handler (see @ref{Enhanced Keyboard Mapping}) is active.
@item Population and the internal number of buildings in a city could be wrong when a new town is 
created in the scenario editor; this is now fixed.  This fix is also applied 
if the extended town data are collected; see @ref{More Town Statistics} 
for the list of switches that enable extended town data.
@item The list of available local authority actions no longer becomes empty 
if the player's cash is close to the maximum possible value
@item TTD will no longer create temperate-climate banks in the sub-tropical
climate.  This will apply to new games only. (*)
@item Shops and offices in the snow areas are no longer shown as a church sometimes (*)
@item TTD will now show a more detailed error message when placing a bridge fails
(without this patch, it would show detailed message only after tubular bridges were introduced)
@item The maximum amount towns are allowed to spend for raising/lowering land is now
affected by inflation, so that towns will not become eventually unable to modify the land (*)
@item Ships no longer get stuck if a bridge is built over them parallel to the line of their movement
@item Using the query tool no longer can cause loss of synchronization in the multiplayer mode
@item It's no longer possible to place `ghost' buoys in the north corner of the map
@end itemize

@noindent Fixes contributed by Norman Rasmussen:
@itemize @bullet
@item Screenshot hotkeys (Ctrl-S and Ctrl-G) work now in the Windows
version and the screenshots have a correct colour palette.  In addition,
you no longer get hundreds of screenshots if you hold the key
combination for a bit too long.  This particular
fix is also applied when the @option{win2k} switch is turned on.
@end itemize

@noindent Fixes contributed by Csaba Varga:
@itemize @bullet
@item Zeppelins will not crash on heliports.  If bit 8 of the @option{miscmods} switch is set,
they will not crash on large airports either.
@item Sound no longer pans always to the left in the Windows version of TTD
@item TTD will no longer mix commas (@samp{,}) and periods (@samp{.}) as thousand separators 
in initial loan size in the Difficulty Settings window with some currencies.  This fix is also 
applied when the @option{morecurrencies} switch (see @ref{More Currencies and Euro}) is enabled.
@end itemize

@noindent Fixes done by Josef Drexler himself:
@itemize @bullet
@item It's now possible to make a giant screenshot at another zoom level than the default
@item TTD will no longer crash when creating a bubble (from a bubble generator in the toyland climate) 
if the reserved part of the vehicle array is full
@item Last maintenance dates (and other absolute date values) are properly updated 
when the current date is set one year back at the end of 2070 (note that this behaviour 
of TTD may be changed, see @ref{Eternal Game})
@item The monorail and maglev tunnel icons are now correct, previously TTD had
them switched
@item The company value will no longer become negative when the player has too much
cash. Also, the individual income statistics will still be correct in that case.
@item The game now remembers the previous selection of railroad track system and uses
it as default (*)
@item The company graph windows are now rescaled when a company is deselected in the legend key (*)
@end itemize

@noindent (*) These specific fixes can be disabled with the miscmods switch, see 
@ref{Miscellaneous Modifications}.

In the future, more fixes may join this category, but that's all for now 
(in case it's not enough for you).

@metanode @section,More Airports,Build more than two airports per city.

@switch{moreairports, -J}

Normally, you can only build two airports within a city's area of influence.
Lobbying by powerful Transport Tycoons has led the politicians to allow this option,
though.  However, the population is still upset by all the noise so you cannot build
an unlimited number of airports, even with this option.

@cindex noise units
So how many can you build then?  The basic idea is the concept of ``noise units''.
In total, you are allowed to have up to nine noise units per city.  And here's how
many noise units the different types of airports use up:

@multitable @columnfractions .15 .15 .70
@item Type @tab Noise units @tab Maximum number per city
@item Small airport @tab 2 @tab 4
@item Large airport @tab 3 @tab 3
@item Heliport @tab 1 @tab 9
@end multitable

Of course you can also combine the types, and just add up the noise units.  For example,
you can now build one large airport, two small ones, and still two heliports, because
that adds up to exactly nine noise units.

@metanode @section,Plane Crash Control,Determine under what circumstances planes may crash.

@switch{planecrashcontrol, -Xc}

Using this switch you can determine under what circumstances planes may crash, as well
as the probability of this happening.

The switch is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Effect
@item 0 @tab 1 @tab Normal plane crashes are turned off if disasters are turned off 
 in the Difficulty Settings window in TTD.  This does not affect crashes that occur when a jet
plane tries to land on a small airport --- i.e. those crashes are not ``normal''.
@item 1 @tab 2 @tab Jet planes landing on small airports don't crash if disasters are turned off.
@item 2 @tab 4 @tab Normal plane crashes occur only when a plane lands after a breakdown, 
but then they are four times more likely than normally.  If this option is specified
together with the next one, it affects all plane crashes, not just normal ones.
@item 3 @tab 8 @tab Jets landing on small airports have the normal crash probability.
@item 4 @tab 16 @tab All normal plane crashes are turned off, regardless of other settings.
@item 5 @tab 32 @tab Jets landing on small airports never crash, regardless of other settings.
@end multitable

For example, with @t{@w{planecrashcontrol 5}} normal plane crashes occur only when a plane is
broken down, and only if disasters are turned on; @t{@w{planecrashcontrol 48}} disables plane
crashes altogether.

With this switch turned off, the normal crash probability is about 1 in 1500; for jet planes
landing on small airports, the probability of a crash is 1 in 20.

(This patch provided by Marcin Grzegorczyk.)

@metanode @section,Bribe Option,Add a bribe option to the local authority menu.

@switch{bribe, -Xb}

This switch adds a bribe option to the local authority menu.  Using this option will increase
your local authority rating by one level, unless the rating is very appalling, in which case
it might take several bribes.  There is a 7% chance of getting caught by a regional investigator,
which will reduce the rating to ``poor'', and bar you from interacting with the local authority for
six months.

The cost of the bribe depends on various factors.  If you have lots of cash, it will be more
expensive, as it will be for a larger city.  However, if you already provide a good service
to the citizens by transporting lots of passengers and mail, the cost of the bribe will be
reduced.

Using this option causes extended town data to be collected; see @ref{More Town Statistics} 
for more information.

@metanode @section,Show Vehicle Speed,In the vehicle window, show the current speed.

@switch{showspeed, -Xs}

@cindex vehicle speed
With this switch, the vehicle window will show the current speed in the status bar.  This
is not really useful, but it is nice for comparing two engines with respect to power and
maximum speed.  For example, if you have a hilly terrain, this might help you choose between
an engine with a high speed but low power, and one with a lower speed but more power.

@putimage{showspd, 2.5in}

@metanode @section,Autorenewal of old vehicles,Automatically renew vehicles when they reach their maximum age.

@switch{autorenew, -Xa}
@switch{forceautorenew, -XA}
@cindex renew old vehicles

Using the switch ``autorenew'', all vehicles will be automatically renewed the given number of months before (or after)
they reach the maximum age.  Note that they will be replaced by an identical vehicle, it is not
(yet?) possible to change the engine type.  Vehicles with an obsolete engine will not be
renewed.

Normally, with ``autorenew'', the vehicles will be renewed at the next service,
or whenever they enter a depot.  If you also enable ``forceautorenew'',
they will be sent to a depot and renewed immediately, as soon as they are too
old.  Setting ``autorenew'' without ``forceautorenew'' 
will not work properly if you are also using
the new service intervals, in which case a vehicle will never go to the service
where it would be renewed.

The value given with either of these switches determines the number of months @emph{after} the maximum age when
they are renewed.  This value can be negative, in which case vehicles will be renewed @emph{before}
they reach the maximum age.  Since you get the first warning of a vehicle getting old a year before
it reaches the maximum age, you have the following options for the value of this switch:

@itemize @bullet
@item
less than -12 months: you will get no messages, all vehicles are renewed

@item
between -12 and 0 months: you get the message once, so that you have time to
manually replace a vehicle

@item 
more than 1 month: you get several messages warning you to replace the vehicle
@end itemize

The default value is -6, which means that after the first warning, you have half
a year to manually replace the vehicle, otherwise it will be renewed with the
same vehicle type.  If you do get the second warning, it means that something is going wrong:
the vehicle could not be renewed and you should pay more attention to it.

The way this renewal works is that when it is time to renew a vehicle, and if you
have enough money to actually do the renewal, it will start looking for a depot, as
if it were going for a standard maintenance.  However, in addition to the maintenance,
the vehicle (actually, the entire consist) is also renewed automatically, and the cost is deducted from your account.
Afterwards, the vehicle continues its regular schedule, it even keeps the cargo if it
had any.

@metanode @section,Rebuild ttdpatch.ovl on every run,Rebuilds @file{ttdpatch.ovl} even when it is valid.

@switch{forcerebuildovl, -Xr}

This option causes TTDPatch to always rebuild the @file{ttdpatch.ovl} file from scratch, even if
it is already valid.  This is useful if you modify the TTD executable regularly, for example
using TTD Alter (see @ref{Other Tools}).  With this option, the changes will be integrated into
the version that TTDPatch uses, without the need for a batch file to clear @file{ttdpatch.ovl}
or manually deleting it.

@metanode @section,Windows 2000/XP compatibility,Makes the Windows version of TTD compatible with Windows 2000/XP.

@switch{win2k, -2}
@cindex @file{dxmci.dll}

This switch applies some patches that make the Windows version of TTD compatible with Windows 2000/XP.
It was contributed by Norman Rasmussen.

With this switch turned on,
you simply run TTDPatch under Windows 2000 or XP, and it should work.  You may have to delete the @file{ttdpatchw.ovl}
file if you tried to run an earlier version of TTDPatch.

To play on Windows 2003, you need to turn on this switch, and copy the file
@file{dplay.dll} to @file{dplayx.dll}, or get a copy of @file{dplayx.dll}.  Search
for this file on your computer if you don't know where it is.

Additionally, this switch enables the use of @file{dxmci.dll}, a DLL that changes TTD's music routines
to use DirectMusic, instead of the outdated MCI functions.  To use it, simply install @file{dxmci.dll}
(available from the @uref{http://www.ttdpatch.net/tools.html, TTDPatch tools page})
in your TTD folder, and turn on the @option{win2k} switch.  Now TTD will use DirectMusic to play its music.
This may make the music sound slightly differently than what you are used to, because DirectMusic will use
its own instrument definitions for the MIDI music.

Note that some computers running Windows 98 experience a crash when exiting TTD, if @file{dxmci.dll} is
used.  The cause of this crash is not clear, nor does anyone know how to fix it.  It is benign however,
aside from writing a crash log (@file{crash###.txt}) every time you quit TTD.

@metanode @section,Load Entry in the Disk Menu,Adds a ``load game'' option to the in-game disk menu.

@switch{diskmenu, -Xm}

This switch will change the gray bar in TTD's disk menu to show a ``load game'' entry.  This way, you don't
have to quit the current game to be able to load a new game.

It also changes the scenario editor to show a ``load game'' option in the disk menu as well.  In addition, this entry
will change to ``save game'' when you hold down the @kbd{Ctrl} key.  This way, you can load a savegame in the editor,
make some changes, and save it back as a savegame.  Note that there are some minor problems that can occur if you
do this, such as towns taking over ownership of all road-railroad level crossings.  To correct this afterwards, you
have to use the ``OwnCrossings'' sign cheat.

Note that it is not possible to save a scenario as a savegame unless it has
been played as a savegame before.  The reason for this is that otherwise,
no companies have been founded, and effectively you are not a player in the
game.  Even your mouse is disabled!  So, only save a game as a savegame that
you actually loaded as a savegame too!

@putimage{diskmenu, 6in}

@metanode @section,Feeder Service,Allows feeder service operation: unload cargo at a station that would accept them

@switch{feederservice, -Xf}

This switch allows you to operate a feeder service, that is a service which
transports cargo from one station to another, where it is not delivered but
rather left for another carrier.  An example would be a bus that transports
passengers from the city to an airport, where they are then picked up and
transported to a different city by a plane.

To make use of this switch, you have to select the ``unload'' option in the
first carrier's orders, which will force it to not deliver its cargo but
rather add it to the station's cargo list.  This works with as many carriers
in a chain as you would like.

In addition, this patch improves how carrier profit is calculated.  Normally,
all carriers in such a chain contribute to the revenue, but only the final
carrier gets credited with positive profit, all others get negative profit
through their running costs.  With this patch, all carriers get appropriate
profit depending on how fast and how far they transport cargo.

This also works with a chain of more than two carriers, although in that case
the final carriers get less and less of their fair share of the profit,
because the cargo is on its way for a longer time, leading to smaller profit.

Note that only the very last carrier in a chain will actually generate income.
Only a successful delivery will give you money, the profits in-between are
only for accounting purposes, they do not actually contribute to your bottom
line.  The main reason for this profit calculation is the company performance
ratings, which take into account the carrier with the @emph{least} profit.  If
you have feeder services without this patch, that will of course mean the least
profit of all but the last carriers in the chain is negative, even though
every carrier actually does help generate revenue.

If you temporarily take over another company using the subsidiary management
or @t{@w{Cht: PlayerID}}, the feeder service option is only active in your
original company, and not in the computer company you're managing temporarily.
The reason for this is that computer players turn on the ``Unload'' option in
almost all of their services, which means they would all be considered feeder
services and not earn any money.

@metanode @section,Go To Depot,Add depots to vehicle orders

@switch{gotodepot, -Xd}

This switch allows you to add depots to a vehicle's orders.  When adding a new
order, you can simply click on a depot (or hangar) to send the vehicle
there as part of the schedule.

You can use this to force servicing at a station entrance, so that trains are
less likely to break down inside the station.  You can also use depots as crude
waypoints by sending trains to a specific location.  This is also very useful
for ships, where you can now use depots instead of buoys.

These depot orders come in two variations: always or only after the service
interval.  You choose between the two variations by clicking on the ``Full
load'' button in the vehicle orders.  If a vehicle is ordered to always go
to a certain depot, it will go there everytime it comes to that entry in the
schedule.  However, if you choose the ``service only'' option, the vehicle
will ignore that order unless its service interval has expired.  Note that
it will skip the order as soon as it leaves the previous station, so if the
service interval expires while the train is on the way, it won't go to
the depot until the next rotation of the schedule.  You can work around this
by placing a waypoint station (see @ref{New Non-stop Handling}) just in front of
the depot.

Additionally, whenever a vehicle has any depot on its order list, it will
never try to go to any other depot.  It will always go to that particular depot,
which means it won't get lost looking for another depot or run around in 
circles.

@metanode @section,New Vehicle Graphics,Enable new graphics for vehicles and new vehicle models

@switch{newships, -S}
@switch{newtrains, -T}
@switch{newplanes, -XP}
@switch{newrvs, -XR}
@switch{loadallgraphics, -XG}

If you're bored with the selection of vehicles that TTD has to offer,
this switch is right for you!  It allows the use of new graphics files to
modify the existing vehicles.  You can have new trains, ships, planes and
road vehicles.

For a list of available graphics sets, please go to the
@uref{http://www.ttdpatch.net/newgrf.html,TTDPatch New Graphics page}.

Each of these switches enables new graphics for that particular vehicle
type, except for ``loadallgraphics'', which makes TTD loads all new graphics 
into existing savegames.  Normally, only those graphics are loaded
that were active when the game was saved.
See @ref{New Graphics} for more information on how to enable and use them.

@putimage{newgrf, 5in}

@metanode @section,Subsidiaries,Manage subsidiary companies

@switch{subsidiaries, -XS}

Normally, there is little incentive to buy shares of another company, except
for buying it out entirely.  Even if you own 75% of the shares, you get none
of the profit, you get no control over the company and it's as if you didn't
own any shares at all.

Using the new subsidiary management however, you can manage a company that you
own 75% of.  Once you own 75% of a company, you can open its player info window,
and the usual ``View HQ'' button will become
a ``Manage'' button instead.  If you
click this button, you temporarily switch companies, and can now build new
services, remove services or do anything else you want.

When you're done managing the subsidiary, you can open your own player window,
and click the ``Manage'' button there to return control to your own company.

Note that after you manage another company, the computer AI will take over the
management of that company, and it may do with it what it wants as well.  This
means that you should try not to build confusing (to the AI) train routes or
services, because it may decide that they are unprofitable and remove them 
again. 

@metanode @section,Move Error Popups,Move red error popup windows into a corner

@switch{moveerrorpopup, -E}

If you are annoyed by the red error messages always popping up in the middle
of the screen where you are working, you can enable this switch, and it will
move error messages to the top left corner of the screen, where they will be less
intrusive.

@metanode @section,Gradual Loading,Gradually load and unload vehicles

@switch{gradualloading, -Xg}

Normally, when a consist arrives at a station, all of its cargo is unloaded
and the new cargo is loaded instantly, and then it sits there waiting for 
a few seconds.

With this switch, all loading and unloading processes are changed so that they
occur gradually.  Instead of loading or unloading everything at once, only
5-10 units of cargo per vehicle
are loaded or unloaded at a time.  This means that you can
watch your train window and see how the cargo gets loaded or unloaded.  This
is especially useful for the new ship graphics, which are capable of showing
different loading states.  Without this switch, you'll probably never see how
the ships are being loaded or unloaded.

Another useful property of this switch is that trains can have some carriages
being loaded while others are still being unloaded.  This can sometimes speed
up the loading and unloading in a train station.  Also, a vehicle will not
leave the station while there is still cargo available for loading, no matter
what the setting of the ``full load'' option is.  This is true even if the
new cargo appears when the vehicle is already being loaded, the new cargo will
just be loaded as well, until the consist is full or no more cargo is
available for loading.

Note that the gradual loading switch requires that the loadtime switch is
active too, and will always activate it if you haven't already done so.
It also changes the loading time by making it cargo type specific, meaning
that one type of cargo can be done with loading but another still has more
cargo to be loaded or unloaded.  Because of this, sometimes train can take
a bit longer to load if you have an uneven number of carriages for each cargo
type.

Normally, gradual loading loads or unloads all wagons of a train at the same time.
This may have some side effects if the train has multiple destinations,
for example if it loads coal from several stations.  In that case, the coal
that's added at the last station causes the entire load to be considered to
be from that station.  This means you'll get less money than you should have.
You can use the ``miscmods'' switch to choose to have the wagons loaded
separately.  See @ref{Miscellaneous Modifications} for more details.

@metanode @section,Disaster selection,Select which disasters may occur

@switch{disasters, -XD}

This switch allows you to select or deselect specific types of disasters that
may occur in the game.  It only applies if disasters are enabled in the
difficulty settings.  For example, you can use this to turn off UFO disasters
because they're unrealistic.

The switch is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Disaster type
@item 0   @tab   1   @tab Zeppelin crash
@item 1   @tab   2   @tab Small UFO
@item 2   @tab   4   @tab Refinery explosion
@item 3   @tab   8   @tab Factory explosion
@item 4   @tab  16   @tab Large UFO
@item 5   @tab  32   @tab Small submarine
@item 6   @tab  64   @tab Large submarine
@item 7   @tab 128   @tab Coal mine subsidence
@end multitable

Plane crashes are not affected by these settings, for changing them please
see @ref{Plane Crash Control}.  Also, the submarines are not really disasters,
they are just handled by TTD in the same way so they are included here for
completeness sake.

Note that for each disaster type TTD has a range of years in which the disaster 
may occur.  For example, refinery explosions are possible only between 1960 and 1990, 
after 2009 only large UFOs may show up, and before 1930 (see @ref{New Starting Year}, 
@ref{Year Cheat}) or after 2099 (see @ref{Eternal Game}) no disasters will occur 
at all.  These year ranges may be changed using TTD Alter (see @ref{Other Tools}).

Also note that if you disable some disaster types, the others are more likely to 
occur.  When TTD decides it's time for a disaster, it always generates one, 
unless there are none to choose from@enddots{}

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,Signal wait times,Adjust the time a train waits at a red signal

@switch{signal1waittime, -X1}
@switch{signal2waittime, -X2}

These two switches allow you to select how long a train waits at a red signal,
either a one-way signal or a two-way signal.  Both take a parameter between
zero and 254 that is the
maximum number of days to wait, or the value 255 for waiting indefinitely.

Normally, a train waits approximately 41 days at a red one-way signal and
15 days at a red two-way signal, after which it turns around and tries to
find an alternative route.  If you are sure that the signal will turn
green eventually, you can tell all trains to wait a longer time, or to wait
forever.

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,More news items,Generate news items for more events

@switch{morenews, -N}

After enabling this switch, TTD will generate news items for 
additional events.

In the current version of the patch, these are
@itemize @bullet
@item The destruction of a large UFO (disaster category)
@item A lumber mill runs out of trees (economy changes category)
@item An airport is cleared of a crashed plane or zeppelin (disaster category)
@end itemize

This patch was originally contributed by Marcin Grzegorczyk, but the
lumber mill and plane crash messages were coded by Csaba Varga.

@metanode @section,Unified Maglev,Unifies the monorail and maglev track systems
@switch{unifiedmaglev, -XM}

This switch combines TTD's monorail and maglev track systems into a unified maglev
system.  The rationale behind it is that Transport Tycoon's monorail seems to be modelled after
the German ``Transrapid'', which is actually a maglev (magnetic levitation) system as well.

This switch works differently, whether the @option{electrifiedrailway} switch 
(see @ref{Electrified Railways}) is on or off.  For @option{electrifiedrailway off}, 
it can take the following parameters:

@itemize
@item @option{unifiedmaglev 1}: Convert all maglev engines to monorail
@item @option{unifiedmaglev 2}: Convert all monorail engines to maglev
@item @option{unifiedmaglev 3} (default): No conversion, keep two seperate systems
@end itemize

The conversion of the engines only applies to new games, or if you use
@t{@w{Cht: ResetVehicles}}.

In all of the three cases, you can buy monorail engines in maglev depots
and vice versa.  Wagons are not affected.

In the first case however, the maglev construction option will not appear, 
because there are no maglev engines (but if it appeared before, it'll stay).  
In the second case, the monorail construction option will not appear.

If @option{electrifiedrailway} is set to @samp{on}, all monorail engines are converted to maglev
(like option 2 above) and monorail wagons are made unavailable.  In this case, the parameter 
selects how the maglev system will @emph{look} like:

@itemize
@item @option{unifiedmaglev 1} (default): Use TTD's monorail graphics to display the maglev system
@item @option{unifiedmaglev 2}: Use TTD's maglev graphics to display the maglev system
@end itemize

With @option{electrifiedrailway on}, if you set @option{unifiedmaglev} 
to @samp{3} or @samp{off}, TTDPatch will change it to 1 internally.

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,Bridge Speed Limits,Raise speeds limits for the two fastest maglev bridge types
@switch{bridgespeedlimits, -XX}

One annoying thing about bridges in TTD is the speed limit they impose on maglev 
trains.  In the standard TTD set of vehicles, the fastest maglev engine can go at 
400 mph, but the best bridge (the tubular steel bridge) has a speed limit of 200 mph, 
whether it carries road or maglev track.  And if you need to build a bridge 3 
tiles long, you can't use the tubular one, you can only use a steel girder bridge 
with its speed limit of 160 mph.

With this switch, you can raise the speed limits of these two bridge types, 
if they carry monorail or maglev track.  The new speed
limit will be a percentage of the top speed of the fastest engine for the 
appropriate railway class (monorail or maglev).
If the @option{unifiedmaglev} switch (see @ref{Unified Maglev}) is enabled, monorail 
and maglev engines are treated as a common railway class, so monorail and maglev 
bridges get the same speed limits.

By default, the percentage value is 90%, but you can specify it as an additional
parameter, in the range 25% to 250%.

For example, if the percentage is 98%, and the fastest monorail vehicle 
(the Millennium Z1) has a top speed of 210 mph, the speed limit on monorail tubular bridges would be set to
98% of 210 mph, or 205.6 mph.  However, the limit has to be a multiple of 10 mph, so
it is rounded up to 210 mph.  For the steel girder bridges, the limit is always 90% 
of the limit for tubular bridges, also rounded to a multiple 10 mph; in this case 
it would be 190 mph.

However, if the resulting speed limit would be slower than that of the bridge without
this switch, the speed limit is not changed.  This means that this switch is mostly
useful for the maglev track system, unless you use the @option{unifiedmaglev} switch, 
or use an alternative train set with faster monorail engines (see @ref{New Graphics}).

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,Eternal Game,Allows you to play forever, time never stops
@switch{eternalgame, -Xe}

Normally, the game will never go past the year 2070.  On December 31, 2070, the following
day is again January 1, 2070.

With this switch, that will not happen, and instead time will continue running, and you
can keep playing the game virtually forever, although in many places the year will 
seem to stop at 65535 (if you have enough patience to play for @emph{that} long@dots{}).

@metanode @section,Show Full Date,Always show the full date, not only when paused
@switch{showfulldate, -d}

In TTD, you can normally see the full date with the current day only while the game
is paused.  With this switch, the full date is displayed all the time.

@metanode @section,Signals on Road Traffic Side,Always display rail signals on the side road vehicles drive on
@switch{signalsontrafficside, -Ys}

With this switch, rail signals are displayed on the same side as the one road vehicles
drive on.  If road vehicles drive on the left side, signals will be on the left side
of the track, and same to the right side.

If you are using semaphores, this and the road traffic side 
will also determine whether you get the British
style semaphores (on the left side) or German style semaphores (on the right side).  Note
that the selection of graphics only happens when a game is started or loaded, so if
you change the road traffic side during a game, it will show the wrong signals until
you save and reload the game.

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,Electrified Railways,Enable the electrified track system
@switch{electrifiedrailway, -XE}

One of the most common track systems in the world is now available for TTD too.  With
this switch, the second track system (monorail) is replaced by electrified railways.
Monorails and maglev merge together in the third track system (see also
@ref{Unified Maglev}).

This electrified rail system works the same way as the regular track, and the track
itself looks the same.  However, if you've loaded the new graphics, it will display
a catenary system with pylons and overhead wires.

If turned on, electric engines such as the SH 40 can only run on electrified track,
but steam and diesel engines can run on both regular and electrified track.

Note that if you should have a train composed of mixed engines (both diesel and electric
engines), it's only the first engine that matters, it determines what track the whole
train can run on.  Realistically, electric engines would just not contribute any power
when over regular track, but that is currently not built into the patch.

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,New Starting Year,Choose the starting year for new games
@switch{startyear, -XY}

This switch allows you to choose the starting year of new games.  It does not apply
to existing savegames and scenarios, which have the year set.

The range of possible values is 1921 (the first year TTD will work correctly) and
2030, with the default if turned on being 1930.

The switch also increases the range of years that can be selected in the scenario
editor.  Previously, you could only set it between 1950 and 1975, now all the years
from 1921 to 2030 are available.  Once set in a scenario, this starting year applies
even if the game is played without startyear turned on.

Note that years before 1930 have very few vehicles available, so your options for
new transport services are very limited.  If you choose years before 1930, the patch
also turns on @option{generalfixes}, to ensure that the
game will not lock up when you start it (see @ref{General Fixes} for more information).

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,Error Popup Time,Set the time an error popup is displayed
@switch{errorpopuptime, -YE}

With this switch, you can control how long an error popup is displayed before 
it disappears.  Sometimes you want more time to read, or you find them so annoying
that you want them to disappear quickly.

The parameter sets the number of seconds that an error popup is displayed, between
1 and 255 (about 4 minutes).  If you set it to 0, the popup is not going to disappear
at all unless you close it yourself by right-clicking the mouse for example.

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,New Town Growth Switches,Control how towns grow
@switch{towngrowthlimit, -Xt}
@switch{largertowns, -XT}
@cfgonlyswitch{townminpopulationsnow}
@cfgonlyswitch{townminpopulationdesert}
@switch{towngrowthratemode, -YT}
@cfgonlyswitch{towngrowthratemin}
@cfgonlyswitch{towngrowthratemax}
@cfgonlyswitch{tgr*}

These switches allow you to modify how fast, how much, and in what conditions
cities grow.  Because there are so many switches and so many possibilities of
setting up town growth, they are explained in more detail in the next
chapter, see @ref{New Town Growth Mechanism}.  A short description is provided below.

@option{towngrowthlimit} sets how far from the central point of a town (where 
you see the town name) new houses may be built.  You can set the limit to 
anything between 12 and 128; with this switch turned off, it is 20.  The effects 
of this switch are most visible when you expand towns in the scenario editor.

In TTD, activity at nearby stations boosts growth of towns, but not if a town 
has more than 71 buildings.  If @option{towngrowthlimit} is turned on, this 
limitation is removed.

@option{largertowns} makes each one out of a specified number of towns grow 
twice as fast as others.  For example, @option{largertowns 4} (the default) makes every 
fourth town grow twice as fast.  If you create a scenario, you can control 
which towns will grow faster: the doubled growth will always apply to the first 
town you create, then (assuming the switch is set to 4) to the 5th, 9th, 13th, 
and so on (this can get messy if you start 
deleting towns, so try not to do it).  In random games, you cannot control 
to which towns this will apply.

If @option{largertowns} is enabled, @option{towngrowthlimit} is also enabled, 
but the parameter of the latter will apply only to towns that have the growth 
rate doubled; other towns will have growth limit of 20, the TTD default.

@option{towngrowthratemode} controls how the growth rate of towns is calculated.  Briefly, use mode 0 
(or turn the switch off) if you're traditionalist and want the original 
TTD algorithm (with bugs fixed, of course); use mode 1 if you want a slightly enhanced 
version of the TTD algorithm; or use mode 2 if you want the full power of all the 
new switches@dots{}

In TTD, towns above the snow line in the sub-arctic climate require delivery of 
food, or they don't grow at all.  Similarly, towns in desert areas in the 
sub-tropical climate require food and water.  If such town happens to have 
too few buildings to accept food, there's no way to make it grow.  As a remedy, 
you can use the switches @option{townminpopulationsnow} and @option{townminpopulationdesert} 
to define minimum town populations, below which towns will grow even without 
food or water supplies, so you get a chance to transport food to them eventually.  
To use these two switches, you also have to enable at least one of the three switches 
mentioned above in this section (@option{towngrowthlimit}, @option{largertowns}, 
@option{towngrowthratemode}) or the @option{generalfixes} switch.  The ``on'' 
defaults for these switches are 90 for @option{townminpopulationsnow} 
and 60 for @option{townminpopulationdesert}.  If you don't want this feature, 
set both to zero; setting them to @samp{off} won't work.

All the other new town growth switches are active only if @option{towngrowthratemode} 
is set to @samp{2}.  Again, specifying @samp{on} as the parameter sets them to their 
default values, but specifying @samp{off} has no effect.

All patches contributed by Marcin Grzegorczyk.

@metanode @section,Miscellaneous Modifications,Modify some aspects of the generalfixes and other switches
@switch{miscmods, -Yo}

This switch doesn't introduce any new feature, but rather changes some aspects
of other features.

It is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Meaning
@item  0 @tab 1 @tab Towns don't build on coasts/riverbanks
@item  1 @tab 2 @tab (reserved, do not use)
@item  2 @tab 4 @tab (reserved, do not use)
@item  3 @tab 8 @tab Gradual loading goes wagon by wagon instead of the whole train
@item  4 @tab 16 @tab Don't change litres display such that a ton is equivalent to 1000 litres, instead of 100
@item  5 @tab 32 @tab Don't prevent temperate-climate banks in other climates
@item  6 @tab 64 @tab Don't try to fix the bug with shops and offices displayed as churches
@item  7 @tab 128 @tab Don't make raising/lowering terrain for town expansion
be affected by inflation
@item  8 @tab 256 @tab Prevent zeppelins from crashing on large airports
@item  9 @tab 512 @tab Don't remember the railroad track system you've used previously
@item 10 @tab 1024 @tab Show denser smoke plumes from steam engines
@item 11 @tab 2048 @tab Don't rescale company graph windows when a company is deselected
@end multitable

@noindent Bit 3 modifies gradual loading (see @ref{Gradual Loading}), 
other bits modify `generalfixes' (see @ref{General Fixes}) except for bit 10, which works on its own.

Note that bit 10 causes the generation of quite a bit more steam.  Each stume plume however counts as
a special effect object, and those are normally limited to 160 objects.  This means that if you have many
steam engines, the amount of steam you say may not actually be more because of this limitation.  You can
increase this limit using the @option{morevehicles} switch, see
@ref{Increased Number of Vehicles}. 

This switch was originally contributed by Marcin Grzegorczyk; some features 
have been added by Josef Drexler and Csaba Varga.

@metanode @section,Save Optional Data,Store additional information in savegames
@switch{saveoptionaldata, -Xx}

In order to function properly, the patch has to save extra data in savegames in
certain cases (for example if the extended town data are collected, see @ref{More Town Statistics}).

However you can also tell the patch to save more information that isn't actually
required.  This includes for example the vehicle data.  If enabled, the patch will
store and load back the current values of all vehicle data, e.g. the top speed, power, weight,
capacity and so on.  This is especially important and useful if you use new
graphics files, which change the vehicle data.  With this switch on, TTDPatch 
will record which graphics files were active in the game, and then use this 
information to prevent activation of incompatible graphics sets.  
See @ref{New Graphics} for more information.

It is recommended that you turn this switch on unless you have a good reason not
to use it.

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,More Build Options,More freedom when building and removing industries and other objects
@switch{morebuildoptions, -YB}

Are you annoyed that you can only have one industry of each type per city?  Or that
you cannot place an oil rig in the middle of a large bay you crafted in the scenario 
editor?  Then this option is for you.

It is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Meaning
@item 0 @tab 1 @tab Crossing tunnels
@item 1 @tab 2 @tab Oil rigs may be built everywhere, not only near edges of map.
Outside the scenario editor, refineries may also appear or be funded everywhere.
@item 2 @tab 4 @tab Allow multiple industries of the same type in one town
@item 3 @tab 8 @tab Removal of statues, lighthouses and transmitters with @kbd{Ctrl}
@item 4 @tab 16 @tab Removal of industries
@item 5 @tab 32 @tab Allow identical industries to be built very close to
each other
@end multitable

The default value is 15, meaning bits 0 through 3 are enabled by default.

With the ``crossing tunnels'' switch, you can build tunnels that cross, 
but the tunnels are independent, so that trains can pass by without collisions. 

Note that with bit 2 set, you can build more than one industry per town, 
but cargo delivered to a station always goes to the nearest industry, 
so it's not a good idea to build industries of the same type too 
close together.  Bit 2 is required for bit 5 to work.

Normally you can't remove company statues, lighthouses and transmitters.
When you enable bit 3, you can hold down 
@kbd{Ctrl} while using the dynamite tool to remove them. 
You can even build things over them, but keep in mind that the @kbd{Ctrl} key
may affect other building actions, too.
The removal of these objects doesn't affect the local authority ratings in the town. 
You don't benefit from the removal and 
rebuilding of statues.

If you remove all statues of a company in a town, the 
bonus for that company's station ratings disappears.

The @option{extradynamite} switch makes it possible to remove company statues 
without the @kbd{Ctrl} key, but not to build over them.

With bit 4 set,
you can remove industries like normal objects, again with holding down the @kbd{Ctrl}
key.  Removing industries is very costly.

This patch was contributed by Oskar Eisemuth.

@metanode @section,Semaphore Signals,Show semaphore signals before 1975
@switch{semaphores, -YS}

Transport Tycoon (original) had semaphore signals in the earlier years, and light
signals in the later years.  TTD normally only has light signals, but this switch
reintroduces semaphore signals.

If enabled, the signals you build before 1975 are semaphore signals, and signals after
1975 are light signals.  Note that you need the signals.grf graphics to be able to
see semaphores.

If you have also turned on @option{signalsontrafficside}, the road traffic side determines
what kind of semaphores you will see, British style (left side) or German style (right
side).  You have to make this choice before starting the game, or save and reload 
for the change to take effect.

To place a semaphore after 1975, or a light signal before 1975, you can hold down the
@kbd{Ctrl} while building the signal.  Note that after a signal has been built, the
@kbd{Ctrl} key is used for pre-signal selection, not semaphores, so this only applies
when the signal is first built.  However you can remove and then rebuild the signal
of course.

To switch all signals to light signals or semaphores, use the @t{@w{Cht: Semaphores}}
sign cheat.

@putimage{semaphor, 3in}

@metanode @section,Plant Many Trees,Plant a rectangular area of trees
@switch{plantmanytrees, -Yp}

It is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Meaning
@item 0 @tab 1 @tab Allow adding trees to a tile
@item 1 @tab 2 @tab Plant rectangular area with @kbd{Ctrl}
@item 2 @tab 4 @tab Rectangular planting adds trees to tile
@end multitable

The first option allows you to plant trees on a tile which already has trees.
However, currently this does not impress the local authority; for that you need to
plant trees on empty tiles.  Also, the new trees have to be fully grown (due to an 
internal restriction of TTD), so they cost more.

The second option allows you to plant a large rectangular area with trees.  First,
you plant a tree in one corner of the rectangle.  Then you hold down @kbd{Ctrl}, and
plant a tree in the opposite corner of the rectangle.  Now all empty fields in the
rectangle will be filled with trees.  If the tree type is the same in both corners,
the whole rectangle will be filled with that type of tree.  If the tree types
differ, the rectangle will be filled with random trees.

If you enable the third option, this rectangular planting will add trees to tiles
which contain trees already, whereas otherwise it only plants on empty tiles.

This patch was contributed by Csaba Varga.

@metanode @section,More Hotkeys,Enable hot keys for all tools in the rail and road construction menus and for general actions
@switch{morehotkeys, -YH}
@cindex hotkey

Normally, hotkeys only work for the four railway track types, and the two orientations
of roads.  With this option, everything in the railway and road construction menu can
be activated by hotkeys.

In addition, you get hotkeys for all display options, such as transparent building and
station and town signs.

For the construction menu, keys @kbd{1} to @kbd{4} choose the track or road orientation as usual.
The keys from @kbd{5} to the end of the top row of keys activate the other tools, and
the key to the left of @kbd{1} (usually @kbd{`} or @kbd{~}) 
toggles the bulldozer on or off.

For the display options, @kbd{t} toggles transparency, and @kbd{Shift-1} (@kbd{!}) to 
@kbd{Shift-5} (usually @kbd{%}) to toggle the other display options.

Note that you can modify the hotkey list using the `ttdpttxt' mechanism, for more
information see @ref{Custom in-game texts}.

Note that the DOS versions of TTD have hardcoded keyboard mappings (which can be a 
little strange sometimes), while Windows versions follow the Windows keyboard layout.  
This may make it difficult to determine the
key code to use for a certain key.  To help with that, you can use the `ttdpttxt' 
mechanism to turn on the display of key codes to make your own hotkey list.

Or, you can use the enhanced keyboard mapping feature (see @ref{Enhanced Keyboard Mapping}) 
to remap all keys in the DOS versions the way you like it@enddots{}

This patch was contributed by Oskar Eisemuth.

@metanode @section,More Currencies and Euro,Enable selection of more currencies and introduce the Euro in 2002
@switch{morecurrencies, -XC}

This switch adds more currencies to TTD.  It adds the Hungarian Forint, 
Polish Zloty, Austrian Shilling, Belgian Franc, Danish Krone, Finnish Markka,
Greek Drachma, Swiss Franc, Dutch Guilder, Italian Lira, Swedish Krona, Russian Rubel
and, after 2002, the Euro. If you're using DM, FF or Pt as your currency in 2002, 
the currency is changed to the
Euro and the national currencies become unavailable.  This happens to the Forint in
2008 as well.

You can fully customize each of the new currencies, see @ref{Currency Entries}.

This switch is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Meaning
@item 0 @tab 1 @tab Currency symbol displayed always before number
@item 1 @tab 2 @tab Currency symbol displayed always after number
@item 2 @tab 4 @tab Do not introduce the Euro
@item 3 @tab 8 @tab Always use comma to separate thousands
@item 4 @tab 16 @tab Always use period to separate thousands
@end multitable

Bits 0 and 1 are of course mutually exclusive.  If either is set, it applies to all
currencies.  The same is true for Bits 3 and 4.

This patch was contributed by Csaba Varga.

@metanode @section,Manual Track Conversion,Replace tracks with a different type by simply building over them
@switch{manualconvert, -Ym}

If this switch is active, you can convert a piece of track to another type simply
by building over it, instead of having to remove it first.
Conversion of stations, depots, bridges and tunnels is also done by building 
a piece of track (@emph{not} a station, depot etc.) over them.

This patch was contributed by Csaba Varga.

@metanode @section,Enhanced Graphical User Interface,Enhance the graphical user interface inside TTD
@switch{enhancegui, -YG}

This switch makes some changes to the graphical user interface in TTD.  For example,
it modifies the station construction menu if @option{largerstations} is active and shows
buttons for all 7 lengths and all 7 numbers of platforms.  It also makes the depot
window slightly larger, to accomodate 14 wagons instead of just 10.

It is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Meaning
@item 0 @tab 1 @tab (reserved, do not use)
@item 1 @tab 2 @tab Make depot window even larger (18 wagons)
@item 2 @tab 4 @tab Dragging a railway vehicle outside the depot window sells the vehicle 
(i.e. acts as dragging to the trashcan)
@item 3 @tab 8 @tab Show horizontal trashcan bar instead of the standard vertical one
@end multitable

The improved station construction menu and 14-wagon depot window are always 
activated, other bits are off by default.

This patch was contributed by Oskar Eisemuth.

@metanode @section,More Town Statistics,Show statistics about cargo delivered to towns as well
@switch{moretownstats, -Yt}

When active, this switch collects and displays information about how much cargo is accepted by
stations belonging to a particular town.  Normally, TTD counts and displays only how many passengers and
how much mail is transported away from the town; it also counts how much food 
and water is delivered to it, but does not display this information anywhere.  
With this switch, you will know how many passengers and how much mail, goods, 
food, water, sweets and fizzy drinks (if applicable) 
have been transported @emph{to} the city.

@cindex extended town data
Other switches that enable collection (but not display) of the additional 
statistics and other @dfn{extended town data} when turned on include
@option{towngrowthlimit},
@option{largertowns},
@option{towngrowthratemode},
and @option{bribe}.

If the extended town data are enabled town populations are not limited to 65535.

This patch was contributed by Marcin Grzegorczyk.

@putimage{townstat, 2.5in}

@metanode @section,New Wagon Age Rating,New calculation of station ratings for aging wagons
@switch{newagerating, -Ya}

TTD's station ratings depend on the age of the last wagon of a train that can carry
the cargo in question.  The rating will be highest if the wagon is less than a year old,
and will be lowest three years later.

With this switch active, the maximum rating is maintained for the first five years,
then it slowly drops to the minimum, which it reaches at the age of 21 years.

This patch was contributed by Csaba Varga.

@metanode @section,Build on Slopes,Build more items on sloped tiles
@switch{buildonslopes, -Yb}

Normally, what you can build on slopes (sides of a mountain) is very limited, tracks
and roads can only be parallel to the incline, not in any other direction.

With this switch, you will have more options for things to build on sloped tiles:

@itemize @bullet
@item Depots and truck and bus loading bays 
can be built facing towards the mountain or sideways, but not downhill
@item Tracks, railway stations and roads can be built perpendicular to the slope
@item Railway stations can be built over small ``holes'' in the ground, if they are at most
one height level deep
@item Edges of airports and company headquarters can be one height level lower than the rest
@item Heliports can be built on sloped tiles
@item Lighthouses and transmitters can be built (in the scenario editor) on sloped tiles, including coasts
@item Inclined tracks and roads with inclined foundations on tiles with one raised corner
@item Bridge heads on tiles with one raised or one lowered corner (but the ground under the bridge itself must still be flat)
@end itemize

Note that it is always impossible to build on so-called ``steep slopes'', which have a 
height difference of two levels between opposite corners.  You can only build on 
slopes that have a height difference of at most one level.  You also can't change the
altitude of a tile corner on which there is a foundation.

One very useful side effect of this is that you can now build stations over several
height levels.
@ifclear TXT
See the picture below for an example.
@end ifclear
Simply place for example 
one or more train station platforms, then add other platforms or other station
facilities next to it, on the higher level.  Adding more platforms of course only 
works if @option{largerstations} is on, and only if the lengths and orientations match.

The AI players would be of course unable to connect tracks and roads built on 
foundations properly, so they're not allowed to use this feature, except for placing
their HQs and airports.

This patch was contributed by Marcin Grzegorczyk.

@putimage{slopes}

@metanode @section,Experimental Features,Enable experimental features of the patch
@switch{experimentalfeatures, -XF}

This switch enables some features of the patch that are still considered to be under
development.

It is a bit switch.  To find out how that works, see
@ref{Bit Switches}, or simply add up the values of the options you want.
For TTDPatch version 2.0, you have the options:

@multitable @columnfractions .05 .09 .85
@item Bit @tab Value @tab Meaning
@item 0 @tab 1 @tab Slow down trains before road/rail crossings to avoid collisions
@item 1 @tab 2 @tab Very experimental support for new stations 
(don't ask how it works yet!)
@item 2 @tab 4 @tab The TTD newspaper will be in colour starting from the year 2000
@item 3 @tab 8 @tab Vehicle orders can be shared or copied. See below.
@item 4 @tab 16 @tab A news message appears when a crashed train is cleared (with morenews on)
@item 5 @tab 32 @tab Colour-code vehicle profits in the vehicle list, see below.
@item 6 @tab 64 @tab Don't show company finances on every January 1st.
@end multitable

This switch is not enabled by default or by the @option{-a} command line switch, 
because the features are still under development.

How to use shared/copied vehicle orders:
@enumerate 
@item Open the vehicle orders window as usual, and click ``Go to''
@item Hold @kbd{Ctrl} and click on another vehicle instead of a station
or depot.
@item Now the two vehicles use the same schedule. If you modify
the schedule of either of them, the other will change, too.
@end enumerate

You can link as many vehicles as you want this way.
For example, you can give the orders normally to the first
vehicle
of the route, then make the others share its schedule, so
if you want to change the route later, you have to do it only
once.
You can tell wheter a schedule is shared by looking at the
last entry.
If it's ``End of orders'', it's a normal schedule. However, if
it's
``End of shared orders'', it applies to more vehicles.  Shared orders use only
one entry in the internal order list, no matter how many vehicles are using it.
This means it's a way to conserve the limited number of orders (5000) if you have
many vehicles.

If you do these steps without holding @kbd{Ctrl}, the orders will simply be
copied
instead of sharing them.  Then you can change the orders of all vehicles 
independently.

You can reset a schedule (to clear it or to make it unshared) this way:
@enumerate
@item Make sure that no orders are selected in the schedule
window, or the last one (``End of (shared) orders'') is selected.
@item Press the Delete button of the window. All orders will be
cleared from the schedule.
@item If you do this on a vehicle with shared schedule, only that
vehicle will be affected, the others will still have the shared
schedule.
@end enumerate

This way you can unlink a vehicle if you don't want it to use
the shared schedule any more.

Unfortunately, this feature won't work in multiplayer, except copying
orders without @kbd{Ctrl}.

Colour-coded vehicle profits:  TTD uses last year's profits of the least profitable
vehicle that is at least two years old to determine part of the performance score. If
the profit of the least profitable vehicle is the equivalent of 20,000 pounds or more, 
you get the full score.  If it is zero or less, you get no score for it, and in between
you get the appropriate partial score.  With this feature, you can quickly see if you
have any vehicles that cause you to not have a perfect score.  Their profit will show
up in red if negative, or in yellow if below 10,000 pounds.  Vehicles with 10,000 pounds
of profit in the last year will be green.  Vehicles that are less than two years old
will not be rated, and will be in black.  This means that if any of your vehicles in the
four categories is yellow or red, your score will suffer.

The first two features were contributed by Oskar Eisemuth, the others by Csaba Varga.

@metanode @section,Track Type Cost Differences,Make different types of track cost differently
@switch{tracktypecostdiff, -Yc}

Normally, all types of track cost the same in TTD.  This does not take into
account that more sophisticated track is realistically expected to be more
expensive.

With this switch, different types will have different costs.  Regular railroad will
have the same price as before, but more sophisticated track types will be increasingly
more expensive.

This patch was contributed by Oskar Eisemuth.

@metanode @section,New Plane Speed,Make planes have the correct speed in the game
@switch{planespeed, -YP}

TTD normally divides a plane's speed by four when calculating how fast it should
move across the map.  Thus it will seem really slow when compared to fast trains
for example.

With this switch, planes move as fast as their speed indicates.  This means that they
will be extremely fast in the game, and are difficult to click on with the mouse unless
the game is paused.  However, they do have a speed consistent with all other vehicle
types.

This does not affect anything except motion across the map, for
example the speed used in the station ratings calculation is still calculated 
differently for planes.

@metanode @section,Build on Coasts,Build on coasts without having to bulldoze the water manually
@switch{buildoncoasts, -YC}

This switch allows you to build items on coastal tiles that are partly land and partly
water.  Normally you would have to bulldoze the tile, and quickly build on it before
the water returns.  If this switch is active, you don't have to manually bulldoze
first.

This option is most useful when the @option{buildonslopes} switch is also enabled 
(see @ref{Build on Slopes}), as it gives you a much wider choice of things that 
can be built on sloped tiles like the coastal ones.

Note that you still have to pay for the cost of bulldozing, so building on the tiles
can still be very expensive if more than one edge has water on it.

This patch was contributed by Marcin Grzegorczyk.

@metanode @section,Sell Entire Trains,Sell entire trains by selling the engine with Ctrl
@switch{fastwagonsell, -Yw}

It can be very annoying to have to sell each wagon individually when selling a train.
With this switch, all you have to do is hold down @kbd{Ctrl}, sell the engine, 
and the entire train will be sold.

Alternatively, you can sell all wagons behind a certain wagon, by selling that wagon and 
holding down @kbd{Ctrl} as well.

This patch was contributed by Csaba Varga.

@metanode @section,New Road Vehicle Crashes,Choose what happens when trains and road vehicles collide
@switch{newrvcrash, -Yr}

This switch changes what happens when a road vehicle collides with a train.  It has
two possible settings:

@itemize @bullet
@item ``newrvcrash 1'' changes it such that the train that was involved in the collision
has a breakdown, as well as destroying the road vehicle
@item ``newrvcrash 2'' disables the collisions entirely, trains will just drive through 
road vehicles without doing any harm to them
@end itemize

This patch was contributed by Csaba Varga.

@metanode @section,Stable Industries,Industries never close down when stable economy is selected
@switch{stableindustry, -Xi}

Sometimes, industries can reduce their production and close down.  This happens even if a stable
economy is selected in the difficulty settings.

With this switch enabled, industries will never close down with a stable economy, 
as in the original Transport Tycoon.

This patch was contributed by Csaba Varga.
