@c	vim: syntax=texinfo

@metanode @chapter,Additional Reading,Some in-depth information about various aspects of the patch.
@c --------------------


@metanode @section,Sign Cheats (detailed),A detailed description of all sign cheats
@c --------------------------
@cindex @t{Cht: <cheat>}


@metanode @subsection,Money Cheat,Change how much money you have

@cheat{Money,<number>}

Sets your cash to the number, given in British pounds.  For example, with
@t{@w{Cht: Money 1000000}} as a sign name you will have the equivalent
of one million pounds in your selected currency.


@metanode @subsection,Year Cheat,Change the current year
@cindex date cheat

@cheat{Year,<number>}

Changes the current year, and this works in both directions.  Now you
can start your game in the year 2030 with all the Maglevs available,
or change it back from 2070 when time stops.  The year can be anything
from 1921 to 65535 if ``eternalgame'' is on.  Without eternalgame, the years
can go only to 2098, although years after 2072 or so won't work
correctly because time stops somewhere around then.  This cheat really
sets the date to December 31st of the previous year, so that the year
change can be processed properly.  That's also the reason why you can't jump to
the year 1920, because the date would have to be set to Dec 31st 1919, which doesn't
exist in the game.

@cindex game hangs before 1930
Note that when jumping to a year before 1930, you must have ``generalfixes'' on.
Otherwise, the game will lock up when a town
tries to build another house.

The cheat also updates the age and service intervals of all
vehicles, lest all of your vehicles go to the depot after increasing the
year, because they have suddenly aged many years in a few seconds.

It's a good idea to activate the ``persistent engines'' patch, or
you might run out of engines to buy, because their lifetimes are
too short by default.

@putimage{yearcht, 3in}


@metanode @subsection,Automatic Track Conversion,Convert track to monorail, maglev
@cindex track conversion
@cindex converting tracks

@cheat{Tracks,<to> [<from>] [?]}

This will change all the tracks that are currently the @option{from} type (or
all if @option{from} is not given) to the new type set by @option{to}.
The types are 0=Railroad, 1=Monorail (or Electrified if enabled), 2=Maglev.

So, for example @t{@w{Cht: Tracks 2 1}} will change all your monorail tracks
to maglevs, or @t{@w{Cht: Tracks 1}} would convert everything to monorail.

Also, all the trains of that type will be fitted with a new undercarriage and
a new drive system, otherwise
they would blow up because they are on the wrong track.  However, if you're using
electrified railways (see @ref{Electrified Railways}), @t{@w{Cht: Tracks 1 0}} will convert all regular track to
electric, but it will @emph{not} convert steam or diesel engines.

If the ``CheatsCost'' switch is enabled, this cheat will calculate the cost
for all replacements, and deduct it from your bank account.  Use the
question mark to inquire about the cost without actually activating the cheat.


@metanode @subsection,Cheat Detection,Find out what cheats were used in a game
@cindex detecting cheats

@cheat{Used}

Use this to show which of the sign cheats have been used in the
current game.  It is intended for competitions where the use of some
of the sign cheats is not allowed.  The value is a hexadecimal bit
mask of the following hexadecimal bit values:

@multitable @columnfractions .04 .1 .8
@item Bit @tab Value @tab Cheat
@item   0 @tab     1 @tab Money
@item   1 @tab     2 @tab Year
@item   2 @tab     4 @tab Tracks
@item   3 @tab     8 @tab Used
@item   4 @tab    10 @tab OwnCrossing
@item   5 @tab    20 @tab Renew
@item   6 @tab    40 @tab DumpMemory (obsolete)
@item   7 @tab    80 @tab AllNonStop
@item   8 @tab   100 @tab NoNonStop
@item   9 @tab   200 @tab ServInt
@item  10 @tab   400 @tab ResetStation
@item  11 @tab   800 @tab AllVehicles (used to be AllEngines)
@item  12 @tab  1000 @tab ClearPreSig
@item  13 @tab  2000 @tab RemoveVehicles (used to be RemoveEngines)
@item  14 @tab  4000 @tab ClearGhosts
@item  15 @tab  8000 @tab PlayerID
@item  16 @tab 10000 @tab NoUnload
@item  17 @tab 20000 @tab ResetVehicles
@item  18 @tab 40000 @tab Semaphores
@item  19 @tab 80000 @tab PlantTrees
@item  20 @tab 100000 @tab Subsidy
@item  21 @tab 200000 @tab Debugger
@item  22 @tab 400000 @tab Graphics
@end multitable

The value 8 for the ``used'' cheat will always be present
because you have to use the cheat to see it, after all.


@metanode @subsection,Road/railroad crossing owner bugfix,Regain ownership of your track/road crossings

@cheat{OwnCrossing}

There's a bug in TTD that causes road/railroad crossing to be taken
over by the local authorities when you import a savegame to
the scenario editor, and then load it back as a savegame, and 
possibly in other circumstances too.

If this bug occurs, you'll be able to remove the road instead of
the tracks.  The tracks will belong to the city and can't be removed.
The road will belong to the city as well.

Using this cheat, all these crossings will be given back to you, so
that you can remove the tracks, but not the road (unless that really
was yours, which shouldn't have triggered the bug).

If you've already removed the road, you have to put it back there for
this to work.  This cheat only affects crossings, nothing else.

The tracks will always be owned by the first human
player, because ownership information is lost
completely and the correct owner can't be determined.  A future
version of the patch will fix this by tracing back the railroad track to
determine whose tracks they really are.


@metanode @subsection,Train car renewal,Renew all train cars for better ratings
@cindex renewing train cars

@cheat{Renew,[?]}

It would be a good idea to frequently renew the rolling stock, mostly
train cars, because the age of them affects station ratings.  (It's
the difference between the year they are built and the current year
that counts).  Problem is that, like upgrading all tracks, it is a
very tedious process.  This cheat will make this easier.  It changes
the age of all carriages to zero, sets the ``year built'' to the current
year and updates their value to the current price.

Note that this does not affect the engines, only the carriages.  To renew
the engines you will still have to send them to a depot.

If the ``CheatsCost'' switch is enabled, this cheat will calculate the cost
for all replacements, and deduct it from your bank account.  Use the
question mark to inquire about the cost without actually activating the cheat.


@metanode @subsection,Train non-stop command modifications,Set all commands to ``non-stop'' (or not)
@cindex non-stop command

@cheat{NoNonStop}

With this you can remove the ``non-stop'' flag from the commands of all your
trains.  It is useful to do when you turn on the new non-stop handling for
example.

@cheat{AllNonStop}

This switch sets all your trains' commands to ``non-stop'', when you don't
want to use the new non-stop handling anymore.


@metanode @subsection,Service interval changes,Change the service interval of all your vehicles

@cheat{ServInt,<days> [<types> [<ai>]]}

With this cheat you can modify the service interval of all existing vehicles.
It will be set to the given number of days.

If you specify a second number, it will determine what type of vehicle you
want to change.  It is a bit-coded number, with the bits meaning the following:

@multitable @columnfractions .04 .09 .2
@item Bit @tab Value @tab Vehicle type
@item   0 @tab     1 @tab Trains
@item   1 @tab     2 @tab Road Vehicles
@item   2 @tab     4 @tab Ships
@item   3 @tab     8 @tab Aircraft
@end multitable

Simply add all the values for the types of vehicles that you want to modify.

If you specify a third number (and it is not zero), you can tell TTDPatch to
modify the other players' vehicles as well.


@metanode @subsection,Station reset,Reset cargo, acceptance and ratings of all stations

@cheat{ResetStation,[<all>]}

This sign cheat allows you to reset all stations to a state as if they had just
been built.  This can be useful if some industries close down and the cargo
rating drops to zero, in which case this type of cargo will be removed from 
the list, along with all others.
It is also useful in conjunction with the ``selectgoods''
patch, because it also resets which goods will appear at a station, in case you
want to rearrange the goods across different stations.

If you just name the sign @t{@w{Cht: Resetstation}}, then only your stations will
be affected.  However, if you add a ``@t{1}'', as in @t{@w{Cht: Resetstation 1}}, 
then it will affect all stations, even those owned by computer players.


@metanode @subsection,Purchase list modifications,Add or remove engines from the list of vehicles for purchase
@cindex adding engines

@cheat{AllVehicles}
@cheat{AllEngines,,(obsolete)}

This will make it possible to purchase all engines and wagons available in the
current climate, if they have been introduced already.
Use this if you can't buy some engines because you forgot to turn on persistent engines.

Note that it will not make engines available, which have yet to be introduced.  If you
want to have those engines too, you need to use the Year cheat first.  The AllVehicles
cheat is only intended for games in which some of the engines have expired already,
not for those where they aren't available @emph{yet}.

@cheat{RemoveVehicles}
@cheat{RemoveEngines,,(obsolete)}

As the name would imply, this cheat is the exact opposite to the above cheat.
Namely, it removes all engines from the list of engines that can be bought,
unless the engine is currently in use.  In that respect, it behaves a lot
like persistent engines, except that the engines are removed immediately and
not only after they get too old.  Train wagons are not affected.

Those engines that have yet to be introduced will be available at the time of
their introduction, that is, the RemoveVehicles cheat does not affect an engine
until it was available for purchasing.


@metanode @subsection,Reset Vehicle Data,Reload updated vehicle data
@cindex engine data
@cindex vehicle data
@cindex TTD Alter

@cheat{ResetVehicles}
@cheat{ReloadEngines,,(obsolete)}

Normally, it is not possible to change a vehicle's date of introduction
or the climates in which it is available in a savegame.
All such changes (for example using TTD
Alter or the ``newships'' switch) are only available after starting a new
game.

With this sign cheat however, all values are reloaded and all modifications
are included in the current game.  Note that this may also cause some
vehicle types, including those you're using, to disappear from the market.  
The vehicles you have already bought are safe, though.  
If a vehicle type disappears that you would like to be available, 
you may use the @t{@w{Cht: AllVehicles}} cheat to make all vehicle types available.  
This, however, will not work if an alternative vehicle set (see @ref{New Graphics}), 
in which your vehicle type does not exist, is loaded.

Reliabilities, introduction dates, names and other properties of vehicle types 
are also reset when you use this cheat.


@metanode @subsection,Pre-signal removal,Remove all pre-signal setups, or only automatic ones
@cindex removing all pre-signals

@cheat{ClearPreSig,[<all>]}

This clears pre-signal setups and reverts signals back to the normal
type.  If <all> is specified and non-zero, the cheat clears all pre-signals,
even manual ones.  Otherwise, only automatic pre-signals will be reset.

Note that if automatic pre-signals are enabled, the signals will be converted
to pre-signals again when a train enters the corresponding block, as long as
they are a valid automatic pre-signal block (see @ref{Pre-signals (detailed)}).


@metanode @subsection,Ghost station removal,Remove ghost stations

@cheat{ClearGhosts}

Previous versions of TTDPatch (before 1.8) had a bug that sometimes caused the
creation of ``ghost'' train stations.  These are either station buildings on the
map without an associated station sign, or station signs where the train
station did not exist.

This cheat will correct both problems.  The first case will be converted to
plain tracks, so that these can then be removed.  (They can't be removed automatically
in case there are trains on these tiles.)  The second case will lose the
train facility, and turn into a gray sign that eventually disappears,
if the train terminal was the only facility.

Note: Always save your game before using this cheat, because it might remove
stations that look alright, but are in fact ghost stations.  If you find a 
station gets removed that you want to keep, place an additional facility right
next to it (e. g. a bus station), and re-build the station after using this
cheat.


@metanode @subsection,Switching companies/players,Switch control to a different company or player

@cheat{PlayerID,<num> [<temp>]}

Note: this sign cheat has largely been superceded by the new subsidiary
management.

You can switch control to a different company or player using this cheat.
The parameter is the number of the player, ranging from 0 to 7.  If the
company doesn't exist or is another human player (in multiplayer games), the
cheat will fail, otherwise you now own a different company.

If you specify <temp> and it is not zero, the company is only taken over
temporarily, and you can switch back using @t{@w{Cht: PlayerID}} with no
parameters, or with your original company ID as the number.
Without <temp>, the takeover is permanent, which means that
the computer AI will take over your old company.

If you intend to switch back to your old company, make sure
that you do a temporary takeover, otherwise the computer may shut down several
of your lines, or waste money by building some of its brain-damaged routes.

You may also find it easier to switch temporarily by using the subsidiary
management (see @ref{Subsidiaries}).


@metanode @subsection,Clear unload option,Remove unload option from all orders

@cheat{NoUnload}

When taking over an AI company using either @t{@w{Cht: PlayerID}} or the
subsidiary management, you will notice that most of their services use the
unload command on all orders, even though it is unnecessary.  As a result,
all of these services will be considered to be feeder services (see
@ref{Feeder Service}) if you have enabled them.  This
means that they will not earn any money and no cargo will ever reach a final
destination.

This cheat will remove the unload command from all orders, so that you can
take over an AI company without having to go through all orders manually.


@metanode @subsection,Change Semaphores,Change to or from semaphore signals

@cheat{Semaphores,0/1 [tracktype]}

This sets all signals to be light signals (if 0) or semaphores (if 1).  Optionally
you can restrict the conversion to the given track type.  Note that to see the
semaphores, the ``semaphores'' option has to be turned on and you must have loaded
the semaphore graphics.


@metanode @subsection,Plant Many Trees Cheat,Plant a large rectangular area of trees

@cheat{PlantTrees,[<SizeX>] [<SizeY>] [<type>]}

This cheat plants a rectangular area of trees around the location of the sign.  It is
especially useful to plant trees for a lumber mill, just place a sign with
@t{@w{Cht: PlantTrees}} on top of the lumber mill.

If SizeX is given, it specifies the size of the rectangle in the X direction.  
By default the size is just right to cover the range of a lumber mill (40 squares).

If SizeY is given, it specifies the size of the rectangle in the Y direction.  If
not given, the size in Y direction is the same size as in X direction.

Finally, you can specify the tree type as a number from 0 to the maximum tree type.
If not given, random trees are planted.


@metanode @subsection,Remove Headquarters,Remove headquarters

@cheat{RemoveHQ}

This cheat removes your company headquarters.  For example this is useful if you want
to move the headquarters to a different city, or if they're in the way of your railway
tracks.


@metanode @subsection,Switch Climate,Switch to a new climate

@cheat{Climate,<newclimate>}

This cheat switches to the given climate: 0=temperate, 1=arctic, 2=tropical,
3=toyland.

It is somewhat dangerous, because it means that the existing industries and vehicles
are for the wrong climate.  This means that some of your transport routes may be useless
and need to be adjusted.  It is advisable to keep a backup savegame from before using
this sign cheat in case something goes wrong.

This cheat may be useful for example to buy vehicles that are not normally available
in the current climate.

Note that the climate-specific graphics will not change until you save and reload the
game.


@metanode @subsection,Subsidy Cheat,Make TTD offer a new subsidy

@cheat{Subsidy}

This cheat forces the offer of a new random subsidy.  Note that it may fail if TTD is unable
to find any sources with cargo in need of a subsidy, or if the maximum of 8 subsidies 
has been reached.


@metanode @subsection,Debugger Cheat,Enable TTD's internal debugger

@cheat{Debugger}

This cheat shows the window of TTD's built-in debugger.  It shows some statistics about
the game, for example how much memory is used, how many vehicles there are and other
things.

@metanode @subsection,Graphics Cheat,Activate or deactivate new graphics sets

@cheat{Graphics,[<ID> [0/1]]}

With this cheat, you can selectively activate or deactivate specific new .grf files.

If entered without any parameters, all graphics will be activated if they can.

If you say ``Cht: Graphics <ID> [0/1]'', you
can activate or deactivate a specific graphics file, identified by the
GRFID.  If you leave off the 0 or 1, it will be activated by default.  To
find out the right graphics IDs for a certain .grf file, you can use
Shadow's Graphics Manager, available from 
@uref{http://www.ttdpatch.de.vu/}.  
Note that for these activations/deactivations to be permanent,
``saveoptionaldata'' must be @emph{on}.

Note also that you can't for example activate the tempset if the dbset is
already active, because these two sets are mutually
exclusive.  You have to turn off the first one, then turn on the second one
if you want to switch.

Here's a list of some GRFIDs:

@itemize
@item arcticset: 6D620104
@item dbset: 6D620400
@item newships: 6D620004
@item tempset: 6D620204
@item cargoset: 6D620305
@end itemize

Finally, this switch forces the vehicle list to be reset, so that new vehicles
are available and have the correct stats.  In effect, this is the same as
@w{@t{Cht: ResetVehicles}}.  See the description of that cheat for more details.


@metanode @section,Pre-signals (detailed),In-depth information about pre-signals and useful setups

Usually, making an efficient station where all trains can go to all platforms
is very difficult, because if all platforms are in use, the trains randomly
choose one and wait till the train occupying it leaves.  If that train is
set to ``full load'' this may take a long time, the station will be blocked
until that train leaves.  One workaround is to have
``overflow'' tracks, where the train goes if everything is full.  While this
works, it makes the train run all the time while waiting for a platform.  This
is very inefficient, and it takes up a lot of space which might be an 
issue especially for a city station.

These new pre-signals on the other hand 
work similar to what is also often called ``home signals''
or ``entrance signals''.  The regular TTD signals are called
``block signals'', because they always indicate whether the block protected by
them is occupied, no matter where the train actually wants to go.

@metanode @subsection,How pre-signals work,Detailed information about the prinicples behind pre-signals

TTDPatch's pre-signals work differently, more like most real-life
station signals, or similar to advance signals.
They state whether a train can enter a station by looking
if there is a free platform, not just by looking if the entrance is clear.

The basic principle is very simple: a pre-signal shows a green light if,
and only if, there is a green exit from the block behind it (or if there
are @emph{no} exits at all).  In the context
of a station entrance, for example, this means that trains will enter the
entrance only when there is at least one platform it can go to.  If there isn't,
it will wait in front of the pre-signal, and not block the station entrance.

@putimage{presig1, 4in}

This simple principle can allow you to build very efficient yet simple
stations, but first you have to understand how.  The next few sections
attempt to explain in more detail what the different types of signals
are.

With these signals, is quite easy to have a small and yet very efficient station
without the usual problems you get with busy stations, because now trains will
be able to queue in front of a station, and get to the platforms in the order that
they've arrived in.

Note that pre-signals @emph{do not} change @emph{where} a train goes, only
@emph{when}.  You cannot use them to tell trains where to go, instead you 
should use waypoints for that (see @ref{New Non-stop Handling}).

@subheading Types of signals
@c ---------------------------
@cindex pre-signal types

In the context of pre-signals, there are four different types of signals:
plain signals, pre-signals, pre-signal exits, and combo signals.

@cindex combo signal
@cindex exit signal
@multitable @columnfractions .14 .45 .35
@item Type @tab Appearance @tab Function
@item Plain signals @tab Single green light, no bar @tab normal
@item Pre-signals @tab Double green light, horizontal yellow bar @tab Entrance to a pre-signal block
@item Exits @tab Double green light, vertical gray bar @tab Exit from a pre-signal block
@item Combo @tab Double green light, vertical yellow bar @tab Between two pre-signal blocks
@end multitable

Pre-signals and combo signals are the only signals that really @emph{behave} differently, the
exits only affect how the other signals behave.

@putimage{presig2, 3in}

Pre-signals will show a green light if any of the exits or combo signals behind it show
green.  They prevent a train from entering a block unless it can leave it quickly.  A
pre-signal with no exit signals will behave as a normal signal, to allow the use of two-way pre-signals 
(where the other direction would usually lead to a route serviced by one train only).
The pre-signal only considers actual exit signals when deciding whether to go green or remain red, 
even if there are other, non-exit signals that would allow a train to leave the block.  Pre-signals
can be either one-way or two-way signals, but will usually be one-ways.

Pre-signal exits are signals leading away from the pre-signal block, and should normally be
two-way signals, so as to give the train a choice.  If they were one-way signals, the trains
would all attempt to go to what they consider the ``best'' choice, even if there are other
green signals they could go to as well.  Therefore, an exit will in almost all cases have to
be a two-way signal.

Combo signals are a combination of both pre-signals and exits.  They serve as exit to a
prior pre-signal, but are a pre-signal themselves.  As such, they are to be placed between
two pre-signal blocks, so that trains can go to the additional exits behind a combo signal
if they need to, but the blocks are still separate and allow a train in each block.  Please
see below for a specific example.  Note that combo signals are not as useful as they should
be, because they currently have some limitations.  In the case where all exits are blocked, and 
trains are waiting at both pre-signal blocks, both trains will start moving when one exit becomes
available, but of course there is only one platform, so one train ends up waiting in the
pre-signal block.

Unlike pre-signals, combo signals with no exit signals always show red.

@metanode @subsection,Automatic pre-signal blocks,How to set up automatic pre-signal blocks
@c -------------------------------------

With automatic pre-signal setups enabled (see @ref{Pre-signals}), all
signal blocks that satisfy the following conditions will be converted to
pre-signal blocks:

@enumerate
@item At least one one-way signal going in
@item At least two two-way signals
@item At least one of these two-way signals leads to a block
with another one-way signal going out, or an end-of-line.
@end enumerate

@c [ there will be a picture here explaining automatic blocks ]

If these three conditions are met, the one-way signals from condition 1 will
be turned into a pre-signal, and the two-way signal(s) satisfying condition
3 will be turned into pre-signal exits.  All other signals are left as they
are, in particular, non-conforming two-way signals will not be converted.

@need 4000
@metanode @subsection,Specific examples of useful pre-signal setups,Terminus station, through station and overflow loops

@subsubsection The through station
(sometimes called ``roro'' or roll on/roll off station)
@c -----------------------

@cindex through station
@cindex roro station
Such a station should be built like this:

@putfigure{through, 6in}

There are four sets of signals involved, labelled 1 to 4.  Signal 1
is the pre-signal, and only go green if any of the exit signals 2 are green.
Signals 3 are those letting the trains out of the station.  Finally, signal 4
terminates the exit block.

The following conditions have to be met for this to qualify for automatic
conversion.  Note that if you convert it manually, it will work like you
might expect.

@enumerate
@c @bullet
@item Signal 1 must be a one-way signal leading into the station.  This is the 
pre-signal.
@item All of signals 2 must be two-way signals.  There have to be at least two
of these.  (Otherwise pre-signals are useless.)
@item All of signals 3 must be one-way signals leading out of the station
@end enumerate

Also, even though not shown in the figure,

@itemize @bullet
@item There can be more than one of signal 1
@item There can be more than one of signal 4 (or none, or a two-way)
@item You don't have to follow the actual track layout, it can go in any
  direction you like.  It doesn't even have to be at a station.
@end itemize

If conditions two and three are only met for part of the signals, it will work
neither as it should, nor as it did before pre-signals.  Those signals will
not be converted to exits, so the pre-signal will not consider them when
deciding to go green.

To repair a signal stuck at red, you'll have to modify its pre-signal 
setup with the @kbd{Ctrl} key, or remove and replace it.


@subsubsection The terminus station
@c ------------------------

@cindex terminus station
@putfigure{terminus, 5in}

This very compact layout of a station 
is often useful in a city, where there is not enough
space for a full roro station.
Here, the same conditions apply as in the previous case, and there can also be
more than one of signals 1 and 3.

You can even combine both types of stations, i.e.  have some of the platforms
go through and others end.

@subsubsection Improved overflow loops
@c ---------------------------------------

@cindex overflow loops
These improved overflow loops are useful at the entrance of a busy station,
where you need to prevent traffic backup into the main line.

@putfigure{overflow, 5in}

Here, (a) is the usual way to the station, and it's used if there's no train
waiting.  Make sure
that your longest train will fit entirely on (a) to make this work.  If there
is already a train waiting, other trains will take route (b) and line up at
signal 6.  You can make (b) as long as you like.  It should have a few one-way
signals 7 along the way to allow several trains to line up.

A few important points:

@itemize @bullet
@item Signal 1 is the pre-signal leading into the station
@item Signals 5 have to be two-way, or all trains will want to use route (a)
@item Route (b) can either cut into route (a) before signal 1, or lead directly
  into the station.  I recommend the above setup (connecting before signal 1)
  because that way all trains will use the overflow if it is in use.
  Otherwise trains will be able to take the shortcut even though they should
  line up at the end of route (b).
@item Signal 6 has to be a one-way signal, as does signal 1.
@item If you put a one-way signal before signal 5, it will be a pre-signal
@end itemize

This has a few advantages over a regular overflow loop.
First, the trains only have to use it once before lining up at
signal 6 and don't continue to loop until a platform is available.  Also, even
if the station is full, at least one more train will not have to use it, only
if two or more trains are waiting will it be used.  Third, one of the
waiting trains will enter the station as soon as a platform is free, without
having to complete a loop because it already is waiting at the station
entrance.  And lastly, the trains will be served in the order that they arrive
in.  In an overflow loop, there is no guarantee that a train will not loop
indefinitely at a very busy station, just because newly arriving trains steal
into the platforms.

@subsubsection Example savegame

Many aspects of pre-signalling can be
confusing to those new to it.  To help with the understanding,
I have created a demonstration with a small savegame that you can
@uref{http://www.ttdpatch.net/presig.zip, download}.
Please make sure that it won't
overwrite one of your savegames.  The save file is @file{trt56.sv1}, so if you
already have that file, make a copy of it.  It features both a through
station and a terminus station, and has two improved overflow loops.

I encourage you to test this savegame with the pre-signal switch disabled,
too, so you can see the difference it makes, and try different numbers of
trains (as low as 7 maybe) by sending them to the depot, and more or fewer
platforms at both stations.


@metanode @section,New Graphics,In-depth explanation of how to enable and use the new graphics

@metanode @subsection,New Graphics Installation,How to install new graphics

Here's the executive summary:

@enumerate
@item Download the graphics
@item If you don't have it yet, create a new folder called @file{newgrf} in the TTD directory
@item If the files are in @file{.zip} format, unzip them. Make sure the @file{.grf} files
go into the @file{newgrf} folder
@item Add the new @file{.grf} files to either @file{newgrf.cfg} (DOS) or 
@file{newgrfw.cfg} (Windows) in the TTD folder.  Create that file if it doesn't exist.
@item Start a new game in TTD, or see the instructions below on how to import new
graphics into existing savegames
@end enumerate

Here is an example of a @file{newgrfw.cfg} file, in this case for the Windows version of TTD.
For the DOS version, simply remove the ``W'' or ``w'' at the end of each name.

@example
newgrf/newshipsw.grf
newgrf/cargosetw.grf
newgrf/dbsetw.grf
newgrf/tempsetw.grf
newgrf/signalsw.grf
newgrf/elrailsw.grf
newgrf/arcticsetw.grf
newgrf/trkfoundw.grf
@end example

You can temporarily disable a graphics file by putting a hash mark, ``#'' in front
of it in the configuration file.  Also, some graphics files allow you to modify some
of their options by putting numbers behind the graphics file.  For more information,
refer to the readme file that should have come with the specific graphics file.

For example, the DB set normally replaces all railway crossings with versions that have
gates instead of lights.  If you don't want that, you can use the line

@example
newgrf/dbsetw.grf 2
@end example

For other possibilities, refer to the readme files of each graphics file.

@metanode @subsection,Use of New Graphics,How to use them

This section explains how to deal with the multitude of graphics files, some of
them being mutually exclusive.

Most of the new graphics sets are designed for a certain climate.  They will only work
in the right climate, for example you can't use the DB set in anything but the temperate
climate.  The DB set is also incompatible with the Temperate set (``tempset''), 
which means only one of the two can be active at the same time.

The most important switches that control activation and automatic selection of graphics
are ``loadallgraphics'' and ``saveoptionaldata''.

If ``loadallgraphics'' is off (which is the default), only those graphics are loaded that
were loaded when the game was saved.  If you later add new .grf files to 
@file{newgrf.cfg}, those graphics won't be loaded in your existing savegames.  The reason
for this is that the new graphics also change the vehicle stats, and could lead to an
inconsistent state of your vehicles.  If you set the switch to on, all new graphics 
will be loaded when you load an existing savegame.  This switch only applies to
@emph{new} graphics, so it should better be called ``loadnewgraphics'', but for 
historical reasons it isn't.

The ``saveoptionaldata'' switch allows TTDPatch to actually @emph{save} the information about
active graphics with your savegames.  It is recommended that you always leave it turned
on.  If turned off, TTDPatch doesn't know which graphics are old and which ones are new,
so it assumes all of them are new.  In that case, ``loadallgraphics'' applies to all
entries in the @file{newgrf.cfg} file.

Additionally, you can use the @w{@t{Cht: Graphics}} sign cheat to activate or deactivate
individual graphics files.  See the description of that cheat to find out how it works.

@metanode @subsection,Graphics Errors,Error messages about graphics files

The following errors can occur when trying to load new graphics.  Each error describes
the file that caused the error, and the place within the file where the error occured
(the so-called ``sprite number'').

@itemize
@item Out of memory: TTDPatch ran out memory when trying to load more sprites.
Make more memory available to it, or remove some entries from @file{newgrf(w).cfg}.
@item Wrong .grf version: This .grf file is for a different version of TTDPatch.
Download the correct version of either the graphics, or the patch.
@item Cannot load more sprites: The total number of sprites that TTD can handle is
limited at 11484 active sprites.  You must deactivate or remove some entries from 
@file{newgrf(w).cfg} to get below that limit.
@item File not found: The specified file does not exist.  Check to make sure that
it is installed in the @file{newgrf} folder, and that you haven't made a typo when
entering it in @file{newgrf(w).cfg}.
@item More sprites than specified: This is an error caused by a corrupt .grf file.  It
has to be fixed by the author of the graphics file. It means the first entry in the
graphics file's info file is wrong.
@item File has invalid sprite: This is an error caused by a corrupt .grf file, or by
an invalid parameter in @file{newgrf(w).cfg}.  If you have one or more numbers after the
filename in @file{newgrf(w).cfg}, remove all numbers and try again.  If the error still
occurs, it's a problem in the graphics file, and needs to be fixed by the author.
@end itemize


@metanode @section,New Town Growth Mechanism,How the switches controlling town growth work in detail

TTDPatch version 2.0 introduced a host of new switches that control how fast and when
towns can grow, thanks to Marcin Grzegorczyk who wrote the feature.  This section
attempts to explain all the details and intricacies about town growth, first by 
explaining how it works in regular TTD, and then how the new switches modify this.

There are two sets of town growth switches.  The first one makes small modifications,
but keeps TTD's general town growth algorithm as explained in the
next section.  The second one allows you to 
fine-tune the town growth conditions and rates.

The first set includes @option{towngrowthlimit} and @option{largertowns}.
@option{towngrowthlimit} sets (roughly) the maximum radius to
which towns can grow.  @option{largertowns} allows a certain fraction of towns to grow
twice as fast.  For example, @w{@option{largertowns 5}} doubles the growth rate of every
fifth city, but the selection of cities for which this applies is random.
If @option{largertowns} is enabled, @option{towngrowthlimit} affects only towns 
with doubled growth rate; if @option{largertowns} is disabled, 
@option{towngrowthlimit} affects all towns.
Both these switches also apply some small modifications and bug fixes that are explained
in the next section.

The rate at which towns grow is controlled by the setting of @option{towngrowthratemode}:
@itemize
@item @t{towngrowthratemode 0} or @t{off}: TTD's original algorithm, unmodified except for a bugfix
@item @t{towngrowthratemode 1}: Improved town growth rate calculation
@item @t{towngrowthratemode 2}: Custom town growth algorithm
@end itemize

To fully understand how both the improved and custom town growth rates work, read the 
following sections.

The executive summary for modes 0 and 1: Town growth is boosted by activity 
(loading or unloading) at stations in the town's @dfn{transport zone}, the size 
of which depends on the number of buildings in the town. Up to 4 (in mode 0) 
or 5 (in mode 1) stations can contribute to the growth.  If the ``Fund new buildings'' 
action was carried out in the town within the last 3 months, stations either 
do not affect the growth rate (mode 0) or affect it weakly (mode 1).  The 
@option{largertowns} option does not double the growth rate of towns which have 
no active stations in their transport zones.

For mode 2, there is no executive summary.  All switches whose name begins with 
``towngrowthrate'' or ``tgr'' are used to control and fine-tune town growth rate.  See the
@ref{New Town Growth Switches} for the detailed description.


@metanode @subsection,TTD Town Growth,How towns grow in regular TTD

This is very technical, and only required if you want to fine-tune your town growth.
Otherwise, you can skip over this and the next section.

The basic time unit in TTD is a ``tick''.  In the following, it will
be used to describe how often something happens.  A tick of 
the simulation engine takes ca. 27 ms, if your computer is fast enough, otherwise
it takes as long as necessary.  One TTD day is ca. 74 ticks, which is about 2 seconds 
of real time on fast enough computers.

The ``expansion state'' of a town is determined by two fields in town 
structure: bit 0 in the word at the offset 0x12 (I'll call it the 
@code{growth_flag}) and the byte at 0x0A (@code{idle_countdown}):

@multitable @columnfractions 0.2 0.25 0.3
@item @code{growth_flag}@w{  } @tab @code{idle_countdown}@w{  } @tab state
@item 0 @tab any @tab blocked
@item 1 @tab 0 @tab expanding
@item 1 @tab nonzero @tab idle
@end multitable

Town status update (including expansion) is performed on every tick in a 
round-robin fashion; since the town array can hold 70 entries, the main 
town status update procedure is called every 70 ticks for each town.  If 
the town is blocked, nothing happens.  If it's idle, @code{idle_countdown} is 
decremented.  If it's expanding, an attempt to place a new building or a 
piece of road (or a bridge) is taken; if it succeeds, the expansion 
state is changed to idle by setting @code{idle_countdown} to the byte at 0x39, 
from now on referred to as @code{growth_delay} (extension of an existing road usually 
doesn't change the state to idle). Therefore, @code{growth_delay} 
determines how often the town will be in the expanding state, and thus 
is the @emph{inverse} growth rate of the town.  Smaller values of @code{growth_delay} 
mean faster growth.

@code{growth_delay} is reset each month, and depends on the number of ``active''
stations within town's transport zone as follows:

@multitable @columnfractions 0.15 0.15 0.15 0.15
@item number of @tab @code{growth_delay}
@item ``active'' stations @w{ } @tab normal @tab funded[1] @tab funded[2]
@item    0         @tab    160 [3] @tab   60      @tab    60
@item    1         @tab    210     @tab   60      @tab    60
@item    2         @tab    150     @tab   60      @tab    60
@item    3         @tab    110     @tab   60      @tab    50
@item    4         @tab    80      @tab   60      @tab    40
@item    5 or more @tab    11 [4]  @tab   60      @tab    30
@end multitable

Footnotes:
@multitable @columnfractions 0.03 0.9
@item [1] @tab When a town building fund is active (i.e., up to 3 months after
using the ``Fund new buildings'' option).
@item [2] @tab When a town building fund is active and ``towngrowthratemode'' is set to 1.
@item [3] @tab In this case the town is blocked with a 11/12 probability,
so the effective mean @code{growth_delay} is 1920.
@item [4] @tab This is a bug in TTD (array overrun).  
TTDPatch now fixes this if any of ``generalfixes'', ``towngrowthratemode''  or ``towngrowthlimit'' is 
active. If ``towngrowthratemode'' is 0 or off, @code{growth_delay} is set to 80 
(which seems to be the original programmer's intention); if ``towngrowthratemode'' is 1, it's set to 55.
@end multitable

Apart from the random blocking in the case [3], town growth is also blocked:
@itemize
@item in the sub-arctic climate, if the central tile of the town is above 
the snow line, and no food has been delivered to the town in the last month;
@item in the sub-tropical climate, if the central tile of the town is in 
desert, and no food or no water has been delivered to the town in the last 
month.
@end itemize

The switches @option{townminpopulationsnow} and @option{townminpopulationdesert} 
may be used to prevent blocking of towns with population less than some threshold,
so they get a chance to grow enough to accept food.

If ``largertowns'' is active, @code{growth_delay} is halved for selected towns,
making them grow twice as fast 
(except in the case [3] above, so transport is still necessary to 
make towns grow; this is different if ``towngrowthratemode'' is 2, 
as explained in the next section).

A station is ``active'' if any cargo has been picked up or accepted there 
within the last 50 days.  The type of cargo is irrelevant, so if there's 
a coal mine in the middle of a town and you're picking up coal there, it 
will contribute to the growth of the town.  This also means that many 
single-facility stations make a town grow faster than one multi-facility station, as long as 
they're serviced regularly.

The town's transport zone is a circular area around the town's central 
tile.  Its radius (in tiles) is a function of the number of town 
buildings as follows:

@multitable @columnfractions 0.2 0.4
@item number of town buildings @w{ }  @tab  radius of transport zone
@c  ----------------        ------------------------
@item   0--3                @tab 2
@item   4--7                @tab 4
@item   8--11               @tab 5
@item   12--15              @tab 6
@item   16--19              @tab 7
@item   20--35              @tab 8
@item   36--71              @tab 9
@item   72 or more          @tab 0
@end multitable

Notice the last row.  If there are more than 71 town buildings, the 
transport zone vanishes and stations no longer contribute to the growth. 
However, if ``towngrowthlimit'' is enabled, TTDPatch changes this by extrapolating the 
function for larger values.

Also note that the internal number of buildings may be incorrect 
in games save under old versions of TTDPatch or without TTDPatch, due to the bugs 
mentioned in @ref{General Fixes}.  However, this is not a big problem since TTDPatch 
recalculates these numbers (and populations) if the extended town data are enabled 
(see @ref{More Town Statistics}) and the game without those data is loaded, 
and all the new town growth switches do enable the extended town data.

The function called if a town is in the expanding state starts by 
searching for a piece of road in the vicinity 
of town's centre.  If no road is found, an attempt is made to create it. 
If a road piece is found, the function randomly `walks' along the roads trying 
to find a place to create a new house, or possibly branch out a new street 
or extend an existing one.  
Normally, this walk is limited 
to 20 steps (where a tunnel counts as one step), which limits the maximum 
possible extents of a town.  The ``towngrowthlimit'' switch modifies this value.

Regardless of all the town growth processing mentioned above, each town 
building's status is updated periodically (every 256 ticks). 
This includes construction progress and ``production'' of passengers and 
mail.  If the town the building belongs to is not blocked, this also 
includes destroying the building (and, with 61/64 probability, 
immediately building a new one in its place) at random intervals.  This process 
is not controlled by @code{growth_delay} or any of the new town growth switches, 
althought is does indirectly affect the growth of a town.


@metanode @subsection,New Town Growth Switches (details),How the new town growth switches work

This section describes the switches that apply in ``towngrowthratemode 2''.  They
fine tune and control every detail of town growth.

As described in the previous section,
TTD internally uses an inverse growth rate, i.e. the number of 70-tick 
time units between attempts to build a 
new house.  However, the enhanced rate calculation uses a direct growth 
rate, defined as the average number of new town buildings per 38400 time 
units, which is approximately 100 years.  At the end of calculations 
this rate is converted to the inverse growth rate.  If the inverse 
growth rate is greater than 255, it's reduced and town growth is blocked 
randomly to have the same effect on the average.

For comparison, with ``towngrowthratemode 0'' (TTD's original calculation), 
the rates are:

@multitable @columnfractions 0.2 0.4
@item     number of         @tab average rate
@item     active stations   @tab (new houses per 100 years)
@c    ---------------   --------------------------
@item     0                 @tab 20
@item     1                 @tab 182
@item     2                 @tab 256
@item     3                 @tab 349
@item     4                 @tab 480
@end multitable

@noindent or, if a building fund is active, the rate is fixed at 640 new houses per 
century.  These rates are as they're normally in TTD, except that a bug 
with 5 or more stations (see the previous section) is fixed.

For the new growth rate calculation,
we have the maximum and minimum rate, the @option{towngrowthratemin} and 
@option{towngrowthratemax} switches.  Let @var{ratediff} be the difference between the 
maximum and the minimum, i.e.

@example
   ratediff = towngrowthratemax - towngrowthratemin
@end example


Then the @dfn{base rate delta multiplier} (BRDM) is calculated as follows:

@example
  BRDM = (AS*ASW + PO*POW + MO*MOW + PI*PIW + MI*MIW + GI*GIW + FI*FIW + WI*WIW + SI*SIW + DI*DIW)
                / (ASW + POW + MOW + PIW + MIW + GIW + FIW + WIW + SIW + DIW)
@end example

where the two-letter abbreviations represent @dfn{growth boost components}
(explained in detail later in this message) depending on, respectively:

@multitable @columnfractions 0.05 0.8
@item @var{AS} @tab the number of active stations
@item @var{PO} @tab percentage of passengers transported (`passengers out')
@item @var{MO} @tab percentage of mail transported (`mail out')
@item @var{PI} @tab incoming passengers (`passengers in')
@item @var{MI} @tab incoming mail (you get the picture...)
@item @var{GI} @tab incoming goods
@item @var{FI} @tab incoming food
@item @var{WI} @tab incoming water
@item @var{SI} @tab incoming sweets/candy
@item @var{DI} @tab incoming fizzy drinks
@end multitable

Each component is a number between 0 and 1, so the result (BRDM) is also 
between 0 and 1.  The rest are weighting factors, represented by the 
following settings in the configuration file:

@multitable @columnfractions 0.08 0.8
@item @var{ASW} @tab @option{tgractstationsweight}
@item @var{POW} @tab @option{tgrpassoutweight}
@item @var{MOW} @tab @option{tgrmailoutweight}
@item @var{PIW} @tab @option{tgrpassinweight}
@item @var{MIW} @tab @option{tgrmailinweight}
@item @var{GIW} @tab @option{tgrgoodsinweight}
@item @var{FIW} @tab @option{tgrfoodinweight}
@item @var{WIW} @tab @option{tgrwaterinweight}
@item @var{SIW} @tab @option{tgrsweetsinweight}
@item @var{DIW} @tab @option{tgrfizzydrinksinweight}
@end multitable

The higher the weighting factor for some component is relative to the 
other weighting factors, the more influence the asociated growth boost 
component has on the final growth rate.  Note that it's the relation 
betwen weighting factors that matters; for instance, if all the other 
weighting factors are zero, the following set

@example
  tgractstationsweight = 10
  tgrpassoutweight = 5
@end example

yields exactly the same results as

@example
  tgractstationsweight = 2
  tgrpassoutweight = 1
@end example

The growth boost components are calculated as follows:

@table @t
@item @var{AS} = ((@var{NAS} * tgractstations) + tgractstationexist) * 10 / @var{ratediff}
except: @w{@t{@var{AS} = 0}} if @w{@t{@var{NAS} = 0}}, and @w{@t{@var{AS} = 1}} if the above term > 1, @*
where @var{NAS} = number of active stations.  If @option{tgractstationsweight} is the 
only nonzero weighting factor, then the default values, 
@option{tgractstations=10} and @option{tgractstationexist=5} result in an approximation of 
the standard TTD behaviour.  Note that @option{tgractstationexist} can be negative.

@item @var{PO}, @var{MO}
These are simply percentages of passengers and mail, respectively, 
generated by this town and transported within the last month.

@item @var{PI} = @var{PILM}/tgrpassinmax
@w{@t{@var{PI} = 1}} if @w{@t{@var{PILM}>tgrpassinmax}}, @*
where @var{PILM} = number of passengers `in' (i.e 
accepted at all stations belonging to the town) last month.  The 
rationale is that incoming passengers boost growth of a town, but only 
up to a point.

@item @var{GI} = (@var{GILM}*tgrmailinoptim)/(@var{P}*2)
@w{@t{@var{GI} = 1}} if @w{@t{@var{GILM}>(@var{P}*2/tgrmailinoptim)}}, @*
where @var{GILM} = number of crates of 
goods `in' last month and @var{P} = population of the town.  The rationale is 
that incoming goods boost growth of a town, but only up to some 
`optimum', which is directly proportional to the population of the town; 
in a sort of way, each inhabitant can consume only up to some amount of 
goods each month.  This `optimum' is defined as population per 2 crates 
of goods.  For example, if @code{tgrgoodsinoptim=20}, then a town with 
population of 400 needs @w{(400/20)*2 = 40} crates of goods each month; more 
goods will be still accepted but will not contribute to the growth of 
the town.

@item @var{MI}, @var{FI}, @var{WI}, @var{SI}, @var{DI} 
These are calculated the same way GI is, except that each 
uses its own `tgr*optim' setting.  Any cargo type not available in the 
current climate is omitted from the calculations, as if its weighting 
factor were zero.
@end table

An additional calculation is done for towns in snow and desert areas. 
It is presumed that towns above the snow line (or in desert) need some 
minimum food to grow at all.  This is defined via @option{tgrfoodinmin}, again 
as population per 2 tonnes of food.  Before @var{FI} is calculated, @w{@t{@var{RFI} = 
(@var{P}*2)/tgrfoodinmin}} is subtracted from @var{FILM} (which is, remember, the 
number of tonnes of food `in' last month); if the result is negative, 
the town will not grow at all.  Similarly, @w{@t{@var{RWI} = (@var{P}*2)/tgrwaterinmin}} is 
subtracted from @var{WILM} for towns in desert.

The base rate delta multiplier is then used to 
calculate the @dfn{rate delta multiplier}:

@example
   RDM = BRDM * ((NTB / tgrtownsizebase) * TSF) + (1 - TSF))
@end example

where @var{NTB} is the number of buildings in the town and 
@w{@t{@var{TSF}=tgrtownsizefactor/255}} (i.e. it's a value between 0 and 1, which 
determines how much of the growth rate depends on the town size, in 
percent).  This can be used to add a bit of `exponentiality' to the 
growth of towns (remember, the growth rate is expressed in new buildings 
per time unit, so with a constant rate larger towns will appear to grow 
more slowly).

Then the @dfn{real growth rate} is calculated:

@example
   RGR = towngrowthratemin + ratediff*CRDM
@end example

where @var{CDRM}=@var{RDM} if 
@tex
$@var{RDM} \le 1$, 
@end tex
@ifnottex
@w{@var{RDM} <= 1}, 
@end ifnottex
and @w{@var{CRDM=1}} otherwise.

Then, if a town building fund is active in this town, 600 is added. 
Then, if the town is one of those supposed to be larger (see 
the @option{largertowns} switch), the rate is doubled.  And @emph{this} is the final growth 
rate, in new houses per century.

As a final note, the real growth of towns is a second- or third-order 
effect of the final growth rate, so don't expect towns to grow exactly 
at the rate you've calculated from the formulae above@enddots{}  But on the 
average it shouldn't be far off.

@metanode @section,Realistic Acceleration,How the new realistic acceleration is calculated

Here you'll find out how exactly the train acceleration is calculated
if you enable realistic acceleration (see @ref{New Curve and Mountain Handling}).

This realistic model takes into account physical properties of the train, such as
engine weight, total train weight, power and tractive effort.  It is of course not
100% realistic, because it doesn't support details such as a realistic torque curve,
powered wheel arrangements (bogie types), and other things that TTD knows nothing
about.  It had to work within the description of engines offered by TTD.  As such, it
assumes that the engines always operate at optimum torque, and ignores the differences
between steam, diesel and electric propulsion (for example that usually not all wheels
of a steam engine are powered, unlike most electric engines).

The result is thus not perfectly realistic, but it is reasonably close.  It's certainly
close enough that the train acceleration ``feels'' more realistic.  For example, effects
such as friction and air drag (enhanced in tunnels) are taken into account.  Therefore
very heavy trains may not reach their stated top speed at all, or be able to make it
up a steep hill.  The acceleration also decreases the faster a train is, so that it
will accelerate very quickly in the beginning, but then take a long time to reach its
top speed.

The basis of the calculation is the maximum force that can be generated by the engine. 
This is using an idealistic model of constant power, or equivalently, constant torque, 
which is close enough to reality though, for most real engines: 

@tex
$$F_{\rm max} = P / v$$

$F_{\rm max}$ is the maximum force in Kilonewtons, $P$ is the power in Kilowatts 
and $v$ is the speed in m/s. Of course the patch has to do a conversion from TTD's units.
@end tex
@ifnottex
Fmax = P / v 

Fmax is the maximum force in Kilonewtons, P is the power in Kilowatts 
and v is the speed in m/s. Of course the patch has to do a conversion from TTD's units.
@end ifnottex

After this, the patch calculates the maximum tractive effort that the engine can 
exert on the rails. This depends on its weight (or rather, the total adhesive 
weight of all engines) and the coefficient of friction on steel: 

@tex
$$T\!E_{\rm max} = \mu W_{\rm adh} $$

$T\!E_{\rm max}$ is the maximum tractive effort in kN, $W_{\rm adh} = 9.8 m_{\rm adh}$ 
is the total adhesive weight in kN, and $\mu = 0.30$
@end tex
@ifnottex
TEmax = Wadh * mu

TEmax is the maximum tractive effort in kN, Wadh = madh * 9.8 is the total adhesive 
weight in kN, and mu = 0.30
@end ifnottex
is the coefficient of friction for steel on steel as used by TTDPatch.

The actual tractive effort is then the lower of the two values: 

@tex
$$T\!E_{\rm eff} = \min (F, T\!E_{\rm max})$$
@end tex
@ifnottex
TEeffective = min (F, TEmax) 
@end ifnottex

This is the tractive effort shown in the vehicle speed window if you have enabled that,
see below.

From this, the patch subtracts the loss forces of static/kinetic friction, 
rolling friction and air resistance, and any tangential forces from an 
inclined track to arrive at the net force: 

@tex
$$F_{\rm net} = T\!E_{\rm eff} - c_0 W - c_1 W v - c_2 v^2 - F_{\rm incl}$$

$F_{\rm net}$ is the net force in kN, $W$ is the total weight of the train in kN,
$c_0$ is the coefficient of static/kinetic friction, $c_1$ is the coefficient of 
rolling friction, $c_2$ is the coefficient of air resistance and
$F_{\rm incl}$ includes the tangential forces of inclined track.
@end tex
@ifnottex
Fnet = TEeffective - c0 * W - c1 * W * v - c2 * v2 - Fincl

Fnet is the net force in kN, W is the total weight of the train in kN, c0 is the 
coefficient of static/kinetic friction, c1 is the coefficient of rolling friction, 
c2 is the coefficient of air resistance and Fincl includes the 
tangential forces of inclined track.
@end ifnottex

For
@tex
$c_0$ and $c_1$
@end tex
@ifnottex
c0 and c1
@end ifnottex
the patch uses the same values for all trains. These values were chosen to give a
realistic feeling to the acceleration, and not strictly derived.  The reason for that
is that TTD doesn't have a consistent time scale, so that it is impossible to calculate
the values of such constants.
@tex
$c_2$
@end tex
@ifnottex
c2
@end ifnottex
depends on the top speed of the engine, to account for the 
fact that faster engines are usually streamlined.  Roughly speaking, an engine that
has twice the top speed than another engine is considered to have half the air
resistance.

The incline forces are calculated as a sum over all train vehicles: 

@tex
$$F_{\rm incl} = \sum_i W_i \sin \theta_i$$

$W_i$ is the weight of the i'th vehicle and $\theta_i$ is the slope of the incline 
for that vehicle.
@end tex
@ifnottex
Fincl = sum [ W[i] * sin(theta[i]) ] 

W[i] is the weight of the i'th vehicle and theta[i] is the slope of the incline 
for that vehicle.
@end ifnottex

The slope is taken to be either -5%, 0% or +5%, depending on whether the vehicle is
moving downhill, flat or uphill.

Finally, once the net force is known, the patch can calculate the train acceleration: 

@tex
$$a = F_{\rm net} / m$$

$a$ is the acceleration in m/s$^2$ and $m$ is the total mass of the train in kg.
@end tex
@ifnottex
a = Fnet / m 

a is the acceleration in m/s2 and m is the total mass of the train in kg.
@end ifnottex

And that's the final acceleration value used to calculate the increase in train speed
from one engine tick to the next.

If you are interested, you can see the resulting values for tractive effort and
acceleration by using custom patch texts, see @ref{Detailed Information}.  You need to
modify the ``headingfor'' entries to have them show tractive effort and acceleration.
For example, use the following format:

@example
headingfor="\95\80, \84, TE=\7c kN, a=\7c\00"
@end example

This shows the tractive effort (TE) in Kilonewtons, and the acceleration (a) in
@tex
cm/s$^2$.  The unit of acceleration is cm/s$^2$
@end tex
@ifnottex
cm/s^2.  The unit of acceleration is cm/s^2
@end ifnottex
because it is usually very small, and TTD cannot
easily show decimals.  It is only used if ``showspeed'' is on.  
Note that this can sometimes make the status bar text too wide to fit in the window,
if that annoys you, you will have to remove these displays again.

@metanode @section,Enhanced Keyboard Mapping,Remapping key combinations in TTD
@cindex enhanced keyboard handler
@cindex keyboard mapping
@cindex remapping keys

TTD uses its own character set, which is a modification of the ISO-8859-1 (also known as Latin-1) 
character set with some less useful characters replaced with special symbols.  For 
the most part, this set matches the Windows Western code page (Windows-1252), so e.g. accented letters 
may be entered directly in the Windows versions of TTD as long as your keyboard layout 
supports them.  However, it doesn't work that well if you want to translate TTD 
(see @ref{Translating TTDPatch}) to a language not covered by the Western set, like 
Czech or Polish, and you're going to modify TTD's character set to support characters 
that occur in those languages.  Non-Western Windows code pages are, unfortunately, 
more or less incompatible with TTD.  For instance, some letters that occur in 
Czech are mapped by Windows to character codes that TTD uses to change color of text.

A similar problem occurs with the Euro character (see @ref{More Currencies and Euro}), 
which in most Windows code pages is mapped to the code 128; but that code has special 
meaning in TTD, so no character may be mapped to it, and therefore TTDPatch maps the Euro glyph to 
the unused code 158.  Unfortunately this means you have to resort to key combinations 
like @kbd{Alt-0158} if you want to enter the Euro character into e.g. the name of a 
savegame, even if the Euro character is directly supported in your keyboard layout.

The problem is even more severe in the DOS versions of TTD, which have hardcoded 
and sometimes very restricted keyboard mappings (in particular, the French version 
is notorious for missing the colon (@kbd{:}) key mapping), and have no support for 
key combinations involving the right Alt key, common in many European locales.

Therefore, since version 2.0 TTDPatch supports keyboard remapping.  To enable this 
feature, first you have to get (or create yourself) the keyboard remapping file, 
@file{ttdpatch.kbd} for the DOS version or @file{ttdpatchw.kbd} for the Windows 
version.  Simply place that file in the TTD directory, and TTDPatch will load it 
and enable its @dfn{enhanced keyboard handler}.

The keyboard remapping file is a binary file; the DOS version and the Windows 
version use a different format.  You may download a sample file from the TTDPatch
website at @uref{http://www.ttdpatch.net/kbd-sample.zip}, which contains a
detailed description of the file formats as well.

DOS versions of TTD feature its own low-level keyboard handler, so TTDPatch's 
enhanced keyboard handler is more powerful in the DOS version, allowing the user 
to remap virtually any key or key combination.  Windows versions of TTD rely 
on the Windows keyboard driver to map keys to characters, so the Windows version 
of TTDPatch offers a more simple character-based remapping.

When the enhanced keyboard handler is active, some bug fixes are activated 
even if the @option{generalfixes} switch is disabled (see @ref{General Fixes}), 
and some aspects of the keyboard interface change, which is explained in detail 
in the sample file mentioned above.

In the DOS versions, if the enhanced keyboard handler is active, the three 
Lock keys (Num Lock, Caps Lock, Scroll Lock) toggle the LED indicators on 
the keyboard, as they normally do in DOS and Windows.  This works even if 
@file{ttdpatch.kbd} is empty; however, TTD normally ignores the states of 
the Lock keys anyway, so if proper key mappings are not defined in 
@file{ttdpatch.kbd}, this feature is rather useless.

The enhanced keyboard mapping can work together with the @option{morehotkeys} 
switch (see @ref{More Hotkeys}) and the `ttdpttxt' mechanism (see @ref{Custom 
in-game texts}).  The keyboard remapping file defines which keys (or combinations) 
translate to which characters, while the `ttdpttxt' mechanism decides which 
characters trigger which functions if @option{morehotkeys} is turned on.

@metanode @section,Debug switches,Modifying how TTDPatch works

Debug switches are not useful for most people, but they can sometimes help
fixing odd problems in the patch.  They are mostly intended to be used
by developers when testing the patch.

To use them, they must be the first switch on TTDPatch's command line, and start
with an exclamation mark, ``!''.  After the exclamation mark follows the list of
debug switches, each of them possibly trailed by a ``+'' or ``-'' to choose two
different modes of operation.  Currently if neither ``+'' nor ``-'' is specified,
``+'' is assumed. An example:

@example
ttdpatch.exe -!v+T+w-
@end example

This would run TTDPatch to collect new version information and terminate before even
starting TTD.  If any warnings occur, they are ignored.

Here's the complete list of debug switches:

@multitable @columnfractions 0.1 0.8
@item Switch @tab Meaning
@item @t{v-} @tab Ignore TTD version info stored with TTDPatch (i.e. do not recognize TTD version)
@item @t{v+} @tab Collect TTD version info and write to a file
@item @t{s-} @tab Never swap out the real mode code when starting TTD (DOS only)
@item @t{s+} @tab Always swap out the real mode code when starting TTD (DOS only)
@item @t{c} @tab This switch is very special: if specified, TTDPatch will not process 
the command line options as usual, instead it will treat the rest of the command 
line as name and arguments of a program to run.  This feature can be used to analyze
TTDPatch's memory usage in the DOS version.
@item @t{t-} @tab Assume @file{TTDLOAD(W).OVL} exists and is correct, don't process it 
or try to locate the original files.  Currently this is useful only if combined 
with the @option{c} debug switch, otherwise it'll prevent TTDPatch from working 
and may cause a crash.
@item @t{m-} @tab Run even if there's not enough memory to start TTD (DOS only)
@item @t{f-} @tab Don't read or create the default @file{ttdpatch.cfg}
@item @t{a-} @tab Don't check dependencies between switches.  If used, TTDPatch 
will not correct illegal combinations of switches.  
@strong{Warning}: some switch combinations are dangerous.  
For example, if @option{startyear} is set to 1927 and @option{generalfixes} to off,
TTD will probably hang when you try to start a new random game.
Normally, i.e. without this debug switch, TTDPatch would prevent that 
by turning @option{generalfixes} on.
See @ref{New Starting Year} for more information.
@item @t{w-} @tab Do not wait for a key after a warning message, just continue
@item @t{w+} @tab Do not wait for a key after a warning message, just abort
@item @t{o+} @tab Reorder switches alphabetically when writing a configuration file
@item @t{T+} @tab Terminate TTD immediately after collecting version information 
(see @option{v+})
@item @t{L+} @tab Load language data from the file named @file{language.dat} 
instead of the TTDPatch executable.  Useful in debugging because many debuggers 
fail to load symbol information with those data appended to the executable.
@item @t{C+} @tab Load patch code from @file{ttdprotd.bin} for DOS 
or @file{ttdprotw.bin} for Windows.  Useful in debugging because many debuggers 
fail to load symbol information with that code appended to the executable.
@item @t{I-} @tab Prevent the enhanced keyboard handler from updating keyboard 
LED indicators.  The Lock keys will still toggle internal flags, though. (DOS only)
@item @t{S+} @tab Dump information about all supported switches (non-debug, non-special ones) 
to swtchlst.txt and abort
@end multitable


@metanode @section,Help,Where to get help with TTDPatch

So, you have tried TTDPatch and it didn't work like it should?  You need some
help getting it to work?

You've already found a good way to get help, namely this manual itself.  If you
can't find what you're looking for, a good place to start is the
@ref{Index}.  Just try to find a keyword that might relate to your question.

Also, you might try reading the FAQ section just below, it has answers to many
common questions.

There are also a few ways of asking other people for help:

@itemize
@item Mailing list: If the FAQ or the manual don't answer your questions, 
you can post to the mailing list, see @ref{TTDPatch Mailing Lists} in the
next section.
@item Official TTDPatch forum: You can ask your question on the official 
@uref{http://www.tt-forums.net/, TTDPatch forum}.
@item Newsgroup: If you have access to Usenet, ask your question on the Transport
Tycoon newsgroup
@ifclear HTML
@url{alt.games.microprose.transport-tyc}.
@end ifclear
@ifset HTML
@uref{news:alt.games.microprose.transport-tyc, alt.games.microprose.transport-tyc}.
@end ifset
@item IRC: There's the #tycoon channel on Quakenet as well
@end itemize

Finally, if all else fails, you can of course contact the author, see
@ref{Contact Information}.  Note that this is usually the @emph{slowest} way to get
answers, because Josef is very busy working on the patch@dots{}


@metanode @section,TTDPatch Mailing Lists,The mailing lists about TTDPatch
@c -------------------------------------

@cindex mailing lists

The TTDPatch mailing lists are email lists that allow you to discuss TTDPatch
with other list subscribers, as well as ask questions about the patch and keep
up to date with the latest developments of the patch.

Note that if you have questions about the patch or need help, there are other
ways than the mailing lists described in the previous section.  Use whichever
you find the most convenient.

There are three mailings lists for TTDPatch:
@table @t
@item ttdpatch
The general topic list for questions, comments, general discussion and so on.
Anyone who is subscribe can contribute.  All messages to the announcements
lists are copied to this list as well.  This is a high volume list, with 
on average about 5-10 messages per day.
@item ttdpatch-announce
TTDPatch announcements only.  A message is posted to this list whenever a new
version of TTDPatch comes out, as well as general news and announcements about
the patch and related utilities.  This list is moderated, which means that
only messages which are genuine announcements will be posted.  It is low volume,
with usually no more than one message per week.
@item ttdpatch-digest
Digested version of the above lists.  All messages sent to either the general
or the announcements list will be digested, and a digest is sent out on average
every 30 messages, or three days after the first message in the digest,
whichever comes first.
@end table

The lists are archived at @uref{http://lists.ttdpatch.net/}.  It is often
a good idea to search or browse the archive to see if your question has been
answered already.

If you want to ask a question or contribute to the lists, you need to subscribe
to them.  To do that, send a message to @email{Majordomo@@ttdpatch.net},
with the following in the message @emph{body}:

@example
subscribe <list name>
end
@end example

@noindent Here, the list name can be any of the above lists.
For example, to subscribe to the digest list, put the following in the email
body:

@example
subscribe ttdpatch-digest
end
@end example

You only need to subscribe to one of the lists, because all announcements are copied to the ``ttdpatch'' list as well, and the digests contain message from both
lists too.

@ifset HAVELINKS
Instead of composing the email yourself, you can try the following links, 
which should open your email program with
an appropriate message, so that all you have to do is click the send button:
@itemize @bullet
@item @uref{mailto:Majordomo@@ttdpatch.net?Body=subscribe%20ttdpatch%0Aend%0A, Subscribe to the general topic list}
@item @uref{mailto:Majordomo@@ttdpatch.net?Body=subscribe%20ttdpatch-announce%0Aend%0A, Subscribe to the announcements list}
@item @uref{mailto:Majordomo@@ttdpatch.net?Body=subscribe%20ttdpatch-digest%0Aend%0A, Subscribe to the digested list}
@end itemize
@end ifset

All emails to the announcements list are tagged so that you can filter the already
infrequent messages you're not interested in.  The subject line will look like this:
@example
Subject: Beta: TTDPatch 2.0 beta 4 released
@end example

Here's a list of the possible tags:
@table @asis
@item Alpha
@item Beta
@item Release
Announcements of a new alpha, beta or release version of TTDPatch.
@item Related
Messages regarding programs related to TTDPatch, such as configuration
utilities
@item Announce
A general announcement about changes in the mailing lists; about policies,
new lists etc.
@item News
General news about TTDPatch
@end table

@metanode @section,Frequently Asked Questions,Look here if you have a question
@cindex questions

For the following questions you'll find answers in this section.

@table @asis
@item Running TTD or TTDPatch and configuration issues:
How do I run TTD/TTDPatch on Windows NT, 2000 or XP?
@*What version of TTDPatch do I need?
@*How do I make a configuration file?
@*How do I change the configuration?
@*I get the message: ``Unable to access Transport Tycoon Deluxe CD!''
@*I get an error message about opening a COM port.
@*I get an error message saying that @file{ttdload.ovl} or @file{tycoon.exe} or @file{gamegfx.exe} could not be
found.
@*I installed TTDPatch but none of the patches work!
@*Why don't the new graphics work?
@*Why can't I play multiplayer games in full-screen mode?
@item Questions about features of the patch or how it works:
Why does @emph{something} suddenly not work? 
@*Why does the game not behave like it used to?
@*Why is the service interval set to 16000 days and can't be changed?
@*Why doesn't any cargo appear at my stations?
@*Why don't my trains make any profit? The cargo is delivered but it just stays ``en-route'' at the station.
@*How do I place a sign for sign cheats?
@*Why does TTD stop for a few seconds when changing songs?
@*Why is the game so slow suddenly? How can I speed it up?
@item General questions:
Can you please fix the multiplayer problems?
@*Are you still working on TTDPatch?
@*When is the next version going to come out?
@end table

@table @b

@item How do I run TTD/TTDPatch on Windows NT/2000/XP?

Please read @ref{Windows 2000/XP compatibility}

@anchor{FAQ--Version}@item Which version of the patch do I need?

TTD comes in two different versions, an older one from 1995 that runs in DOS, 
and a newer one from 1999 that only runs in Windows and uses DirectX. The gameplay 
is identical, the only difference is what operating system they need. 
Also, only the Windows version of TTD runs on Windows NT, 2000 and XP. 

To find out which version you have, look at the title screen of your game. 
The Windows version has a large ``Fish UK'' logo on the screen, whereas the DOS version 
does not have that logo. If you see this logo, you need the TTDPatch file that ends 
in a @file{W}, i.e. @file{ttdpt@i{xxx}W.zip}, where @i{xxx} is the version number. 
Conversely, if you don't see this logo, download @file{ttdpt@i{xxx}.zip} without the @file{W}. 

Another clue is the executable file. The DOS version uses @file{TTDX.EXE} 
or @file{TYCOON.EXE}, whereas the Windows version uses @file{GameGFX.exe}. 
Simply by finding which of these files you have, you can determine your version. 

@item How do I make a configuration file?

Since TTDPatch version 1.8, a default configuration file is created if
you run TTDPatch without any options and no @file{ttdpatch.cfg} file exists.
Then you can simply edit this file and set the options as you like.

Other ways of making a configuration file:

@itemize @bullet
@item Get a configuration tool from the TTDPatch website, 
choose the switches you want, and then save it as
@file{ttdpatch.cfg}. 

@item Have TTDPatch make one for you. In a command prompt, enter the following: 

@noindent For the DOS version: 
@example
ttdpatch -a -W ttdpatch.cfg 
@end example

@noindent For the Windows version: 
@example
ttdpatchw -a -W ttdpatch.cfg 
@end example

This will also run TTDPatch with the new configuration, so that you can test
whether it works.
@end itemize

@item How do I change the configuration?

If you already have a configuration file (if not, see above), you can simply edit it in any
text editor. In Windows, run Notepad and open @file{ttdpatch.cfg} in your TTD directory. In
DOS, run Edit and do the same. Then simply change what you like, and save the file again.

@item I get the message: ``Unable to access Transport Tycoon Deluxe CD!''

If this is the Windows version of TTD, please read @ref{Windows 2000/XP compatibility}.

If, however, you have the DOS version, 
this means that you have not told TTDPatch where to find the TTD CD. The most likely
reason is that you have not set up a configuration yet. To correct this, please follow the
steps in the FAQ above, ``How do I make a configuration file?''

If you do have a configuration file and this error persists, it means that you need to modify
the configuration file to set the CD path. To do this, either use one of the configuration
tools or simply go to your TTD directory, and open ttdpatch.cfg in a text editor like
Notepad. Go find the line that begins with @code{cdpath}, and change it to read 
@t{@w{cdpath D:\}} where D: is your CD drive.

One more way to solve this is to copy all missing files from your CD to the TTD
directory. Simply copy everything that's not already on your hard disk and it should work.
Then you can play TTD even without the CD.

@item I get an error message about opening a COM port.

This error message means that you have the DOS version of TTD, and are trying to
run it on Windows NT, 2000 or XP. Currently there is no known way of doing that,
only the Windows version of TTD runs on these operating system, and only if you
enable the @option{win2k} switch See the question ``Which version of the patch do I need?''
above.  Unfortunately the Windows version is very hard to find in shops, so you may have
some trouble trying to buy it. 

@item I get an error message saying that @file{ttdload.ovl} or @file{tycoon.exe} or @file{gamegfx.exe} could not be found.

This probably means that you have the wrong version of the patch.  You might have the
DOS version of TTD, but the Windows version of the patch, or vice versa.  The versions
must match, or the patch won't work.  Another possibility is that you don't actually
have Transport Tycoon Deluxe, but rather some other game, or that you've installed 
TTDPatch in the wrong folder (it must be in TTD's folder).

@item I installed TTDPatch but none of the patches work!

There can be several reasons why this would be the case. 

@itemize @bullet
@item You are still running the unpatched TTD. If that's the case, you have to run TTDPatch
instead. Remember, TTDPatch has to do the patching every time it is started, simply
installing it is not enough.  Check that the title of the main game window
mentions the version of TTDPatch.  If it doesn't, you're not actually running
the patch, but rather the unpatched TTD.

@item If you run TTD from a batch file (e.g. @file{ttdx.bat}), simply edit that file to run @file{ttdpatch.exe}
instead of @file{ttdx.exe}. If, on the other hand, you have a Windows shortcut, edit that
shortcut to run @file{ttdpatch.exe}.

@item You have not set up a configuration yet. By default, all of TTDPatch's switches are
turned off. To correct this, please follow the steps in the FAQ above, ``How do I
make a configuration file?''
@end itemize

@item Why don't the new graphics work?

There are several checks you should do to find out why the graphics don't work.

@itemize
@item Do you have the right name for the configuration file? It should be 
@file{newgrf.cfg} if you have the DOS version of TTD, or @file{newgrfw.cfg} for the
Windows version.
@item Did you enable the switches for new graphics? See @ref{New Vehicle Graphics} for
a list.
@item Do you get any error messages after starting TTD or loading a game?  If so,
see @ref{Graphics Errors} for what they mean.
@item Did you start a new game?  By default, new graphics are loaded only in new
games, although you can use @w{@t{Cht: Graphics}} to activate them in existing games.
@end itemize

@item Why can't I play multiplayer games in full-screen mode?

(This applies to the Windows version only.)  When initiating or joining a multiplayer game,
TTD switches back to the Window interface to display the multiplayer game selection
dialogs.  After the game has been set up or selected, the game should return to fullscreen
mode.  However, this doesn't work correctly on many (most?) graphics cards, and the game
cannot be resumed at all.  If this happens, your only option is to choose windowed mode in
TTD's configuration program, and not play in full-screen mode at all.  It's not clear what
exactly causes this problem, or how to fix it.

@item Why does @i{something} suddenly not work?
@itemx Why does the game not behave like it used to?

This is probably because a feature of the patch changes the way the game works.
If you want to find out why it does this, and how you're supposed to take 
advantage of the changes, you'll just have to find the entry in the manual
that explains it.

The easiest way to do this is to look in the index for key words
(see @ref{Index}) that might
relate to your question, or perhaps look through the table of contents for
hints.

If you can't find it at all, try turning off all switches in @file{ttdpatch.cfg}
until the problem disappears.

Finally, if you still can't figure it out, it might of course be a bug in the
patch.  In that case, please contact the author (see @ref{Contact Information})
and tell him.

@item Why is the service interval set to 16000 days and can't be changed?

This is an effect of the @option{servint} switch, see @ref{New Default Service Interval}. 
It is intended for people that play with breakdowns turned off in the difficulty settings.
If you don't like that, simply turn off the new service interval or set it to a smaller number,
and all new engines will get a better service interval. You can also use the @code{Cht: ServInt} sign
cheat to change the service interval. 

@item Why doesn't any cargo appear at my stations?

This happens if you enable the @option{selectgoods} switch, see @ref{Selectable station cargo}. 
It allows you to choose what goods you want to appear at each station. To make the cargo show up,
you just have to send a vehicle there trying to pick them up first. After that, only the cargo 
of that vehicle will appear, until other carriers enable other cargo types.

@item Why don't my trains make any profit? The cargo is delivered but it just stays ``en-route'' at the station.

You have probably enabled the feeder services (see @ref{Feeder Service}) and are using the ``unload''
option at the target station. You do not need to use the unload option, unless the station does not
accept the cargo you deliver. Simply remove the unload option, and everything will work fine.
Alternatively, you can of course turn off feeder services.

@cindex sign, placing
@item How do I place a sign for sign cheats?

The sign that you need for using the sign cheats is in the ``trees'' menu icon. Simply click
and hold your mouse button on that icon, and choose the ``Place sign'' option.  Note that
this is @emph{not} the same type of sign as the ``sign'' you get when you purchase land for future use.
None of the other types of signs will work.

@item Why does TTD stop for a few seconds when changing songs?

This happens only in the Windows version of TTD, and only under Windows 2000 or XP. The problem is that
TTD uses an obsolete interface to the Windows MIDI functions, which don't work very well on these
operating systems. The solution is to use the @file{dxmci.dll} DirectMusic wrapper DLL.  For more
information please see @ref{Windows 2000/XP compatibility}.

@item Why is the game so slow suddenly? How can I speed it up?

The worst offender in terms of slowing down TTD is the @option{morevehicles} switch.  It multiplies
the time TTD needs to process all vehicle motions and update their states.  If set to a value larger
than 5, the game can get really slow, especially on older computers.  If you experience slow games,
you should first examine your @option{morevehicles} setting, and see if it is too large.  Usually a
value of 2 is enough for all but the most complex games that may require a setting of 3 or 4.  Anything
above 5 is almost certainly too large.  However, before reducing the setting, please read
@ref{Increased Number of Vehicles}, because this can affect the savegames you've already started
with too high a setting.  In particular, if any consists have to be removed when loading a game, you need to
go back to a slightly higher setting.

Other features that TTDPatch introduces to the game can also slow it down, by requiring
additional calculations that were not needed in plain TTD.  Examples of this are the pre-signals,
new vehicle graphics and the realistic acceleration model.  However, the slowdown because of these
should still be fairly small, but you can try turning them off to see if you can get a faster game.

@item Can you please fix the multiplayer problems?

No, I can't. Seriously, I just can't. I don't even have two computers to play multiplayer games with.
Someone would have to buy me another computer, two licences of XP and two licences of Soft/ICE for XP.
Until then, I can't even begin to try fixing anything related to multiplayer games.

Besides, even if I had the computers and debuggers and everything, I'm not sure if the problems can be
fixed in the first place. It may be that TTD's networking protocol is just fundamentally broken and
can't be fixed, short of a complete rewrite of TTD. Who knows@dots{} I certainly don't. 

@item Are you still working on TTDPatch?
@itemx When is the next version going to come out?

Yes, I am still working on TTDPatch, but only sporadically due to other commitments. I
simply find it difficult to find the time to work on TTDPatch, which means that new
versions might take a relatively long time to come out. But, eventually they will, so don't
lose hope. Don't hold your breath either. If you would like to be notified of new versions
by email, please sign up to the TTDPatch Announcements mailing list. 
@end table

@metanode @section,Translating TTDPatch,How you can translate TTDPatch into your language.
@c --------------------------

TTDPatch is available in a variety of languages.
To choose a language, please refer to @ref{Language Selection}.

It is very easy to add more languages.  I just need people who are willing
to translate either the program texts or the documentation, or both.
For translating the program output, download the 
@uref{http://www.ttdpatch.net/src/ttdptlng.zip, program texts} for
all languages that TTDPatch has been translated to.
Please change only the text that is in
double quotes, the comments should remain the way they are,
to make things easier for me.

I'm using @uref{http://texinfo.org/,Texinfo}
for the manual itself, which makes it possible to have
a single file that can easily be converted into a pretty-print file (Postscript
or PDF) as well as HTML for online documentation and a nicely formatted
plain text file.  If you want to translate the documentation,
it would help if you know Texinfo, but it's pretty easy to figure out, so
you shouldn't have a problem translating it.

If you have any questions about this or would like to help translate it,
please contact Josef, see @ref{Contact Information}.

You can get the current version of the manual in Texinfo format from the
@uref{http://www.ttdpatch.net/src/manual.zip,TTDPatch source code page}.

For translating TTD itself, Csaba Varga has written the excellent
@uref{http://www.csucsposta.hu/csaboka/ttdtrans.htm,TTD Translator}.

@metanode @section,Custom in-game texts,Translating the new in-game texts

TTDPatch adds several new messages that are displayed in the game, for example
the bribe option.  TTDPatch includes translations of these in all languages
that TTD is available in.  However, you may have used the TTD Translator 
described in the previous section, in which case your TTD is in a language that
is not available with TTDPatch.  As a result, the in-game texts will be in
English (or whichever language your version of TTD was originally in), not your language.

It is now possible to translate these in-game texts to your own language by
using the @file{mkpttxt.exe} program distributed with TTDPatch.  Simply run
this program once, and it will create a file called @file{ttdpttxt.txt}, which
contains all in-game text strings.

To translate it, open it in a Windows editor like Notepad, or any other editor
that is capable of using the ISO-8859-1 character set.
Follow the instructions at
the beginning of the file, and translate the entries.  Then, simply run
@file{mkpttxt.exe} again, and it will create the file @file{ttdpttxt.dat}, which
will automatically be loaded by TTDPatch if it is present in the TTD directory.

If you would like to distribute your translations, please distribute the 
@file{ttdpttxt.txt} and not @file{ttdpttxt.dat}, because the latter uses an
internal format of TTDPatch that may change from time to time.  If the format
changes, people who have the @file{.txt} file can simply run an updated version
of @file{mkpttxt.exe}, which isn't possible with the @file{.dat} file.

@metanode @subsection,Detailed Information,What all the custom text entries mean

This section has a list of all entries in @file{ttdpttxt.txt}, with the default
values, and what they are used for.  You should leave the control codes (a backslash 
followed by two hexadecimal digits, e.g.
@t{\7c}) alone, they are place holders for numbers, other text strings or
colour or font changes.  To put a literal backslash, use two backslashes (@t{\\}).
@t{\00} marks the end of a string.

@table @t
@item bribetext="Bribe the local authority\00"
Menu entry in the local authority menu for the bribe option
@item bribedesc="\94\80\n"
@example
	"\90  Bribe the local authority to increase your rating, at the risk "
	"of a severe penalty if caught.\n"
	"  Cost: \7f\00"
@end example
Description of the bribe option in the local authority menu
@item bribefailed1="\94Your attempted bribery has been\00"
@item bribefailed2="\94discovered by a regional investigator.\00"
Both lines of the error message shown when a bribe is denied.
@item headingfor="\95\80, \84\00"
@item headingfordepot1="\95\80 Train Depot, \84\00"
@item headingfordepot2="\95\80 Road Depot, \84\00"
@item headingfordepot3="\95\80 Ship Depot, \84\00"
@item headingfordepot4="\95\80 Hangar, \84\00"
Used with ``showspeed'' in the status bar of each vehicle. The first entry is
used for stations, the rest for specific types of depots.
You can modify the first two entries to show tractive effort and acceleration
when the realistic acceleration model is enabled.
For details, see @ref{Realistic Acceleration}.
@item withsignals="Railroad track with \80 (\80)\00"
@item wplainsignals="plain signals\00"
@item wpresignals="pre-signals\00"
@item wpresigexits="pre-signal exits\00"
@item wprecombined="combined signals\00"
@item presigautomatic="automatic\00"
@item presigmanual="manual\00"
Description of track with signals when using the presignal switches, for the four
different kinds of signals possible, as well as whether they were set automatically
or manually.
@item vehmulttoolow1="\94Warning: Game saved with veh. multiplier \7e.\00"
@item vehmulttoolow2="\94Removed \7e vehicles in \7e consists and \7e special objects.\00"
Error message shown when a savegame is loaded that had a ``morevehicles'' setting
larger than the current setting.  See @ref{Increased Number of Vehicles}.
@item rchunknotloaded1="\94Warning: Game uses some features of\00"
@item rchunknotloaded2="\94TTDPatch that are disabled or not present in this version. "@*"Data may be lost.\00"
Error message shown when a savegame is loaded that requires certain switches to be
enabled.  It is not easily possible to tell which switches these are, unfortunately.
As of version 2.0, this message is shown when the savegame contains extended 
town data but they're not enabled in TTDPatch.  See @ref{More Town Statistics}.
@item loadgame="Load game\00"
Load menu item in the disk menu
@item gotodepot="Go to \80\00"
@item gotodepotonly="Service at \80\00"
@item gototraindepot="\80 Train Depot\00"
@item gotoroaddepot="\80 Road Depot\00"
@item gotoshipdepot="\80 Ship Depot\00"
@item gotoairdepot="\80 Hangar\00"
Display of depots in vehicle orders with the ``gotodepot'' switch.
@item cannotcheat="\94Cannot carry out sign cheat action\00"
@item cheatinvalidparm="\94Invalid parameter\00"
@item cheatunknown="\94Unknown sign cheat\00"
@item cheatobsolete1="\94Note: Cht: \80 is obsolete.\00"
@item cheatobsolete2="\94Use Cht: \80 instead.\00"
Various error messages about sign cheats.
@item managedby1=" (temp. Player 1)\00"
@item managedby2=" (temp. Player 2)\00"
@item manage="\98Manage\00"
Display of current player status and the ``manage'' button in the player info window
when using the subsidiary management feature.
@item newwagoninfo="\98Cost: \7f    Weight: \7ct\n" @* "Capacity: \80\00"
@item railwaywagon="railroad wagon\00"
@item monorailwagon="monorail wagon\00"
@item maglevwagon="maglev wagon\00"
Description of wagons when they become newly available.
@item rvweightinfo="\98Weight: \95\7c.\7dt   \98Power: \95\7chp   \80\00"
@item rvweightpurchasewindow="\98Cost: \8a\7f\98   Speed: \8a\84\n" @* "\98Running Cost: \8a\7f/yr\n" @* "\98Power: \8a\7chp\98   Weight: \8a\7d.\7dt\n" @* "\98Capacity: \8a\80\n" @* "\98Designed: \8a\7e\98   Life: \8a\7c years\n" @* "\98Max. Reliability: \8a\7d%\00"
Description of road vehicle stats when using realistic acceleration, first in the
vehicle info window, then the purchase window.
@item grfloaderror="\94Error loading new graphics:\00"
@item toomanysprites="\94More sprites than specified (file \80).\00"
@item outofmemory="\94Out of memory (file \80).\00"
@item wronggrfversion="\94Wrong .grf version (file \80).\00"
@item toomanyspritestotal="\94Cannot load more sprites (from file \80).\00"
@item filenotfound="\94File \"\80\" not found.\00"
@item invalidsprite="\94File \"\80\" has invalid sprite #\7c.\00"
Error messages shown when loading new graphics fails.
@item elecrailconstitle="\94Electrified Railroad Construction\00"
@item elecrailconsmenu="Electr. railroad construction\00"
Construction menu entry and window title for electrified railroad construction.
@item ufodestroyed="\98\0f'UFO' destroyed in huge explosion near \80!\00"
@item lmilloutoftrees="\98\0f\80 \80 ran out of nearby trees!\00"
@item eurointroduced="\98\0fMonetary union!\n\n" @* "European countries switch from national currencies to Euro!\00"
@item aircraftcleared="\98\0fRemnants of the recent plane crash have been cleared from \80!\00"
@item zeppelincleared="\98\0fRemnants of the recent Zeppelin crash have been cleared from \80!\00"
@item traincleared="\98\0fRemnants of the recent train crash have been cleared near \80!\00"
News messages about various events.
@item curr_HUF="Hungarian Forint (Ft)\00\00\00\00\00\00"
@item curr_PLN="Polish Zloty (zl)\00\00\00\00\00\00"
@item curr_ATS="Austrian Shilling (ATS)\00\00\00\00\00\00"
@item curr_BEF="Belgian Franc (BEF)\00\00\00\00\00\00"
@item curr_DKK="Danish Krone (DKK)\00\00\00\00\00\00"
@item curr_FIM="Finnish Markka (FIM)\00\00\00\00\00\00"
@item curr_GRD="Greek Drachma (GRD)\00\00\00\00\00\00"
@item curr_CHF="Swiss Franc (CHF)\00\00\00\00\00\00"
@item curr_NLG="Dutch Guilder (NLG)\00\00\00\00\00\00"
@item curr_ITL="Italian Lira (ITL)\00\00\00\00\00\00"
@item curr_SEK="Swedish Krona (SEK)\00\00\00\00\00\00"
@item curr_RUB="Russian Rubel (RUB)\00\00\00\00\00\00"
@item curr_EUR="Euro (\9e)\00\00\00\00\00\00"
Definition of new currencies, see the next section for details.
@item townlastmonthaccepted="\98Cargo accepted last month at all stations:\00"
Display of more town statistics using ``moretownstats''.
@item endofsharedorders="\01\0a- - End of shared orders - -\00"
End of a shared order list.
@item hotkeylistdos="x@ @ @ !@@#$t%1234567890-=\1e\\\00"
@item hotkeylistwin="x@ @ @ !@@#$t%1234567890-=`\\\00"
List of new hotkeys for the DOS and Windows version.  The first four characters are
reserved. After this follow six characters which toggle display options, and finally
14 characters for the fourteen construction items in the railway construction menu.
If the second character (the first after
the ``x'') is a question mark ``?'', it will turn on the key code display, meaning
that every time you press a key in TTD, it will display what key it thinks that was, so
that you can find out what character to use in the hotkey list.
Note that the control codes are not placeholders here, but keycodes.
@end table

@metanode @subsection,Currency Entries,How to change currencies and create custom ones

With ``morecurrencies'', TTD can have up to 19 currencies. All available slots are filled
by default, but you can change any of the new currencies 
to another one simply by overwrititng its data in @file{ttdpttxt.txt}, see above.

The entries beginning with ``curr_'' specify the data for a
currency.  Each of them consists of six parts, separated by NUL codes (@t{\00}).  Filling the
first part is mandatory, but all other parts can be empty, meaning that the values
hardcoded in TTDPatch should be applied.  If you specify numbers, you can put spaces
before and after them.

The first part is the name of the currency followed by the currency symbol in brackets
(For example: ``Hungarian Forint (Ft)''.)  This text will be shown in the currency list
in the Game Options window.  This part is mandatory.

The second part is the exchange ratio between British pounds and the currency multiplied
by 1000. For example, 1 British pound is 375.62 Forint, so this value should be
375620 for the Forint.

The third part defines the thousand separator and symbol placement of the currency.
If this isn't empty, the first character will be used for the thousand separator.
If a second character is present, and it's a character number one (@t{\01}), the
currency symbol will be placed after the number by default. If there is no second
character or it's not @t{\01}, the currency symbol will be before the number by default.
These options can be overridden if the player forces all currencies to have
the same separator or placement by modifying the parameter of the morecurrencies switch.

The fourth and fifth parts can't be longer than four characters, these specify
the currency symbol. The first symbol is used before the number, the second after
the number. If there should be no space between the number and the symbol (``$100,000''),
both of them should be the same and they shouldn't contain spaces. If there should
be a space separating the number and the symbol (``$ 100,000''), the first symbol
entry should end with a space, the second should start with a space.

The sixth part specifies when should the currency change to Euro. If it should never
change, specify 0, otherwise specify the year when it changes to Euro.

If you simply want to translate the name of the currency, translate the first part and
put six NUL codes (@t{\00}) after it. If you want to change only some options (for example, you
want to lower the exchange ratio), specify only the data you want to change, and leave
the other parts empty (the currency name must be specified, though). If you want to change
the currency to something else, specify all the parts to override all the hardcoded TTDPatch data.

Here's an example that sets the options of the Hungarian Forint to the defaults used
by TTDPatch:
@example
curr_HUF="Hungarian Forint (Ft)\00375620\00.\01\00Ft \00 Ft\002008\00"
@end example

Note that each option starts immediately after the preceding @t{\00} separator.

@metanode @section,Version History,What feature was added when?

For versions from 1.9 and above, 
this section lists the versions that introduced new features or sign cheats.  It only
mentions final release versions, and neither alpha nor beta versions.  It also omits
all minor changes, bug fixes and small improvements to existing versions.  For a full
list of changes, check the change log on the source code page of the TTDPatch site.

@multitable @columnfractions .11 .90
@item Version @tab Changes
@c ----------------------------------------------------------------------------
@item V2.0 @tab New Graphics for all vehicle types
@item 09/25/03 @tab Unified Maglev
@item @tab Bridge Speed Limits
@item @tab Eternal Game
@item @tab Show Full Date
@item @tab Signals on Road Traffic Side
@item @tab Electrified Railways
@item @tab New Starting Year
@item @tab Realistic Acceleration
@item @tab Error Popup Time
@item @tab New Town Growth Switches
@item @tab Miscellaneous Modifications
@item @tab Save Optional Data
@item @tab More Build Options
@item @tab Semaphore Signals
@item @tab Plant Many Trees
@item @tab More Hotkeys
@item @tab More Currencies and Euro
@item @tab Manual Track Conversion
@item @tab Enhanced Graphical User Interface
@item @tab More Town Statistics
@item @tab New Wagon Age Rating
@item @tab Build on Slopes
@item @tab Track Type Cost Differences
@item @tab New Plane Speed
@item @tab Build on Coasts
@item @tab Sell Entire Trains
@item @tab New Road Vehicle Crashes
@item @tab Stable Industries
@item @tab Cht: Semaphores to switch between semaphore and light signals 
@item @tab Cht: PlantTrees to plant trees in a rectangular area around the sign
@item @tab Cht: RemoveHQ to remove the company headquarters 
@item @tab Cht: Climate to switch the current climate 
@item @tab Cht: Subsidy to force a new subsidy to be offered 
@item @tab Cht: Debugger to activate TTD's built-in debugger 
@item @tab Cht: Graphics to activate or deactivate specific new .grf files 
@item V1.9 @tab Go to Depot
@item 10/29/02 @tab New ship models and graphics
@item @tab Cht: PlayerID supports switching temporarily
@item @tab Subsidiary management
@item @tab Move red error popup windows into a corner
@item @tab Gradual loading/unloading
@item @tab Signal wait times
@item @tab Disaster selection
@item @tab Distinction between forced and regular auto-renewal
@item @tab News items generated for more events
@item @tab Custom in-game texts
@item @tab Cht: NoUnload
@item @tab Cht: ReloadEngines
@item @tab Lots of bug fixes again@dots{}
@item V1.8.1 @tab Multiheaded Steam and Diesel engines smoke properly
@item 07/24/02 @tab Cht: PlayerID
@item @tab Feeder service
@item @tab Added Hungarian, Italian and Spanish translations
@item @tab Pre-signals without signals are green now
@item @tab Screenshots work in the Windows version too
@item @tab Many bugfixes: Ctrl key, Clearghosts, etc.
@item V1.8 @tab Add extended command line options (-X...)
@item 03/11/02 @tab Plane crash control (by Marcin)
@item @tab Bribe option
@item @tab Show current vehicle speed
@item @tab Sign cheats optionally cost money
@item @tab New signal graphics for pre-signals
@item @tab More complex pre-signal setups
@item @tab Autorenew: automatically renew old vehicles
@item @tab Crash logger for crashes of the DOS version
@item @tab Windows 2000/XP compatibility for the Windows version
@item @tab Savegames with more vehicles now get a @file{trp} filename
@item @tab Add load option to the disk menu
@item @tab City bridges can be removed
@item @tab Cht: AllEngines, Cht: RemoveEngines, Cht: ClearPreSig
@item @tab Multihead option now has an optional speedup parameter
@item @tab Convert source code from C++ to C (by Marcin)
@item @tab @dots{} and many, many bug fixes
@item V1.7 @tab TTDPatch supports the Windows version of TTD
@item 02/24/01 @tab Trains with additional engines for more power
@item @tab TTDPatch can swap out and leave more memory to TTD
@item @tab A low memory version that only needs 2.5 MB
@item @tab Road vehicles queue up at the station
@item @tab @t{@w{Cht: resetstation}}
@item @tab More airports allowed per city
@item @tab Many, many bug fixes
@item @tab Now patching @file{ttdload.ovl}, not @file{ttdload.exe}
@item @tab TTDPatch is now distributed under the terms of the GPL
@item V1.6 @tab Several bug fixes in the cfg file, etc.
@item 07/15/00 @tab Keep small airports around
@item @tab Fixed eternal servicing after 2055
@item @tab Build 7x7 station with @kbd{Ctrl}
@item @tab Longer bridges, up to half the map length
@item @tab Multiplayer: Cheats only affect player placing signs
@item @tab Bulldoze all city roads
@item @tab Boost AI, set recursion factor
@item @tab @t{@w{Cht: AllNonStop}} and @t{@w{Cht: NoNonStop}}
@item @tab @t{@w{Cht: ServInt}}
@item @tab Automatic language selection and support for English,
                Dutch, French, German and Italian.
@c ----------------------------------------------------------------------------
@item V1.5.1 @tab Configuration file support
@item 10/16/99 @tab Convert source code to C++
@item @tab Convert docs to Texinfo
@item @tab Framework for multiple language support
@c ----------------------------------------------------------------------------
@item V1.5 @tab Turn off inflation
@item 09/04/99 @tab Office towers in Tropic/Arctic accept food too
@item @tab Longer stations (up to 7 squares)
@item @tab Borrow/Repay maximum amount by holding @kbd{Ctrl} key
@item @tab The default service interval is selectable
@item @tab @t{@w{Cht: DumpMemory}} for saving uncompressed
@item @tab Pre-signals no longer experimental
@item @tab Persistent engines won't become obsolete if in use
@item @tab Full load for any cargo type, not the whole train
@item @tab Selectable station goods
@item @tab Fixed @t{@w{Cht: OwnCrossing}} (I think@dots{})
@c @end itemize
@c ----------------------------------------------------------------------------
@item V1.4.3 @tab This was just a bug fix beta version, no real release
@item 08/16/99 @tab Fixed @option{-trpb} and @option{-x}, they were broken (except when using @option{-a}) since V1.4
@c ----------------------------------------------------------------------------
@item V1.4.2 @tab Three new versions supported: German, French and Spanish
@item 08/12/99 @tab
@c ----------------------------------------------------------------------------
@item V1.4.1 @tab @option{-w} switch for pre-signals now actually works
@item 07/31/99 @tab (no need to use @option{-a} anymore)
@c ----------------------------------------------------------------------------
@item V1.4 @tab More multiplayer support (now also for @option{-l})
@item 07/29/99 @tab Improved algorithm to calculate load/unload times
@item @tab Mammoth trains up to 127 cars
@item @tab @t{@w{Cht: Renew}} and @t{@w{Cht: Owncrossing}}
@item @tab Pre-signals supported but still experimental
@item @tab All switches must be entered in lowercase letters
  now, to allow for future switches.  Sorry for the
  inconvenience but I'm running out of letters@dots{}
@c ----------------------------------------------------------------------------
@item V1.3 @tab Fixed ``ghost train'' bug
@item 07/16/99 @tab Added multiplayer support
@c -----------------------------------------------------------------------------
@item V1.2 @tab Enable CD-only version of TTD by passing the CD
  drive parameter to TTDPatch
@item 06/06/99 @tab Stations extensible to up to 7 equal platforms
@c -----------------------------------------------------------------------------
@item V1.1 @tab Now also supports version V2.01.119 with a file size of 496601 bytes.
@item 06/03/99 @tab
@c -----------------------------------------------------------------------------
@item V1.0 @tab First version, supports TTD V2.01.119, with an executable file size of 496543 bytes.
@item 05/30/99 @tab
@end multitable



@metanode @section,Error Messages,An explanation of all the error messages.
@c --------------------

This is a list of all errors and warnings that can occur while TTDPatch is still loading.
Messages while inside the game are not covered here.

The messages are sorted alphabetically, ignoring an initial ``Warning:'' or
``Error:'' that is not part of the actual message.

@table @t
@item *** Internal TTDPatch error #[number] ***
This message should not occur, it means something went wrong in the patching
program.  Report this message to the author of TTDPatch.

@item Can't write to TTDLOAD.OVL, is it read-only?
This happens after copying the TTD executable to @file{ttdload.ovl}, when
TTDPatch tries to patch this copy.  Most likely it is set to
read-only.  Remove the read-only flag and it should work.

@item Configuration line is longer than 32 chars, truncated
For some reason, you have a very long line in the configuration file.  Only
the beginning of it has been considered by the patch.

@item Copy error - file doesn't exist.
When TTDPatch tried to copy the old executable to @file{ttdload.ovl},
something went wrong and nothing was copied.  You can try to copy it
yourself and run TTDPatch again.  It will then try to work with this
copy instead, and not copy the file itself.

@item Could find neither TYCOON.EXE nor TTDX.EXE.
@itemx Could not find GAMEGFX.EXE.
There are two possibilities.  Either you started TTDPatch 
from the wrong directory, or you have the wrong version of the
patch.  Make sure that you copied the patch into the TTD folder, and that
you didn't mismatch the DOS and the Windows versions.

@item Could not determine program version.
This means that TTDPatch couldn't find out what version of TTD you
are using, and thus cannot patch it.  This can only be fixed by
sending your executable to the maintainer of TTDPatch.
It's most likely that it actually isn't TTD but something else.

@item Couldn't execute TTDLOAD.OVL
There was a problem running the game (contained in TTDLOAD.OVL). 
This message is followed by a more detailed error description that
may help you determine the cause of this problem.

@item Couldn't find cfg file <file>.  Ignored.
You specified a file with the @t{-C} option or the @t{include} directive,
but it could not be found.  You probably have a typo in the filename.

@item Couldn't install code loader - try deleting TTDLOAD.OVL.
TTDPatch found some problem in @file{ttdload.ovl} and couldn't patch it.
You can try to delete @file{ttdload.ovl} so that TTDPatch creates it again,
hopefully correct this time.  Otherwise there is some problem with
your TTD executable.

@cindex create process failed
@item Create process failed.
This happens in the Windows version of TTDPatch, when it is unable
to start TTD.  The reason can be that TTD is not installed properly,
or that @file{ttdloadW.ovl} is outdated.  Please try deleting
@file{ttdloadW.ovl} first, and see if it helps.  If not, check
whether TTD runs without the patch.  If it doesn't, you may have
to re-install.  One other possibility is a conflict with another
program or not enough system resources.  Try shutting down all other
programs before running TTDPatch.

@item Invalid cfg line `<name>'
You have a switch in the configuration file or on the command line that TTDPatch
does not recognize.  Either you have made a typo, or it could be
that your configuration file is for a different version
of the patch.  For example, you may have a configuration tool that makes files
for TTDPatch 2.0, but you only actually have TTDPatch 1.9.  In that case TTDPatch
1.9 will complain about all switches that are new in version 2.0, because it doesn't
understand them yet.  Just upgrade your TTDPatch version, or remove the offending
line from the configuration file.

@item Invalid original segment length.
This message indicates that something is wrong with the @file{ttdload.ovl}.
Try deleting that file, so that TTDPatch can create it again, hopefully
correctly this time.

@item Not enough memory available, need <number> KB more
The DOS version ran out of memory.  You must make more memory available
to the patch for it to work.

@item Reading ttdpttxt.dat: Invalid file format.
TTDPatch could not read ttdpttxt.dat because it is not in the
expected format.  You must run mkpttxt.exe to generate this file
from ttdpttxt.txt.  Do not edit ttdpttxt.dat directly.

@item Sorry, this version of TTDPatch works only with the DOS/Windows version
You have the wrong version of the patch, or the wrong version of TTD.  You
must get the DOS version of the patch for the DOS version of TTD, and the
Windows version of the patch for the Windows version of TTD.

@item TTD is not installed properly (registry error <number>)
This message can occur if you have the Windows version, but didn't install
it with its installer program.  TTDPatch tried reading the registry entries
for the game, but they were either missing or incorrect.  Try reinstalling
TTD with its installer program.

The specific meaning of the registry error numbers:
@enumerate
@item The registry key ``HKLM\Software\Fish Technology Group\Transport Tycoon Deluxe''
does not exist.
@item @ 
@item The value ``HDPath'' does not exist or could not be read from the registry key.
@item @ 
@item The TTD folder does not have a short (DOS-compatible) name.
@end enumerate
Other numbers indicate that the ``HDPath'' registry value could not be updated.

@item The switch `<name>' (-<option>) is obsolete
You have a switch in the configuration file or on the command line that is no
longer valid in this version of TTDPatch.  Either it has been replaced by
a different switch, or it is no longer required.  Simply remove it from
the configuration file or command line.

@item This is not Transport Tycoon Deluxe
You are trying to run TTDPatch, but you do not have Transport Tycoon Deluxe.
You probably have a version of regular Transport Tycoon, which will not work
with the patch.

@item This is not a known executable format
TTDPatch could not determine whether your game is the DOS or Windows version.
This probably means that the installation is corrupt; try installing TTD again.

@item ttdpttxt.dat must be remade for this version of TTDPatch
You are using ttdpttxt.dat, see @ref{Custom in-game texts}.  Your file was
for a different version of TTDPatch and must be updated.  Simply run
mkpttxt.exe again to do this.

@item Unknown switch `<name>'
See ``Invalid cfg line'' above.

@item Unknown on/off state <name>, set to off
You have a line in the configuration file that has a switch setting which
the patch does not recognize, so the switch is turned off.
Perhaps you made a typo when editing the file.

@item Unrecognised .EXE format.
@file{tycoon.exe} is not an executable file.  This should not happen, unless
you copied or renamed something else to @file{tycoon.exe}.

@item Version has too many numbers!
While trying to find out version of TTD, the program got confused
because it found more than the usual three numbers.  This can only be
fixed by sending your executable to the maintainer of TTDPatch.

@item Version is unknown!
@itemx Your program version is not known to this program
You are running TTDPatch with an unknown version of TTD, or you told it to
ignore its version data.  This will usually work fine, but it may take a longer time
to start TTD than usual, up to a minute on slow computers.

@end table


@metanode @section,Version Trouble,What if TTDPatch doesn't recognize your version of TTD.
@c ---------------------

This section should now be of no relevance, since all versions of TTD that
I know of are supported by TTDPatch.  But if you're interested anyway, read on.

TTDPatch will have to know the locations of code that has to be patched.  This
will usually be a table that has to be compiled into the program to make it
work.

If the version of TTD you are using is not known to TTDPatch, it will tell you
so and offer the option to try and start anyway.  However, this is a bit
tricky, and may result in the program locking up, or causing a protection
violation.  Depending on your operating system, this may lead to complete
hang of the computer.  So, don't try this if you have any important programs
running in the background.

These are the versions that are known to work:
@cindex supported versions
@multitable @columnfractions .15 .15 .15 
@item          @tab File size @tab
@item Language @tab DOS     @tab Windows
@item American @tab 496,543 @tab 1,695,744
@item English  @tab 496,601 @tab 1,696,256
@item German   @tab 499,583 @tab 1,699,328
@item French   @tab 505,759 @tab 1,707,008
@item Spanish  @tab 506,237 @tab 1,707,520
@end multitable


