@c	vim:	syntax=texinfo

@metanode @chapter,Other Stuff,Whatever didn't fit in any of the previous chapters.
@c -------------

@metanode @section,Contact Information,How to contact the author of TTDPatch.
@c --------------

For getting help, please see @ref{Help} first.

However, do not hesitate to email me your opinion about this program, or any
bugs or typos you may find, or suggestions about what to put into the next
version of the program.  If you have trouble getting it to run please tell
me the version number of your TTD (as shown in the ``About'' box) and of
TTDPatch.  The output of TTDPatch would also be helpful, as well as your
@file{ttdpatch.cfg} and @file{newgrf(w).cfg} files plus any @file{crash*.txt} crash
logs you may have.

@cindex email address
To email me, please go to the 
@uref{http://www.ttdpatch.net/email.php, TTDPatch email page}.  There, you will
always find my latest email address.

Note that if you send me email, it can take a couple of days to a week or two before I
have the time to reply.  I always read all email I get, and usually answer all
email, but it takes time.


@metanode @section,Future Plans,What might be included in a future version of the patch.
@c ------------------

Here are some things I am considering to include in future versions, in no particular
order.  For some reason this list keeps getting longer and longer, no matter how much
I try to implement, there are always more new ideas than I can handle.

This list is not updated very regularly, for a more up-to-date version check
@file{todonow.txt} at the source code page of the TTDPatch site.

@itemize @bullet

@item Make station coverage depend on size of station, especially increase
coverage of large airports

@item More options for refitting aircraft, allow changing relative sizes of
passengers and mail compartments, refit each compartment individually

@item Make combined pre-signals more useful

@item Include depots in some useful way in pre-signal setups

@item Allow AI roads to be bulldozed to clear up their excessive use of space

@item Maximum loan should depend on company value too

@item Slow down time and/or make it possible to build during pause

@item Load carriers in the order that they arrive at a station

@item Cht: Engine to change all train engines into a specific type, or maybe for
planes etc.  as well.  Maybe only change a specific engine?  Maybe not
at all, because it seems to be rather difficult.

@item Even larger stations; maybe there is a way to have even more than 7
platforms and be longer than 7 squares

@item Signals in tunnels and on bridges, possibly invisible and/or
automatically placed

@item Make it possible to restrict which switches may be used in
a competition for example

@item Modified plane breakdowns: crash instead of becoming slower, but
of course much more rarely.  Try to crash them not at the airport maybe

@item Sort vehicle lists, by number, profit, last year's profit, perhaps
even by the schedule

@item Better stock market, get part of the profit, get money for selling stock,
better company value calculation.  When a company you hold at 75% goes bankrupt, only
pay 25% to buy it.

@item Make faster ships possible (currently max. is 127 km/h)

@item Much higher production limits to really make use of the improved rail networks

@item Retain names and service intervals when selling an engine and then buying a new one

@item Improved path finding for trains and ships

@item Hydroplanes that can land on water and use the ship docks

@item Faster scrolling with Ctrl-Shift

@item Link road signals to train signals,
so they go red quicker when a train approaches 

@item Disable particular vehicle types for the AI, so they can not build road vehicles etc.

@item Make tenders for steam engines mandatory

@item Make ``fulloadany'' be optional for each vehicle type (e.g., not planes)

@item Link several stations' ratings and cargo, to simulate several facilities
of each type in a station

@item Cargo payment rates should follow supply and demand rules

@item Make economy fluctuations smoother, e.g. changes or +/- 10%, 
but more often. +/- 50% should be rare.

@item Minimum load, specify that a carrier should not leave unless at
least x% of it is full.  This will probably only apply to ``full load''.

@item Make planes have limited fuel supply and limited range, depending
on plane size

@item Add hotkeys to the airport and dock construction windows as well

@item A freight trains option that allows really heavy cargo trains
by for example making each coal wagon count as ten

@item Show in town window whether town is considered to be in the snow
or in the desert

@item Allow subsidiaries that don't get taken over by the AI

@item Allow refitting of train wagons, so that fewer vehicle slots
are necessary for a large variety of train wagons

@item Allow adding new sound effects, especially for new vehicles

@item Allow trains to drive backwards

@item Show list of destinations in the train and road vehicles lists,
like for planes and ships

@item Implement speed limits for cargo wagons (trains)

@item Make tracks cost maintenance, maybe depending on use

@end itemize


@metanode @section,Impossible Changes,Things that are often asked for but cannot be done.
@c ------------------------

This is a list of things I'm regularly asked to do, but which are either
impossible to do, or at least an awful lot of work:

@itemize @bullet

@item Higher bridges.  Complication: TTD has no provision to store the height of a
bridge, it is always implicitly one, nor can the graphics engine display them.

@item Diagonal bridges or tunnels, for the same reason.

@item More cargo types.
This can't be done because there can only be 12 different cargo types
per climate, and it's impossible to add more.
@c Oil rigs *are* possible in all climates that support oil, actually -- Marcin

@item More stations or more depots.

Both stations and depots have an ID value that is stored in a single byte in
memory.  Because of this, the IDs can only go up to 255, allowing at most
256 stations or depots.  For stations, a couple of the ID values have special
meanings, so that only 250 stations are possible.

However, because they are stored in a byte, it is not possible to have more
stations or depots than 255.  It is all but impossible to change the ID to
use a word value, which would be required to do that.

Changing the number of vehicles on the other hand
was less difficult because they were already
stored in a word value, which can take values up to 65535.

@item Joining more than one of each station facility type in a single station, e.g.
two joined bus stations.  While it is possible to place those on the map, the internal
station structure can only hold the position of one of each facility type.  Therefore
the vehicles would only use one of them as well.  In addition this would eventually turn
into a ghost station.

@item Larger airports (more runways).  It's possible, but would involve recoding
the whole aircraft movement scheme of an airport.  It's too much work right
now.  Maybe if enough people bug me about it I might do it though.
If/when I do it, I'd add another runway at the other side of the airport,
and separate them into landing/departing runways.  This should work nicely,
but it is still a lot of work.

@item Larger maps.  This is all but impossible, because the whole program
assumes a coordinate has 8 bits for each direction, totalling a 256x256 grid.

@item A patch for the original Transport Tycoon.  I have worked on TTDPatch
for almost six years now, and asking me to duplicate that work for TT original
is just a little bit unreasonable.

@item More players in multiplayer games.  This would need a full re-write
of TTD's multiplayer networking protocol.  That's pretty much impossible
without having the source, and even then it would be a huge amount of work.
@end itemize

@metanode @section,Other Tools,Programs related to TTDPatch, or otherwise useful for TTD.

@cindex GRFCodec
@cindex modifying graphics
@cindex graphics changes
I have made a program which can be used to modify TTD's graphics.  It will
convert the @file{.GRF} file into a @file{.PCX} file which you can edit
with your favourite graphics program.  Then you can convert it back and have
TTD use your own graphics set.  In addition, you can use it to edit
@file{ttdpatch.grf} if you want to modify the look of pre-signals.
You can find GrfCodec at @uref{http://www.ttdpatch.net/grfcodec/}

@noindent It is still more or less in beta stage and may not work correctly
in all cases, though.

@cindex TTDAlter
Another very useful tool is TTDAlter 4.0, written by Owen Rudge.  It lets you edit the engines and
bridges and other stuff, to make them faster, better, bigger, whatever.  It's
especially useful in combination with TTDPatch.

You can find it at @uref{http://www.transporttycoon.uk.tt/, Owen's Transport Tycoon Station}.

When using it with TTDPatch, make sure you check the ``Delete TTDLOAD[W].OVL 
when saving'' option, which allow TTDPatch to make use of your changes.

For other tools, please check the @uref{http://www.ttdpatch.net/tools.html, Tools page} on
the TTDPatch site.

@metanode @section,Real Maglevs,If you want to know what Maglevs are.
@c ------------------

So, you've been building maglev routes and buying maglev trains all the time in
TTD.  Did you know that there are actual maglevs running, that you can even test
ride?  One of them is the German ``Transrapid'' system, which uses static magnetic
levitation (maglev) to travel without any moving parts.  There is more information
about it at the @uref{http://www.transrapid.de/en/, Transrapid
home page}, and even though it
resembles TTD's monorail more than its maglev, it is in fact a maglev.

Since version 2.0 of TTDPatch, you can actually @emph{play} with the Transrapid
too, by loading the ``DB Set'', available as a new graphics set.

Another maglev train that is still under development is the Japanese MLX, which
you can find at the
@uref{http://www.rtri.or.jp/rd/maglev/html/english/maglev_frame_E.html, home page}.
This one relies on dynamic magnetic levitation, which means that it will only levitate
once it is fast enough.  It appears that this is what TTD's maglev is modelled after,
because it also has the guide rails at the side of the tracks, and TTD's Chimera seems
to be very similar to the MLU002N test vehicle.


@metanode @section,Closing Words,Useless trivialities because I couldn't think of anything better to say.
@c -------------------

Well, what can I say more?  Congratulations on reading everything I've written, if
you've really gotten that far really by reading it, and not just cheating@dots{}

I hope you will enjoy TTDPatch, I've certainly done my best to ensure that you
will.
