#!/usr/bin/perl

my @data;
my %node;
my %desc;
my %levels=(top=>0, chapter=>1, section=>2, subsection=>3, unnumbered=>1);
my @cur=(0);
$|=1;

$"="/";

sub rightcase($) {
	my @words = split /(\W+)/, shift, -1;	# split, keep trailing chars
	my $out="";
	local $_;
	while (defined($_ = shift @words)) {
		next unless /\w/;
		next if /[A-Z]{2}/;	# leave acronyms alone
		$_ = lc;
		s/windows/Windows/g;	# but keep capitalization for some words
	} continue {
		$out .= $_;
	}
	return $out;
}

&parse(*STDIN);
sub parse {
my $fh = shift;
	
while (<$fh>) {
	/^\@include (.*)/ and do {
#		print "Including $1.\n";
		my $newfh = (\local *FH);
		open $newfh, "<$1";
		parse ($newfh);
		close $newfh;
		next;
	};
#print "Got $_";
	push @data,$_;
	/^\@metanode \@(.*)/ and do {
		my ($type,$name,$desc)=split /,/,$1,3;
		my $level=$levels{$type};
		die "Unknown level $type in $_" unless defined $level;
		@cur=(@cur[0..$level-1],$cur[$level]+1);
		my $id="@cur";
		$node{$name} and die "Duplicate title $name in $_";
		$node{$name}=$id;
		$node{$id}=$name;
		$desc{$id}=$desc;
#		print "Node $name is a $type with level $level, id $id.\n";
	};
};
};

@cur=(0);
foreach (@data) {
	/^\@metanode \@(.*)/ and do {
		my ($type,$name,$desc)=split /,/,$1,3;
		my $level=$levels{$type};
		@cur=(@cur[0..$level-1],$cur[$level]+1);
		my $id="@cur";
		die "I can't count $name in $_" if $id ne $node{$name};
#		print "Node $2 is a $1 with level $level, id $id.\n";
		my @prev=@cur;$prev[-1]--;
		my @next=@cur;$next[-1]++;
		@next=(@cur,1) unless $level;
		my @up=@cur;pop @up;
		my $previd=$prev[-1]?"@prev":undef;
		my $nextid="@next";
		my $upid="@up";
		my $prev=$previd?$node{$previd}:"";
		my $next=$node{$nextid} or $down;
		my $up=$upid?$node{$upid}:"";
#		print "Prev: $previd=$prev Next: $nextid=$next Up: $upid=$up\n";
		print "\@new$type\n";
		print "\@node $name, $next, $prev, $up\n";
		print "\@$type $name\n" if $level;
		print "\@cindex ", rightcase $name, "\n"
			unless ($type eq "unnumbered")
				 || ($type eq "top");
		my @menu=sort {(split("/",$a))[-1] <=> (split("/",$b))[-1]}
			grep /^$id\/\d+$/, keys %node;
		next unless @menu;
		print "\n\@menu\n";
		print "* $node{$_}:: $desc{$_}\n" foreach (@menu);
		print "\@end menu\n\n";
#		print qq(\n\@menu\n* $node{"$id/1"}  The first menu entry\n* $node{"$id/2"}  The second entry\n\@end menu\n\n);
		next;
	};
	print;
};
