@c	vim: syntax=texinfo

@c  %header
@c @setfilename ttdpatch.info
@c footnotestyle end
@c documentlanguage en
@c  %header end

@c HAVELINKS is set if we're compiling either HTML or interactive PDF

@clear HAVELINKS

@ifset HTML
@set HAVELINKS
@end ifset
@ifset PDFI
@set HAVELINKS
@set PDF
@end ifset
@ifset PDFP
@set PDF
@end ifset

@finalout

@c prototype definitions, override these to add some code for
@c each new node of that type
@macro newtop
@end macro
@macro newchapter
@end macro
@macro newunnumbered
@newchapter
@end macro
@macro newsection
@end macro
@macro newsubsection
@end macro

@c some other macro definitions

@c Macro to typeset a new switch and generate one or more index entries
@macro switch{CFG,CMD,COMMENT}
@display
@t{\CFG\}, @t{\CMD\} \COMMENT\
@cindex @t{\CFG\}
@cindex @t{\CMD\}
@end display
@end macro

@macro cfgonlyswitch{CFG,COMMENT}
@display
@t{\CFG\} \COMMENT\
@cindex @t{\CFG\}
@end display
@end macro

@macro cheat{NAME,OPT,COMMENT}
@display
@t{Cht: \NAME\ \OPT\} \COMMENT\
@cindex @t{\NAME\}
@end display
@end macro

@c ---------------------------
@c Output specific definitions
@c ---------------------------

@c *** interactive PDF output ***
@ifset PDFI
@include pdf_i.inc
@end ifset

@c *** Printable PDF output ***
@c (really dvi->ps->pdf)
@ifset PDFP
@include pdf_p.inc
@end ifset

@c *** HTML output ***
@ifset HTML
@include html.inc
@end ifset

@c *** .txt output ***
@ifset TXT
@include txt.inc
@end ifset

