//
// This file is part of TTDPatch
// Copyright (C) 1999-2001 by Josef Drexler
// Copyright (C) 2003 by Petr Baudis
//
// C++ to C conversion by Marcin Grzegorczyk
//
// TTDPatch interface to LoadTycoon
//
// TODO: Normalize this to use auxfiles etc. Big cleanups. Make version saving
// to work. And so on... --pasky
//


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <linux/types.h>
#include "types.h"
#include "error.h"

#if WINTTDX
#	include "versionw.h"
	const char *patchedfilename = "TTDLOADW.OVL";
#else
#	include "versiond.h"
	const char *patchedfilename = "TTDLOAD.OVL";
#endif

unsigned int grep_blksize = 4096;

#define IS_TTDSTART_CPP 1
#include "language.h"
#include "loadlng.h"
#include "switches.h"
#include "osfunc.h"


extern char ttdprotl;	// binary TTDPatch data
extern FILE* logfile;

langinfo *linfo;

paramset tempflags;


// functions for grepfile() to use my own memory allocation

char *grepalloc(unsigned int size)
{
  char *buffer = (char*) malloc(size);

  if (!buffer)
	error(langtext[LANG_NOTENOUGHMEM], "grepalloc()", size/1024+1);

  return buffer;
}

void grepfree(char *buffer)
{
  free(buffer);
}

#if 0
void saveversion(int wasgood)
{
  char s1[40], s2[40], verfilename[40];
  FILE *f;
  int i;

  curversion->h.version = newversion;
  curversion->h.filesize = newfilesize;

  versioninfototext(curversion, 1, s1);
  versioninfototext(curversion, 0, s2);

  sprintf(verfilename, "%s.ver", s1);

  if (wasgood)
	printf("Version information succesfully collected.\n");
  else {
	printf("FAILED to collect version information.\n");
	return;
  }

  printf("Writing the collected information to %s.\n\n", verfilename);

  f = fopen(verfilename, "wt");
  fprintf(f, "// Version information for %s\n"
	     "\n"
	     "\t{ 0x%lX, 0x%lX, %ld,\n\t  ",
	     s2, curversion->h.version, curversion->h.filesize, curversion->h.numoffsets);

  for (i=0; i<curversion->h.numoffsets; i++)
	fprintf(f, "0x%lX%s%s",
		curversion->versionoffsets[i],
		(i < curversion->h.numoffsets - 1)?", ":"\n\t};\n",
		( (i < curversion->h.numoffsets - 1) && ( (i % 6) == 5) )?"\n\t  ":"");
  fclose(f);
}
#endif


void getlangdata(langinfo *info)
{
  langinfo_loadcurlangdata(info);
  langinfo_processlangdata(info);
  return;
}

void initlanguage(langinfo *info)
{
  int text;
  s16 lang = -1;
  char *envlang;

  // find country code
  // TODO: lang = getdefaultlanguage(info);
  if (lang == -1) lang = 0;	// default not found, use first language

  envlang = getenv("LANG");
  if (!envlang) envlang = getenv("LANGUAGE");
  if (envlang) {
	lang = langinfo_findlang(info, envlang);

#if 0
	if (lang == -1) {
		printf(	"Unknown language '%s' specified in the environment \n"
			"variable LANG or LANGUAGE. Known languages:\n",
			envlang);

		for (lang=0; lang<langinfo_number(info); lang++) {
			langinfo_loadlang(info, lang);
			langinfo_loadcurlangdata(info);
			printf("%s %s", lang==0?"":",", langinfo_name(info));
		}

		printf("\nUse SET LANG=language to select the language.\n"
			"E.g. SET LANG=french\n");
		exit(1);
	}
#endif
	if (lang == -1)
		lang = langinfo_findlang(info, (char *) "english");

  }

  langinfo_loadlang(info, lang);
  getlangdata(info);

}

void parse_ttdpatch_cmdline(int argc, char **argv)
{
  check_debug_switches(&argc, (const char *const **)&argv);
  if ((debug_flags.runcmdline > 0) && argv[0])
	patchedfilename = argv[0];

  linfo = langinfo_new();

  initlanguage(linfo);

  if (debug_flags.dumpswitches > 0) {
	dumpswitches();
	return;
  }

  flags = (pparamset) &tempflags;

  commandline(argc, (const char **)argv);

  if (showswitches)
	showtheswitches(ensureconsize);
}

typedef struct {
	__u32 loaderofs;
	__u32 loaderlen;
	__u32 dataofs;
	__u32 datalen;
	__u32 database;
} ttdprotl_head;

void install_ttdpatch()
{
   ttdprotl_head *head = (ttdprotl_head*) &ttdprotl;
   __u8 *loader = ((__u8*) head)+head->loaderofs;
   __u8 *data = ((__u8*) head)+head->dataofs;

   paramset *u;

  printf("TTDPatch V%s%s", TTDPATCHVERSION, langtext[LANG_STARTING]);
  printf("Loader offset: 0x%x length: 0x%x\n", head->loaderofs, head->loaderlen);
  printf("Data offset: 0x%x length: 0x%x, base 0x%x\n", head->dataofs, head->datalen, head->database);

#if 0
  if (debug_flags.checkttd >= 0) {
	checkpatch();
  }
#endif

  if (flags->data.vehicledatafactor > 0)
	setf1(uselargerarray);
  if (getf(gradualloading) && !getf(recordversiondata))
	clearf(improvedloadtimes);



   // install loader at 0x136aca
   u= (pparamset) 0x136aca;
   if (u->magic != 0x7918358b) {
	fprintf(stderr, "Could not install loader, wrong code: %x\n", * (__u32*) u);
	exit(27);
   }

   fprintf(logfile, "Installing TTDPatch loader (%d bytes) at %p\n", 
	head->loaderlen, u);
   memcpy(u, loader, head->loaderlen);

	// install data at head->database
   u= (pparamset) head->database;
   fprintf(logfile, "Installing TTDPatch data (%d bytes) at %p\n",
	head->datalen, u);
   memcpy(u, data, head->datalen + 8);

	// make sure that the Magic is right
   if (u->magic != MAGIC) {
	fprintf(stderr, "TTDPatch data magic is %lx, that's not right!\n",
		u->magic);
	exit(28);
   }

	// set the flags and variables
   memcpy(u->flags, flags->flags, (nparlong+nflags)*4);

   fprintf(logfile, "TTDPatch is installed.\n");


#if 0
  result = runttd(patchedfilename, ttdoptions, &linfo);

  printf(langtext[LANG_RUNRESULT],
	result?langtext[LANG_RUNRESULTERROR]:langtext[LANG_RUNRESULTOK]);

  if (getf(recordversiondata))
	saveversion(!result);

  if ((unsigned)result > 1)
	warning(NULL);

  langinfo_delete(linfo);

  return result;
#endif
}
