// This is not assembler code, it has to be passed through a C preprocessor
// first.  The Cygwin and DJGPP preprocessors (GCC versions 2.9.x) work with
// this, GCC versions 3.x work with problems, I don't know about others.
// Something like gcc -E -P ttdprot.asm > x.asm, then nasm x.asm.
// The preprocessor has to strip all "//" comments and be able to handle
// #defines with arguments, and make concatenation with ##. Also, the line
// numbering has to be turned off, or lines beginning with "#" have to be
// filtered, e.g. by perl/lineinfo.pl.

; Compiled with "WINTTDX"=<WINTTDX>, "LINTTDX"=<LINTTDX>, "DEBUG"=<DEBUG>
#if WINTTDX
; "WINTTDX" is on.
#else
; "WINTTDX" is off.
#endif
#if LINTTDX
; "LINTTDX" is on.
#else
; "LINTTDX" is off.
#endif
#if DEBUG
; "DEBUG" is on.
#else
; "DEBUG" is off.
#endif

#define ASSEMBLER

cpu 386
bits 32

%ifdef OBJ
#if WINTTDX
	segment _data public align=16 class=DATA USE16
	segment _data	; to prevent errors about redefined segments
#else
	segment TTDPatch public align=16 class=CODE USE16
	segment TTDPatch	; to prevent errors about redefined segments
#endif
%elifdef COFF
	section .code
%elifdef BIN
	section .code
%else
	%error "Define OBJ, COFF or BIN"
%endif

bits 32

%ifdef PREPROCESSONLY
%error Do not compile the results of preprocessing!	// no "", so it's a warning
%endif

// Define a new endstruc macro that sets the "bits" setting properly
%imacro endstruc_32 0.nolist
	endstruc
	bits 32
%endmacro

#include "ttdprot.ah"
#include "common.h"


// These are the exported public functions
cglobal initfunc,initfuncend,patchdatfile
cglobal winloader,winloaderend,realentrypoint
cglobal protectedcode,protectedfunc

#ifdef USEPROTBIN
	db "pROTcODE"

	#if WINTTDX
		dd winloaderend-winloader
	#else
		dd initfuncend-initfunc
	#endif
#endif

#include "loader.ah"

%ifdef USEORG
	resb runindexbase-($-$$)-8
%else
	align 4
%endif

// Here is the actual code that TTDPatch passes on
protectedcode:

	// first the two sizes written to ttdpatch.dat
	dd protectedcodeend - protectedfunc
	dd protectedcoderealend - protectedfunc

protectedfunc:

#include "vars.ah"
#include "fragment.ah"
#include "init.ah"
#include "patches.ah"


// Some utility functions

#include "patches/texthndl.asm"
#include "patches/grfload.asm"
#include "patches/tools.asm"


// Include all the various patches

#include "patches/mountain.asm"
#include "patches/loadsave.asm"
#include "patches/nonstop.asm"
#include "patches/presigna.asm"
#include "patches/signcht.asm"
#include "patches/trnrefit.asm"
#include "patches/stspread.asm"
#include "patches/lrgstat.asm"
#include "patches/loadtime.asm"
#include "patches/fullload.asm"
#include "patches/offcfood.asm"
#include "patches/maxloan.asm"
#include "patches/perseng.asm"
#include "patches/selgood.asm"
#include "patches/servint.asm"
#include "patches/moredyna.asm"
#include "patches/multihd.asm"
//#include "patches/smallap.asm"	// no longer used
#include "patches/airptcnt.asm"
#include "patches/fixpcrsh.asm"
#include "patches/pcrshctl.asm"
#include "patches/bribe.asm"
#include "patches/trnspd.asm"
#include "patches/diskmenu.asm"
#include "patches/fixmisc.asm"
#include "patches/feeder.asm"
#include "patches/gotodepo.asm"
#include "patches/rvpower.asm"
#include "patches/vehspri.asm"
#include "patches/subsid.asm"
#include "patches/errorpop.asm"
#include "patches/trnwait.asm"
#include "patches/disaster.asm"
#include "patches/morenews.asm"
#include "patches/unimagl.asm"
#include "patches/bridgspd.asm"
#include "patches/eternal.asm"
#include "patches/electrif.asm"
#include "patches/startyr.asm"
#include "patches/bigcity.asm"
#include "patches/newtrain.asm"
#include "patches/morebopt.asm"
#include "patches/hotkeys.asm"
#include "patches/manytree.asm"
#include "patches/kbdhand.asm"
#include "patches/morecurr.asm"
#include "patches/manucnvt.asm"
#include "patches/towndata.asm"
#include "patches/enhgui.asm"
#include "patches/slopebld.asm"
#include "patches/railcost.asm"
#include "patches/planemot.asm"
#include "patches/fastsell.asm"

#if WINTTDX
#	include "patches/win2k.asm"
#endif

#if !WINTTDX
#	include "versiond.h"
#else
#	include "versionw.h"
#endif
#include "patches/catchgpf.asm"

#if DEBUG_TUNNSIG
#	include "patches/tunnsig.asm"
#endif

//#include "patches/newairpt.asm"


// The Windows version needs fixed relocations in the data segment
#if WINTTDX
var relocofs
#	include "reloc.inc"
	db 0
#endif


protectedcoderealend:

	// WARNING: Nothing below here must be initialized

var fake_bss_start	// fake BSS section starts at this address

// define the uninitalized variables
// maybe eventually we'll just have nasm make a flat binary, and
// %incbin it into another dummy .asm file to actually make the .obj file
// so that we can use a real .bss section

%macro declare_uvarlist 0-*
	%rep %0/2
		%1: %2
		%rotate 2
	%endrep
%endmacro

struc _bss

	// skip to the right address
	resb fake_bss_start
	resb ($$-$) & 3

_fake_bss_start:

_fake_bss_zero_init:
	%ifdef uvar_d_z
		declare_uvarlist uvar_d_z
	%endif
	%ifdef uvar_w_z
		declare_uvarlist uvar_w_z
	%endif
	%ifdef uvar_b_z
		declare_uvarlist uvar_b_z
	%endif

	resb ($$-$) & 3		// align to DWORD

_fake_bss_zero_init_size equ $-_fake_bss_zero_init

_fake_bss_signed_init:
	%ifdef uvar_d_s
		declare_uvarlist uvar_d_s
	%endif
	%ifdef uvar_w_s
		declare_uvarlist uvar_w_s
	%endif
	%ifdef uvar_b_s
		declare_uvarlist uvar_b_s
	%endif

_fake_bss_signed_init_size equ $+( ($$-$)&3 )-_fake_bss_signed_init

	// minimum amount of memory necessary to run at all
//minmemsize:

	// and the number of 4KB pages for this memory, plus
	// the size of a heap structure at the beginning
//minmempages equ (minmemsize + 0xfff + heap_size) >> 12

_fake_bss_end:

	resb ($$-$) & 3

	// at this point we load the version info
	// and the custom texts

	// then follows the vehicle array (unless lowmemory&&vehfactor==1)
	// and the heap

currentversion:

endstruc_32

protectedcodeend equ protectedcoderealend + _fake_bss_end - fake_bss_start

; endp protectedcode
