%{
#include <stdlib.h>
#include <string.h>
#include "turing.h"

void yyerror(char *);
int yylex();

#define YYERROR_VERBOSE
%}

%token LIST
%token DELIM
%token END

%token ASSIGN

%token ALPHANUMERIC
%token NUMBER
%token DIRECTION

%%

conf:
	| conf conf_item
	;

conf_item:	parameter ASSIGN result
	{ fn_t *fn = malloc(sizeof(fn_t));
	  fn->sym = ((fn_t *) $1)->sym;
	  fn->state = ((fn_t *) $1)->state;
	  fn->newsym = ((fn_t *) $3)->newsym;
	  fn->newstate = ((fn_t *) $3)->newstate;
	  fn->newdir = ((fn_t *) $3)->newdir;
	  add_fn(fn);
	}
	;

parameter:	LIST ALPHANUMERIC DELIM NUMBER END
	{ static fn_t fn;
	  fn.sym = $2;
	  fn.state = $4;
	  $$ = (int) &fn;
	}
	;

result:		LIST ALPHANUMERIC DELIM NUMBER DELIM DIRECTION END
	{ static fn_t fn;
	  fn.newsym = $2;
	  fn.newstate = $4;
	  fn.newdir = $6;
	  $$ = (int) &fn;
	}
	;

%%

void yyerror(char *s) {
  fprintf(stderr, "Configuration: %s\n", s);
}
