/* definition file for scanner of the language */
/*
 * the input of turing looks like:
 * 
 *   (<val>,<state>) = (<val>,<state>,<dir>)
 *   
 *   where val may be any possible symbol, state may be
 * any normal number, and dir can be either L or R.
 * 
 *   possible symbol can be only alpha-numeric. Z is lambda.
 */

%{
#include "source.tab.h"
%}
  
ALPHA	[a-zA-Z0-9]
NUM	[0-9]
DIR	[<>]
S	([ \t\n])*

%%

'{ALPHA}'			yylval = yytext[1]; return ALPHANUMERIC;

{NUM}+				yylval = atoi(yytext); return NUMBER;

{DIR}				yylval = yytext[0]; return DIRECTION;

{S},{S}				return DELIM;

{S}={S}				return ASSIGN;

{S}\({S}			return LIST;

{S}\){S}			return END;

{S}#[^\n]*{S}
